/*
 * Decompiled with CFR 0.152.
 */
package xcodegen.structure;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XObject {
    private static final Collection __empty_collection = new Vector();
    private String _name;
    private String _description = "";
    private Collection _children = new Vector();
    private XObject _parent;

    protected String trimXMLText(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceFirst("^[\r\n\t ]*", "");
        string = string.replaceFirst("[\r\n\t ]*$", "");
        return string;
    }

    protected String getXMLText(Element element) {
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            if (node.getNodeType() == 3) {
                stringBuffer.append(((Text)node).getData());
            } else if (node.getNodeType() == 4) {
                stringBuffer.append(((CDATASection)node).getData());
            }
            node = node.getNextSibling();
        }
        return this.trimXMLText(stringBuffer.toString());
    }

    protected String getXMLChildText(String string, Element element) {
        return this.getXMLChildText(string, element, null);
    }

    protected Element getXMLChild(String string, Element element) {
        Object var3_3 = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1 && string.equals(node.getNodeName())) {
                    return (Element)node;
                }
                ++n;
            }
        }
        return null;
    }

    protected String getXMLChildText(String string, Element element, String string2) {
        Element element2 = this.getXMLChild(string, element);
        return element2 != null ? this.getXMLText(element2) : string2;
    }

    protected void addError(String string, XObject xObject, Collection collection) {
        String string2 = xObject != null ? xObject.getLongName() + ": " + string : string;
        this.getLogger().error((Object)string2);
        collection.add(string2);
    }

    protected boolean initChildren(Element element, XObject xObject, Collection collection, String string, Class clazz) throws Exception {
        if (element == null) {
            return true;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            XObject xObject2;
            String string2;
            if (node.getNodeType() == 1 && (string2 = node.getNodeName()).equals(string) && !(xObject2 = (XObject)clazz.newInstance()).init((Element)node, xObject, collection)) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public boolean init(Element element, XObject xObject, Collection collection) throws Exception {
        this._name = element.getAttribute("name");
        this._description = this.getXMLChildText("description", element, "");
        if (this._name == null || this._name.length() == 0) {
            this.addError("Element without name", xObject, collection);
            return false;
        }
        if (xObject != null) {
            if (this.getChild(this._name, this.getClass()) != null) {
                this.addError("Duplicate element named: " + this._name, xObject, collection);
                return false;
            }
            xObject.add(this);
        }
        this.getLogger().debug((Object)this.getLongName());
        return true;
    }

    public String getLongName() {
        return this._parent == null ? this._name : this._parent.getLongName() + "." + this._name;
    }

    public String getBeanName() {
        if (this._name == null) {
            return null;
        }
        if (this._name.length() == 1) {
            return this._name.toUpperCase();
        }
        return this._name.substring(0, 1).toUpperCase() + this._name.substring(1);
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getClass());
    }

    public boolean hasChild(XObject xObject) {
        return this.getChildren().contains(xObject);
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public Collection getChildren() {
        return this._children != null ? this._children : __empty_collection;
    }

    public XObject getParent() {
        return this._parent;
    }

    protected void add(XObject xObject) {
        if (this._children == null) {
            this._children = new Vector();
        }
        this._children.add(xObject);
        xObject._parent = this;
    }

    protected Collection getChildren(Class clazz) {
        Iterator iterator = this.getChildren().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e.getClass() != clazz) continue;
            vector.add(e);
        }
        return vector;
    }

    protected XObject getChild(String string) {
        Iterator iterator = this.getChildren().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            XObject xObject = (XObject)iterator.next();
            if (!string.equals(xObject.getName())) continue;
            return xObject;
        }
        return null;
    }

    protected XObject getChild(String string, Class clazz) {
        Iterator iterator = this.getChildren().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            XObject xObject = (XObject)iterator.next();
            if (xObject.getClass() != clazz || !string.equals(xObject.getName())) continue;
            return xObject;
        }
        return null;
    }
}

