/*
 * Decompiled with CFR 0.152.
 */
package xcodegen.generator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import xcodegen.exceptions.XCodeGenException;
import xcodegen.generator.CodeGenerator;
import xcodegen.generator.CodeGeneratorFactory;
import xcodegen.structure.XClass;
import xcodegen.structure.XPackage;

public abstract class AbstractCodeGenerator
implements CodeGenerator {
    private Properties _config;
    private String _name;
    private Logger _logger = Logger.getLogger(this.getClass());
    private VelocityContext _context;

    public AbstractCodeGenerator(String string) {
        this._name = string;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public String getName() {
        return this._name;
    }

    public VelocityContext getVelocityContext() {
        if (this._context == null) {
            this._context = new VelocityContext();
            this._context.put("date", (Object)new Date());
            this._context.put("version", (Object)"1.0");
            this._context.put("codegen", (Object)this);
            this._context.put("factory", (Object)CodeGeneratorFactory.getInstance());
        }
        return this._context;
    }

    public abstract String getVelocityTemplatePath();

    public Template getVelocityTemplate() throws XCodeGenException {
        String string = null;
        try {
            string = this.getVelocityTemplatePath();
            return Velocity.getTemplate((String)string);
        }
        catch (ParseErrorException parseErrorException) {
            throw new XCodeGenException("Syntax error in template: " + string, (Exception)((Object)parseErrorException));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new XCodeGenException("Template not found: " + string, (Exception)((Object)resourceNotFoundException));
        }
        catch (Exception exception) {
            throw new XCodeGenException("Unexpected error while loading template: " + string, exception);
        }
    }

    protected abstract void generate(XPackage var1, VelocityContext var2, Template var3) throws XCodeGenException, IOException;

    protected abstract void generate(XClass var1, VelocityContext var2, Template var3) throws XCodeGenException, IOException;

    protected Properties loadResourceAsProperties(String string) throws XCodeGenException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new XCodeGenException("Resource not found: " + string);
        }
        try {
            properties.load(inputStream);
        }
        catch (Exception exception) {
            throw new XCodeGenException("Unable to load resource: " + string);
        }
        return properties;
    }

    public void generate(XPackage[] xPackageArray) throws XCodeGenException, IOException {
        Logger logger = this.getLogger();
        VelocityContext velocityContext = this.getVelocityContext();
        Template template = this.getVelocityTemplate();
        int n = 0;
        while (n < xPackageArray.length) {
            XPackage xPackage = xPackageArray[n];
            logger.info((Object)("Package: " + xPackage.getName()));
            this.generate(xPackage, velocityContext, template);
            Iterator iterator = xPackage.getClasses().iterator();
            while (iterator.hasNext()) {
                XClass xClass = (XClass)iterator.next();
                velocityContext.put("class", (Object)xClass);
                logger.info((Object)("Class: " + xPackage.getName() + "." + xClass.getName()));
                this.generate(xClass, velocityContext, template);
            }
            ++n;
        }
    }

    public String getConfigProperty(String string, String string2) {
        return this._config.getProperty(string, string2);
    }

    public void init(Properties properties) throws XCodeGenException {
        this._config = properties;
    }
}

