'
'	Frank Lupo (Wolf) !!
'	Frank_lupo@email.it

'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Help
'
Option Explicit

Class ClsHelp
	Private HelpCommad

	Private Sub Class_Initialize
	dim Fso,szVersion,szPath,f,fc,f1,szMaxVer,szTemp,objTmp
		Set HelpCommad=Nothing

		Set fso = CreateObject("Scripting.FileSystemObject")

		'Verify current version of help
		'if not Exists load precedent version of help

		szVersion=replace(App.Data.ConDb.Version,".","_")

		'Directory Help
		szPath=szIncludePath & PATH_HELP & "\" 
		
		Set f = fso.GetFolder(szPath)
   		Set fc = f.Files

		'If not Exists files 
		if fc.count=0 then CreateHelp

		'Find version
		szMaxVer=""
   		For Each f1 in fc
			szTemp=fso.getbasename(f1.name)
			if szTemp=szVersion then 
				szMaxVer=szTemp
				exit for
			elseif szTemp > szMaxVer and szTemp <=szVersion then 
				szMaxVer=szTemp
			end if
   		Next

		'Load help
		if len(szMaxVer) > 0 then
			Execute Include(szPath & szMaxVer & ".vbs")
			Set objTmp= New ClsHelpVersion
			Set HelpCommad = objTmp.ReturnHelp
			if szMaxVer <> szVersion then
				if not App.Data.Setting.CmdFromLineCommand then 
					wscript.echo "Load Help version :" & szMaxVer & " current version: " & szVersion
				end if
			end if
		else
			wscript.echo "Help not exists"
		end if
	End Sub

	Private Sub Class_Terminate
		Set HelpCommad=Nothing
	End Sub

	Public Sub ShowHelp(szNameCommand)
	Dim szCommand

		if HelpCommad Is Nothing then
			wscript.echo "Help not exists"
		else
			if len(trim(szNameCommand)) = 0 then
				for each szCommand in HelpCommad
					PrintHelp szCommand
				next 
			else
				PrintHelp szNameCommand
			end if
		end if
	End Sub

	Private Sub PrintHelp(szNameCommand)
	dim szCommand,vData,szTemp,vData1,bFlag

		szCommand=Ucase(Trim(szNameCommand))
		if HelpCommad.Exists(szCommand) then
			vData=HelpCommad(szCommand)
			wscript.echo "Command:     " & szCommand
			wscript.echo "Description: " & vData(0)
			wscript.echo "Syntax:" & vbcrlf & vData(1) & vbcrlf
		else
			bFlag=False

			'Verify if is a frist part of command
			vData=HelpCommad.Keys
			for each szTemp in vData
				vData1=split(szTemp)
				if ucase(trim(vData1(0)))=szCommand then
					bFlag=True
					PrintHelp szTemp
				end if
			next
			if not bFlag then
				wscript.echo "No help available for " & szCommand & "."
				wscript.echo "Try \h with no arguments to see available help."
			end if
		end if
	End Sub

	' This script automatically generates the help on SQL in psql from the HTML docs. 
	Public Sub CreateHelp()
	Dim Fso,f,fc,f1,vData,iStart,iEnd,szHelp,szName,szPurpose,szSynopsis,szTemp,ii,szVersion
	Dim szPath,bExit,bValid,szPathSgml

	Const Quote=""""

		Set fso = CreateObject("Scripting.FileSystemObject")

		'Require data
		WScript.StdOut.Write "Do you want create help? Y/N : "
		if ucase(WScript.StdIn.ReadLine)<> "Y" then exit sub

		'Get verions postgresql
		bExit=True
		While bExit
			WScript.StdOut.Write "Version Postgres Help (E.g 7.2.2): "
			szTemp = WScript.StdIn.ReadLine
			if len(trim(szTemp)) >0 then
				bValid=False

				szVersion=""
				'Verify if valid version
				vData=split(szTemp,".")
				if Ubound(vData) <= 2 and Ubound(vData) >= 1  then
					if IsNumeric(vData(0)) then 
						szVersion=vData(0)
						bValid=True
					End if
					if Ubound(vData) > 0 then 
						if IsNumeric(vData(1)) then 
							szVersion=szVersion & "." & vData(1)
							bValid=True
						end if
					end if
					if Ubound(vData) > 1 then 
						if IsNumeric(vData(2)) then 
							szVersion=szVersion & "." & vData(2)
							bValid=True
						end if
					end if
				End if
					if bValid then
					bExit=False
				end if
			end if
		Wend

		'Get Path file sgml postgresql
		bExit=True
		While bExit
			WScript.StdOut.Write "Insert path for read SGML Help: "
			szTemp = WScript.StdIn.ReadLine
			if fso.FolderExists(szTemp) then
				szPathSgml=szTemp
				bExit=False
			End if
		Wend

		'Path for help file
		szPath=szIncludePath & PATH_HELP & "\"

		szVersion=replace(szVersion,".","_")

		Set f = fso.GetFolder(szPathSgml)

		szHelp="'" & vbcrlf
		szHelp= szHelp & "'	Frank Lupo (Wolf) !!" & vbcrlf
		szHelp= szHelp & "'	Frank_lupo@email.it" & vbcrlf
		szHelp= szHelp & vbcrlf
		szHelp= szHelp & "'	This is a Psql command for Postgresql write in Visual Basic Script"& vbcrlf
		szHelp= szHelp & "'" & vbcrlf
		szHelp= szHelp & "'	Help SQL for postgres version : " & szVersion & vbcrlf
		szHelp= szHelp & "'" & vbcrlf
		szHelp= szHelp & "Option Explicit" & vbcrlf
		szHelp= szHelp & vbcrlf
		szHelp= szHelp & "Class ClsHelpVersion" & vbcrlf
		szHelp= szHelp & vbcrlf
		szHelp= szHelp & "	Public Function ReturnHelp()" & vbcrlf
		szHelp= szHelp & "	Dim HelpCommad" & vbcrlf
		szHelp= szHelp & "		Set HelpCommad = CreateObject(" & Quote & "Scripting.Dictionary" & Quote & ")" & vbcrlf
		szHelp= szHelp & vbcrlf

   		Set fc = f.Files
   		For Each f1 in fc
			'Read file
			vData=App.Data.Utility.FileSystem.ReadFile(f1.path,0)
			vdata=replace(vdata,vblf,vbcrlf)
			if instr(vdata,"<refmiscinfo>SQL - Language Statements</refmiscinfo>") > 0 then
				szName=""
				szPurpose=""
				szSynopsis=""

				'Name
				iStart=instr(vData,"<refname>")
				iEnd=instr(vData,"</refname>")
				if iEnd > 0 and iStart > 0 then
					iStart=iStart+9
					szName=trim(mid(vData,iStart,iEnd-iStart))
					szName=trim(replace(szName,vbcrlf,""))
				end if

				'Purpose
				iStart=instr(vData,"<refpurpose>")
				iEnd=instr(vData,"</refpurpose>")
				if iEnd > 0 and iStart > 0 then
					iStart=iStart+12
					szPurpose=trim(mid(vData,iStart,iEnd-iStart))
					szPurpose=trim(replace(szPurpose,vbcrlf,""))
					szPurpose=Replace(szPurpose,Quote,Quote & Quote)
				end if

				'Synopsis
				iStart=instr(vData,"<synopsis>")
				iEnd=instr(vData,"</synopsis>")
				if iEnd > 0 and iStart > 0 then
					iStart=iStart+10
					szSynopsis=trim(mid(vData,iStart,iEnd-iStart))

					'delete all tag
					while instr(szSynopsis,"<") > 0
						iStart=instr(szSynopsis,"<")
						iEnd=instr(szSynopsis,">")
						szSynopsis=left(szSynopsis,istart-1) & mid(szSynopsis,iend+1)
					Wend
					szSynopsis=Replace(szSynopsis,Quote,Quote & Quote)
				end if

				'Create Help structure				
				szHelp=szHelp & "		HelpCommad.Add " & Quote & szName & Quote & ", _" & vbcrlf
				szHelp=szHelp & "			Array(" & Quote & szPurpose & Quote & ", _" & vbcrlf

				szTemp=split(szSynopsis,vbcrlf)
				for ii=1 to ubound(szTemp)-1
					szHelp=szHelp & "				" & Quote & szTemp(ii) & Quote 
					if ii < ubound(szTemp)-1 then 
						szHelp=szHelp & " & vbcrlf & _" 
					else
						szHelp=szHelp & " )" 
					end if
					szHelp=szHelp & vbcrlf
				next
				szHelp=szHelp & vbcrlf
			end if
   		Next

		szHelp= szHelp & "		Set ReturnHelp = HelpCommad" & vbcrlf
		szHelp= szHelp & "	End Function" & vbcrlf
		szHelp= szHelp & "End Class" & vbcrlf

		'Write File
		App.Data.Utility.FileSystem.WriteFile szPath & szversion & ".vbs",szHelp,ForWriting
	End Sub
End Class
