<?php

/**************************************************
Program name:	get_table_indexes.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of indexes on a table.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

/*
0 - Indexname
1 - Tablename
2 - Unqiue y/n
3 - Primary y/n
4 - Fieldname
5 - Comment
*/
	
// SQL string to get indexes on table
$sql_get = "
		SELECT 
			ic.relname AS ".dquotes($strKeyname).",
			bc.relname AS ".dquotes($strTable).", 
			i.indisunique AS ".dquotes($strUnique).",
			i.indisprimary AS ".dquotes($strPrimary).",
			ta.attname AS ".dquotes($strField).",
			obj_description(ic.oid) as ".dquotes($strDescription)."  
		FROM 
			pg_class bc,
			pg_class ic,
			pg_index i,
			pg_attribute ta,
			pg_attribute ia
		WHERE 
			bc.oid = i.indrelid
			AND ic.oid = i.indexrelid
			AND ia.attrelid = i.indexrelid
			AND ta.attrelid = bc.oid
			AND ta.attrelid = i.indrelid
			AND ta.attnum = i.indkey[ia.attnum-1]
			AND bc.relname !~ '^pg_' 

		";
# filter for list of all non-RI triggers
If (webpage($PHP_SELF) == "tbl_indexespage.php") {
		$sql_get .= "
			AND bc.relname = '$table'
		";
}
$sql_get .= "
		ORDER BY ".
			dquotes($strKeyname).", ".dquotes($strTable).", ".dquotes($strField)
	;


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modify 
for ($i = 0; $i < $num_rows; $i++) {

	# Make Table Link
	$sql_array[$i][1] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][1].">".$sql_array[$i][1]."</a>";

	# unique_key
	$sql_array[$i][2] = bool_YesNo($sql_array[$i][2]); 

	# primary key
	$sql_array[$i][3] = bool_YesNo($sql_array[$i][3]); 	
}

?>

