<?php

/**************************************************
Program name:	get_array_systemtables.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of system tables.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/


// SQL string to get list of tables
$sql_get = "
	SELECT
		relname as ".dquotes($strName).", 
		relkind as ".dquotes($strType).",
		'postgres' as ".dquotes($strOwner)." 
	FROM 
		pg_class 
	WHERE
		relname ~ 'pg_.*' 
		AND (relkind = 'r' or relkind = 'v') 
	ORDER BY
		relname
	";


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modify Array
for ($i = 0; $i < $num_rows; $i++) {

	// Count values of Table
	if ($cfgCountRecs) { 
		$Extra_Column_Value[$i][0] = count_records($link, $sql_array[$i][0]);
	}

	// Make array table names
	$arySystemTables[$i] = $sql_array[$i][0];

	// Change Tablename into a link
	$sql_array[$i][0] = "<a class=link href=tbl_properties.php?ntable=".$sql_array[$i][0].">".$sql_array[$i][0]."</a>";
	// Change kind into View or Table
	if ($sql_array[$i][1] == "r") {
		$sql_array[$i][1] = $strTable;
	} elseif ($sql_array[$i][1] == "v") {
		$sql_array[$i][1] = $strView;
	}

}


?>
