<?php

/**************************************************
Program name:	build_sql_for_alter_field.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Builds SQL string from the data entered
		on tbl_alterpage.php.  You get here from 
		the "Change" Link on tbl_propertiespage.php
		
Create Date:	6/29/01 

Modified Date(s):	

Notes:

**************************************************/

unset($sql_query);

unset($query);

$query .= " ".dq($field_orig)." TO ".dq($field_name);
$query = stripslashes($query);

if ($field_orig != $field_name) {
	$rename_query = "ALTER TABLE ".dq($table)." RENAME ".$query;
}
	
if ($field_default != "") {
	$default_query = "ALTER TABLE ".dq($table)." ALTER ".dq($field_name)." SET DEFAULT ".squotes($field_default);
	// don't add single quotes if default has a function name, otherwise, add single quotes.
	if (eregi("([[:alnum:]_]+)\(([[:alnum:][:punct:][:cntrl:][:space:]]*)\)$", $field_default, $vals)) {
			// val[1] is the function name
			If (!empty($vals[1])) {
				$function_written = strtoupper($vals[1]);
				# compare to $cfgFunctions array
				$index_of_function = array_keys ($cfgFunctions, $function_written);
				
				If ($index_of_function[0] > 1) {  // has function	
						$default_query = "ALTER TABLE ".dq($table)." ALTER ".dq($field_name)." SET DEFAULT ".$field_default;
				} else {
						$default_query = "ALTER TABLE ".dq($table)." ALTER ".dq($field_name)." SET DEFAULT ".squotes($field_default);
				}
			}
	}
	// default field is blank.
} else {
		$default_query = "ALTER TABLE ".dq($table)." ALTER ".dq($field_name)." DROP DEFAULT";


}


// strip slashes
$default_query = stripslashes($default_query);
	
$sql_query = $rename_query;

if (!empty($sql_query)) {
	$sql_query .= "; \n";
}

// $sql_query 
$sql_query .= $default_query;
	

?>
