#!/usr/bin/perl##################################################
#								#
# pglogparser.pl v 0.1.1					#
# This perl script parses that entries in a PostgreSQL log file	#
# and outputs the information in a nice format.  Current only	#
# parses query logs						#
#								#
#    Written by Stephen Howie (showie8@comcast.net)		#
#    (c) 2003 showie						#
#    Released under the BSD License.				#
#								#
#################################################################

use Text::Wrap;

if($ARGV[0]){
	if($ARGV[0] eq '--help'){
		print "perl pglogparser.pl [filename] [> duration] [print type]\n";
		exit();
	}else{
		open(F,$ARGV[0]) or die "$!";
	}
}else{
	print "perl pglogparser.pl [filename] [> duration] [print type]\n";
	die "No file specified!";
}

my $value = 0;
if($ARGV[1]){
	$value = $ARGV[1];
}
my $printtype = 0;
if($ARGV[2]){$printtype = $ARGV[2];}

sub printout
{
	if($printtype == 0){
		print '[' . @_[0] . '] ' . @_[1] . "\t" . @_[2] . "\t" . @_[3] . "\t" . @_[4] . "\t" . @_[5] . "\n";
	}elsif($printtype == 1){
		print "-------------------------------------------\n";
		print '[' . @_[0] . '] ' . @_[4] . "\n";
		print '[' . @_[0] . '] ' . @_[1] . "\n";
		print '[' . @_[0] . '] ' . @_[2] . "\n";
		print '[' . @_[0] . '] ' . @_[3] . "\n";
		print '[' . @_[0] . '] ' . wrap("","",@_[5]) . "\n";
	}
}

my %holding;
my %timestamp1;
my $i = 0;
while(<F>)
{
	read(F,my $timestamp,19);
	read(F,my $text,2);
	next if $text ne ' [';

	my $pid;
	my $pidr;
	my $logtype;
	my $type;
	my $typer;
	my $out;
	my $outr;
	while(read(F,$pidr,1) && $pidr ne ']'){
		$pid .= $pidr;
	}

	seek(F,2,1);
	
	read(F,$logtype,6);

	while(read(F,$typer,1) && $typer ne ' ' && $typer ne "\n"){
		$type .= $typer;
	}
	if($logtype eq 'ERROR:'){$type = $logtype;}

	next if !$type;
	
	while(read(F,$outr,1) && $outr ne "\n"){
		$out .= $outr;
	}
	$out =~ s/^\s//;

	seek(F,-1,1);
        
	if($type eq 'query:'){
		delete($holding{$pid});
		delete($htimestamp{$pid});
		$htimestamp{$pid} = $timestamp;
		$holding{$pid} = $out;
	}elsif($type eq 'statement:'){
		$out =~ s/\n$//;
		$holding{$pid} .= $out;
	}elsif($type eq 'ERROR:'){
		if(exists($holding{$pid})){
			if((substr($out,0,8) + 0) >= $value){
				printout($pid,$htimestamp{$pid},$timestamp,"\t",'ERROR',$out . ';' . $holding{$pid});
				$i++;
			}
		}
	}elsif($type eq 'duration:'){
		if(exists($holding{$pid})){
			if((substr($out,0,8) + 0) >= $value){
				printout($pid,$htimestamp{$pid},$timestamp,$out,'QUERY',$holding{$pid});
				$i++;
			}
		}
	}
}
print "-------------------------------------------\n";
print $i . " queries\n";
