/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "indexitempopup.h"
#include "indexlistviewitem.h"
#include "../../common/commentform.h"
#include "../../../utils/debugger.h"

	/**
	 * Constructor
	 */
	IndexItemPopup::IndexItemPopup(QWidget *pqoParent, IndexListViewItem *poIndexListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poIndexListViewItem = poIndexListViewItem;	// keep a reference to the Index item
		
		insertItem("View/Edit Comment", this, SLOT(editComment()));				

	} // end constructor

	/**
	 * Used to get a reference to the Index item that this popup was generated from.
	 */
	IndexListViewItem * IndexItemPopup::getIndexListViewItem() const
	{
		return m_poIndexListViewItem;
	} // end getIndexListViewItem
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void IndexItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poIndexListViewItem->getDBMasterManager())->getDBConnection()),
																				CommentForm::IndexComment);
		poCommentForm->setObjectName(m_poIndexListViewItem->getIndexName());		
		poCommentForm->setComment(m_poIndexListViewItem->getIndexComment().c_str());
		poCommentForm->show();				
	} // end editComment

