/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "foreignkeygrouplistviewitem.h"
#include "foreignkeylistviewitem.h"
#include "../../common/infodialogs.h"
#include "../../../utils/debugger.h"

#include <iostream.h>

	ForeignKeyGroupListViewItem::ForeignKeyGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrForeignKeys("Foreign Keys");
		setText(0, qstrForeignKeys);
		m_qstrDescription = "<h1>Foreign Keys</h1><hr><p>Lists all the foreign keys for this database table.</p>";		
	} // end constructor

	ForeignKeyGroupListViewItem::ForeignKeyGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrForeignKeys("Foreign Keys");
		setText(0, qstrForeignKeys);
		m_qstrDescription = "<h1>Foreign Keys</h1><hr><p>Lists all the foreign keys for this database table.</p>";		
	} // end constructor

	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void ForeignKeyGroupListViewItem::setTableName(const string & rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName
					
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void ForeignKeyGroupListViewItem::initChildren()
	{	
		string strMethodName = "ForeignKeyGroupListViewItem::initChildren";
		
		Debugger::entered(strMethodName);
		
		DBForeignKeySet oDBForeignKeySet;
		
		try
		{		
			getDBMasterManager()->getDBForeignKeyManager()->retrieveListOfForeignKeys(m_strTableName, oDBForeignKeySet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);						
			return;
		} // end catch
		while (oDBForeignKeySet.next())
		{
			ForeignKeyListViewItem *poForeignKeyItem = new ForeignKeyListViewItem(this);
			// retrieve trigger details
			oDBForeignKeySet.getDBForeignKey(*poForeignKeyItem);
			poForeignKeyItem->setText(0, QString(poForeignKeyItem->getForeignKeyName().c_str()));					
			// set master manager
			poForeignKeyItem->setDBMasterManager(getDBMasterManager());
			poForeignKeyItem->updateDescription();
		} // end while more

		Debugger::exited(strMethodName);
	} // end initChildren
	