/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "mainlistview.h"
#include "grouplistviewitem.h"
#include <qpoint.h>
#include <iostream.h>

	MainListView::MainListView(QWidget *pqoParent)
  	  : QListView(pqoParent)
	{		
		// setup signal and slot
		connect(this, SIGNAL(pressed(QListViewItem*)), this, SLOT(changeItemDescription(QListViewItem*)));
		connect(this, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(changeItemDescription(QListViewItem*)));		
		connect(this, SIGNAL(expanded(QListViewItem*)), this, SLOT(prepareGrandChildren(QListViewItem*)));				
		connect(this, SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int)), this, SLOT(showRightPressedMenu(QListViewItem *, const QPoint &, int)));				
				
	} // end constructor

	/**
	 * This slot is used to add a new group item.
	 */
	void MainListView::addGroupItem()
	{
		GroupListViewItem *poGroupItem = new GroupListViewItem(this);
		QString qstrGroup("New Group");
		poGroupItem->setText(0, qstrGroup);
		setSelected(poGroupItem, true);
	
	} // end addGroupItem
	
	void MainListView::showRightPressedMenu(QListViewItem *pqoListViewItem, const QPoint & rqoPoint, int nColumn)
	{
		if (pqoListViewItem == 0)
		{
			// do nothing return
			return;
		} // end if null
		
		// call init grand children
		((BaseListViewItem*)pqoListViewItem)->showRightPressedMenu(rqoPoint, nColumn);
		
	} // end showRightPressedMenu

	void MainListView::changeItemDescription(QListViewItem *pqoListViewItem)
	{
		if (pqoListViewItem == 0)
		{
			// do nothing return
			return;
		} // end if null
		
		// get description out
		// must cast to BaseListViewItem as this has the getDescription method
		QString qstrDescription = ((BaseListViewItem*)pqoListViewItem)->getDescription();
		
		// emit need to change description signal
		emit itemDescriptionChanged(qstrDescription);
		
	} // end showRightPressedMenu
	
	void MainListView::prepareGrandChildren(QListViewItem *pqoListViewItem)		
	{
		if (pqoListViewItem == 0)
		{
			// do nothing return
			return;
		} // end if null
		
		// call init grand children
		((BaseListViewItem*)pqoListViewItem)->initGrandChildren();

	} // end prepareChildren