/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef VPEXCEPTION_H
#define VPEXCEPTION_H

#include <string>

/**
 * This class is the based class used by all exceptions in the VisualPsql application.
 * The class encapsulates information about the exception that might be useful to
 * other objects and also for debugging.
 *
 * The class should never be used directly. Two other classes are provided that other
 * generalised exceptions should inherit, namely VPSystemException and VPAppicationException.
 */
class VPException
{

protected:
	string m_strDescription;
	string m_strClassName;
	string m_strMethodName;
	string m_strName;			// this member variable is used to record the name of this exception
				
public:
	
	/**
 	 * Constructor
 	 *
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	VPException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);

	/**
 	 * Copy Constructor
 	 * Make sure copy constructors are written for any subclasses that have extra member variables.
 	 *
 	 * @param	roException			another exception to copy
   */		
	VPException(const VPException &roException);

	/**
 	 * Assignment operator
 	 * Make sure assignment operator are written for any subclasses that have extra member variables.
 	 *
 	 * @param	roException			another exception to assign from
   */		
	VPException & operator=(const VPException &roException);
		
	/**
 	 * Used to retrieve the exception description.
   */			    	
	const string &getExceptionDescription() const;

	/**
 	 * Used to retrieve the class name of origin.
   */			    			
	const string &getExceptionClassName() const;

	/**
 	 * Used to retrieve the method name of origin.
   */			    						
	const string &getExceptionMethodName() const;

	/**
 	 * Used to retrieve the exception name;
   */			    						
	const string &getExceptionName() const;
			
};


#endif

