/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "vpexception.h"					
#include <iostream.h>
	
	/**
 	 * Constructor
 	 *
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	VPException::VPException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName)
	{
		// make copies of the strings
		m_strDescription = rstrDescription;
		m_strClassName = rstrClassName;
		m_strMethodName = rstrMethodName;
		m_strName = "VPException";	// exception name
		// for debug
		cout << "\n-----------------";
		cout << "\nException Name: " << m_strName;
		cout << "\nDescription: " << m_strDescription;
		cout << "\nClassName: " << m_strClassName;
		cout << "\nMethodName: " << m_strMethodName;
		cout << "\n-----------------";
	} // end constructor

	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException
   */		
	VPException::VPException(const VPException &roException)
	{
		// make copies of the strings
		m_strDescription = roException.getExceptionDescription();
		m_strClassName = roException.getExceptionClassName();
		m_strMethodName = roException.getExceptionMethodName();
		m_strName = roException.getExceptionName();
	} // end copy constructor

	/**
 	 * Assignment operator
 	 * Make sure assignment operator are written for any subclasses that have extra member variables.
 	 *
 	 * @param	roException			another exception to assign from
   */		
	VPException & VPException::operator=(const VPException &roException)
	{
		// make copies of the strings
		m_strDescription = roException.getExceptionDescription();
		m_strClassName = roException.getExceptionClassName();
		m_strMethodName = roException.getExceptionMethodName();
		m_strName = roException.getExceptionName();
		
		return *this;	// return a reference to the calling object
	} // end operator=
		
	/**
 	 * Used to retrieve the exception description.
   */			    	
	const string &VPException::getExceptionDescription() const
	{
		return m_strDescription;
	} // end getExceptionDescription

	/**
 	 * Used to retrieve the class name of origin.
   */			    			
	const string &VPException::getExceptionClassName() const
	{
		return m_strClassName;
	} // end getExceptionClassName

	/**
 	 * Used to retrieve the method name of origin.
   */			    						
	const string &VPException::getExceptionMethodName() const
	{
		return m_strMethodName;
	} // end getExceptionMethodName

	/**
 	 * Used to retrieve the exception name;
   */			    						
	const string &VPException::getExceptionName() const
	{
		return m_strName;	
	} // end getExceptionName

