/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBSEQUENCE_H
#define DBSEQUENCE_H

#include <string>

/**
 * This class is used to represent a database sequence.
 */
class DBSequence
{

protected:
	string m_strSequenceName;
	string m_strSequenceComment;
	string m_strSequenceOwner;
				
public:
	
	/**
 	 * Constructor
   */		
	DBSequence();
	
	/**
 	 * Destructor
   */		
	~DBSequence();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to set the sequence name.
   */			    	
	void setSequenceName(const string &rstrSequenceName);

	/**
 	 * Used to retrieve the sequence name.
   */			    			
	const string & getSequenceName() const;

	/**
 	 * Used to set the sequence comment.
   */			    						
	void setSequenceComment(const string &rstrSequenceComment);

	/**
 	 * Used to retrieve the sequence comment.
   */			    			
	const string & getSequenceComment() const;			

	/**
 	 * Used to set the sequence owner.
   */			    						
	void setSequenceOwner(const string &rstrSequenceOwner);

	/**
 	 * Used to retrieve the sequence owner.
   */			    			
	const string & getSequenceOwner() const;			
		
};

#endif

