/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBFUNCTION_H
#define DBFUNCTION_H

#include <string>
#include <vector>
#include "../../exceptions/indexoutofrangeexception.h"

/**
 * This class is used to represent a database function (stored procedures).
 */
class DBFunction
{

protected:
	string m_strFunctionName;
	string m_strFunctionComment;
	string m_strFunctionOwner;
	string m_strLanguage;	
	string m_strReturnType;
	vector<string> m_vstrArgumentTypes;
				
public:
	
	/**
 	 * Constructor
   */		
	DBFunction();
	
	/**
 	 * Destructor
   */		
	~DBFunction();
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void clear();
	
	/**
 	 * Used to set the function name.
   */			    	
	void setFunctionName(const string &rstrFunctionName);

	/**
 	 * Used to retrieve the function name.
   */			    			
	const string & getFunctionName() const;

	/**
 	 * Used to set the function comment.
   */			    						
	void setFunctionComment(const string &rstrFunctionComment);

	/**
 	 * Used to retrieve the function comment.
   */			    			
	const string & getFunctionComment() const;			

	/**
 	 * Used to set the function owner.
   */			    						
	void setFunctionOwner(const string &rstrFunctionOwner);

	/**
 	 * Used to retrieve the function owner.
   */			    			
	const string & getFunctionOwner() const;			

	/**
 	 * Used to set the return type.
   */			    						
	void setReturnType(const string &rstrReturnType);

	/**
 	 * Used to retrieve the return type.
   */			    			
	const string & getReturnType() const;			

	/**
 	 * Used to set the language.
   */			    						
	void setLanguage(const string &rstrLanguage);

	/**
 	 * Used to retrieve the language.
   */			    			
	const string & getLanguage() const;			

	/**
 	 * Used to add an argument type to the list.
   */			    			
	void addArgumentType(const string & rstrArgumentType);
	
	/**
 	 * Used to retrieve an argument type.
   */			    			
	const string & getArgumentType(int nColumnIndex) const throw (IndexOutOfRangeException);
	
	/**
	 * Used to get the number arguments for this function.
	 */
	int getNumberOfArgumentTypes() const; 			

	/**
 	 * Used to get all the argument types in a vector.
   */			    			
	const vector<string> & getArgumentTypes() const;
						
};

#endif

