/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBBASEMANAGER_H
#define DBBASEMANAGER_H

#include <string>
#include "dbconnection.h"

/**
 * This class is used to the base class that all other managers will inherit from.
 */
class DBBaseManager
{
	
protected:
	// the database connection object
	DBConnection *m_poDBConn;
				
public:

	/**
 	 * Constructor
   */		
  DBBaseManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBBaseManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBBaseManager();

	/**
	 * Used to set the database connection object
	 * @param poDBConn
	 */
	void setDBConnection(DBConnection * poDBConn);

	/**
	 * Used to Get the database connection object
	 * @return a pointer to a database connection
	 */
	DBConnection * getDBConnection();
		
};

#endif

