/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlParser
extends SpiderParser {
    private static final Pattern urlPattern = Pattern.compile("url\\s*=\\s*[\"']?([^;'\"]+)", 2);
    private static final Pattern PLAIN_COMMENTS_URL_PATTERN = Pattern.compile("(?:http(?:s?):)?//[^\\x00-\\x1f\"'\\s<>#()\\[\\]{}]+", 2);
    private SpiderParam params;

    public SpiderHtmlParser(SpiderParam params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter params must not be null.");
        }
        this.params = params;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (source == null) {
            source = new Source((CharSequence)message.getResponseBody().toString());
        }
        String baseURL = message.getRequestHeader().getURI().toString();
        Element base = source.getFirstElement("base");
        if (base != null) {
            String href;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Base tag was found in HTML: " + base.getDebugInfo());
            }
            if ((href = base.getAttributeValue("href")) != null && !href.isEmpty()) {
                baseURL = URLCanonicalizer.getCanonicalURL(href, baseURL);
            }
        }
        this.parseSource(message, source, depth, baseURL);
        if (this.params.isParseComments()) {
            List comments = source.getAllStartTags(StartTagType.COMMENT);
            for (StartTag comment : comments) {
                Source s = new Source((CharSequence)comment.getTagContent());
                if (this.parseSource(message, s, depth, baseURL)) continue;
                Matcher matcher = PLAIN_COMMENTS_URL_PATTERN.matcher(s.toString());
                while (matcher.find()) {
                    this.processURL(message, depth, matcher.group(), baseURL);
                }
            }
        }
        return false;
    }

    private boolean parseSource(HttpMessage message, Source source, int depth, String baseURL) {
        this.getLogger().debug("Parsing an HTML message...");
        boolean resourcesfound = false;
        List elements = source.getAllElements("a");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "href");
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "ping");
        }
        elements = source.getAllElements("area");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "href");
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "ping");
        }
        elements = source.getAllElements("frame");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "src");
        }
        elements = source.getAllElements("iframe");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "src");
        }
        elements = source.getAllElements("link");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "href");
        }
        elements = source.getAllElements("script");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "src");
        }
        elements = source.getAllElements("img");
        for (Element el : elements) {
            resourcesfound |= this.processAttributeElement(message, depth, baseURL, el, "src");
        }
        elements = source.getAllElements("meta");
        for (Element el : elements) {
            Matcher matcher;
            String equiv = el.getAttributeValue("http-equiv");
            String content = el.getAttributeValue("content");
            if (equiv == null || content == null || !equiv.equalsIgnoreCase("refresh") && !equiv.equalsIgnoreCase("location") || !(matcher = urlPattern.matcher(content)).find()) continue;
            String url = matcher.group(1);
            this.processURL(message, depth, url, baseURL);
            resourcesfound = true;
        }
        return resourcesfound;
    }

    private boolean processAttributeElement(HttpMessage message, int depth, String baseURL, Element element, String attributeName) {
        String localURL = element.getAttributeValue(attributeName);
        if (localURL == null) {
            return false;
        }
        if (!attributeName.equalsIgnoreCase("ping")) {
            this.processURL(message, depth, localURL, baseURL);
        } else {
            for (String pingURL : localURL.split("\\s")) {
                if (pingURL.isEmpty()) continue;
                this.processURL(message, depth, pingURL, baseURL);
            }
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyConsumed) {
        return !wasAlreadyConsumed && message.getResponseHeader().isHtml();
    }
}

