/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class ChannelNumberAttribute
extends Attribute {
    public static final String NAME = "CHANNEL-NUMBER";
    public static final char DATA_LENGTH = '\u0004';
    private char channelNumber = '\u0000';

    ChannelNumberAttribute() {
        super('\f');
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ChannelNumberAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ChannelNumberAttribute att = (ChannelNumberAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.channelNumber == this.channelNumber;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.channelNumber >> 8 & 0xFF), (byte)(this.channelNumber & 0xFF), 0, 0};
        return binValue;
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("length invalid");
        }
        this.channelNumber = (char)(attributeValue[offset] << 8 | attributeValue[offset + '\u0001'] & 0xFF);
    }

    public void setChannelNumber(char channelNumber) {
        this.channelNumber = channelNumber;
    }

    public char getChannelNumber() {
        return this.channelNumber;
    }

    public static boolean isValidRange(char channelNo) {
        return channelNo >= '\u4000';
    }
}

