/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.ws.WebServiceException;
import org.virtualbox_7_2.IUnknown;
import org.virtualbox_7_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_2.jaxws.VboxPortType;

class ObjectRefManager {
    private static final ReferenceQueue<IUnknown> refQ = new ReferenceQueue();
    private final ConcurrentMap<String, ManagedObj> map = new ConcurrentHashMap<String, ManagedObj>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ObjRefMgrCleanupThread objRefMgrCleanup = new ObjRefMgrCleanupThread(this, 100);

    public ObjectRefManager() {
        this.objRefMgrCleanup.start();
    }

    public void preventObjRelease() {
        this.lock.readLock().lock();
    }

    public void allowObjRelease() {
        this.lock.readLock().unlock();
    }

    public void startObjRelease() {
        this.lock.writeLock().lock();
    }

    public void endObjRelease() {
        this.lock.writeLock().unlock();
    }

    public void registerObj(IUnknown iUnknown) {
        assert (this.lock.getReadLockCount() > 0);
        ManagedObjRef managedObjRef = new ManagedObjRef(iUnknown);
        ManagedObj managedObj = (ManagedObj)this.map.get(iUnknown.getWrapped());
        if (managedObj != null) {
            managedObj.addObject(managedObjRef);
        } else {
            managedObj = new ManagedObj(iUnknown.getWrapped(), iUnknown.getRemoteWSPort());
            managedObj.addObject(managedObjRef);
            this.map.put(iUnknown.getWrapped(), managedObj);
        }
    }

    public ManagedObj unregisterObj(ManagedObjRef managedObjRef) {
        ManagedObj managedObj = (ManagedObj)this.map.get(managedObjRef.objId);
        assert (managedObj != null);
        managedObj.removeObject(managedObjRef);
        if (!managedObj.isReferenced()) {
            return managedObj;
        }
        return null;
    }

    public void releaseRemoteObj(ManagedObj managedObj) {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (!managedObj.isReferenced()) {
            try {
                managedObj.port.iManagedObjectRefRelease(managedObj.objId);
            }
            catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
                throw new WebServiceException((Throwable)invalidObjectFaultMsg);
            }
            catch (RuntimeFaultMsg runtimeFaultMsg) {
                throw new WebServiceException((Throwable)runtimeFaultMsg);
            }
            finally {
                this.map.remove(managedObj.objId);
            }
        }
    }

    static class ObjRefMgrCleanupThread
    extends Thread {
        ObjectRefManager objRefMgr;
        int cStubsReleased;
        int cStubsReleaseThreshold;
        HashMap<String, ManagedObj> mapToRelease = new HashMap();

        ObjRefMgrCleanupThread(ObjectRefManager objectRefManager) {
            this.init(objectRefManager, 500);
        }

        ObjRefMgrCleanupThread(ObjectRefManager objectRefManager, int n) {
            this.init(objectRefManager, n);
        }

        private void init(ObjectRefManager objectRefManager, int n) {
            this.objRefMgr = objectRefManager;
            this.cStubsReleased = 0;
            this.cStubsReleaseThreshold = n;
            this.setName("ObjectRefManager-VBoxWSObjRefGcThrd");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            while (true) lbl-1000:
            // 8 sources

            {
                if (this.cStubsReleased < this.cStubsReleaseThreshold) {
                    try {
                        while (true) {
                            if (this.cStubsReleased >= this.cStubsReleaseThreshold) ** GOTO lbl-1000
                            var1_1 = (ManagedObjRef)ObjectRefManager.access$200().remove();
                            var2_5 = this.objRefMgr.unregisterObj(var1_1);
                            if (var2_5 != null && !this.mapToRelease.containsKey(var1_1.objId)) {
                                this.mapToRelease.put(var1_1.objId, var2_5);
                            }
                            ++this.cStubsReleased;
                        }
                    }
                    catch (InterruptedException var1_2) {
                    }
                    catch (WebServiceException var1_3) {}
                    continue;
                }
                this.cStubsReleased = 0;
                if (this.mapToRelease.isEmpty()) continue;
                this.objRefMgr.startObjRelease();
                try {
                    for (ManagedObj var2_5 : this.mapToRelease.values()) {
                        this.objRefMgr.releaseRemoteObj(var2_5);
                    }
                    this.mapToRelease.clear();
                }
                catch (WebServiceException var1_4) {}
                continue;
                finally {
                    this.objRefMgr.endObjRelease();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ManagedObjRef
    extends WeakReference<IUnknown> {
        final String objId;

        ManagedObjRef(IUnknown iUnknown) {
            super(iUnknown, refQ);
            this.objId = iUnknown.getWrapped();
        }
    }

    static class ManagedObj {
        private final String objId;
        private final VboxPortType port;
        private final ConcurrentLinkedQueue<ManagedObjRef> refQ;

        ManagedObj(String string, VboxPortType vboxPortType) {
            this.objId = string;
            this.port = vboxPortType;
            this.refQ = new ConcurrentLinkedQueue();
        }

        public void addObject(ManagedObjRef managedObjRef) {
            this.refQ.add(managedObjRef);
        }

        public void removeObject(ManagedObjRef managedObjRef) {
            this.refQ.remove(managedObjRef);
        }

        public boolean isReferenced() {
            return !this.refQ.isEmpty();
        }
    }
}

