for f in $(find -name '*.re'); do
    grep -q -E 'func Test|func main()' $f || continue # skip incomplete tests

    echo $f
    gofile="${f%.re}.go"
    gotest="example_test.go"

    cat "$gofile" \
        | egrep -v 'warning: rule .*matches empty string \[-Wmatch-empty-string\]' \
        | egrep -v 'warning: tag .* degree of nondeterminism \[-Wnondeterministic-tags\]' \
        > "$gotest"

    # If the autogenerated message appears more than once in the file, then
    # it must have autogenerated header appended at the end. Cut it off.
    msg='// Code generated by re2c, DO NOT EDIT.'
    if [ $(grep -c "$msg" "$gotest") -gt 1 ]; then
        # Get the line of the second message occurrence.
        l=$(grep -n "$msg" "$gotest" | tail -n +2 | cut -d : -f 1)
        # Cut off everything past that line.
        head -n $l "$gotest" > "$gotest".mod && mv "$gotest".mod "$gotest"
    fi

    GO111MODULE=off \
    GOPATH="${GOPATH}:$(pwd)/$(dirname $gofile)" \
        go test "$gotest" || { echo "*** error ***"; exit 1; }
    rm -f "$gotest"
done

echo "All good."
