; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN:opt -passes=loop-vectorize -force-vector-width=4 -force-vector-interleave=1 -S %s | FileCheck %s

; For %for.1, we are fine initially, because the previous value %for.1.next dominates the
; user of %for.1. But for %for.2, we have to sink the user (%for.1.next) past the previous
; value %for.2.next. This however breaks the condition we have for %for.1. We cannot fix
; both first order recurrences and cannot vectorize the loop.
define i32 @c(i32 %N) {
; CHECK-LABEL: @c(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[INC:%.*]], [[FOR_BODY]] ], [ 10, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[FOR_1:%.*]] = phi i32 [ [[FOR_1_NEXT:%.*]], [[FOR_BODY]] ], [ 20, [[ENTRY]] ]
; CHECK-NEXT:    [[FOR_2:%.*]] = phi i32 [ [[FOR_2_NEXT:%.*]], [[FOR_BODY]] ], [ 11, [[ENTRY]] ]
; CHECK-NEXT:    [[FOR_1_NEXT]] = add nsw i32 [[FOR_2]], 1
; CHECK-NEXT:    [[FOR_2_NEXT]] = shl i32 [[FOR_1]], 24
; CHECK-NEXT:    [[INC]] = add nsw i32 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i32 [[INC]], [[N:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_COND1_FOR_END_CRIT_EDGE:%.*]], label [[FOR_BODY]]
; CHECK:       for.cond1.for.end_crit_edge:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i32 [ [[FOR_1_NEXT]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[SEXT_LCSSA:%.*]] = phi i32 [ [[FOR_2_NEXT]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_LCSSA]], [[SEXT_LCSSA]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %for.body
  %iv  = phi i32 [ %inc, %for.body ], [ 10, %entry ]
  %for.1 = phi i32 [ %for.1.next, %for.body ], [ 20, %entry ]
  %for.2 = phi i32 [ %for.2.next, %for.body ], [ 11, %entry ]
  %for.1.next = add nsw i32 %for.2, 1
  %for.2.next = shl i32 %for.1, 24
  %inc = add nsw i32 %iv, 1
  %exitcond = icmp eq i32 %inc, %N
  br i1 %exitcond, label %for.cond1.for.end_crit_edge, label %for.body

for.cond1.for.end_crit_edge:                      ; preds = %for.body
  %add.lcssa = phi i32 [ %for.1.next, %for.body ]
  %sext.lcssa = phi i32 [ %for.2.next, %for.body ]
  %res = add i32 %add.lcssa, %sext.lcssa
  ret i32 %res
}


; The 'previous' instruction of %for.2 is in a separate block.
; PR54195.
define void @multiple_recurrences_with_previous_in_different_block(i32 %a, i8 %b, ptr %ptr) {
; CHECK-LABEL: @multiple_recurrences_with_previous_in_different_block(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[FOR_1:%.*]] = phi i8 [ 10, [[ENTRY:%.*]] ], [ [[FOR_1_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[FOR_2:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[FOR_2_NEXT:%.*]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[FOR_1]] to i64
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i64 [[CONV]], [[FOR_2]]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i64 [[IV]], 1
; CHECK-NEXT:    [[FOR_1_NEXT]] = xor i8 [[B:%.*]], 6
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV]], 1000
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[PTR_GEP:%.*]] = getelementptr inbounds i64, ptr [[PTR:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[SUB]], ptr [[PTR_GEP]], align 4
; CHECK-NEXT:    [[FOR_2_NEXT]] = zext i32 [[A:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %for.1 = phi i8 [ 10, %entry ], [ %for.1.next, %loop.latch ]
  %for.2 = phi i64  [0, %entry ], [ %for.2.next, %loop.latch ]
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %conv = sext i8 %for.1 to i64
  %sub = sub nsw i64 %conv, %for.2
  %iv.next = add nuw i64 %iv, 1
  %for.1.next = xor i8 %b, 6
  %exitcond = icmp eq i64 %iv, 1000
  br i1 %exitcond, label %exit, label %loop.latch

loop.latch:
  %ptr.gep = getelementptr inbounds i64, ptr %ptr, i64 %iv
  store i64 %sub, ptr %ptr.gep
  %for.2.next = zext i32 %a to i64
  br label %loop.header

exit:
  ret void
}

define void @test_pr54223_sink_after_insertion_order(ptr noalias %a, ptr noalias %b, ptr noalias %dst) {
; CHECK-LABEL: @test_pr54223_sink_after_insertion_order(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR:%.*]] = phi <4 x float> [ <float poison, float poison, float poison, float 0.000000e+00>, [[VECTOR_PH]] ], [ [[BROADCAST_SPLAT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR1:%.*]] = phi <4 x float> [ <float poison, float poison, float poison, float 0.000000e+00>, [[VECTOR_PH]] ], [ [[BROADCAST_SPLAT3:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds float, ptr [[DST:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <4 x float> poison, float [[TMP2]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT]] = shufflevector <4 x float> [[BROADCAST_SPLATINSERT]], <4 x float> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP3:%.*]] = shufflevector <4 x float> [[VECTOR_RECUR]], <4 x float> [[BROADCAST_SPLAT]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    [[TMP4:%.*]] = load float, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT2:%.*]] = insertelement <4 x float> poison, float [[TMP4]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT3]] = shufflevector <4 x float> [[BROADCAST_SPLATINSERT2]], <4 x float> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <4 x float> [[VECTOR_RECUR1]], <4 x float> [[BROADCAST_SPLAT3]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    [[TMP6:%.*]] = fneg <4 x float> [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = call <4 x float> @llvm.fmuladd.v4f32(<4 x float> [[TMP3]], <4 x float> [[TMP6]], <4 x float> zeroinitializer)
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr inbounds float, ptr [[TMP1]], i32 0
; CHECK-NEXT:    store <4 x float> [[TMP7]], ptr [[TMP8]], align 4
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i64 [[INDEX_NEXT]], 10000
; CHECK-NEXT:    br i1 [[TMP9]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       middle.block:
; CHECK-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; CHECK:       scalar.ph:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 10000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT:%.*]] = phi float [ [[TMP2]], [[MIDDLE_BLOCK]] ], [ 0.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT5:%.*]] = phi float [ [[TMP4]], [[MIDDLE_BLOCK]] ], [ 0.000000e+00, [[ENTRY]] ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[SCALAR_RECUR:%.*]] = phi float [ [[SCALAR_RECUR_INIT]], [[SCALAR_PH]] ], [ [[FOR_1_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[SCALAR_RECUR6:%.*]] = phi float [ [[SCALAR_RECUR_INIT5]], [[SCALAR_PH]] ], [ [[FOR_2_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[SCALAR_RECUR6]]
; CHECK-NEXT:    [[MULADD:%.*]] = call float @llvm.fmuladd.f32(float [[SCALAR_RECUR]], float [[NEG]], float 0.000000e+00)
; CHECK-NEXT:    [[DST_GEP:%.*]] = getelementptr inbounds float, ptr [[DST]], i64 [[IV]]
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; CHECK-NEXT:    [[FOR_1_NEXT]] = load float, ptr [[A]], align 4
; CHECK-NEXT:    [[FOR_2_NEXT]] = load float, ptr [[B]], align 4
; CHECK-NEXT:    store float [[MULADD]], ptr [[DST_GEP]], align 4
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_NEXT]], 10000
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %for.1 = phi float [ 0.0, %entry ], [ %for.1.next, %loop ]
  %for.2 = phi float [ 0.0, %entry ], [ %for.2.next, %loop ]
  %neg = fneg float %for.2
  %muladd = call float @llvm.fmuladd.f32(float %for.1, float %neg, float 0.000000e+00)
  %dst.gep = getelementptr inbounds float, ptr %dst, i64 %iv
  %iv.next = add nuw nsw i64 %iv, 1
  %for.1.next = load float, ptr %a, align 4
  %for.2.next = load float, ptr %b, align 4
  store float %muladd, ptr %dst.gep
  %exitcond.not = icmp eq i64 %iv.next, 10000
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

declare float @llvm.fmuladd.f32(float, float, float) #1

define void @test_pr54227(ptr noalias %a, ptr noalias %b) {
; CHECK-LABEL: @test_pr54227(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[AND17:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[AND1:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[F_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[MUL:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[E_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[AND17]], 255
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[AND]], [[E_0]]
; CHECK-NEXT:    [[AND1]] = and i32 [[E_0]], [[F_0]]
; CHECK-NEXT:    [[MUL]] = shl nsw i32 [[OR]], 1
; CHECK-NEXT:    [[ADD]] = or i32 [[AND1]], 1
; CHECK-NEXT:    [[A_GEP:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i32 [[ADD]], ptr [[A_GEP]], align 4
; CHECK-NEXT:    [[B_GEP:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IV]]
; CHECK-NEXT:    store i32 [[MUL]], ptr [[B_GEP]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV]], 1000
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %and17 = phi i32 [ 0, %entry ], [ %and1, %loop ]
  %f.0 = phi i32 [ 0, %entry ], [ %mul, %loop ]
  %e.0 = phi i32 [ 0, %entry ], [ %add, %loop ]
  %and = and i32 %and17, 255
  %or = or i32 %and, %e.0
  %and1 = and i32 %e.0, %f.0
  %mul = shl nsw i32 %or, 1
  %add = or i32 %and1, 1
  %a.gep = getelementptr inbounds i32, ptr %a, i64 %iv
  store i32 %add, ptr %a.gep, align 4
  %b.gep = getelementptr inbounds i32, ptr %a, i64 %iv
  store i32 %mul, ptr %b.gep, align 4
  %iv.next = add nuw i64 %iv, 1
  %exitcond = icmp eq i64 %iv, 1000
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @test_pr54233_for_depend_on_each_other(ptr noalias %a, ptr noalias %b) {
; CHECK-LABEL: @test_pr54233_for_depend_on_each_other(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR:%.*]] = phi <4 x i32> [ <i32 poison, i32 poison, i32 poison, i32 0>, [[VECTOR_PH]] ], [ [[TMP4:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR1:%.*]] = phi <4 x i32> [ <i32 poison, i32 poison, i32 poison, i32 0>, [[VECTOR_PH]] ], [ [[BROADCAST_SPLAT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <4 x i32> poison, i32 [[TMP1]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT]] = shufflevector <4 x i32> [[BROADCAST_SPLATINSERT]], <4 x i32> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x i32> [[VECTOR_RECUR1]], <4 x i32> [[BROADCAST_SPLAT]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    [[TMP3:%.*]] = or <4 x i32> [[TMP2]], splat (i32 10)
; CHECK-NEXT:    [[TMP4]] = xor <4 x i32> splat (i32 12), [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <4 x i32> [[VECTOR_RECUR]], <4 x i32> [[TMP4]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    [[TMP6:%.*]] = shl <4 x i32> [[TMP2]], [[TMP5]]
; CHECK-NEXT:    [[TMP7:%.*]] = xor <4 x i32> [[TMP6]], splat (i32 255)
; CHECK-NEXT:    [[TMP8:%.*]] = and <4 x i32> [[TMP7]], [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i32, ptr [[TMP9]], i32 0
; CHECK-NEXT:    store <4 x i32> [[TMP8]], ptr [[TMP10]], align 4
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; CHECK-NEXT:    [[TMP11:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; CHECK-NEXT:    br i1 [[TMP11]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; CHECK:       middle.block:
; CHECK-NEXT:    [[VECTOR_RECUR_EXTRACT:%.*]] = extractelement <4 x i32> [[TMP4]], i32 3
; CHECK-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; CHECK:       scalar.ph:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT:%.*]] = phi i32 [ [[VECTOR_RECUR_EXTRACT]], [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT3:%.*]] = phi i32 [ [[TMP1]], [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[SCALAR_RECUR:%.*]] = phi i32 [ [[SCALAR_RECUR_INIT]], [[SCALAR_PH]] ], [ [[FOR_1_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[SCALAR_RECUR4:%.*]] = phi i32 [ [[SCALAR_RECUR_INIT3]], [[SCALAR_PH]] ], [ [[FOR_2_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[SCALAR_RECUR4]], 10
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[SCALAR_RECUR4]], [[SCALAR_RECUR]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[SHL]], 255
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[XOR]], [[OR]]
; CHECK-NEXT:    [[FOR_1_NEXT]] = xor i32 12, [[SCALAR_RECUR4]]
; CHECK-NEXT:    [[FOR_2_NEXT]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    [[A_GEP:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IV]]
; CHECK-NEXT:    store i32 [[AND]], ptr [[A_GEP]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV]], 1000
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %for.1 = phi i32 [ 0, %entry ], [ %for.1.next, %loop ]
  %for.2 = phi i32 [ 0, %entry ], [ %for.2.next, %loop ]
  %or = or i32 %for.2, 10
  %shl = shl i32 %for.2, %for.1
  %xor = xor i32 %shl, 255
  %and = and i32 %xor, %or
  %for.1.next = xor i32 12, %for.2
  %for.2.next = load i32, ptr %b
  %a.gep = getelementptr inbounds i32, ptr %a, i64 %iv
  store i32 %and, ptr %a.gep, align 4
  %iv.next = add nuw i64 %iv, 1
  %exitcond = icmp eq i64 %iv, 1000
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

define void @pr54218(ptr %dst, ptr noalias %d) {
; CHECK-LABEL: @pr54218(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[FOR_1:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[FOR_1_NEXT:%.*]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[P:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[P_NEXT:%.*]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq i32 [[FOR_1]], 0
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C_1]], i8 [[P]], i8 0
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV]], 1000
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[FOR_1_NEXT]] = load i32, ptr [[D:%.*]], align 4
; CHECK-NEXT:    [[P_NEXT]] = add i8 [[SEL]], -1
; CHECK-NEXT:    [[DST_GEP:%.*]] = getelementptr inbounds i8, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i8 [[SEL]], ptr [[DST_GEP]], align 1
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i64 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %for.1 = phi i32 [ 0, %entry ], [ %for.1.next, %loop.latch ]
  %p = phi i8 [ 0, %entry ], [ %p.next, %loop.latch ]
  %c.1 = icmp eq i32 %for.1, 0
  %sel = select i1 %c.1, i8 %p, i8 0
  %exitcond = icmp eq i64 %iv, 1000
  br i1 %exitcond, label %exit, label %loop.latch

loop.latch:
  %for.1.next = load i32, ptr %d, align 4
  %p.next = add i8 %sel, -1
  %dst.gep = getelementptr inbounds i8, ptr %dst, i64 %iv
  store i8 %sel, ptr %dst.gep
  %iv.next = add nuw i64 %iv, 1
  br label %loop.header

exit:
  ret void
}

define void @pr54254_fors_depend_on_each_other(ptr %dst) {
; CHECK-LABEL: @pr54254_fors_depend_on_each_other(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[D_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[XOR:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[C_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[REM_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[F_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[XOR1:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[D_0]], -1
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[F_0]], [[NEG]]
; CHECK-NEXT:    [[XOR]] = xor i32 [[C_0]], 1
; CHECK-NEXT:    [[XOR1]] = xor i32 [[REM]], 1
; CHECK-NEXT:    [[DST_GEP:%.*]] = getelementptr inbounds i32, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    [[REM_NEXT]] = add i32 [[REM]], 10
; CHECK-NEXT:    store i32 [[REM]], ptr [[DST_GEP]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[IV]], 1000
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %d.0 = phi i32 [ 0, %entry ], [ %xor, %loop ]
  %c.0 = phi i32 [ 0, %entry ], [ %rem.next, %loop ]
  %f.0 = phi i32 [ 0, %entry ], [ %xor1, %loop ]
  %neg = xor i32 %d.0, -1
  %rem = srem i32 %f.0, %neg
  %xor = xor i32 %c.0, 1
  %xor1 = xor i32 %rem, 1
  %dst.gep = getelementptr inbounds i32, ptr %dst, i64 %iv
  %rem.next = add i32 %rem, 10
  store i32 %rem, ptr %dst.gep
  %iv.next = add nuw i64 %iv, 1
  %exitcond = icmp eq i64 %iv, 1000
  br i1 %exitcond, label %exit, label %loop

exit:
  ret void
}

; Similar to the test cases for https://github.com/llvm/llvm-project/issues/106523.
; The previous truncation (%trunc) gets vectorized (rather than folded into an
; IV) and hoisted along with its AND operand above the user 'or'.
define void @hoist_previous_value_and_operand(ptr %dst, i64 %mask) {
; CHECK-LABEL: @hoist_previous_value_and_operand(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; CHECK:       vector.ph:
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <4 x i64> poison, i64 [[MASK:%.*]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <4 x i64> [[BROADCAST_SPLATINSERT]], <4 x i64> poison, <4 x i32> zeroinitializer
; CHECK-NEXT:    br label [[VECTOR_BODY:%.*]]
; CHECK:       vector.body:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR:%.*]] = phi <4 x i32> [ <i32 poison, i32 poison, i32 poison, i32 1>, [[VECTOR_PH]] ], [ [[TMP4:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[VECTOR_RECUR1:%.*]] = phi <4 x i32> [ <i32 poison, i32 poison, i32 poison, i32 0>, [[VECTOR_PH]] ], [ [[TMP6:%.*]], [[VECTOR_BODY]] ]
; CHECK-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i32, ptr [[DST:%.*]], i64 [[OFFSET_IDX]]
; CHECK-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = and <4 x i64> [[VEC_IND]], [[BROADCAST_SPLAT]]
; CHECK-NEXT:    [[TMP4]] = trunc <4 x i64> [[TMP3]] to <4 x i32>
; CHECK-NEXT:    [[TMP5:%.*]] = shufflevector <4 x i32> [[VECTOR_RECUR]], <4 x i32> [[TMP4]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    [[TMP6]] = or <4 x i32> [[TMP5]], splat (i32 3)
; CHECK-NEXT:    [[TMP7:%.*]] = shufflevector <4 x i32> [[VECTOR_RECUR1]], <4 x i32> [[TMP6]], <4 x i32> <i32 3, i32 4, i32 5, i32 6>
; CHECK-NEXT:    store <4 x i32> [[TMP7]], ptr [[TMP2]], align 4
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; CHECK-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i64 [[INDEX_NEXT]], 336
; CHECK-NEXT:    br i1 [[TMP8]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; CHECK:       middle.block:
; CHECK-NEXT:    [[VECTOR_RECUR_EXTRACT:%.*]] = extractelement <4 x i32> [[TMP4]], i32 3
; CHECK-NEXT:    [[VECTOR_RECUR_EXTRACT2:%.*]] = extractelement <4 x i32> [[TMP6]], i32 3
; CHECK-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; CHECK:       scalar.ph:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 337, [[MIDDLE_BLOCK]] ], [ 1, [[BB:%.*]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT:%.*]] = phi i32 [ [[VECTOR_RECUR_EXTRACT]], [[MIDDLE_BLOCK]] ], [ 1, [[BB]] ]
; CHECK-NEXT:    [[SCALAR_RECUR_INIT3:%.*]] = phi i32 [ [[VECTOR_RECUR_EXTRACT2]], [[MIDDLE_BLOCK]] ], [ 0, [[BB]] ]
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[ADD:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR_1:%.*]] = phi i32 [ [[SCALAR_RECUR_INIT]], [[SCALAR_PH]] ], [ [[TRUNC:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[FOR_2:%.*]] = phi i32 [ [[SCALAR_RECUR_INIT3]], [[SCALAR_PH]] ], [ [[OR:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[OR]] = or i32 [[FOR_1]], 3
; CHECK-NEXT:    [[ADD]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i32, ptr [[DST]], i64 [[IV]]
; CHECK-NEXT:    store i32 [[FOR_2]], ptr [[GEP]], align 4
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ult i64 [[IV]], 337
; CHECK-NEXT:    [[A:%.*]] = and i64 [[IV]], [[MASK]]
; CHECK-NEXT:    [[TRUNC]] = trunc i64 [[A]] to i32
; CHECK-NEXT:    br i1 [[ICMP]], label [[LOOP]], label [[EXIT]], !llvm.loop [[LOOP7:![0-9]+]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
bb:
  br label %loop

loop:
  %iv = phi i64 [ 1, %bb ], [ %add, %loop ]
  %for.1 = phi i32 [ 1, %bb ], [ %trunc, %loop ]
  %for.2 = phi i32 [ 0, %bb ], [ %or, %loop ]
  %or = or i32 %for.1, 3
  %add = add i64 %iv, 1
  %gep = getelementptr inbounds i32, ptr %dst, i64 %iv
  store i32 %for.2, ptr %gep, align 4
  %icmp = icmp ult i64 %iv, 337
  %a = and i64 %iv, %mask
  %trunc = trunc i64 %a to i32
  br i1 %icmp, label %loop, label %exit

exit:
  ret void
}
