; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+tbm | FileCheck %s --check-prefixes=X64

; PR35908 - Fold ADD/SUB and bit extracts into ADC/SBB+BT
;
; int test_add_add(int x, int y, int z) { return ((x + y) + bool(z & (1 << 30))); }
; int test_add_sub(int x, int y, int z) { return ((x - y) + bool(z & (1 << 30))); }
; int test_sub_add(int x, int y, int z) { return ((x + y) - bool(z & (1 << 30))); }
; int test_sub_sub(int x, int y, int z) { return (x - (y - bool(z & (1 << 30)))); }

;
; Constant Bit Indices
;

define i32 @test_i32_add_add_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_add_add_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $30, {{[0-9]+}}(%esp)
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_add_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $30, %edx
; X64-NEXT:    adcl %esi, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, 30
  %mask = and i32 %shift, 1
  %add1 = add i32 %add, %mask
  ret i32 %add1
}

define i32 @test_i32_add_add_commute_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_add_add_commute_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $2, {{[0-9]+}}(%esp)
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_add_commute_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $2, %edx
; X64-NEXT:    adcl %esi, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, 2
  %mask = and i32 %shift, 1
  %add1 = add i32 %mask, %add
  ret i32 %add1
}

define i32 @test_i32_add_add_idx0(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_add_add_idx0:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_add_idx0:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    andl $1, %edx
; X64-NEXT:    addl %edx, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %mask = and i32 %z, 1
  %add1 = add i32 %mask, %add
  ret i32 %add1
}

define i24 @test_i24_add_add_idx(i24 %x, i24 %y, i24 %z) nounwind {
; X86-LABEL: test_i24_add_add_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $15, {{[0-9]+}}(%esp)
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i24_add_add_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $15, %edx
; X64-NEXT:    adcl %esi, %eax
; X64-NEXT:    retq
  %add = add i24 %y, %x
  %shift = lshr i24 %z, 15
  %mask = and i24 %shift, 1
  %add1 = add i24 %add, %mask
  ret i24 %add1
}

define i128 @test_i128_add_add_idx(i128 %x, i128 %y, i128 %z) nounwind {
; X86-LABEL: test_i128_add_add_idx:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    andl $-16, %esp
; X86-NEXT:    movl 8(%ebp), %eax
; X86-NEXT:    movl 48(%ebp), %ecx
; X86-NEXT:    movl 52(%ebp), %edx
; X86-NEXT:    movl 40(%ebp), %esi
; X86-NEXT:    movl 44(%ebp), %edi
; X86-NEXT:    addl 24(%ebp), %esi
; X86-NEXT:    adcl 28(%ebp), %edi
; X86-NEXT:    adcl 32(%ebp), %ecx
; X86-NEXT:    adcl 36(%ebp), %edx
; X86-NEXT:    btl $5, 64(%ebp)
; X86-NEXT:    adcl $0, %esi
; X86-NEXT:    adcl $0, %edi
; X86-NEXT:    adcl $0, %ecx
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    movl %edi, 4(%eax)
; X86-NEXT:    movl %esi, (%eax)
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl %edx, 12(%eax)
; X86-NEXT:    leal -8(%ebp), %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: test_i128_add_add_idx:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    addq %rdx, %rax
; X64-NEXT:    adcq %rcx, %rsi
; X64-NEXT:    btl $5, %r9d
; X64-NEXT:    adcq $0, %rax
; X64-NEXT:    adcq $0, %rsi
; X64-NEXT:    movq %rsi, %rdx
; X64-NEXT:    retq
  %add = add i128 %y, %x
  %shift = lshr i128 %z, 69
  %mask = and i128 %shift, 1
  %add1 = add i128 %add, %mask
  ret i128 %add1
}

define i32 @test_i32_add_sub_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_add_sub_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    subl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_sub_idx:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edx killed $edx def $rdx
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    subl %esi, %edi
; X64-NEXT:    shrl $31, %edx
; X64-NEXT:    leal (%rdx,%rdi), %eax
; X64-NEXT:    retq
  %sub = sub i32 %x, %y
  %shift = lshr i32 %z, 31
  %mask = and i32 %shift, 1
  %add = add i32 %sub, %mask
  ret i32 %add
}

define i32 @test_i32_add_sub_commute_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_add_sub_commute_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $8, {{[0-9]+}}(%esp)
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_sub_commute_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    btl $8, %edx
; X64-NEXT:    adcl $0, %eax
; X64-NEXT:    retq
  %sub = sub i32 %x, %y
  %shift = lshr i32 %z, 8
  %mask = and i32 %shift, 1
  %add = add i32 %mask, %sub
  ret i32 %add
}

define i32 @test_i32_sub_add_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_add_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $1, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl $0, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_idx:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    btl $1, %edx
; X64-NEXT:    sbbl $0, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, 1
  %mask = and i32 %shift, 1
  %sub = sub i32 %add, %mask
  ret i32 %sub
}

define i32 @test_i32_sub_add_commute_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_add_commute_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $1, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_commute_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $1, %edx
; X64-NEXT:    sbbl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, 1
  %mask = and i32 %shift, 1
  %add = add i32 %y, %mask
  %sub = sub i32 %x, %add
  ret i32 %sub
}

define i32 @test_i32_sub_add_sext_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_add_sext_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    shll $25, %ecx
; X86-NEXT:    sarl $31, %ecx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    subl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_sext_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $25, %edx
; X64-NEXT:    sarl $31, %edx
; X64-NEXT:    addl %esi, %edx
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    retq
  %shl = shl i32 %z, 25
  %sext = ashr i32 %shl, 31
  %add = add i32 %y, %sext
  %sub = sub i32 %x, %add
  ret i32 %sub
}

define i32 @test_i32_sub_sub_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_sub_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $16, {{[0-9]+}}(%esp)
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sub_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $16, %edx
; X64-NEXT:    adcl $0, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, 16
  %mask = and i32 %shift, 1
  %sub0 = sub i32 %y, %mask
  %sub1 = sub i32 %x, %sub0
  ret i32 %sub1
}

define i32 @test_i32_sub_sub_commute_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_sub_commute_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $15, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sub_commute_idx:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl $15, %edx
; X64-NEXT:    sbbl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, 15
  %mask = and i32 %shift, 1
  %sub0 = sub i32 %x, %y
  %sub1 = sub i32 %sub0, %mask
  ret i32 %sub1
}

define i32 @test_i32_sub_sum_idx(i32 %x, i32 %y, i32 %z) nounwind {
; X86-LABEL: test_i32_sub_sum_idx:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl $30, {{[0-9]+}}(%esp)
; X86-NEXT:    sbbl $0, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sum_idx:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    btl $30, %edx
; X64-NEXT:    sbbl $0, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, 30
  %mask = and i32 %shift, 1
  %add = add i32 %y, %x
  %sub = sub i32 %mask, %add
  ret i32 %sub
}

;
; Variable Bit Indices
;

define i32 @test_i32_add_add_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_add_add_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_add_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    adcl %esi, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add1 = add i32 %add, %mask
  ret i32 %add1
}

define i32 @test_i32_add_add_commute_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_add_add_commute_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_add_commute_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    adcl %esi, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add1 = add i32 %mask, %add
  ret i32 %add1
}

define i64 @test_i64_add_add_var(i64 %x, i64 %y, i64 %z, i64 %w) nounwind {
; X86-LABEL: test_i64_add_add_var:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl %ebx, %edi
; X86-NEXT:    shrl %cl, %edi
; X86-NEXT:    shrdl %cl, %ebx, %esi
; X86-NEXT:    testb $32, %cl
; X86-NEXT:    jne .LBB15_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:  .LBB15_2:
; X86-NEXT:    andl $1, %edi
; X86-NEXT:    addl %edi, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64-LABEL: test_i64_add_add_var:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    btq %rcx, %rdx
; X64-NEXT:    adcq %rsi, %rax
; X64-NEXT:    retq
  %add = add i64 %y, %x
  %shift = lshr i64 %z, %w
  %mask = and i64 %shift, 1
  %add1 = add i64 %add, %mask
  ret i64 %add1
}

define i32 @test_i32_add_sub_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_add_sub_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_sub_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    adcl $0, %eax
; X64-NEXT:    retq
  %sub = sub i32 %x, %y
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add = add i32 %sub, %mask
  ret i32 %add
}

define i32 @test_i32_add_sub_commute_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_add_sub_commute_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_add_sub_commute_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    adcl $0, %eax
; X64-NEXT:    retq
  %sub = sub i32 %x, %y
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add = add i32 %mask, %sub
  ret i32 %add
}

define i32 @test_i32_sub_add_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_add_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    sbbl $0, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_var:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    sbbl $0, %eax
; X64-NEXT:    retq
  %add = add i32 %y, %x
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %sub = sub i32 %add, %mask
  ret i32 %sub
}

define i32 @test_i32_sub_add_commute_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_add_commute_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_commute_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    sbbl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add = add i32 %y, %mask
  %sub = sub i32 %x, %add
  ret i32 %sub
}

define i32 @test_i32_sub_add_sext_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_add_sext_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shll %cl, %edx
; X86-NEXT:    sarl $31, %edx
; X86-NEXT:    addl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    subl %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_add_sext_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shll %cl, %edx
; X64-NEXT:    sarl $31, %edx
; X64-NEXT:    addl %esi, %edx
; X64-NEXT:    subl %edx, %eax
; X64-NEXT:    retq
  %shl = shl i32 %z, %w
  %sext = ashr i32 %shl, 31
  %add = add i32 %y, %sext
  %sub = sub i32 %x, %add
  ret i32 %sub
}

define i32 @test_i32_sub_sub_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_sub_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    adcl $0, %eax
; X86-NEXT:    subl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sub_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    adcl $0, %eax
; X64-NEXT:    subl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %sub0 = sub i32 %y, %mask
  %sub1 = sub i32 %x, %sub0
  ret i32 %sub1
}

define i32 @test_i32_sub_sub_commute_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_sub_commute_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    sbbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sub_commute_var:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    sbbl %esi, %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %sub0 = sub i32 %x, %y
  %sub1 = sub i32 %sub0, %mask
  ret i32 %sub1
}

define i32 @test_i32_sub_sum_var(i32 %x, i32 %y, i32 %z, i32 %w) nounwind {
; X86-LABEL: test_i32_sub_sum_var:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    btl %ecx, %edx
; X86-NEXT:    sbbl $0, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_i32_sub_sum_var:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $esi killed $esi def $rsi
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal (%rdi,%rsi), %eax
; X64-NEXT:    btl %ecx, %edx
; X64-NEXT:    sbbl $0, %eax
; X64-NEXT:    negl %eax
; X64-NEXT:    retq
  %shift = lshr i32 %z, %w
  %mask = and i32 %shift, 1
  %add = add i32 %y, %x
  %sub = sub i32 %mask, %add
  ret i32 %sub
}
