; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -aa-pipeline=basic-aa -passes='require<opt-remark-emit>,make-guards-explicit,loop-mssa(licm)' < %s | FileCheck %s

declare void @llvm.experimental.guard(i1,...)
declare void @maythrow()
declare void @llvm.experimental.deoptimize.isVoid(...)
declare i1 @llvm.experimental.widenable.condition()

; Make sure that we do not hoist widenable_cond out of loop.
; Widenable conditions don't actually alias anything or throw, however
; hoisting them is not profitable because it can prevent guard widening
; in loop.
; If we want to widen guards in branch form, we need to generate them
; at the point of widenable_condition call
; (see https://github.com/llvm/llvm-project/issues/60234). Because of
; this, hoisting a widenable condition out of loop can make widening of
; in-loop conditions impossible (e.g. if they depend on loop variant). On
; the other hand, hoisting of the WC doesn't really see profitable,
; because it will be optimized away later anyways. So the test checks that
; LICM will not move it out of loop.
define void @do_not_hoist_widenable_cond(i1 %cond, i32 %N, i32 %M) {
; CHECK-LABEL: @do_not_hoist_widenable_cond(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[GUARDED:%.*]] ]
; CHECK-NEXT:    [[GUARD_COND:%.*]] = icmp slt i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[GUARD_COND]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV]], [[M:%.*]]
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %guard_cond = icmp slt i32 %iv, %N
  call void(i1, ...) @llvm.experimental.guard(i1 %guard_cond) [ "deopt"() ]
  %loop_cond = icmp slt i32 %iv, %M
  %iv.next = add i32 %iv, 1
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret void
}

define void @do_not_hoist_widenable_cond_speculate(i1 %cond, i32 %N, i32 %M) {
; CHECK-LABEL: @do_not_hoist_widenable_cond_speculate(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[GUARDED:%.*]] ]
; CHECK-NEXT:    [[GUARD_COND:%.*]] = icmp slt i32 [[IV]], [[N:%.*]]
; CHECK-NEXT:    call void @maythrow()
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[GUARD_COND]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV]], [[M:%.*]]
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %guard_cond = icmp slt i32 %iv, %N
  call void @maythrow()
  call void(i1, ...) @llvm.experimental.guard(i1 %guard_cond) [ "deopt"() ]
  %loop_cond = icmp slt i32 %iv, %M
  %iv.next = add i32 %iv, 1
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret void
}


define void @hoist_invariant_load(i1 %cond, ptr %np, i32 %M) {
; CHECK-LABEL: @hoist_invariant_load(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[N:%.*]] = load i32, ptr [[NP:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[GUARDED:%.*]] ]
; CHECK-NEXT:    [[GUARD_COND:%.*]] = icmp slt i32 [[IV]], [[N]]
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[GUARD_COND]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp slt i32 [[IV]], [[M:%.*]]
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop ]
  %N = load i32, ptr %np
  %guard_cond = icmp slt i32 %iv, %N
  call void(i1, ...) @llvm.experimental.guard(i1 %guard_cond) [ "deopt"() ]
  %loop_cond = icmp slt i32 %iv, %M
  %iv.next = add i32 %iv, 1
  br i1 %loop_cond, label %loop, label %exit

exit:
  ret void
}

; TODO: Hoist widenable condition out of loop since it's the only
; non-invariant operand of its user. If we hoist wc here, we can hoist
; `and` as well, otherwise it prevents us from doing that.
define void @hoist_widenable_cond_1(ptr %p, i32 %x) {
; CHECK-LABEL: @hoist_widenable_cond_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD:%.*]] = load atomic i32, ptr [[P:%.*]] unordered, align 8
; CHECK-NEXT:    [[ICMP7:%.*]] = icmp ult i32 0, [[LOAD]]
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ult i32 [[IV]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP]], label [[LOOP_BODY:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.body:
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[ICMP7]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED]], label [[DEOPT:%.*]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid(i32 13) [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %load = load atomic i32, ptr %p unordered, align 8
  br label %loop.header

loop.header:
  %iv = phi i32 [ %iv.next, %guarded ], [ 0, %entry ]
  %icmp = icmp ult i32 %iv, %x
  br i1 %icmp, label %loop.body, label %exit

loop.body:
  %icmp7 = icmp ult i32 0, %load
  %widenable_cond = call i1 @llvm.experimental.widenable.condition()
  %exiplicit_guard_cond = and i1 %icmp7, %widenable_cond
  br i1 %exiplicit_guard_cond, label %guarded, label %deopt

deopt:
  call void (...) @llvm.experimental.deoptimize.isVoid(i32 13) [ "deopt"() ]
  ret void

guarded:
  %iv.next = add nuw nsw i32 %iv, 1
  br label %loop.header

exit:
  ret void
}

; Same as hoist_widenable_cond_1 test, but widenable condition goes before
; icmp - the second operand of wc's user.
; TODO: Hoist widenable condition out of loop.
define void @hoist_widenable_cond_2(ptr %p, i32 %x) {
; CHECK-LABEL: @hoist_widenable_cond_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD:%.*]] = load atomic i32, ptr [[P:%.*]] unordered, align 8
; CHECK-NEXT:    [[ICMP7:%.*]] = icmp ult i32 0, [[LOAD]]
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[GUARDED:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[ICMP:%.*]] = icmp ult i32 [[IV]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP]], label [[LOOP_BODY:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.body:
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[ICMP7]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED]], label [[DEOPT:%.*]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid(i32 13) [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %load = load atomic i32, ptr %p unordered, align 8
  br label %loop.header

loop.header:
  %iv = phi i32 [ %iv.next, %guarded ], [ 0, %entry ]
  %icmp = icmp ult i32 %iv, %x
  br i1 %icmp, label %loop.body, label %exit

loop.body:
  %widenable_cond = call i1 @llvm.experimental.widenable.condition()
  %icmp7 = icmp ult i32 0, %load
  %exiplicit_guard_cond = and i1 %icmp7, %widenable_cond
  br i1 %exiplicit_guard_cond, label %guarded, label %deopt

deopt:
  call void (...) @llvm.experimental.deoptimize.isVoid(i32 13) [ "deopt"() ]
  ret void

guarded:
  %iv.next = add nuw nsw i32 %iv, 1
  br label %loop.header

exit:
  ret void
}
