// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefixes=GFX12 %s

s_cmp_lt_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x41,0xbf]

s_cmp_lt_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x41,0xbf]

s_cmp_lt_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x41,0xbf]

s_cmp_lt_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x41,0xbf]

s_cmp_lt_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x41,0xbf]

s_cmp_lt_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x41,0xbf]

s_cmp_lt_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x41,0xbf]

s_cmp_lt_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x41,0xbf]

s_cmp_lt_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x41,0xbf]

s_cmp_lt_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x41,0xbf]

s_cmp_lt_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x41,0xbf]

s_cmp_lt_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x41,0xbf]

s_cmp_lt_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x41,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x41,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x41,0xbf]

s_cmp_eq_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x42,0xbf]

s_cmp_eq_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x42,0xbf]

s_cmp_eq_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x42,0xbf]

s_cmp_eq_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x42,0xbf]

s_cmp_eq_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x42,0xbf]

s_cmp_eq_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x42,0xbf]

s_cmp_eq_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x42,0xbf]

s_cmp_eq_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x42,0xbf]

s_cmp_eq_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x42,0xbf]

s_cmp_eq_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x42,0xbf]

s_cmp_eq_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x42,0xbf]

s_cmp_eq_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x42,0xbf]

s_cmp_eq_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x42,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x42,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x42,0xbf]

s_cmp_le_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x43,0xbf]

s_cmp_le_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x43,0xbf]

s_cmp_le_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x43,0xbf]

s_cmp_le_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x43,0xbf]

s_cmp_le_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x43,0xbf]

s_cmp_le_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x43,0xbf]

s_cmp_le_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x43,0xbf]

s_cmp_le_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x43,0xbf]

s_cmp_le_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x43,0xbf]

s_cmp_le_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x43,0xbf]

s_cmp_le_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x43,0xbf]

s_cmp_le_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x43,0xbf]

s_cmp_le_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x43,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x43,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x43,0xbf]

s_cmp_gt_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x44,0xbf]

s_cmp_gt_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x44,0xbf]

s_cmp_gt_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x44,0xbf]

s_cmp_gt_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x44,0xbf]

s_cmp_gt_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x44,0xbf]

s_cmp_gt_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x44,0xbf]

s_cmp_gt_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x44,0xbf]

s_cmp_gt_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x44,0xbf]

s_cmp_gt_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x44,0xbf]

s_cmp_gt_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x44,0xbf]

s_cmp_gt_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x44,0xbf]

s_cmp_gt_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x44,0xbf]

s_cmp_gt_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x44,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x44,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x44,0xbf]

s_cmp_lg_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x45,0xbf]

s_cmp_lg_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x45,0xbf]

s_cmp_lg_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x45,0xbf]

s_cmp_lg_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x45,0xbf]

s_cmp_lg_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x45,0xbf]

s_cmp_lg_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x45,0xbf]

s_cmp_lg_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x45,0xbf]

s_cmp_lg_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x45,0xbf]

s_cmp_lg_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x45,0xbf]

s_cmp_lg_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x45,0xbf]

s_cmp_lg_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x45,0xbf]

s_cmp_lg_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x45,0xbf]

s_cmp_lg_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x45,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x45,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x45,0xbf]

s_cmp_ge_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x46,0xbf]

s_cmp_ge_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x46,0xbf]

s_cmp_ge_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x46,0xbf]

s_cmp_ge_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x46,0xbf]

s_cmp_ge_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x46,0xbf]

s_cmp_ge_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x46,0xbf]

s_cmp_ge_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x46,0xbf]

s_cmp_ge_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x46,0xbf]

s_cmp_ge_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x46,0xbf]

s_cmp_ge_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x46,0xbf]

s_cmp_ge_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x46,0xbf]

s_cmp_ge_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x46,0xbf]

s_cmp_ge_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x46,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x46,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x46,0xbf]

s_cmp_o_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x47,0xbf]

s_cmp_o_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x47,0xbf]

s_cmp_o_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x47,0xbf]

s_cmp_o_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x47,0xbf]

s_cmp_o_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x47,0xbf]

s_cmp_o_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x47,0xbf]

s_cmp_o_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x47,0xbf]

s_cmp_o_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x47,0xbf]

s_cmp_o_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x47,0xbf]

s_cmp_o_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x47,0xbf]

s_cmp_o_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x47,0xbf]

s_cmp_o_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x47,0xbf]

s_cmp_o_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x47,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_o_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x47,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_o_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x47,0xbf]

s_cmp_u_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x48,0xbf]

s_cmp_u_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x48,0xbf]

s_cmp_u_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x48,0xbf]

s_cmp_u_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x48,0xbf]

s_cmp_u_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x48,0xbf]

s_cmp_u_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x48,0xbf]

s_cmp_u_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x48,0xbf]

s_cmp_u_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x48,0xbf]

s_cmp_u_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x48,0xbf]

s_cmp_u_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x48,0xbf]

s_cmp_u_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x48,0xbf]

s_cmp_u_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x48,0xbf]

s_cmp_u_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x48,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_u_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x48,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_u_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x48,0xbf]

s_cmp_nge_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x49,0xbf]

s_cmp_nge_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x49,0xbf]

s_cmp_nge_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x49,0xbf]

s_cmp_nge_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x49,0xbf]

s_cmp_nge_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x49,0xbf]

s_cmp_nge_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x49,0xbf]

s_cmp_nge_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x49,0xbf]

s_cmp_nge_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x49,0xbf]

s_cmp_nge_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x49,0xbf]

s_cmp_nge_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x49,0xbf]

s_cmp_nge_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x49,0xbf]

s_cmp_nge_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x49,0xbf]

s_cmp_nge_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x49,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nge_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x49,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nge_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x49,0xbf]

s_cmp_nlg_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x4a,0xbf]

s_cmp_nlg_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x4a,0xbf]

s_cmp_nlg_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x4a,0xbf]

s_cmp_nlg_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x4a,0xbf]

s_cmp_nlg_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x4a,0xbf]

s_cmp_nlg_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x4a,0xbf]

s_cmp_nlg_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x4a,0xbf]

s_cmp_nlg_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x4a,0xbf]

s_cmp_nlg_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x4a,0xbf]

s_cmp_nlg_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x4a,0xbf]

s_cmp_nlg_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x4a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nlg_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x4a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nlg_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x4a,0xbf]

s_cmp_ngt_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x4b,0xbf]

s_cmp_ngt_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x4b,0xbf]

s_cmp_ngt_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x4b,0xbf]

s_cmp_ngt_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x4b,0xbf]

s_cmp_ngt_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x4b,0xbf]

s_cmp_ngt_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x4b,0xbf]

s_cmp_ngt_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x4b,0xbf]

s_cmp_ngt_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x4b,0xbf]

s_cmp_ngt_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x4b,0xbf]

s_cmp_ngt_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x4b,0xbf]

s_cmp_ngt_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x4b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ngt_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x4b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ngt_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x4b,0xbf]

s_cmp_nle_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x4c,0xbf]

s_cmp_nle_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x4c,0xbf]

s_cmp_nle_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x4c,0xbf]

s_cmp_nle_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x4c,0xbf]

s_cmp_nle_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x4c,0xbf]

s_cmp_nle_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x4c,0xbf]

s_cmp_nle_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x4c,0xbf]

s_cmp_nle_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x4c,0xbf]

s_cmp_nle_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x4c,0xbf]

s_cmp_nle_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x4c,0xbf]

s_cmp_nle_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x4c,0xbf]

s_cmp_nle_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x4c,0xbf]

s_cmp_nle_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x4c,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nle_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x4c,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nle_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x4c,0xbf]

s_cmp_neq_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x4d,0xbf]

s_cmp_neq_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x4d,0xbf]

s_cmp_neq_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x4d,0xbf]

s_cmp_neq_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x4d,0xbf]

s_cmp_neq_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x4d,0xbf]

s_cmp_neq_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x4d,0xbf]

s_cmp_neq_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x4d,0xbf]

s_cmp_neq_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x4d,0xbf]

s_cmp_neq_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x4d,0xbf]

s_cmp_neq_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x4d,0xbf]

s_cmp_neq_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x4d,0xbf]

s_cmp_neq_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x4d,0xbf]

s_cmp_neq_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x4d,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_neq_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x4d,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_neq_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x4d,0xbf]

s_cmp_nlt_f32 s1, s2
// GFX12: encoding: [0x01,0x02,0x4e,0xbf]

s_cmp_nlt_f32 s105, s2
// GFX12: encoding: [0x69,0x02,0x4e,0xbf]

s_cmp_nlt_f32 s101, s2
// GFX12: encoding: [0x65,0x02,0x4e,0xbf]

s_cmp_nlt_f32 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x4e,0xbf]

s_cmp_nlt_f32 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x4e,0xbf]

s_cmp_nlt_f32 m0, s2
// GFX12: encoding: [0x7d,0x02,0x4e,0xbf]

s_cmp_nlt_f32 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x4e,0xbf]

s_cmp_nlt_f32 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0, s2
// GFX12: encoding: [0x80,0x02,0x4e,0xbf]

s_cmp_nlt_f32 -1, s2
// GFX12: encoding: [0xc1,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0.5, s2
// GFX12: encoding: [0xf0,0x02,0x4e,0xbf]

s_cmp_nlt_f32 -4.0, s2
// GFX12: encoding: [0xf7,0x02,0x4e,0xbf]

s_cmp_nlt_f32 0xaf123456, s2
// GFX12: encoding: [0xff,0x02,0x4e,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_nlt_f32 0x3f717273, s2
// GFX12: encoding: [0xff,0x02,0x4e,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_nlt_f32 s1, s105
// GFX12: encoding: [0x01,0x69,0x4e,0xbf]

s_cmp_lt_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x51,0xbf]

s_cmp_lt_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x51,0xbf]

s_cmp_lt_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x51,0xbf]

s_cmp_lt_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x51,0xbf]

s_cmp_lt_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x51,0xbf]

s_cmp_lt_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x51,0xbf]

s_cmp_lt_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x51,0xbf]

s_cmp_lt_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x51,0xbf]

s_cmp_lt_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x51,0xbf]

s_cmp_lt_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x51,0xbf,0x00,0x38,0x00,0x00]

s_cmp_lt_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x51,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_lt_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x51,0xbf,0x56,0x34,0x00,0x00]

s_cmp_eq_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x52,0xbf]

s_cmp_eq_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x52,0xbf]

s_cmp_eq_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x52,0xbf]

s_cmp_eq_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x52,0xbf]

s_cmp_eq_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x52,0xbf]

s_cmp_eq_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x52,0xbf]

s_cmp_eq_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x52,0xbf]

s_cmp_eq_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x52,0xbf]

s_cmp_eq_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x52,0xbf]

s_cmp_eq_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x52,0xbf,0x00,0x38,0x00,0x00]

s_cmp_eq_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x52,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_eq_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x52,0xbf,0x56,0x34,0x00,0x00]

s_cmp_le_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x53,0xbf]

s_cmp_le_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x53,0xbf]

s_cmp_le_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x53,0xbf]

s_cmp_le_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x53,0xbf]

s_cmp_le_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x53,0xbf]

s_cmp_le_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x53,0xbf]

s_cmp_le_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x53,0xbf]

s_cmp_le_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x53,0xbf]

s_cmp_le_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x53,0xbf]

s_cmp_le_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x53,0xbf,0x00,0x38,0x00,0x00]

s_cmp_le_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x53,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_le_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x53,0xbf,0x56,0x34,0x00,0x00]

s_cmp_gt_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x54,0xbf]

s_cmp_gt_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x54,0xbf]

s_cmp_gt_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x54,0xbf]

s_cmp_gt_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x54,0xbf]

s_cmp_gt_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x54,0xbf]

s_cmp_gt_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x54,0xbf]

s_cmp_gt_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x54,0xbf]

s_cmp_gt_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x54,0xbf]

s_cmp_gt_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x54,0xbf]

s_cmp_gt_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x54,0xbf,0x00,0x38,0x00,0x00]

s_cmp_gt_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x54,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_gt_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x54,0xbf,0x56,0x34,0x00,0x00]

s_cmp_lg_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x55,0xbf]

s_cmp_lg_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x55,0xbf]

s_cmp_lg_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x55,0xbf]

s_cmp_lg_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x55,0xbf]

s_cmp_lg_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x55,0xbf]

s_cmp_lg_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x55,0xbf]

s_cmp_lg_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x55,0xbf]

s_cmp_lg_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x55,0xbf]

s_cmp_lg_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x55,0xbf]

s_cmp_lg_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x55,0xbf,0x00,0x38,0x00,0x00]

s_cmp_lg_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x55,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_lg_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x55,0xbf,0x56,0x34,0x00,0x00]

s_cmp_ge_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x56,0xbf]

s_cmp_ge_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x56,0xbf]

s_cmp_ge_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x56,0xbf]

s_cmp_ge_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x56,0xbf]

s_cmp_ge_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x56,0xbf]

s_cmp_ge_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x56,0xbf]

s_cmp_ge_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x56,0xbf]

s_cmp_ge_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x56,0xbf]

s_cmp_ge_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x56,0xbf]

s_cmp_ge_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x56,0xbf,0x00,0x38,0x00,0x00]

s_cmp_ge_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x56,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_ge_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x56,0xbf,0x56,0x34,0x00,0x00]

s_cmp_o_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x57,0xbf]

s_cmp_o_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x57,0xbf]

s_cmp_o_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x57,0xbf]

s_cmp_o_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x57,0xbf]

s_cmp_o_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x57,0xbf]

s_cmp_o_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x57,0xbf]

s_cmp_o_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x57,0xbf]

s_cmp_o_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x57,0xbf]

s_cmp_o_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x57,0xbf]

s_cmp_o_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x57,0xbf,0x00,0x38,0x00,0x00]

s_cmp_o_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x57,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_o_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x57,0xbf,0x56,0x34,0x00,0x00]

s_cmp_u_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x58,0xbf]

s_cmp_u_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x58,0xbf]

s_cmp_u_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x58,0xbf]

s_cmp_u_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x58,0xbf]

s_cmp_u_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x58,0xbf]

s_cmp_u_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x58,0xbf]

s_cmp_u_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x58,0xbf]

s_cmp_u_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x58,0xbf]

s_cmp_u_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x58,0xbf]

s_cmp_u_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x58,0xbf,0x00,0x38,0x00,0x00]

s_cmp_u_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x58,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_u_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x58,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nge_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x59,0xbf]

s_cmp_nge_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x59,0xbf]

s_cmp_nge_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x59,0xbf]

s_cmp_nge_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x59,0xbf]

s_cmp_nge_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x59,0xbf]

s_cmp_nge_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x59,0xbf]

s_cmp_nge_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x59,0xbf]

s_cmp_nge_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x59,0xbf]

s_cmp_nge_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x59,0xbf]

s_cmp_nge_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x59,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nge_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x59,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nge_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x59,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nlg_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x5a,0xbf]

s_cmp_nlg_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x5a,0xbf]

s_cmp_nlg_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x5a,0xbf]

s_cmp_nlg_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x5a,0xbf]

s_cmp_nlg_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x5a,0xbf]

s_cmp_nlg_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x5a,0xbf]

s_cmp_nlg_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x5a,0xbf]

s_cmp_nlg_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x5a,0xbf]

s_cmp_nlg_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x5a,0xbf]

s_cmp_nlg_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x5a,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nlg_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x5a,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nlg_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x5a,0xbf,0x56,0x34,0x00,0x00]

s_cmp_ngt_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x5b,0xbf]

s_cmp_ngt_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x5b,0xbf]

s_cmp_ngt_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x5b,0xbf]

s_cmp_ngt_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x5b,0xbf]

s_cmp_ngt_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x5b,0xbf]

s_cmp_ngt_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x5b,0xbf]

s_cmp_ngt_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x5b,0xbf]

s_cmp_ngt_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x5b,0xbf]

s_cmp_ngt_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x5b,0xbf]

s_cmp_ngt_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x5b,0xbf,0x00,0x38,0x00,0x00]

s_cmp_ngt_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x5b,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_ngt_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x5b,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nle_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x5c,0xbf]

s_cmp_nle_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x5c,0xbf]

s_cmp_nle_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x5c,0xbf]

s_cmp_nle_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x5c,0xbf]

s_cmp_nle_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x5c,0xbf]

s_cmp_nle_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x5c,0xbf]

s_cmp_nle_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x5c,0xbf]

s_cmp_nle_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x5c,0xbf]

s_cmp_nle_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x5c,0xbf]

s_cmp_nle_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x5c,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nle_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x5c,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nle_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x5c,0xbf,0x56,0x34,0x00,0x00]

s_cmp_neq_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x5d,0xbf]

s_cmp_neq_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x5d,0xbf]

s_cmp_neq_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x5d,0xbf]

s_cmp_neq_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x5d,0xbf]

s_cmp_neq_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x5d,0xbf]

s_cmp_neq_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x5d,0xbf]

s_cmp_neq_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x5d,0xbf]

s_cmp_neq_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x5d,0xbf]

s_cmp_neq_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x5d,0xbf]

s_cmp_neq_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x5d,0xbf,0x00,0x38,0x00,0x00]

s_cmp_neq_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x5d,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_neq_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x5d,0xbf,0x56,0x34,0x00,0x00]

s_cmp_nlt_f16 s1, s2
// GFX12: encoding: [0x01,0x02,0x5e,0xbf]

s_cmp_nlt_f16 s101, s2
// GFX12: encoding: [0x65,0x02,0x5e,0xbf]

s_cmp_nlt_f16 vcc_lo, s2
// GFX12: encoding: [0x6a,0x02,0x5e,0xbf]

s_cmp_nlt_f16 vcc_hi, s2
// GFX12: encoding: [0x6b,0x02,0x5e,0xbf]

s_cmp_nlt_f16 m0, s2
// GFX12: encoding: [0x7d,0x02,0x5e,0xbf]

s_cmp_nlt_f16 exec_lo, s2
// GFX12: encoding: [0x7e,0x02,0x5e,0xbf]

s_cmp_nlt_f16 exec_hi, s2
// GFX12: encoding: [0x7f,0x02,0x5e,0xbf]

s_cmp_nlt_f16 0, s2
// GFX12: encoding: [0x80,0x02,0x5e,0xbf]

s_cmp_nlt_f16 -1, s2
// GFX12: encoding: [0xc1,0x02,0x5e,0xbf]

s_cmp_nlt_f16 0x3800, s2
// GFX12: encoding: [0xff,0x02,0x5e,0xbf,0x00,0x38,0x00,0x00]

s_cmp_nlt_f16 0xfe0b, s2
// GFX12: encoding: [0xff,0x02,0x5e,0xbf,0x0b,0xfe,0x00,0x00]

s_cmp_nlt_f16 0x3456, s2
// GFX12: encoding: [0xff,0x02,0x5e,0xbf,0x56,0x34,0x00,0x00]

s_cmp_eq_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x00,0xbf]

s_cmp_eq_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x00,0xbf]

s_cmp_eq_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x00,0xbf]

s_cmp_eq_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x00,0xbf]

s_cmp_eq_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x00,0xbf]

s_cmp_eq_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x00,0xbf]

s_cmp_eq_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x00,0xbf]

s_cmp_eq_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x00,0xbf]

s_cmp_eq_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x00,0xbf]

s_cmp_eq_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x00,0xbf]

s_cmp_eq_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x00,0xbf]

s_cmp_eq_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x00,0xbf]

s_cmp_eq_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x01,0xbf]

s_cmp_lg_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x01,0xbf]

s_cmp_lg_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x01,0xbf]

s_cmp_lg_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x01,0xbf]

s_cmp_lg_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x01,0xbf]

s_cmp_lg_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x01,0xbf]

s_cmp_lg_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x01,0xbf]

s_cmp_lg_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x01,0xbf]

s_cmp_lg_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x01,0xbf]

s_cmp_lg_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x01,0xbf]

s_cmp_lg_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x01,0xbf]

s_cmp_lg_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x01,0xbf]

s_cmp_lg_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x02,0xbf]

s_cmp_gt_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x02,0xbf]

s_cmp_gt_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x02,0xbf]

s_cmp_gt_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x02,0xbf]

s_cmp_gt_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x02,0xbf]

s_cmp_gt_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x02,0xbf]

s_cmp_gt_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x02,0xbf]

s_cmp_gt_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x02,0xbf]

s_cmp_gt_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x02,0xbf]

s_cmp_gt_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x02,0xbf]

s_cmp_gt_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x02,0xbf]

s_cmp_gt_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x02,0xbf]

s_cmp_gt_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x03,0xbf]

s_cmp_ge_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x03,0xbf]

s_cmp_ge_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x03,0xbf]

s_cmp_ge_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x03,0xbf]

s_cmp_ge_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x03,0xbf]

s_cmp_ge_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x03,0xbf]

s_cmp_ge_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x03,0xbf]

s_cmp_ge_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x03,0xbf]

s_cmp_ge_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x03,0xbf]

s_cmp_ge_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x03,0xbf]

s_cmp_ge_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x03,0xbf]

s_cmp_ge_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x03,0xbf]

s_cmp_ge_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x04,0xbf]

s_cmp_lt_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x04,0xbf]

s_cmp_lt_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x04,0xbf]

s_cmp_lt_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x04,0xbf]

s_cmp_lt_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x04,0xbf]

s_cmp_lt_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x04,0xbf]

s_cmp_lt_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x04,0xbf]

s_cmp_lt_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x04,0xbf]

s_cmp_lt_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x04,0xbf]

s_cmp_lt_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x04,0xbf]

s_cmp_lt_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x04,0xbf]

s_cmp_lt_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x04,0xbf]

s_cmp_lt_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s0, s1
// GFX12: encoding: [0x00,0x01,0x05,0xbf]

s_cmp_le_i32 s105, s104
// GFX12: encoding: [0x69,0x68,0x05,0xbf]

s_cmp_le_i32 s0, s104
// GFX12: encoding: [0x00,0x68,0x05,0xbf]

s_cmp_le_i32 s105, s1
// GFX12: encoding: [0x69,0x01,0x05,0xbf]

s_cmp_le_i32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x05,0xbf]

s_cmp_le_i32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x05,0xbf]

s_cmp_le_i32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x05,0xbf]

s_cmp_le_i32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x05,0xbf]

s_cmp_le_i32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x05,0xbf]

s_cmp_le_i32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x05,0xbf]

s_cmp_le_i32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x05,0xbf]

s_cmp_le_i32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x05,0xbf]

s_cmp_le_i32 s0, 0
// GFX12: encoding: [0x00,0x80,0x05,0xbf]

s_cmp_le_i32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x05,0xbf]

s_cmp_le_i32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x05,0xbf]

s_cmp_le_i32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x05,0xbf]

s_cmp_le_i32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x06,0xbf]

s_cmp_eq_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x06,0xbf]

s_cmp_eq_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x06,0xbf]

s_cmp_eq_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x06,0xbf]

s_cmp_eq_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x06,0xbf]

s_cmp_eq_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x06,0xbf]

s_cmp_eq_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x06,0xbf]

s_cmp_eq_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x06,0xbf]

s_cmp_eq_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x06,0xbf]

s_cmp_eq_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x06,0xbf]

s_cmp_eq_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x06,0xbf]

s_cmp_eq_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x06,0xbf]

s_cmp_eq_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x07,0xbf]

s_cmp_lg_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x07,0xbf]

s_cmp_lg_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x07,0xbf]

s_cmp_lg_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x07,0xbf]

s_cmp_lg_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x07,0xbf]

s_cmp_lg_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x07,0xbf]

s_cmp_lg_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x07,0xbf]

s_cmp_lg_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x07,0xbf]

s_cmp_lg_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x07,0xbf]

s_cmp_lg_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x07,0xbf]

s_cmp_lg_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x07,0xbf]

s_cmp_lg_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x07,0xbf]

s_cmp_lg_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x08,0xbf]

s_cmp_gt_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x08,0xbf]

s_cmp_gt_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x08,0xbf]

s_cmp_gt_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x08,0xbf]

s_cmp_gt_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x08,0xbf]

s_cmp_gt_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x08,0xbf]

s_cmp_gt_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x08,0xbf]

s_cmp_gt_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x08,0xbf]

s_cmp_gt_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x08,0xbf]

s_cmp_gt_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x08,0xbf]

s_cmp_gt_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x08,0xbf]

s_cmp_gt_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x08,0xbf]

s_cmp_gt_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x09,0xbf]

s_cmp_ge_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x09,0xbf]

s_cmp_ge_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x09,0xbf]

s_cmp_ge_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x09,0xbf]

s_cmp_ge_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x09,0xbf]

s_cmp_ge_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x09,0xbf]

s_cmp_ge_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x09,0xbf]

s_cmp_ge_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x09,0xbf]

s_cmp_ge_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x09,0xbf]

s_cmp_ge_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x09,0xbf]

s_cmp_ge_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x09,0xbf]

s_cmp_ge_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x09,0xbf]

s_cmp_ge_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x0a,0xbf]

s_cmp_lt_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x0a,0xbf]

s_cmp_lt_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x0a,0xbf]

s_cmp_lt_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x0a,0xbf]

s_cmp_lt_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x0a,0xbf]

s_cmp_lt_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x0a,0xbf]

s_cmp_lt_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s0, s1
// GFX12: encoding: [0x00,0x01,0x0b,0xbf]

s_cmp_le_u32 s105, s104
// GFX12: encoding: [0x69,0x68,0x0b,0xbf]

s_cmp_le_u32 s0, s104
// GFX12: encoding: [0x00,0x68,0x0b,0xbf]

s_cmp_le_u32 s105, s1
// GFX12: encoding: [0x69,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x0b,0xbf]

s_cmp_le_u32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x0b,0xbf]

s_cmp_le_u32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x0b,0xbf]

s_cmp_le_u32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0b,0xbf]

s_cmp_le_u32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x0b,0xbf]

s_cmp_le_u32 s0, 0
// GFX12: encoding: [0x00,0x80,0x0b,0xbf]

s_cmp_le_u32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x0b,0xbf]

s_cmp_le_u32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x0b,0xbf]

s_cmp_le_u32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x0b,0xbf]

s_cmp_le_u32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s0, s1
// GFX12: encoding: [0x00,0x01,0x0c,0xbf]

s_bitcmp0_b32 s105, s104
// GFX12: encoding: [0x69,0x68,0x0c,0xbf]

s_bitcmp0_b32 s0, s104
// GFX12: encoding: [0x00,0x68,0x0c,0xbf]

s_bitcmp0_b32 s105, s1
// GFX12: encoding: [0x69,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x0c,0xbf]

s_bitcmp0_b32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x0c,0xbf]

s_bitcmp0_b32 s0, 0
// GFX12: encoding: [0x00,0x80,0x0c,0xbf]

s_bitcmp0_b32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s0, s1
// GFX12: encoding: [0x00,0x01,0x0d,0xbf]

s_bitcmp1_b32 s105, s104
// GFX12: encoding: [0x69,0x68,0x0d,0xbf]

s_bitcmp1_b32 s0, s104
// GFX12: encoding: [0x00,0x68,0x0d,0xbf]

s_bitcmp1_b32 s105, s1
// GFX12: encoding: [0x69,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s1
// GFX12: encoding: [0x7e,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s1
// GFX12: encoding: [0x7f,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s1
// GFX12: encoding: [0x6a,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s1
// GFX12: encoding: [0x6b,0x01,0x0d,0xbf]

s_bitcmp1_b32 m0, s1
// GFX12: encoding: [0x7d,0x01,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_lo
// GFX12: encoding: [0x00,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_hi
// GFX12: encoding: [0x00,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s0, m0
// GFX12: encoding: [0x00,0x7d,0x0d,0xbf]

s_bitcmp1_b32 s0, 0
// GFX12: encoding: [0x00,0x80,0x0d,0xbf]

s_bitcmp1_b32 s0, -1
// GFX12: encoding: [0x00,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s0, 0.5
// GFX12: encoding: [0x00,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s0, -4.0
// GFX12: encoding: [0x00,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s0, 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s0, 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[0:1], s2
// GFX12: encoding: [0x00,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s102
// GFX12: encoding: [0x68,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], s102
// GFX12: encoding: [0x00,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s2
// GFX12: encoding: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// GFX12: encoding: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// GFX12: encoding: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_lo
// GFX12: encoding: [0x00,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_hi
// GFX12: encoding: [0x00,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], m0
// GFX12: encoding: [0x00,0x7d,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0
// GFX12: encoding: [0x00,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -1
// GFX12: encoding: [0x00,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0.5
// GFX12: encoding: [0x00,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -4.0
// GFX12: encoding: [0x00,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[0:1], 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[0:1], s2
// GFX12: encoding: [0x00,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s102
// GFX12: encoding: [0x68,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], s102
// GFX12: encoding: [0x00,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s2
// GFX12: encoding: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// GFX12: encoding: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// GFX12: encoding: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_lo
// GFX12: encoding: [0x00,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_hi
// GFX12: encoding: [0x00,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_lo
// GFX12: encoding: [0x00,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_hi
// GFX12: encoding: [0x00,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], m0
// GFX12: encoding: [0x00,0x7d,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0
// GFX12: encoding: [0x00,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -1
// GFX12: encoding: [0x00,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0.5
// GFX12: encoding: [0x00,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -4.0
// GFX12: encoding: [0x00,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0x3f717273
// GFX12: encoding: [0x00,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[0:1], 0xaf123456
// GFX12: encoding: [0x00,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 s[0:1], s[2:3]
// GFX12: encoding: [0x00,0x02,0x10,0xbf]

s_cmp_eq_u64 s[104:105], s[102:103]
// GFX12: encoding: [0x68,0x66,0x10,0xbf]

s_cmp_eq_u64 s[0:1], s[102:103]
// GFX12: encoding: [0x00,0x66,0x10,0xbf]

s_cmp_eq_u64 s[104:105], s[2:3]
// GFX12: encoding: [0x68,0x02,0x10,0xbf]

s_cmp_eq_u64 exec, s[2:3]
// GFX12: encoding: [0x7e,0x02,0x10,0xbf]

s_cmp_eq_u64 vcc, s[2:3]
// GFX12: encoding: [0x6a,0x02,0x10,0xbf]

s_cmp_eq_u64 s[0:1], exec
// GFX12: encoding: [0x00,0x7e,0x10,0xbf]

s_cmp_eq_u64 s[0:1], vcc
// GFX12: encoding: [0x00,0x6a,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0
// GFX12: encoding: [0x00,0x80,0x10,0xbf]

s_cmp_eq_u64 s[0:1], -1
// GFX12: encoding: [0x00,0xc1,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0.5
// GFX12: encoding: [0x00,0xf0,0x10,0xbf]

s_cmp_eq_u64 s[0:1], -4.0
// GFX12: encoding: [0x00,0xf7,0x10,0xbf]

s_cmp_eq_u64 s[0:1], 0x3f717273
// GFX12: encoding: [0x00,0xff,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u64 s[0:1], 0xaf123456
// GFX12: encoding: [0x00,0xff,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 s[0:1], s[2:3]
// GFX12: encoding: [0x00,0x02,0x11,0xbf]

s_cmp_lg_u64 s[104:105], s[102:103]
// GFX12: encoding: [0x68,0x66,0x11,0xbf]

s_cmp_lg_u64 s[0:1], s[102:103]
// GFX12: encoding: [0x00,0x66,0x11,0xbf]

s_cmp_lg_u64 s[104:105], s[2:3]
// GFX12: encoding: [0x68,0x02,0x11,0xbf]

s_cmp_lg_u64 exec, s[2:3]
// GFX12: encoding: [0x7e,0x02,0x11,0xbf]

s_cmp_lg_u64 vcc, s[2:3]
// GFX12: encoding: [0x6a,0x02,0x11,0xbf]

s_cmp_lg_u64 s[0:1], exec
// GFX12: encoding: [0x00,0x7e,0x11,0xbf]

s_cmp_lg_u64 s[0:1], vcc
// GFX12: encoding: [0x00,0x6a,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0
// GFX12: encoding: [0x00,0x80,0x11,0xbf]

s_cmp_lg_u64 s[0:1], -1
// GFX12: encoding: [0x00,0xc1,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0.5
// GFX12: encoding: [0x00,0xf0,0x11,0xbf]

s_cmp_lg_u64 s[0:1], -4.0
// GFX12: encoding: [0x00,0xf7,0x11,0xbf]

s_cmp_lg_u64 s[0:1], 0x3f717273
// GFX12: encoding: [0x00,0xff,0x11,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[0:1], 0xaf123456
// GFX12: encoding: [0x00,0xff,0x11,0xbf,0x56,0x34,0x12,0xaf]
