; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefixes=X86,X86-NOCMOV
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+cmov | FileCheck %s --check-prefixes=X86,X86-CMOV
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+bmi,+lzcnt | FileCheck %s --check-prefix=X86-CLZ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+bmi,+lzcnt | FileCheck %s --check-prefix=X64-CLZ
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+bmi,+lzcnt,+fast-lzcnt | FileCheck %s --check-prefix=X86-CLZ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+bmi,+lzcnt,+fast-lzcnt | FileCheck %s --check-prefix=X64-CLZ

declare i8 @llvm.ctlz.i8(i8, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i64 @llvm.ctlz.i64(i64, i1)

define i8 @ctlo_i8(i8 %x) {
; X86-NOCMOV-LABEL: ctlo_i8:
; X86-NOCMOV:       # %bb.0:
; X86-NOCMOV-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    xorb $-1, %al
; X86-NOCMOV-NEXT:    je .LBB0_1
; X86-NOCMOV-NEXT:  # %bb.2: # %cond.false
; X86-NOCMOV-NEXT:    movzbl %al, %eax
; X86-NOCMOV-NEXT:    bsrl %eax, %eax
; X86-NOCMOV-NEXT:    xorl $7, %eax
; X86-NOCMOV-NEXT:    # kill: def $al killed $al killed $eax
; X86-NOCMOV-NEXT:    retl
; X86-NOCMOV-NEXT:  .LBB0_1:
; X86-NOCMOV-NEXT:    movb $8, %al
; X86-NOCMOV-NEXT:    # kill: def $al killed $al killed $eax
; X86-NOCMOV-NEXT:    retl
;
; X86-CMOV-LABEL: ctlo_i8:
; X86-CMOV:       # %bb.0:
; X86-CMOV-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-CMOV-NEXT:    notb %al
; X86-CMOV-NEXT:    movzbl %al, %eax
; X86-CMOV-NEXT:    bsrl %eax, %ecx
; X86-CMOV-NEXT:    movl $15, %eax
; X86-CMOV-NEXT:    cmovnel %ecx, %eax
; X86-CMOV-NEXT:    xorl $7, %eax
; X86-CMOV-NEXT:    # kill: def $al killed $al killed $eax
; X86-CMOV-NEXT:    retl
;
; X64-LABEL: ctlo_i8:
; X64:       # %bb.0:
; X64-NEXT:    notb %dil
; X64-NEXT:    movzbl %dil, %ecx
; X64-NEXT:    movl $15, %eax
; X64-NEXT:    bsrl %ecx, %eax
; X64-NEXT:    xorl $7, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i8:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    shll $24, %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    # kill: def $al killed $al killed $eax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i8:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    shll $24, %edi
; X64-CLZ-NEXT:    notl %edi
; X64-CLZ-NEXT:    lzcntl %edi, %eax
; X64-CLZ-NEXT:    # kill: def $al killed $al killed $eax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i8 %x, -1
  %tmp2 = call i8 @llvm.ctlz.i8( i8 %tmp1, i1 false )
  ret i8 %tmp2
}

define i8 @ctlo_i8_undef(i8 %x) {
; X86-LABEL: ctlo_i8_undef:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    notb %al
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    bsrl %eax, %eax
; X86-NEXT:    xorl $7, %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: ctlo_i8_undef:
; X64:       # %bb.0:
; X64-NEXT:    notb %dil
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    bsrl %eax, %eax
; X64-NEXT:    xorl $7, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i8_undef:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notb %al
; X86-CLZ-NEXT:    movzbl %al, %eax
; X86-CLZ-NEXT:    shll $24, %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    # kill: def $al killed $al killed $eax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i8_undef:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notb %dil
; X64-CLZ-NEXT:    movzbl %dil, %eax
; X64-CLZ-NEXT:    shll $24, %eax
; X64-CLZ-NEXT:    lzcntl %eax, %eax
; X64-CLZ-NEXT:    # kill: def $al killed $al killed $eax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i8 %x, -1
  %tmp2 = call i8 @llvm.ctlz.i8( i8 %tmp1, i1 true )
  ret i8 %tmp2
}

define i16 @ctlo_i16(i16 %x) {
; X86-NOCMOV-LABEL: ctlo_i16:
; X86-NOCMOV:       # %bb.0:
; X86-NOCMOV-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    xorw $-1, %ax
; X86-NOCMOV-NEXT:    je .LBB2_1
; X86-NOCMOV-NEXT:  # %bb.2: # %cond.false
; X86-NOCMOV-NEXT:    bsrw %ax, %ax
; X86-NOCMOV-NEXT:    xorl $15, %eax
; X86-NOCMOV-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOCMOV-NEXT:    retl
; X86-NOCMOV-NEXT:  .LBB2_1:
; X86-NOCMOV-NEXT:    movw $16, %ax
; X86-NOCMOV-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOCMOV-NEXT:    retl
;
; X86-CMOV-LABEL: ctlo_i16:
; X86-CMOV:       # %bb.0:
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CMOV-NEXT:    notl %eax
; X86-CMOV-NEXT:    bsrw %ax, %cx
; X86-CMOV-NEXT:    movw $31, %ax
; X86-CMOV-NEXT:    cmovnew %cx, %ax
; X86-CMOV-NEXT:    xorl $15, %eax
; X86-CMOV-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-CMOV-NEXT:    retl
;
; X64-LABEL: ctlo_i16:
; X64:       # %bb.0:
; X64-NEXT:    notl %edi
; X64-NEXT:    movw $31, %ax
; X64-NEXT:    bsrw %di, %ax
; X64-NEXT:    xorl $15, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i16:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntw %ax, %ax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i16:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notl %edi
; X64-CLZ-NEXT:    lzcntw %di, %ax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i16 %x, -1
  %tmp2 = call i16 @llvm.ctlz.i16( i16 %tmp1, i1 false )
  ret i16 %tmp2
}

define i16 @ctlo_i16_undef(i16 %x) {
; X86-LABEL: ctlo_i16_undef:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    notl %eax
; X86-NEXT:    bsrw %ax, %ax
; X86-NEXT:    xorl $15, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: ctlo_i16_undef:
; X64:       # %bb.0:
; X64-NEXT:    notl %edi
; X64-NEXT:    bsrw %di, %ax
; X64-NEXT:    xorl $15, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i16_undef:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntw %ax, %ax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i16_undef:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notl %edi
; X64-CLZ-NEXT:    lzcntw %di, %ax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i16 %x, -1
  %tmp2 = call i16 @llvm.ctlz.i16( i16 %tmp1, i1 true )
  ret i16 %tmp2
}

define i32 @ctlo_i32(i32 %x) {
; X86-NOCMOV-LABEL: ctlo_i32:
; X86-NOCMOV:       # %bb.0:
; X86-NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    xorl $-1, %eax
; X86-NOCMOV-NEXT:    je .LBB4_1
; X86-NOCMOV-NEXT:  # %bb.2: # %cond.false
; X86-NOCMOV-NEXT:    bsrl %eax, %eax
; X86-NOCMOV-NEXT:    xorl $31, %eax
; X86-NOCMOV-NEXT:    retl
; X86-NOCMOV-NEXT:  .LBB4_1:
; X86-NOCMOV-NEXT:    movl $32, %eax
; X86-NOCMOV-NEXT:    retl
;
; X86-CMOV-LABEL: ctlo_i32:
; X86-CMOV:       # %bb.0:
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CMOV-NEXT:    notl %eax
; X86-CMOV-NEXT:    bsrl %eax, %ecx
; X86-CMOV-NEXT:    movl $63, %eax
; X86-CMOV-NEXT:    cmovnel %ecx, %eax
; X86-CMOV-NEXT:    xorl $31, %eax
; X86-CMOV-NEXT:    retl
;
; X64-LABEL: ctlo_i32:
; X64:       # %bb.0:
; X64-NEXT:    notl %edi
; X64-NEXT:    movl $63, %eax
; X64-NEXT:    bsrl %edi, %eax
; X64-NEXT:    xorl $31, %eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i32:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i32:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notl %edi
; X64-CLZ-NEXT:    lzcntl %edi, %eax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i32 %x, -1
  %tmp2 = call i32 @llvm.ctlz.i32( i32 %tmp1, i1 false )
  ret i32 %tmp2
}

define i32 @ctlo_i32_undef(i32 %x) {
; X86-LABEL: ctlo_i32_undef:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    notl %eax
; X86-NEXT:    bsrl %eax, %eax
; X86-NEXT:    xorl $31, %eax
; X86-NEXT:    retl
;
; X64-LABEL: ctlo_i32_undef:
; X64:       # %bb.0:
; X64-NEXT:    notl %edi
; X64-NEXT:    bsrl %edi, %eax
; X64-NEXT:    xorl $31, %eax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i32_undef:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i32_undef:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notl %edi
; X64-CLZ-NEXT:    lzcntl %edi, %eax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i32 %x, -1
  %tmp2 = call i32 @llvm.ctlz.i32( i32 %tmp1, i1 true )
  ret i32 %tmp2
}

define i64 @ctlo_i64(i64 %x) {
; X86-NOCMOV-LABEL: ctlo_i64:
; X86-NOCMOV:       # %bb.0:
; X86-NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NOCMOV-NEXT:    notl %ecx
; X86-NOCMOV-NEXT:    notl %eax
; X86-NOCMOV-NEXT:    bsrl %eax, %edx
; X86-NOCMOV-NEXT:    movl $63, %eax
; X86-NOCMOV-NEXT:    je .LBB6_2
; X86-NOCMOV-NEXT:  # %bb.1:
; X86-NOCMOV-NEXT:    movl %edx, %eax
; X86-NOCMOV-NEXT:  .LBB6_2:
; X86-NOCMOV-NEXT:    testl %ecx, %ecx
; X86-NOCMOV-NEXT:    jne .LBB6_3
; X86-NOCMOV-NEXT:  # %bb.4:
; X86-NOCMOV-NEXT:    xorl $31, %eax
; X86-NOCMOV-NEXT:    addl $32, %eax
; X86-NOCMOV-NEXT:    xorl %edx, %edx
; X86-NOCMOV-NEXT:    retl
; X86-NOCMOV-NEXT:  .LBB6_3:
; X86-NOCMOV-NEXT:    bsrl %ecx, %eax
; X86-NOCMOV-NEXT:    xorl $31, %eax
; X86-NOCMOV-NEXT:    xorl %edx, %edx
; X86-NOCMOV-NEXT:    retl
;
; X86-CMOV-LABEL: ctlo_i64:
; X86-CMOV:       # %bb.0:
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-CMOV-NEXT:    notl %ecx
; X86-CMOV-NEXT:    notl %eax
; X86-CMOV-NEXT:    bsrl %eax, %eax
; X86-CMOV-NEXT:    movl $63, %edx
; X86-CMOV-NEXT:    cmovnel %eax, %edx
; X86-CMOV-NEXT:    xorl $31, %edx
; X86-CMOV-NEXT:    addl $32, %edx
; X86-CMOV-NEXT:    bsrl %ecx, %eax
; X86-CMOV-NEXT:    xorl $31, %eax
; X86-CMOV-NEXT:    testl %ecx, %ecx
; X86-CMOV-NEXT:    cmovel %edx, %eax
; X86-CMOV-NEXT:    xorl %edx, %edx
; X86-CMOV-NEXT:    retl
;
; X64-LABEL: ctlo_i64:
; X64:       # %bb.0:
; X64-NEXT:    notq %rdi
; X64-NEXT:    movl $127, %eax
; X64-NEXT:    bsrq %rdi, %rax
; X64-NEXT:    xorq $63, %rax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i64:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    testl %eax, %eax
; X86-CLZ-NEXT:    jne .LBB6_1
; X86-CLZ-NEXT:  # %bb.2:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    addl $32, %eax
; X86-CLZ-NEXT:    xorl %edx, %edx
; X86-CLZ-NEXT:    retl
; X86-CLZ-NEXT:  .LBB6_1:
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    xorl %edx, %edx
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i64:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notq %rdi
; X64-CLZ-NEXT:    lzcntq %rdi, %rax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i64 %x, -1
  %tmp2 = call i64 @llvm.ctlz.i64( i64 %tmp1, i1 false )
  ret i64 %tmp2
}

define i64 @ctlo_i64_undef(i64 %x) {
; X86-NOCMOV-LABEL: ctlo_i64_undef:
; X86-NOCMOV:       # %bb.0:
; X86-NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    notl %eax
; X86-NOCMOV-NEXT:    testl %eax, %eax
; X86-NOCMOV-NEXT:    jne .LBB7_1
; X86-NOCMOV-NEXT:  # %bb.2:
; X86-NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOCMOV-NEXT:    notl %eax
; X86-NOCMOV-NEXT:    bsrl %eax, %eax
; X86-NOCMOV-NEXT:    xorl $31, %eax
; X86-NOCMOV-NEXT:    orl $32, %eax
; X86-NOCMOV-NEXT:    xorl %edx, %edx
; X86-NOCMOV-NEXT:    retl
; X86-NOCMOV-NEXT:  .LBB7_1:
; X86-NOCMOV-NEXT:    bsrl %eax, %eax
; X86-NOCMOV-NEXT:    xorl $31, %eax
; X86-NOCMOV-NEXT:    xorl %edx, %edx
; X86-NOCMOV-NEXT:    retl
;
; X86-CMOV-LABEL: ctlo_i64_undef:
; X86-CMOV:       # %bb.0:
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CMOV-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-CMOV-NEXT:    notl %eax
; X86-CMOV-NEXT:    notl %ecx
; X86-CMOV-NEXT:    bsrl %ecx, %edx
; X86-CMOV-NEXT:    xorl $31, %edx
; X86-CMOV-NEXT:    bsrl %eax, %eax
; X86-CMOV-NEXT:    xorl $31, %eax
; X86-CMOV-NEXT:    orl $32, %eax
; X86-CMOV-NEXT:    testl %ecx, %ecx
; X86-CMOV-NEXT:    cmovnel %edx, %eax
; X86-CMOV-NEXT:    xorl %edx, %edx
; X86-CMOV-NEXT:    retl
;
; X64-LABEL: ctlo_i64_undef:
; X64:       # %bb.0:
; X64-NEXT:    notq %rdi
; X64-NEXT:    bsrq %rdi, %rax
; X64-NEXT:    xorq $63, %rax
; X64-NEXT:    retq
;
; X86-CLZ-LABEL: ctlo_i64_undef:
; X86-CLZ:       # %bb.0:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    testl %eax, %eax
; X86-CLZ-NEXT:    jne .LBB7_1
; X86-CLZ-NEXT:  # %bb.2:
; X86-CLZ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-CLZ-NEXT:    notl %eax
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    addl $32, %eax
; X86-CLZ-NEXT:    xorl %edx, %edx
; X86-CLZ-NEXT:    retl
; X86-CLZ-NEXT:  .LBB7_1:
; X86-CLZ-NEXT:    lzcntl %eax, %eax
; X86-CLZ-NEXT:    xorl %edx, %edx
; X86-CLZ-NEXT:    retl
;
; X64-CLZ-LABEL: ctlo_i64_undef:
; X64-CLZ:       # %bb.0:
; X64-CLZ-NEXT:    notq %rdi
; X64-CLZ-NEXT:    lzcntq %rdi, %rax
; X64-CLZ-NEXT:    retq
  %tmp1 = xor i64 %x, -1
  %tmp2 = call i64 @llvm.ctlz.i64( i64 %tmp1, i1 true )
  ret i64 %tmp2
}
