; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes="loop-vectorize" -pass-remarks-output=%t.yaml -S %s | FileCheck %s
; RUN: FileCheck --input-file=%t.yaml --check-prefix=REMARKS %s

; REMARKS: the cost-model indicates that vectorization is not beneficial

; Test for https://github.com/llvm/llvm-project/issues/116375.
define void @test_i24_load_for(ptr noalias %src, ptr %dst) {
; CHECK-LABEL: define void @test_i24_load_for(
; CHECK-SAME: ptr noalias [[SRC:%.*]], ptr [[DST:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i16 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[FOR:%.*]] = phi i24 [ 0, %[[ENTRY]] ], [ [[FOR_NEXT:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i16 [[IV]], 1
; CHECK-NEXT:    [[GEP_SRC:%.*]] = getelementptr inbounds i24, ptr [[SRC]], i16 [[IV]]
; CHECK-NEXT:    [[FOR_NEXT]] = load i24, ptr [[GEP_SRC]], align 1
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds i24, ptr [[DST]], i16 [[IV]]
; CHECK-NEXT:    store i24 [[FOR]], ptr [[GEP_DST]], align 4
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i16 [[IV_NEXT]], 1000
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i16 [ 0, %entry ], [ %iv.next, %loop ]
  %for = phi i24 [ 0, %entry ], [ %for.next, %loop ]
  %iv.next = add i16 %iv, 1
  %gep.src = getelementptr inbounds i24, ptr %src, i16 %iv
  %for.next = load i24, ptr %gep.src, align 1
  %gep.dst = getelementptr inbounds i24, ptr %dst, i16 %iv
  store i24 %for, ptr %gep.dst
  %ec = icmp eq i16 %iv.next, 1000
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
