; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 -mattr=+d,-div32 < %s | FileCheck %s --check-prefix=LA64
; RUN: llc --mtriple=loongarch64 -mattr=+d,+div32 < %s | FileCheck %s --check-prefix=LA64-DIV32

define i32 @divw(i64 %a, i64 %b) {
; LA64-LABEL: divw:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-DIV32-LABEL: divw:
; LA64-DIV32:       # %bb.0:
; LA64-DIV32-NEXT:    div.w $a0, $a0, $a1
; LA64-DIV32-NEXT:    ret
  %conv1 = trunc i64 %a to i32
  %conv2 = trunc i64 %b to i32
  %r = sdiv i32 %conv1, %conv2
  ret i32 %r
}

define i32  @divwu(i64 %a, i64 %b) {
; LA64-LABEL: divwu:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-DIV32-LABEL: divwu:
; LA64-DIV32:       # %bb.0:
; LA64-DIV32-NEXT:    div.wu $a0, $a0, $a1
; LA64-DIV32-NEXT:    ret
  %conv1 = trunc i64 %a to i32
  %conv2 = trunc i64 %b to i32
  %r = udiv i32 %conv1, %conv2
  ret i32 %r
}

define i32 @modw(i64 %a, i64 %b) {
; LA64-LABEL: modw:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-DIV32-LABEL: modw:
; LA64-DIV32:       # %bb.0:
; LA64-DIV32-NEXT:    mod.w $a0, $a0, $a1
; LA64-DIV32-NEXT:    ret
  %conv1 = trunc i64 %a to i32
  %conv2 = trunc i64 %b to i32
  %r = srem i32 %conv1, %conv2
  ret i32 %r
}

define i32 @modwu(i64 %a, i64 %b) {
; LA64-LABEL: modwu:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA64-DIV32-LABEL: modwu:
; LA64-DIV32:       # %bb.0:
; LA64-DIV32-NEXT:    mod.wu $a0, $a0, $a1
; LA64-DIV32-NEXT:    ret
  %conv1 = trunc i64 %a to i32
  %conv2 = trunc i64 %b to i32
  %r = urem i32 %conv1, %conv2
  ret i32 %r
}

define signext i32 @sextw_rmv(i32 signext %a, i32 signext %b, i32 signext %c) {
; LA64-LABEL: sextw_rmv:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mul.w $a0, $a1, $a0
; LA64-NEXT:    div.w $a1, $a2, $a0
; LA64-NEXT:    sltu $a0, $a1, $a0
; LA64-NEXT:    ret
;
; LA64-DIV32-LABEL: sextw_rmv:
; LA64-DIV32:       # %bb.0: # %entry
; LA64-DIV32-NEXT:    mul.w $a0, $a1, $a0
; LA64-DIV32-NEXT:    div.w $a1, $a2, $a0
; LA64-DIV32-NEXT:    sltu $a0, $a1, $a0
; LA64-DIV32-NEXT:    ret
entry:
  %mul = mul nsw i32 %b, %a
  %div = sdiv i32 %c, %mul
  %cmp = icmp ult i32 %div, %mul
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}
