; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64-none-unknown-elf -mattr=+avx512vl | FileCheck %s

define half @test1(half %x) {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpextrw $0, %xmm0, %eax
; CHECK-NEXT:    vcvtph2ps %xmm0, %xmm0
; CHECK-NEXT:    vucomiss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; CHECK-NEXT:    movl $64512, %ecx # imm = 0xFC00
; CHECK-NEXT:    cmoval %eax, %ecx
; CHECK-NEXT:    vpinsrw $0, %ecx, %xmm0, %xmm0
; CHECK-NEXT:    retq
entry:
  %cmp2 = fcmp ogt half %x, 0xHFC00
  %cond.v = select i1 %cmp2, half %x, half 0xHFC00
  ret half %cond.v
}

define <8 x half> @test2(<8 x half> %x) {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2ps %xmm0, %ymm1
; CHECK-NEXT:    vcmpgtps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %k1
; CHECK-NEXT:    vpbroadcastw {{.*#+}} xmm1 = [-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf]
; CHECK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; CHECK-NEXT:    vmovdqa32 %ymm2, %ymm2 {%k1} {z}
; CHECK-NEXT:    vpmovdw %ymm2, %xmm2
; CHECK-NEXT:    vpternlogq {{.*#+}} xmm0 = xmm1 ^ (xmm2 & (xmm0 ^ xmm1))
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
entry:
  %cmp2 = fcmp ogt <8 x half> %x, splat (half 0xHFC00)
  %cond.v = select <8 x i1> %cmp2, <8 x half> %x, <8 x half> splat (half 0xHFC00)
  ret <8 x half> %cond.v
}
