; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11-SDAG %s

define amdgpu_kernel void @test_p0(ptr addrspace(1) %out, ptr %src0) {
; GFX11-SDAG-LABEL: test_p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_mov_b32 v0, s3
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v2
; GFX11-SDAG-NEXT:    global_store_b64 v3, v[0:1], s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call ptr @llvm.amdgcn.permlane64.p0(ptr %src0)
  store ptr %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v3p0(ptr addrspace(1) %out, <3 x ptr> %src0) {
; GFX11-SDAG-LABEL: test_v3p0:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x2
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x44
; GFX11-SDAG-NEXT:    s_load_b64 s[6:7], s[4:5], 0x54
; GFX11-SDAG-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v6, 0 :: v_dual_mov_b32 v1, s2
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s7
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v8, s6
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v7, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v1
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v4
; GFX11-SDAG-NEXT:    v_permlane64_b32 v5, v5
; GFX11-SDAG-NEXT:    v_permlane64_b32 v4, v8
; GFX11-SDAG-NEXT:    v_permlane64_b32 v3, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v7
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    global_store_b64 v6, v[4:5], s[4:5] offset:16
; GFX11-SDAG-NEXT:    global_store_b128 v6, v[0:3], s[4:5]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call <3 x ptr> @llvm.amdgcn.permlane64.v3p0(<3 x ptr> %src0)
  store <3 x ptr> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_p3(ptr addrspace(1) %out, ptr addrspace(3) %src0) {
; GFX11-SDAG-LABEL: test_p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call ptr addrspace(3) @llvm.amdgcn.permlane64.v3p0(ptr addrspace(3) %src0)
  store ptr addrspace(3) %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v3p3(ptr addrspace(1) %out, <3 x ptr addrspace(3)> %src0) {
; GFX11-SDAG-LABEL: test_v3p3:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX11-SDAG-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v3
; GFX11-SDAG-NEXT:    global_store_b96 v4, v[0:2], s[4:5]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call <3 x ptr addrspace(3)> @llvm.amdgcn.permlane64.v3p3(<3 x ptr addrspace(3)> %src0)
  store <3 x ptr addrspace(3)> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_p5(ptr addrspace(1) %out, ptr addrspace(5) %src0) {
; GFX11-SDAG-LABEL: test_p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call ptr addrspace(5) @llvm.amdgcn.permlane64.p5(ptr addrspace(5) %src0)
  store ptr addrspace(5) %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v3p5(ptr addrspace(1) %out, <3 x ptr addrspace(5)> %src0) {
; GFX11-SDAG-LABEL: test_v3p5:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX11-SDAG-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v3
; GFX11-SDAG-NEXT:    global_store_b96 v4, v[0:2], s[4:5]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call <3 x ptr addrspace(5)> @llvm.amdgcn.permlane64.v3p5(<3 x ptr addrspace(5)> %src0)
  store <3 x ptr addrspace(5)> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_p6(ptr addrspace(1) %out, ptr addrspace(6) %src0) {
; GFX11-SDAG-LABEL: test_p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_mov_b32 v0, s2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v0
; GFX11-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call ptr addrspace(6) @llvm.amdgcn.permlane64.p6(ptr addrspace(6) %src0)
  store ptr addrspace(6) %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_v3p6(ptr addrspace(1) %out, <3 x ptr addrspace(6)> %src0) {
; GFX11-SDAG-LABEL: test_v3p6:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_clause 0x1
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x34
; GFX11-SDAG-NEXT:    s_load_b64 s[4:5], s[4:5], 0x24
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s1
; GFX11-SDAG-NEXT:    v_mov_b32_e32 v3, s0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v2, v0
; GFX11-SDAG-NEXT:    v_permlane64_b32 v1, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_permlane64_b32 v0, v3
; GFX11-SDAG-NEXT:    global_store_b96 v4, v[0:2], s[4:5]
; GFX11-SDAG-NEXT:    s_endpgm
  %v = call <3 x ptr addrspace(6)> @llvm.amdgcn.permlane64.v3p6(<3 x ptr addrspace(6)> %src0)
  store <3 x ptr addrspace(6)> %v, ptr addrspace(1) %out
  ret void
}
