; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; UCVTF H -> H
;

define <4 x half> @ucvtf_v4i16_v4f16(<4 x i16> %op1) {
; CHECK-LABEL: ucvtf_v4i16_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i16_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #14]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #12]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #10]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <4 x i16> %op1 to <4 x half>
  ret <4 x half> %res
}

define void @ucvtf_v8i16_v8f16(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i16_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i16_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #22]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x half>
  store <8 x half> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v16i16_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v16i16_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #58]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #54]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #52]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #50]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #38]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #36]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #34]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

;
; UCVTF H -> S
;

define <2 x float> @ucvtf_v2i16_v2f32(<2 x i16> %op1) {
; CHECK-LABEL: ucvtf_v2i16_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i16_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i16> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i16_v4f32(<4 x i16> %op1) {
; CHECK-LABEL: ucvtf_v4i16_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i16_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <4 x i16> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i16_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i16_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i16_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #56]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f32(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v16i16_v16f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.s
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q2, q0, [x1, #32]
; CHECK-NEXT:    stp q3, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v16i16_v16f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-128]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #88]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #80]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #72]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #120]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #112]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #104]
; NONEON-NOSVE-NEXT:    ucvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x float>
  store <16 x float> %res, ptr %b
  ret void
}

;
; UCVTF H -> D
;

define <1 x double> @ucvtf_v1i16_v1f64(<1 x i16> %op1) {
; CHECK-LABEL: ucvtf_v1i16_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w8, w8, #0xffff
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v1i16_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp], #16
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <1 x i16> %op1 to <1 x double>
  ret <1 x double> %res
}

define <2 x double> @ucvtf_v2i16_v2f64(<2 x i16> %op1) {
; CHECK-LABEL: ucvtf_v2i16_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i16_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i16> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i16_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v4i16_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i16_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i16>, ptr %a
  %res = uitofp <4 x i16> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v8i16_v8f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i16_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    ucvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q2, q1, [x1]
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i16_v8f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #160
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 160
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #88]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #80]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #144]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #72]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #128]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #128]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #112]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #160
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v16i16_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    mov z2.d, z0.d
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    mov z5.d, z3.d
; CHECK-NEXT:    uunpklo z4.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    ext z5.b, z5.b, z3.b, #8
; CHECK-NEXT:    mov z7.d, z1.d
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z4.d, p0/m, z4.d
; CHECK-NEXT:    mov z6.d, z2.d
; CHECK-NEXT:    uunpklo z5.d, z5.s
; CHECK-NEXT:    ext z7.b, z7.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    ucvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ext z6.b, z6.b, z2.b, #8
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    uunpklo z7.d, z7.s
; CHECK-NEXT:    ucvtf z5.d, p0/m, z5.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    uunpklo z6.d, z6.s
; CHECK-NEXT:    stp q4, q0, [x1, #64]
; CHECK-NEXT:    ucvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    stp q3, q5, [x1]
; CHECK-NEXT:    movprfx z3, z7
; CHECK-NEXT:    ucvtf z3.d, p0/m, z7.d
; CHECK-NEXT:    movprfx z0, z6
; CHECK-NEXT:    ucvtf z0.d, p0/m, z6.d
; CHECK-NEXT:    stp q1, q3, [x1, #32]
; CHECK-NEXT:    stp q2, q0, [x1, #96]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v16i16_v16f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #336
; NONEON-NOSVE-NEXT:    str x29, [sp, #320] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 336
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #320] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #56]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #88]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #152]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #72]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #128]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #120]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #136]
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp, #120]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #104]
; NONEON-NOSVE-NEXT:    str d1, [sp, #328]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #104]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #160]
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #176]
; NONEON-NOSVE-NEXT:    str d0, [sp, #168]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #152]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #240]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #144]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #224]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #136]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #208]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #332]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #192]
; NONEON-NOSVE-NEXT:    ucvtf d1, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #328]
; NONEON-NOSVE-NEXT:    ldp q4, q3, [sp, #192]
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #184]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #304]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #176]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #288]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #168]
; NONEON-NOSVE-NEXT:    ldp q7, q6, [sp, #288]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #272]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #256]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #224]
; NONEON-NOSVE-NEXT:    ldp q2, q5, [sp, #256]
; NONEON-NOSVE-NEXT:    stp q3, q4, [x1, #32]
; NONEON-NOSVE-NEXT:    stp q6, q7, [x1, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    stp q5, q2, [x1, #96]
; NONEON-NOSVE-NEXT:    add sp, sp, #336
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; UCVTF S -> H
;

define <2 x half> @ucvtf_v2i32_v2f16(<2 x i32> %op1) {
; CHECK-LABEL: ucvtf_v2i32_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i32_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    str wzr, [sp, #12]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #10]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @ucvtf_v4i32_v4f16(<4 x i32> %op1) {
; CHECK-LABEL: ucvtf_v4i32_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i32_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <4 x i32> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @ucvtf_v8i32_v8f16(ptr %a) {
; CHECK-LABEL: ucvtf_v8i32_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i32_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #38]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #36]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #34]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x half>
  ret <8 x half> %res
}

define void @ucvtf_v16i32_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v16i32_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ucvtf z3.h, p0/m, z3.s
; CHECK-NEXT:    ucvtf z2.h, p0/m, z2.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    splice z2.h, p0, z2.h, z3.h
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v16i32_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0, #32]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    str q2, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #78]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #76]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #74]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #72]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #70]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #68]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #66]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #94]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #92]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #90]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #88]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #86]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #84]
; NONEON-NOSVE-NEXT:    ucvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #82]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i32>, ptr %a
  %res = uitofp <16 x i32> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

;
; UCVTF S -> S
;

define <2 x float> @ucvtf_v2i32_v2f32(<2 x i32> %op1) {
; CHECK-LABEL: ucvtf_v2i32_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i32_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i32_v4f32(<4 x i32> %op1) {
; CHECK-LABEL: ucvtf_v4i32_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i32_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <4 x i32> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i32_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i32_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i32_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #56]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s1, w9
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; UCVTF S -> D
;

define <2 x double> @ucvtf_v2i32_v2f64(<2 x i32> %op1) {
; CHECK-LABEL: ucvtf_v2i32_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i32_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i32_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v4i32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i32_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i32>, ptr %a
  %res = uitofp <4 x i32> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v8i32_v8f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i32_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    ucvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    ucvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q2, q0, [x1, #32]
; CHECK-NEXT:    stp q3, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i32_v8f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-128]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #112]
; NONEON-NOSVE-NEXT:    ucvtf d1, w9
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

;
; UCVTF D -> H
;

define <2 x half> @ucvtf_v2i64_v2f16(<2 x i64> %op1) {
; CHECK-LABEL: ucvtf_v2i64_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.d, z0.d[1]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.d
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i64_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @ucvtf_v4i64_v4f16(ptr %a) {
; CHECK-LABEL: ucvtf_v4i64_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i64_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @ucvtf_v8i64_v8f16(ptr %a) {
; CHECK-LABEL: ucvtf_v8i64_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z0.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fcvt z1.h, p0/m, z2.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z2.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i64_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0, #32]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q3, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    str q2, [sp]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #78]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #76]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #74]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #72]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #70]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #68]
; NONEON-NOSVE-NEXT:    ucvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #66]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #64]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i64>, ptr %a
  %res = uitofp <8 x i64> %op1 to <8 x half>
  ret <8 x half> %res
}

;
; UCVTF D -> S
;

define <2 x float> @ucvtf_v2i64_v2f32(<2 x i64> %op1) {
; CHECK-LABEL: ucvtf_v2i64_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i64_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i64_v4f32(ptr %a) {
; CHECK-LABEL: ucvtf_v4i64_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i64_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i64_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v8i64_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    splice z2.s, p0, z2.s, z3.s
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v8i64_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0, #32]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #32]
; NONEON-NOSVE-NEXT:    str q2, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #72]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #64]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #48]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #88]
; NONEON-NOSVE-NEXT:    ucvtf s1, x9
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i64>, ptr %a
  %res = uitofp <8 x i64> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; UCVTF D -> D
;

define <2 x double> @ucvtf_v2i64_v2f64(<2 x i64> %op1) {
; CHECK-LABEL: ucvtf_v2i64_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v2i64_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    ucvtf d1, x9
; NONEON-NOSVE-NEXT:    ucvtf d0, x8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i64_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: ucvtf_v4i64_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_v4i64_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    ucvtf d1, x9
; NONEON-NOSVE-NEXT:    ucvtf d0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ucvtf d1, x9
; NONEON-NOSVE-NEXT:    ucvtf d0, x8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

;
; SCVTF H -> H
;

define <4 x half> @scvtf_v4i16_v4f16(<4 x i16> %op1) {
; CHECK-LABEL: scvtf_v4i16_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i16_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #14]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #12]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #10]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <4 x i16> %op1 to <4 x half>
  ret <4 x half> %res
}

define void @scvtf_v8i16_v8f16(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v8i16_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i16_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #22]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #20]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #18]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    str q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x half>
  store <8 x half> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v16i16_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    scvtf z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v16i16_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #58]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #54]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #52]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #50]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #38]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #36]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #34]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

; SCVTF H -> S
;

define <2 x float> @scvtf_v2i16_v2f32(<2 x i16> %op1) {
; CHECK-LABEL: scvtf_v2i16_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i16_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i16> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i16_v4f32(<4 x i16> %op1) {
; CHECK-LABEL: scvtf_v4i16_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i16_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <4 x i16> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @scvtf_v8i16_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v8i16_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i16_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #56]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f32(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v16i16_v16f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    scvtf z2.s, p0/m, z2.s
; CHECK-NEXT:    scvtf z3.s, p0/m, z3.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q2, q0, [x1, #32]
; CHECK-NEXT:    stp q3, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v16i16_v16f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-128]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #88]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #80]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #72]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #64]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #64]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #120]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #112]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #104]
; NONEON-NOSVE-NEXT:    scvtf s1, w8
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x float>
  store <16 x float> %res, ptr %b
  ret void
}

;
; SCVTF H -> D
;

define <2 x double> @scvtf_v2i16_v2f64(<2 x i16> %op1) {
; CHECK-LABEL: scvtf_v2i16_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i16_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i16> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i16_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v4i16_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i16_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i16>, ptr %a
  %res = sitofp <4 x i16> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @scvtf_v8i16_v8f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v8i16_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z2.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q2, q1, [x1]
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i16_v8f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #160
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 160
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #88]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #80]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #144]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #72]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #128]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #128]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #112]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #160
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v16i16_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    mov z2.d, z0.d
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    mov z5.d, z3.d
; CHECK-NEXT:    sunpklo z4.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    ext z5.b, z5.b, z3.b, #8
; CHECK-NEXT:    mov z7.d, z1.d
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z4.d, p0/m, z4.d
; CHECK-NEXT:    mov z6.d, z2.d
; CHECK-NEXT:    sunpklo z5.d, z5.s
; CHECK-NEXT:    ext z7.b, z7.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ext z6.b, z6.b, z2.b, #8
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    sunpklo z7.d, z7.s
; CHECK-NEXT:    scvtf z5.d, p0/m, z5.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    sunpklo z6.d, z6.s
; CHECK-NEXT:    stp q4, q0, [x1, #64]
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    stp q3, q5, [x1]
; CHECK-NEXT:    movprfx z3, z7
; CHECK-NEXT:    scvtf z3.d, p0/m, z7.d
; CHECK-NEXT:    movprfx z0, z6
; CHECK-NEXT:    scvtf z0.d, p0/m, z6.d
; CHECK-NEXT:    stp q1, q3, [x1, #32]
; CHECK-NEXT:    stp q2, q0, [x1, #96]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v16i16_v16f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #336
; NONEON-NOSVE-NEXT:    str x29, [sp, #320] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 336
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #320] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #56]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #88]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #152]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #72]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #128]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #120]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #136]
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp, #120]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #104]
; NONEON-NOSVE-NEXT:    str d1, [sp, #328]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #104]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #160]
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #176]
; NONEON-NOSVE-NEXT:    str d0, [sp, #168]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #152]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #240]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #144]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #224]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #136]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #208]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #332]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #192]
; NONEON-NOSVE-NEXT:    scvtf d1, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #328]
; NONEON-NOSVE-NEXT:    ldp q4, q3, [sp, #192]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #184]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #304]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #176]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #288]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #168]
; NONEON-NOSVE-NEXT:    ldp q7, q6, [sp, #288]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #272]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #256]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #224]
; NONEON-NOSVE-NEXT:    ldp q2, q5, [sp, #256]
; NONEON-NOSVE-NEXT:    stp q3, q4, [x1, #32]
; NONEON-NOSVE-NEXT:    stp q6, q7, [x1, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    stp q5, q2, [x1, #96]
; NONEON-NOSVE-NEXT:    add sp, sp, #336
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; SCVTF S -> H
;

define <2 x half> @scvtf_v2i32_v2f16(<2 x i32> %op1) {
; CHECK-LABEL: scvtf_v2i32_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i32_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    str wzr, [sp, #12]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #10]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @scvtf_v4i32_v4f16(<4 x i32> %op1) {
; CHECK-LABEL: scvtf_v4i32_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i32_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <4 x i32> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @scvtf_v8i32_v8f16(ptr %a) {
; CHECK-LABEL: scvtf_v8i32_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i32_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #38]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #36]
; NONEON-NOSVE-NEXT:    scvtf s0, w9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #34]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x half>
  ret <8 x half> %res
}

;
; SCVTF S -> S
;

define <2 x float> @scvtf_v2i32_v2f32(<2 x i32> %op1) {
; CHECK-LABEL: scvtf_v2i32_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i32_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i32_v4f32(<4 x i32> %op1) {
; CHECK-LABEL: scvtf_v4i32_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i32_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <4 x i32> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @scvtf_v8i32_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v8i32_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i32_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #56]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s1, w9
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; SCVTF S -> D
;

define <2 x double> @scvtf_v2i32_v2f64(<2 x i32> %op1) {
; CHECK-LABEL: scvtf_v2i32_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i32_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i32_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v4i32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i32_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i32>, ptr %a
  %res = sitofp <4 x i32> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @scvtf_v8i32_v8f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v8i32_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q2, q0, [x1, #32]
; CHECK-NEXT:    stp q3, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v8i32_v8f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-128]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #40]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #32]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #112]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    stp q2, q3, [x1]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @scvtf_v16i32_v16f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v16i32_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q5, q4, [x0]
; CHECK-NEXT:    mov z2.d, z0.d
; CHECK-NEXT:    mov z3.d, z1.d
; CHECK-NEXT:    mov z6.d, z4.d
; CHECK-NEXT:    mov z7.d, z5.d
; CHECK-NEXT:    ext z2.b, z2.b, z0.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z1.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    ext z6.b, z6.b, z4.b, #8
; CHECK-NEXT:    ext z7.b, z7.b, z5.b, #8
; CHECK-NEXT:    sunpklo z4.d, z4.s
; CHECK-NEXT:    sunpklo z5.d, z5.s
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    sunpklo z6.d, z6.s
; CHECK-NEXT:    sunpklo z7.d, z7.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z4.d, p0/m, z4.d
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    stp q1, q3, [x1, #64]
; CHECK-NEXT:    movprfx z1, z7
; CHECK-NEXT:    scvtf z1.d, p0/m, z7.d
; CHECK-NEXT:    stp q0, q2, [x1, #96]
; CHECK-NEXT:    movprfx z0, z6
; CHECK-NEXT:    scvtf z0.d, p0/m, z6.d
; CHECK-NEXT:    movprfx z2, z5
; CHECK-NEXT:    scvtf z2.d, p0/m, z5.d
; CHECK-NEXT:    stp q2, q1, [x1]
; CHECK-NEXT:    stp q4, q0, [x1, #32]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v16i32_v16f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #272
; NONEON-NOSVE-NEXT:    str x29, [sp, #256] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 272
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    ldp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #256] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    ldp q3, q2, [x0, #32]
; NONEON-NOSVE-NEXT:    str q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q2, [sp]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp]
; NONEON-NOSVE-NEXT:    str q3, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #48]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #104]
; NONEON-NOSVE-NEXT:    ldp d0, d1, [sp, #64]
; NONEON-NOSVE-NEXT:    str d0, [sp, #264]
; NONEON-NOSVE-NEXT:    ldp d0, d2, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d2, d0, [sp, #88]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    scvtf d2, w9
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #56]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #120]
; NONEON-NOSVE-NEXT:    scvtf d0, w9
; NONEON-NOSVE-NEXT:    str d0, [sp, #152]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #104]
; NONEON-NOSVE-NEXT:    stp d2, d0, [sp, #136]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #112]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #192]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #120]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #208]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #268]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #224]
; NONEON-NOSVE-NEXT:    scvtf d1, w8
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #264]
; NONEON-NOSVE-NEXT:    ldp q4, q6, [sp, #208]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #88]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #240]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr q7, [sp, #240]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #160]
; NONEON-NOSVE-NEXT:    scvtf d1, w9
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ldr q5, [sp, #160]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #176]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [sp, #176]
; NONEON-NOSVE-NEXT:    stp q7, q6, [x1, #64]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    stp q4, q3, [x1, #32]
; NONEON-NOSVE-NEXT:    stp q2, q5, [x1, #96]
; NONEON-NOSVE-NEXT:    add sp, sp, #272
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i32>, ptr %a
  %res = sitofp <16 x i32> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; SCVTF D -> H
;

define <2 x half> @scvtf_v2i64_v2f16(<2 x i64> %op1) {
; CHECK-LABEL: scvtf_v2i64_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.d, z0.d[1]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    scvtf z1.h, p0/m, z1.d
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i64_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    scvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @scvtf_v4i64_v4f16(ptr %a) {
; CHECK-LABEL: scvtf_v4i64_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i64_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    scvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    scvtf s0, x9
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #42]
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    str h0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x half>
  ret <4 x half> %res
}

;
; SCVTF D -> S
;

define <2 x float> @scvtf_v2i64_v2f32(<2 x i64> %op1) {
; CHECK-LABEL: scvtf_v2i64_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i64_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    scvtf s1, x9
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i64_v4f32(ptr %a) {
; CHECK-LABEL: scvtf_v4i64_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i64_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    scvtf s1, x9
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    scvtf s1, x9
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x float>
  ret <4 x float> %res
}

;
; SCVTF D -> D
;

define <2 x double> @scvtf_v2i64_v2f64(<2 x i64> %op1) {
; CHECK-LABEL: scvtf_v2i64_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v2i64_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    scvtf d1, x9
; NONEON-NOSVE-NEXT:    scvtf d0, x8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i64_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: scvtf_v4i64_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_v4i64_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp, #16]
; NONEON-NOSVE-NEXT:    scvtf d1, x9
; NONEON-NOSVE-NEXT:    scvtf d0, x8
; NONEON-NOSVE-NEXT:    ldp x8, x9, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #48]
; NONEON-NOSVE-NEXT:    scvtf d1, x9
; NONEON-NOSVE-NEXT:    scvtf d0, x8
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x1]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define half @scvtf_i16_f16(ptr %0) {
; CHECK-LABEL: scvtf_i16_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrsh w8, [x0]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i16_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrsh w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = sitofp i16 %2 to half
  ret half %3
}

define float @scvtf_i16_f32(ptr %0) {
; CHECK-LABEL: scvtf_i16_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrsh w8, [x0]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i16_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrsh w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = sitofp i16 %2 to float
  ret float %3
}

define double @scvtf_i16_f64(ptr %0) {
; CHECK-LABEL: scvtf_i16_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrsh w8, [x0]
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i16_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrsh w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = sitofp i16 %2 to double
  ret double %3
}

define half @scvtf_i32_f16(ptr %0) {
; CHECK-LABEL: scvtf_i32_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i32_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = sitofp i32 %2 to half
  ret half %3
}

define float @scvtf_i32_f32(ptr %0) {
; CHECK-LABEL: scvtf_i32_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i32_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = sitofp i32 %2 to float
  ret float %3
}

define double @scvtf_i32_f64(ptr %0) {
; CHECK-LABEL: scvtf_i32_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i32_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    scvtf d0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = sitofp i32 %2 to double
  ret double %3
}

define half @scvtf_i64_f16(ptr %0) {
; CHECK-LABEL: scvtf_i64_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i64_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = sitofp i64 %2 to half
  ret half %3
}

define float @scvtf_i64_f32(ptr %0) {
; CHECK-LABEL: scvtf_i64_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i64_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    scvtf s0, x8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = sitofp i64 %2 to float
  ret float %3
}

define double @scvtf_i64_f64(ptr %0) {
; CHECK-LABEL: scvtf_i64_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: scvtf_i64_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    scvtf d0, x8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = sitofp i64 %2 to double
  ret double %3
}

define half @ucvtf_i16_f16(ptr %0) {
; CHECK-LABEL: ucvtf_i16_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i16_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrh w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = uitofp i16 %2 to half
  ret half %3
}

define float @ucvtf_i16_f32(ptr %0) {
; CHECK-LABEL: ucvtf_i16_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i16_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrh w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = uitofp i16 %2 to float
  ret float %3
}

define double @ucvtf_i16_f64(ptr %0) {
; CHECK-LABEL: ucvtf_i16_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w8, [x0]
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i16_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldrh w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i16, ptr %0, align 64
  %3 = uitofp i16 %2 to double
  ret double %3
}

define half @ucvtf_i32_f16(ptr %0) {
; CHECK-LABEL: ucvtf_i32_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i32_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = uitofp i32 %2 to half
  ret half %3
}

define float @ucvtf_i32_f32(ptr %0) {
; CHECK-LABEL: ucvtf_i32_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ldr s0, [x0]
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i32_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = uitofp i32 %2 to float
  ret float %3
}

define double @ucvtf_i32_f64(ptr %0) {
; CHECK-LABEL: ucvtf_i32_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i32_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr w8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf d0, w8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i32, ptr %0, align 64
  %3 = uitofp i32 %2 to double
  ret double %3
}

define half @ucvtf_i64_f16(ptr %0) {
; CHECK-LABEL: ucvtf_i64_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i64_f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = uitofp i64 %2 to half
  ret half %3
}

define float @ucvtf_i64_f32(ptr %0) {
; CHECK-LABEL: ucvtf_i64_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i64_f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf s0, x8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = uitofp i64 %2 to float
  ret float %3
}

define double @ucvtf_i64_f64(ptr %0) {
; CHECK-LABEL: ucvtf_i64_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: ucvtf_i64_f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr x8, [x0]
; NONEON-NOSVE-NEXT:    ucvtf d0, x8
; NONEON-NOSVE-NEXT:    ret
  %2 = load i64, ptr %0, align 64
  %3 = uitofp i64 %2 to double
  ret double %3
}
