[comment {-*- tcl -*- doctools manpage}]
[manpage_begin "Application utilities" n ""]
[copyright "2004-2012, Ashok P. Nadkarni"]
[moddesc "Application utilities"]
[titledesc "Commands for various Windows application utilities"]
[require twapi_apputil]
[description]
[para]

This module provides commands commonly required in Windows applications.

[section "Application command line"]
The following commands relate to the command line for the process.
The difference over
Tcl's built-in [var ::argv] variables is that these commands handle
Unicode command lines and use Windows conventions for argument parsing.
[list_begin opt]
[opt_def [uri \#get_command_line [cmd get_command_line]]]
Retrieves the command line passed to the process.
[opt_def [uri \#get_command_line_args [cmd get_command_line_args]]]
Parses a command line using Windows conventions. 
[list_end]

For retrieving the command line for another process, see
[uri process.html#get_process_info [cmd get_process_info]] in
the [uri process.html [cmd twapi_process]] module.

[section "INI files"]
The following commands deal with INI files used for storing
application preferences. 
Note these commands
take into account INI file mappings set up in the
[const {HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\IniFileMapping}] registry key.
[para]
A cross-platform package that provides similar functionality
is available in the available in the [uri http://tcllib.sf.net "tcllib"]
standard library. However, that does not take into account the
registry mappings on Windows platforms.

[list_begin opt]
[opt_def [uri \#read_inifile_key [cmd read_inifile_key]]]
Returns the value of a key.
[opt_def [uri \#write_inifile_key [cmd write_inifile_key]]]
Updates the value of a key.
[opt_def [uri \#delete_inifile_key [cmd delete_inifile_key]]]
Deletes a key and associated value.
[opt_def [uri \#read_inifile_section_names [cmd read_inifile_section_names]]]
Returns the names of all sections in an INI file.
[opt_def [uri \#read_inifile_section [cmd read_inifile_section]]]
Returns the keys and values within a INI file section.
[opt_def  [uri \#delete_inifile_section [cmd delete_inifile_section]]]
Deletes an entire section from an INI file.
[list_end]

[section Commands]
[list_begin definitions]

[call [cmd delete_inifile_key] [arg SECTION] [arg KEY] [opt "[cmd -inifile] [arg FILENAME]"]]

Deletes the key [arg KEY] from the INI file section [arg SECTION].
By default, the command writes to
the [const win.ini] file in the system directory. The [cmd -inifile]
option may be used to specify different INI file.

[call [cmd delete_inifile_section] [arg SECTION] [opt "[cmd -inifile] [arg FILENAME]"]]

Deletes the entire section [arg SECTION]
from an INI file. By default, the command writes to
the [const win.ini] file in the system directory. The [cmd -inifile]
option may be used to specify a different INI file.

[call [cmd get_command_line]]

Returns the command line of the current process. This may be passed to the
[uri \#get_command_line_args [cmd get_command_line_args]]
function to split the line into arguments.

[call [cmd get_command_line_args] [arg COMMANDLINE]]

Parses [arg COMMANDLINE] as per Windows command line conventions and returns
a list of the parsed arguments. The main advantage of this over using
the [cmd argv] and [cmd argv0] variables in [cmd tclsh] and [cmd wish] is
that this call will correctly handle Unicode arguments.

[call [cmd read_inifile_key] [arg SECTION] [arg KEY] [opt [arg options]]]

Returns the value of the key [arg KEY] in the INI file section [arg SECTION].
If the key is not found, an empty string is returned unless the
[cmd -default] option is specified.
The following options may be specified:
[list_begin opt]
[opt_def [cmd -default] [arg DEFAULTVALUE]]If the key is not found in the
section, the command returns [arg DEFAULTVALUE] instead of an empty string.
[opt_def [cmd -inifile] [arg FILENAME]]By default, the command looks up
the [const win.ini] file in the system directory. This option may be used
to look up a different INI file instead.
[list_end]

[call [cmd read_inifile_section] [arg SECTION] [opt "[cmd -inifile] [arg FILENAME]"]]

Returns all the entries in section [arg SECTION]
of an INI file as a list of key value pairs. By default, the command
reads
the [const win.ini] file in the system directory. The [cmd -inifile]
option may be used to specify a different INI file.

[call [cmd read_inifile_section_names] [opt "[cmd -inifile] [arg FILENAME]"]]

Returns the names of all sections in
an INI file. By default, the command
reads
the [const win.ini] file in the system directory. The [cmd -inifile]
option may be used to specify a different INI file.

[call [cmd write_inifile_key] [arg SECTION] [arg KEY] [arg VALUE] [opt "[cmd -inifile] [arg FILENAME]"]]

Writes [arg VALUE] as the value of the key [arg KEY] in the INI file
section [arg SECTION]. The section and key are created if they did not already
exist.
By default, the command writes to
the [const win.ini] file in the system directory. The [cmd -inifile]
option may be used to look up a different INI file instead.

[list_end]

[keywords "INI file" "profile" "command line" "environment variables" "environment string expansion"]

[manpage_end]
