[//]: # (generated using SlashBack 0.2.0)

# Function Reference  
This is where you will find a **reference of all the functions that PyGLM provides**\.  
  
Most functions are **overloaded**, i\.e\. they accept more than one type of argument and may or may not behave differently depending on the type of argument\(s\)\.  
Where possible, I tried to **compromise between exactness and readability** of the supported data types\.  
Therefore there are some **types** that are **placeholders** for others\.  
Here are a few examples:  

Name | Description
-|-
*number* | Can be **\(any\) numerical type**, usually ``` float ``` or ``` int ```\.
*vecN* | Can be **any** or most of the available **vector** types of **any length**\.
*vec3* | Can be **any** or most of the available **vector** types of **length 3**\.
*fvecN* | A **float vector** of **any length**\.
*matNxM* | Can be **any** or most of the available **matrix** types of **any shape**\.
*matSxS* | Can be **any** or most of the available **matrix** types of **square shape**\.
*quat* | **Any** type of **quaternion**\.
  
  
If different combinations of input arguments are possible, **multiple ways to call a particular function are presented**\.  
  
Example:  
#### <code>glm.<code>**abs**(**x**: *float*) -\> *float*</code></code>  
&emsp;&emsp;Returns ``` x ``` if ``` x >= 0 ```; otherwise it returns ``` -x ```\.  
  
#### <code>glm.<code>**abs**(**x**: *vecN*) -\> *vecN*</code></code>  
&emsp;&emsp;For each component ``` c ``` of ``` x ```,  
&emsp;&emsp;Returns ``` c ``` if ``` c >= 0 ```; otherwise it returns ``` -c ```\.  
  
This means that you can call the ``` glm.abs ``` function with a ``` float ``` ``` "x" ``` and it will return a ``` float ``` value  
\(as you can tell by the <code> -> *float*</code>\), or you can call it with a vector, e\.g\. a ``` vec3 ``` and get a vector \(``` vec3 ``` in this case\) back\.  
# Table of Contents  
  
*  [detail](detail/README.md)  
    *  [func\_common methods](detail/func_common.md)  
        *  [**abs** function ](detail/func_common.md#abs-function)  
        *  [**ceil** function ](detail/func_common.md#ceil-function)  
        *  [**clamp** function ](detail/func_common.md#clamp-function)  
        *  [**floatBitsToInt** function ](detail/func_common.md#floatBitsToInt-function)  
        *  [**floatBitsToUint** function ](detail/func_common.md#floatBitsToUint-function)  
        *  [**floor** function ](detail/func_common.md#floor-function)  
        *  [**fma** function ](detail/func_common.md#fma-function)  
        *  [**fmax** function ](detail/func_common.md#fmax-function)  
        *  [**fmin** function ](detail/func_common.md#fmin-function)  
        *  [**fract** function ](detail/func_common.md#fract-function)  
        *  [**frexp** function ](detail/func_common.md#frexp-function)  
        *  [**intBitsToFloat** function ](detail/func_common.md#intBitsToFloat-function)  
        *  [**isinf** function ](detail/func_common.md#isinf-function)  
        *  [**isnan** function ](detail/func_common.md#isnan-function)  
        *  [**ldexp** function ](detail/func_common.md#ldexp-function)  
        *  [**max** function ](detail/func_common.md#max-function)  
        *  [**min** function ](detail/func_common.md#min-function)  
        *  [**mix** function ](detail/func_common.md#mix-function)  
        *  [**mod** function ](detail/func_common.md#mod-function)  
        *  [**modf** function ](detail/func_common.md#modf-function)  
        *  [**round** function ](detail/func_common.md#round-function)  
        *  [**roundEven** function ](detail/func_common.md#roundEven-function)  
        *  [**sign** function ](detail/func_common.md#sign-function)  
        *  [**smoothstep** function ](detail/func_common.md#smoothstep-function)  
        *  [**step** function ](detail/func_common.md#step-function)  
        *  [**trunc** function ](detail/func_common.md#trunc-function)  
        *  [**uintBitsToFloat** function ](detail/func_common.md#uintBitsToFloat-function)  
    *  [func\_exponential methods](detail/func_exponential.md)  
        *  [**exp** function ](detail/func_exponential.md#exp-function)  
        *  [**exp2** function ](detail/func_exponential.md#exp2-function)  
        *  [**inversesqrt** function ](detail/func_exponential.md#inversesqrt-function)  
        *  [**log** function ](detail/func_exponential.md#log-function)  
        *  [**log2** function ](detail/func_exponential.md#log2-function)  
        *  [**pow** function ](detail/func_exponential.md#pow-function)  
        *  [**sqrt** function ](detail/func_exponential.md#sqrt-function)  
    *  [func\_geometric methods](detail/func_geometric.md)  
        *  [**cross** function ](detail/func_geometric.md#cross-function)  
        *  [**distance** function ](detail/func_geometric.md#distance-function)  
        *  [**dot** function ](detail/func_geometric.md#dot-function)  
        *  [**faceforward** function ](detail/func_geometric.md#faceforward-function)  
        *  [**length** function ](detail/func_geometric.md#length-function)  
        *  [**normalize** function ](detail/func_geometric.md#normalize-function)  
        *  [**reflect** function ](detail/func_geometric.md#reflect-function)  
        *  [**refract** function ](detail/func_geometric.md#refract-function)  
    *  [func\_integer methods](detail/func_integer.md)  
        *  [**bitCount** function ](detail/func_integer.md#bitCount-function)  
        *  [**bitfieldExtract** function ](detail/func_integer.md#bitfieldExtract-function)  
        *  [**bitfieldInsert** function ](detail/func_integer.md#bitfieldInsert-function)  
        *  [**bitfieldReverse** function ](detail/func_integer.md#bitfieldReverse-function)  
        *  [**findLSB** function ](detail/func_integer.md#findLSB-function)  
        *  [**findMSB** function ](detail/func_integer.md#findMSB-function)  
        *  [**imulExtended** function ](detail/func_integer.md#imulExtended-function)  
        *  [**uaddCarry** function ](detail/func_integer.md#uaddCarry-function)  
        *  [**umulExtended** function ](detail/func_integer.md#umulExtended-function)  
        *  [**usubBorrow** function ](detail/func_integer.md#usubBorrow-function)  
    *  [func\_matrix methods](detail/func_matrix.md)  
        *  [**determinant** function ](detail/func_matrix.md#determinant-function)  
        *  [**inverse** function ](detail/func_matrix.md#inverse-function)  
        *  [**matrixCompMult** function ](detail/func_matrix.md#matrixCompMult-function)  
        *  [**outerProduct** function ](detail/func_matrix.md#outerProduct-function)  
        *  [**transpose** function ](detail/func_matrix.md#transpose-function)  
    *  [func\_packing methods](detail/func_packing.md)  
        *  [**packDouble2x32** function ](detail/func_packing.md#packDouble2x32-function)  
        *  [**packHalf2x16** function ](detail/func_packing.md#packHalf2x16-function)  
        *  [**packSnorm2x16** function ](detail/func_packing.md#packSnorm2x16-function)  
        *  [**packSnorm4x8** function ](detail/func_packing.md#packSnorm4x8-function)  
        *  [**packUnorm2x16** function ](detail/func_packing.md#packUnorm2x16-function)  
        *  [**packUnorm4x8** function ](detail/func_packing.md#packUnorm4x8-function)  
        *  [**unpackDouble2x32** function ](detail/func_packing.md#unpackDouble2x32-function)  
        *  [**unpackHalf2x16** function ](detail/func_packing.md#unpackHalf2x16-function)  
        *  [**unpackSnorm2x16** function ](detail/func_packing.md#unpackSnorm2x16-function)  
        *  [**unpackSnorm4x8** function ](detail/func_packing.md#unpackSnorm4x8-function)  
        *  [**unpackUnorm2x16** function ](detail/func_packing.md#unpackUnorm2x16-function)  
        *  [**unpackUnorm4x8** function ](detail/func_packing.md#unpackUnorm4x8-function)  
    *  [func\_trigonometric methods](detail/func_trigonometric.md)  
        *  [**acos** function ](detail/func_trigonometric.md#acos-function)  
        *  [**acosh** function ](detail/func_trigonometric.md#acosh-function)  
        *  [**asin** function ](detail/func_trigonometric.md#asin-function)  
        *  [**asinh** function ](detail/func_trigonometric.md#asinh-function)  
        *  [**atan** function ](detail/func_trigonometric.md#atan-function)  
        *  [**atanh** function ](detail/func_trigonometric.md#atanh-function)  
        *  [**cos** function ](detail/func_trigonometric.md#cos-function)  
        *  [**cosh** function ](detail/func_trigonometric.md#cosh-function)  
        *  [**degrees** function ](detail/func_trigonometric.md#degrees-function)  
        *  [**radians** function ](detail/func_trigonometric.md#radians-function)  
        *  [**sin** function ](detail/func_trigonometric.md#sin-function)  
        *  [**sinh** function ](detail/func_trigonometric.md#sinh-function)  
        *  [**tan** function ](detail/func_trigonometric.md#tan-function)  
        *  [**tanh** function ](detail/func_trigonometric.md#tanh-function)  
    *  [func\_vector\_relational methods](detail/func_vector_relational.md)  
        *  [**all** function ](detail/func_vector_relational.md#all-function)  
        *  [**any** function ](detail/func_vector_relational.md#any-function)  
        *  [**equal** function ](detail/func_vector_relational.md#equal-function)  
        *  [**greaterThan** function ](detail/func_vector_relational.md#greaterThan-function)  
        *  [**greaterThanEqual** function ](detail/func_vector_relational.md#greaterThanEqual-function)  
        *  [**lessThan** function ](detail/func_vector_relational.md#lessThan-function)  
        *  [**lessThanEqual** function ](detail/func_vector_relational.md#lessThanEqual-function)  
        *  [**notEqual** function ](detail/func_vector_relational.md#notEqual-function)  
        *  [**not\_** function ](detail/func_vector_relational.md#not_-function)  
*  [recommended\_extensions](recommended_extensions/README.md)  
    *  [color\_space methods](recommended_extensions/color_space.md)  
        *  [**convertLinearToSRGB** function ](recommended_extensions/color_space.md#convertLinearToSRGB-function)  
        *  [**convertSRGBToLinear** function ](recommended_extensions/color_space.md#convertSRGBToLinear-function)  
    *  [constants methods](recommended_extensions/constants.md)  
        *  [**e** function ](recommended_extensions/constants.md#e-function)  
        *  [**epsilon** function ](recommended_extensions/constants.md#epsilon-function)  
        *  [**euler** function ](recommended_extensions/constants.md#euler-function)  
        *  [**four\_over\_pi** function ](recommended_extensions/constants.md#four_over_pi-function)  
        *  [**golden\_ratio** function ](recommended_extensions/constants.md#golden_ratio-function)  
        *  [**half\_pi** function ](recommended_extensions/constants.md#half_pi-function)  
        *  [**ln\_ln\_two** function ](recommended_extensions/constants.md#ln_ln_two-function)  
        *  [**ln\_ten** function ](recommended_extensions/constants.md#ln_ten-function)  
        *  [**ln\_two** function ](recommended_extensions/constants.md#ln_two-function)  
        *  [**one** function ](recommended_extensions/constants.md#one-function)  
        *  [**one\_over\_pi** function ](recommended_extensions/constants.md#one_over_pi-function)  
        *  [**one\_over\_root\_two** function ](recommended_extensions/constants.md#one_over_root_two-function)  
        *  [**one\_over\_two\_pi** function ](recommended_extensions/constants.md#one_over_two_pi-function)  
        *  [**pi** function ](recommended_extensions/constants.md#pi-function)  
        *  [**quarter\_pi** function ](recommended_extensions/constants.md#quarter_pi-function)  
        *  [**root\_five** function ](recommended_extensions/constants.md#root_five-function)  
        *  [**root\_half\_pi** function ](recommended_extensions/constants.md#root_half_pi-function)  
        *  [**root\_ln\_four** function ](recommended_extensions/constants.md#root_ln_four-function)  
        *  [**root\_pi** function ](recommended_extensions/constants.md#root_pi-function)  
        *  [**root\_three** function ](recommended_extensions/constants.md#root_three-function)  
        *  [**root\_two** function ](recommended_extensions/constants.md#root_two-function)  
        *  [**root\_two\_pi** function ](recommended_extensions/constants.md#root_two_pi-function)  
        *  [**third** function ](recommended_extensions/constants.md#third-function)  
        *  [**three\_over\_two\_pi** function ](recommended_extensions/constants.md#three_over_two_pi-function)  
        *  [**two\_over\_pi** function ](recommended_extensions/constants.md#two_over_pi-function)  
        *  [**two\_over\_root\_pi** function ](recommended_extensions/constants.md#two_over_root_pi-function)  
        *  [**two\_pi** function ](recommended_extensions/constants.md#two_pi-function)  
        *  [**two\_thirds** function ](recommended_extensions/constants.md#two_thirds-function)  
        *  [**zero** function ](recommended_extensions/constants.md#zero-function)  
    *  [epsilon methods](recommended_extensions/epsilon.md)  
        *  [**epsilonEqual** function ](recommended_extensions/epsilon.md#epsilonEqual-function)  
        *  [**epsilonNotEqual** function ](recommended_extensions/epsilon.md#epsilonNotEqual-function)  
    *  [integer methods](recommended_extensions/integer.md)  
        *  [**iround** function ](recommended_extensions/integer.md#iround-function)  
        *  [**uround** function ](recommended_extensions/integer.md#uround-function)  
    *  [matrix\_access methods](recommended_extensions/matrix_access.md)  
        *  [**column** function ](recommended_extensions/matrix_access.md#column-function)  
        *  [**row** function ](recommended_extensions/matrix_access.md#row-function)  
    *  [matrix\_inverse methods](recommended_extensions/matrix_inverse.md)  
        *  [**affineInverse** function ](recommended_extensions/matrix_inverse.md#affineInverse-function)  
        *  [**inverseTranspose** function ](recommended_extensions/matrix_inverse.md#inverseTranspose-function)  
    *  [noise methods](recommended_extensions/noise.md)  
        *  [**perlin** function ](recommended_extensions/noise.md#perlin-function)  
        *  [**simplex** function ](recommended_extensions/noise.md#simplex-function)  
    *  [packing methods](recommended_extensions/packing.md)  
        *  [**packF2x11\_1x10** function ](recommended_extensions/packing.md#packF2x11_1x10-function)  
        *  [**packF3x9\_E1x5** function ](recommended_extensions/packing.md#packF3x9_E1x5-function)  
        *  [**packHalf** function ](recommended_extensions/packing.md#packHalf-function)  
        *  [**packHalf1x16** function ](recommended_extensions/packing.md#packHalf1x16-function)  
        *  [**packHalf4x16** function ](recommended_extensions/packing.md#packHalf4x16-function)  
        *  [**packI3x10\_1x2** function ](recommended_extensions/packing.md#packI3x10_1x2-function)  
        *  [**packInt2x16** function ](recommended_extensions/packing.md#packInt2x16-function)  
        *  [**packInt2x32** function ](recommended_extensions/packing.md#packInt2x32-function)  
        *  [**packInt2x8** function ](recommended_extensions/packing.md#packInt2x8-function)  
        *  [**packInt4x16** function ](recommended_extensions/packing.md#packInt4x16-function)  
        *  [**packInt4x8** function ](recommended_extensions/packing.md#packInt4x8-function)  
        *  [**packRGBM** function ](recommended_extensions/packing.md#packRGBM-function)  
        *  [**packSnorm** function ](recommended_extensions/packing.md#packSnorm-function)  
        *  [**packSnorm1x16** function ](recommended_extensions/packing.md#packSnorm1x16-function)  
        *  [**packSnorm1x8** function ](recommended_extensions/packing.md#packSnorm1x8-function)  
        *  [**packSnorm2x8** function ](recommended_extensions/packing.md#packSnorm2x8-function)  
        *  [**packSnorm3x10\_1x2** function ](recommended_extensions/packing.md#packSnorm3x10_1x2-function)  
        *  [**packSnorm4x16** function ](recommended_extensions/packing.md#packSnorm4x16-function)  
        *  [**packU3x10\_1x2** function ](recommended_extensions/packing.md#packU3x10_1x2-function)  
        *  [**packUint2x16** function ](recommended_extensions/packing.md#packUint2x16-function)  
        *  [**packUint2x32** function ](recommended_extensions/packing.md#packUint2x32-function)  
        *  [**packUint2x8** function ](recommended_extensions/packing.md#packUint2x8-function)  
        *  [**packUint4x16** function ](recommended_extensions/packing.md#packUint4x16-function)  
        *  [**packUint4x8** function ](recommended_extensions/packing.md#packUint4x8-function)  
        *  [**packUnorm** function ](recommended_extensions/packing.md#packUnorm-function)  
        *  [**packUnorm1x16** function ](recommended_extensions/packing.md#packUnorm1x16-function)  
        *  [**packUnorm1x5\_1x6\_1x5** function ](recommended_extensions/packing.md#packUnorm1x5_1x6_1x5-function)  
        *  [**packUnorm1x8** function ](recommended_extensions/packing.md#packUnorm1x8-function)  
        *  [**packUnorm2x3\_1x2** function ](recommended_extensions/packing.md#packUnorm2x3_1x2-function)  
        *  [**packUnorm2x4** function ](recommended_extensions/packing.md#packUnorm2x4-function)  
        *  [**packUnorm2x8** function ](recommended_extensions/packing.md#packUnorm2x8-function)  
        *  [**packUnorm3x10\_1x2** function ](recommended_extensions/packing.md#packUnorm3x10_1x2-function)  
        *  [**packUnorm3x5\_1x1** function ](recommended_extensions/packing.md#packUnorm3x5_1x1-function)  
        *  [**packUnorm4x16** function ](recommended_extensions/packing.md#packUnorm4x16-function)  
        *  [**packUnorm4x4** function ](recommended_extensions/packing.md#packUnorm4x4-function)  
        *  [**unpackF2x11\_1x10** function ](recommended_extensions/packing.md#unpackF2x11_1x10-function)  
        *  [**unpackF3x9\_E1x5** function ](recommended_extensions/packing.md#unpackF3x9_E1x5-function)  
        *  [**unpackHalf** function ](recommended_extensions/packing.md#unpackHalf-function)  
        *  [**unpackHalf1x16** function ](recommended_extensions/packing.md#unpackHalf1x16-function)  
        *  [**unpackHalf4x16** function ](recommended_extensions/packing.md#unpackHalf4x16-function)  
        *  [**unpackI3x10\_1x2** function ](recommended_extensions/packing.md#unpackI3x10_1x2-function)  
        *  [**unpackInt2x16** function ](recommended_extensions/packing.md#unpackInt2x16-function)  
        *  [**unpackInt2x32** function ](recommended_extensions/packing.md#unpackInt2x32-function)  
        *  [**unpackInt2x8** function ](recommended_extensions/packing.md#unpackInt2x8-function)  
        *  [**unpackInt4x16** function ](recommended_extensions/packing.md#unpackInt4x16-function)  
        *  [**unpackInt4x8** function ](recommended_extensions/packing.md#unpackInt4x8-function)  
        *  [**unpackRGBM** function ](recommended_extensions/packing.md#unpackRGBM-function)  
        *  [**unpackSnorm** function ](recommended_extensions/packing.md#unpackSnorm-function)  
        *  [**unpackSnorm1x16** function ](recommended_extensions/packing.md#unpackSnorm1x16-function)  
        *  [**unpackSnorm1x8** function ](recommended_extensions/packing.md#unpackSnorm1x8-function)  
        *  [**unpackSnorm2x8** function ](recommended_extensions/packing.md#unpackSnorm2x8-function)  
        *  [**unpackSnorm3x10\_1x2** function ](recommended_extensions/packing.md#unpackSnorm3x10_1x2-function)  
        *  [**unpackSnorm4x16** function ](recommended_extensions/packing.md#unpackSnorm4x16-function)  
        *  [**unpackU3x10\_1x2** function ](recommended_extensions/packing.md#unpackU3x10_1x2-function)  
        *  [**unpackUint2x16** function ](recommended_extensions/packing.md#unpackUint2x16-function)  
        *  [**unpackUint2x32** function ](recommended_extensions/packing.md#unpackUint2x32-function)  
        *  [**unpackUint2x8** function ](recommended_extensions/packing.md#unpackUint2x8-function)  
        *  [**unpackUint4x16** function ](recommended_extensions/packing.md#unpackUint4x16-function)  
        *  [**unpackUint4x8** function ](recommended_extensions/packing.md#unpackUint4x8-function)  
        *  [**unpackUnorm** function ](recommended_extensions/packing.md#unpackUnorm-function)  
        *  [**unpackUnorm1x16** function ](recommended_extensions/packing.md#unpackUnorm1x16-function)  
        *  [**unpackUnorm1x5\_1x6\_1x5** function ](recommended_extensions/packing.md#unpackUnorm1x5_1x6_1x5-function)  
        *  [**unpackUnorm1x8** function ](recommended_extensions/packing.md#unpackUnorm1x8-function)  
        *  [**unpackUnorm2x3\_1x2** function ](recommended_extensions/packing.md#unpackUnorm2x3_1x2-function)  
        *  [**unpackUnorm2x4** function ](recommended_extensions/packing.md#unpackUnorm2x4-function)  
        *  [**unpackUnorm2x8** function ](recommended_extensions/packing.md#unpackUnorm2x8-function)  
        *  [**unpackUnorm3x10\_1x2** function ](recommended_extensions/packing.md#unpackUnorm3x10_1x2-function)  
        *  [**unpackUnorm3x5\_1x1** function ](recommended_extensions/packing.md#unpackUnorm3x5_1x1-function)  
        *  [**unpackUnorm4x16** function ](recommended_extensions/packing.md#unpackUnorm4x16-function)  
        *  [**unpackUnorm4x4** function ](recommended_extensions/packing.md#unpackUnorm4x4-function)  
    *  [quaternion methods](recommended_extensions/quaternion.md)  
        *  [**eulerAngles** function ](recommended_extensions/quaternion.md#eulerAngles-function)  
        *  [**mat3\_cast** function ](recommended_extensions/quaternion.md#mat3_cast-function)  
        *  [**mat4\_cast** function ](recommended_extensions/quaternion.md#mat4_cast-function)  
        *  [**pitch** function ](recommended_extensions/quaternion.md#pitch-function)  
        *  [**quatLookAt** function ](recommended_extensions/quaternion.md#quatLookAt-function)  
        *  [**quatLookAtLH** function ](recommended_extensions/quaternion.md#quatLookAtLH-function)  
        *  [**quatLookAtRH** function ](recommended_extensions/quaternion.md#quatLookAtRH-function)  
        *  [**quat\_cast** function ](recommended_extensions/quaternion.md#quat_cast-function)  
        *  [**roll** function ](recommended_extensions/quaternion.md#roll-function)  
        *  [**yaw** function ](recommended_extensions/quaternion.md#yaw-function)  
    *  [random methods](recommended_extensions/random.md)  
        *  [**ballRand** function ](recommended_extensions/random.md#ballRand-function)  
        *  [**circularRand** function ](recommended_extensions/random.md#circularRand-function)  
        *  [**diskRand** function ](recommended_extensions/random.md#diskRand-function)  
        *  [**gaussRand** function ](recommended_extensions/random.md#gaussRand-function)  
        *  [**linearRand** function ](recommended_extensions/random.md#linearRand-function)  
        *  [**setSeed** function ](recommended_extensions/random.md#setSeed-function)  
        *  [**sphericalRand** function ](recommended_extensions/random.md#sphericalRand-function)  
    *  [reciprocal methods](recommended_extensions/reciprocal.md)  
        *  [**acot** function ](recommended_extensions/reciprocal.md#acot-function)  
        *  [**acoth** function ](recommended_extensions/reciprocal.md#acoth-function)  
        *  [**acsc** function ](recommended_extensions/reciprocal.md#acsc-function)  
        *  [**acsch** function ](recommended_extensions/reciprocal.md#acsch-function)  
        *  [**asec** function ](recommended_extensions/reciprocal.md#asec-function)  
        *  [**asech** function ](recommended_extensions/reciprocal.md#asech-function)  
        *  [**cot** function ](recommended_extensions/reciprocal.md#cot-function)  
        *  [**coth** function ](recommended_extensions/reciprocal.md#coth-function)  
        *  [**csc** function ](recommended_extensions/reciprocal.md#csc-function)  
        *  [**csch** function ](recommended_extensions/reciprocal.md#csch-function)  
        *  [**sec** function ](recommended_extensions/reciprocal.md#sec-function)  
        *  [**sech** function ](recommended_extensions/reciprocal.md#sech-function)  
    *  [round methods](recommended_extensions/round.md)  
        *  [**ceilMultiple** function ](recommended_extensions/round.md#ceilMultiple-function)  
        *  [**ceilPowerOfTwo** function ](recommended_extensions/round.md#ceilPowerOfTwo-function)  
        *  [**floorMultiple** function ](recommended_extensions/round.md#floorMultiple-function)  
        *  [**floorPowerOfTwo** function ](recommended_extensions/round.md#floorPowerOfTwo-function)  
        *  [**roundMultiple** function ](recommended_extensions/round.md#roundMultiple-function)  
        *  [**roundPowerOfTwo** function ](recommended_extensions/round.md#roundPowerOfTwo-function)  
    *  [type\_ptr methods](recommended_extensions/type_ptr.md)  
        *  [**make\_mat2** function ](recommended_extensions/type_ptr.md#make_mat2-function)  
        *  [**make\_mat2x2** function ](recommended_extensions/type_ptr.md#make_mat2x2-function)  
        *  [**make\_mat2x3** function ](recommended_extensions/type_ptr.md#make_mat2x3-function)  
        *  [**make\_mat2x4** function ](recommended_extensions/type_ptr.md#make_mat2x4-function)  
        *  [**make\_mat3** function ](recommended_extensions/type_ptr.md#make_mat3-function)  
        *  [**make\_mat3x2** function ](recommended_extensions/type_ptr.md#make_mat3x2-function)  
        *  [**make\_mat3x3** function ](recommended_extensions/type_ptr.md#make_mat3x3-function)  
        *  [**make\_mat3x4** function ](recommended_extensions/type_ptr.md#make_mat3x4-function)  
        *  [**make\_mat4** function ](recommended_extensions/type_ptr.md#make_mat4-function)  
        *  [**make\_mat4x2** function ](recommended_extensions/type_ptr.md#make_mat4x2-function)  
        *  [**make\_mat4x3** function ](recommended_extensions/type_ptr.md#make_mat4x3-function)  
        *  [**make\_mat4x4** function ](recommended_extensions/type_ptr.md#make_mat4x4-function)  
        *  [**make\_quat** function ](recommended_extensions/type_ptr.md#make_quat-function)  
        *  [**make\_vec2** function ](recommended_extensions/type_ptr.md#make_vec2-function)  
        *  [**make\_vec3** function ](recommended_extensions/type_ptr.md#make_vec3-function)  
        *  [**make\_vec4** function ](recommended_extensions/type_ptr.md#make_vec4-function)  
        *  [**sizeof** function ](recommended_extensions/type_ptr.md#sizeof-function)  
        *  [**value\_ptr** function ](recommended_extensions/type_ptr.md#value_ptr-function)  
    *  [ulp methods](recommended_extensions/ulp.md)  
        *  [**float\_distance** function ](recommended_extensions/ulp.md#float_distance-function)  
        *  [**next\_float** function ](recommended_extensions/ulp.md#next_float-function)  
        *  [**prev\_float** function ](recommended_extensions/ulp.md#prev_float-function)  
*  [stable\_extensions](stable_extensions/README.md)  
    *  [matrix\_clip\_space methods](stable_extensions/matrix_clip_space.md)  
        *  [**frustum** function ](stable_extensions/matrix_clip_space.md#frustum-function)  
        *  [**frustumLH** function ](stable_extensions/matrix_clip_space.md#frustumLH-function)  
        *  [**frustumLH\_NO** function ](stable_extensions/matrix_clip_space.md#frustumLH_NO-function)  
        *  [**frustumLH\_ZO** function ](stable_extensions/matrix_clip_space.md#frustumLH_ZO-function)  
        *  [**frustumNO** function ](stable_extensions/matrix_clip_space.md#frustumNO-function)  
        *  [**frustumRH** function ](stable_extensions/matrix_clip_space.md#frustumRH-function)  
        *  [**frustumRH\_NO** function ](stable_extensions/matrix_clip_space.md#frustumRH_NO-function)  
        *  [**frustumRH\_ZO** function ](stable_extensions/matrix_clip_space.md#frustumRH_ZO-function)  
        *  [**frustumZO** function ](stable_extensions/matrix_clip_space.md#frustumZO-function)  
        *  [**infinitePerspective** function ](stable_extensions/matrix_clip_space.md#infinitePerspective-function)  
        *  [**infinitePerspectiveLH** function ](stable_extensions/matrix_clip_space.md#infinitePerspectiveLH-function)  
        *  [**infinitePerspectiveRH** function ](stable_extensions/matrix_clip_space.md#infinitePerspectiveRH-function)  
        *  [**ortho** function ](stable_extensions/matrix_clip_space.md#ortho-function)  
        *  [**orthoLH** function ](stable_extensions/matrix_clip_space.md#orthoLH-function)  
        *  [**orthoLH\_NO** function ](stable_extensions/matrix_clip_space.md#orthoLH_NO-function)  
        *  [**orthoLH\_ZO** function ](stable_extensions/matrix_clip_space.md#orthoLH_ZO-function)  
        *  [**orthoNO** function ](stable_extensions/matrix_clip_space.md#orthoNO-function)  
        *  [**orthoRH** function ](stable_extensions/matrix_clip_space.md#orthoRH-function)  
        *  [**orthoRH\_NO** function ](stable_extensions/matrix_clip_space.md#orthoRH_NO-function)  
        *  [**orthoRH\_ZO** function ](stable_extensions/matrix_clip_space.md#orthoRH_ZO-function)  
        *  [**orthoZO** function ](stable_extensions/matrix_clip_space.md#orthoZO-function)  
        *  [**perspective** function ](stable_extensions/matrix_clip_space.md#perspective-function)  
        *  [**perspectiveFov** function ](stable_extensions/matrix_clip_space.md#perspectiveFov-function)  
        *  [**perspectiveFovLH** function ](stable_extensions/matrix_clip_space.md#perspectiveFovLH-function)  
        *  [**perspectiveFovLH\_NO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovLH_NO-function)  
        *  [**perspectiveFovLH\_ZO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovLH_ZO-function)  
        *  [**perspectiveFovNO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovNO-function)  
        *  [**perspectiveFovRH** function ](stable_extensions/matrix_clip_space.md#perspectiveFovRH-function)  
        *  [**perspectiveFovRH\_NO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovRH_NO-function)  
        *  [**perspectiveFovRH\_ZO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovRH_ZO-function)  
        *  [**perspectiveFovZO** function ](stable_extensions/matrix_clip_space.md#perspectiveFovZO-function)  
        *  [**perspectiveLH** function ](stable_extensions/matrix_clip_space.md#perspectiveLH-function)  
        *  [**perspectiveLH\_NO** function ](stable_extensions/matrix_clip_space.md#perspectiveLH_NO-function)  
        *  [**perspectiveLH\_ZO** function ](stable_extensions/matrix_clip_space.md#perspectiveLH_ZO-function)  
        *  [**perspectiveNO** function ](stable_extensions/matrix_clip_space.md#perspectiveNO-function)  
        *  [**perspectiveRH** function ](stable_extensions/matrix_clip_space.md#perspectiveRH-function)  
        *  [**perspectiveRH\_NO** function ](stable_extensions/matrix_clip_space.md#perspectiveRH_NO-function)  
        *  [**perspectiveRH\_ZO** function ](stable_extensions/matrix_clip_space.md#perspectiveRH_ZO-function)  
        *  [**perspectiveZO** function ](stable_extensions/matrix_clip_space.md#perspectiveZO-function)  
        *  [**tweakedInfinitePerspective** function ](stable_extensions/matrix_clip_space.md#tweakedInfinitePerspective-function)  
    *  [matrix\_projection methods](stable_extensions/matrix_projection.md)  
        *  [**pickMatrix** function ](stable_extensions/matrix_projection.md#pickMatrix-function)  
        *  [**project** function ](stable_extensions/matrix_projection.md#project-function)  
        *  [**projectNO** function ](stable_extensions/matrix_projection.md#projectNO-function)  
        *  [**projectZO** function ](stable_extensions/matrix_projection.md#projectZO-function)  
        *  [**unProject** function ](stable_extensions/matrix_projection.md#unProject-function)  
        *  [**unProjectNO** function ](stable_extensions/matrix_projection.md#unProjectNO-function)  
        *  [**unProjectZO** function ](stable_extensions/matrix_projection.md#unProjectZO-function)  
    *  [matrix\_transform methods](stable_extensions/matrix_transform.md)  
        *  [**identity** function ](stable_extensions/matrix_transform.md#identity-function)  
        *  [**lookAt** function ](stable_extensions/matrix_transform.md#lookAt-function)  
        *  [**lookAtLH** function ](stable_extensions/matrix_transform.md#lookAtLH-function)  
        *  [**lookAtRH** function ](stable_extensions/matrix_transform.md#lookAtRH-function)  
        *  [**rotate** function ](stable_extensions/matrix_transform.md#rotate-function)  
        *  [**rotate\_slow** function ](stable_extensions/matrix_transform.md#rotate_slow-function)  
        *  [**scale** function ](stable_extensions/matrix_transform.md#scale-function)  
        *  [**scale\_slow** function ](stable_extensions/matrix_transform.md#scale_slow-function)  
        *  [**translate** function ](stable_extensions/matrix_transform.md#translate-function)  
    *  [quaternion\_common methods](stable_extensions/quaternion_common.md)  
        *  [**conjugate** function ](stable_extensions/quaternion_common.md#conjugate-function)  
        *  [**lerp** function ](stable_extensions/quaternion_common.md#lerp-function)  
        *  [**slerp** function ](stable_extensions/quaternion_common.md#slerp-function)  
    *  [quaternion\_trigonometric methods](stable_extensions/quaternion_trigonometric.md)  
        *  [**angle** function ](stable_extensions/quaternion_trigonometric.md#angle-function)  
        *  [**angleAxis** function ](stable_extensions/quaternion_trigonometric.md#angleAxis-function)  
        *  [**axis** function ](stable_extensions/quaternion_trigonometric.md#axis-function)  
    *  [compatibility methods](stable_extensions/compatibility.md)  
        *  [**atan2** function ](stable_extensions/compatibility.md#atan2-function)  
        *  [**isfinite** function ](stable_extensions/compatibility.md#isfinite-function)  
        *  [**lerp** function ](stable_extensions/compatibility.md#lerp-function)  
        *  [**saturate** function ](stable_extensions/compatibility.md#saturate-function)  
*  [unstable\_extensions](unstable_extensions/README.md)  
    *  [decompose methods](unstable_extensions/decompose.md)  
        *  [**decompose** function ](unstable_extensions/decompose.md#decompose-function)  
    *  [norm methods](unstable_extensions/norm.md)  
        *  [**distance2** function ](unstable_extensions/norm.md#distance2-function)  
        *  [**l1Norm** function ](unstable_extensions/norm.md#l1Norm-function)  
        *  [**l2Norm** function ](unstable_extensions/norm.md#l2Norm-function)  
        *  [**lMaxNorm** function ](unstable_extensions/norm.md#lMaxNorm-function)  
        *  [**length2** function ](unstable_extensions/norm.md#length2-function)  
        *  [**lxNorm** function ](unstable_extensions/norm.md#lxNorm-function)  
    *  [polar\_coordinates methods](unstable_extensions/polar_coordinates.md)  
        *  [**euclidean** function ](unstable_extensions/polar_coordinates.md#euclidean-function)  
        *  [**polar** function ](unstable_extensions/polar_coordinates.md#polar-function)  
    *  [matrix\_transform\_2d methods](unstable_extensions/matrix_transform_2d.md)  
        *  [**rotate** function ](unstable_extensions/matrix_transform_2d.md#rotate-function)  
        *  [**scale** function ](unstable_extensions/matrix_transform_2d.md#scale-function)  
        *  [**shearX** function ](unstable_extensions/matrix_transform_2d.md#shearX-function)  
        *  [**shearY** function ](unstable_extensions/matrix_transform_2d.md#shearY-function)  
        *  [**translate** function ](unstable_extensions/matrix_transform_2d.md#translate-function)  
    *  [rotate\_vector methods](unstable_extensions/rotate_vector.md)  
        *  [**orientation** function ](unstable_extensions/rotate_vector.md#orientation-function)  
        *  [**rotate** function ](unstable_extensions/rotate_vector.md#rotate-function)  
        *  [**rotateX** function ](unstable_extensions/rotate_vector.md#rotateX-function)  
        *  [**rotateY** function ](unstable_extensions/rotate_vector.md#rotateY-function)  
        *  [**rotateZ** function ](unstable_extensions/rotate_vector.md#rotateZ-function)  
        *  [**slerp** function ](unstable_extensions/rotate_vector.md#slerp-function)  
*  [other](other/README.md)  
    *  [other methods](other/other.md)  
        *  [**add** function ](other/other.md#add-function)  
        *  [**and\_** function ](other/other.md#and_-function)  
        *  [**cmp** function ](other/other.md#cmp-function)  
        *  [**div** function ](other/other.md#div-function)  
        *  [**floordiv** function ](other/other.md#floordiv-function)  
        *  [**if\_else** function ](other/other.md#if_else-function)  
        *  [**inv** function ](other/other.md#inv-function)  
        *  [**lshift** function ](other/other.md#lshift-function)  
        *  [**mul** function ](other/other.md#mul-function)  
        *  [**neg** function ](other/other.md#neg-function)  
        *  [**or\_** function ](other/other.md#or_-function)  
        *  [**pos** function ](other/other.md#pos-function)  
        *  [**rshift** function ](other/other.md#rshift-function)  
        *  [**silence** function ](other/other.md#silence-function)  
        *  [**sub** function ](other/other.md#sub-function)  
        *  [**xor** function ](other/other.md#xor-function)  
  
