import { SplitLayout } from './splitlayout';
import { Title } from './title';
import { Widget } from './widget';
/**
 * A layout which arranges its widgets into collapsible resizable sections.
 */
export declare class AccordionLayout extends SplitLayout {
    /**
     * Construct a new accordion layout.
     *
     * @param options - The options for initializing the layout.
     *
     * #### Notes
     * The default orientation will be vertical.
     *
     * Titles must be rotated for horizontal accordion panel using CSS: see accordionpanel.css
     */
    constructor(options: AccordionLayout.IOptions);
    /**
     * The section title height or width depending on the orientation.
     */
    titleSpace: number;
    /**
     * A read-only array of the section titles in the panel.
     */
    readonly titles: ReadonlyArray<HTMLElement>;
    /**
     * Dispose of the resources held by the layout.
     */
    dispose(): void;
    /**
     * The renderer used by the accordion layout.
     */
    readonly renderer: AccordionLayout.IRenderer;
    updateTitle(index: number, widget: Widget): void;
    /**
     * Attach a widget to the parent's DOM node.
     *
     * @param index - The current index of the widget in the layout.
     *
     * @param widget - The widget to attach to the parent.
     */
    protected attachWidget(index: number, widget: Widget): void;
    /**
     * Move a widget in the parent's DOM node.
     *
     * @param fromIndex - The previous index of the widget in the layout.
     *
     * @param toIndex - The current index of the widget in the layout.
     *
     * @param widget - The widget to move in the parent.
     */
    protected moveWidget(fromIndex: number, toIndex: number, widget: Widget): void;
    /**
     * Detach a widget from the parent's DOM node.
     *
     * @param index - The previous index of the widget in the layout.
     *
     * @param widget - The widget to detach from the parent.
     *
     * #### Notes
     * This is a reimplementation of the superclass method.
     */
    protected detachWidget(index: number, widget: Widget): void;
    /**
     * Update the item position.
     *
     * @param i Item index
     * @param isHorizontal Whether the layout is horizontal or not
     * @param left Left position in pixels
     * @param top Top position in pixels
     * @param height Item height
     * @param width Item width
     * @param size Item size
     */
    protected updateItemPosition(i: number, isHorizontal: boolean, left: number, top: number, height: number, width: number, size: number): void;
    private _titles;
}
export declare namespace AccordionLayout {
    /**
     * A type alias for a accordion layout orientation.
     */
    type Orientation = SplitLayout.Orientation;
    /**
     * A type alias for a accordion layout alignment.
     */
    type Alignment = SplitLayout.Alignment;
    /**
     * An options object for initializing a accordion layout.
     */
    interface IOptions extends SplitLayout.IOptions {
        /**
         * The renderer to use for the accordion layout.
         */
        renderer: IRenderer;
        /**
         * The section title height or width depending on the orientation.
         *
         * The default is `22`.
         */
        titleSpace?: number;
    }
    /**
     * A renderer for use with an accordion layout.
     */
    interface IRenderer extends SplitLayout.IRenderer {
        /**
         * Common class name for all accordion titles.
         */
        readonly titleClassName: string;
        /**
         * Render the element for a section title.
         *
         * @param data - The data to use for rendering the section title.
         *
         * @returns A element representing the section title.
         */
        createSectionTitle(title: Title<Widget>): HTMLElement;
    }
}
//# sourceMappingURL=accordionlayout.d.ts.map