# Окремі схеми OpenAPI для введення та виведення, чи ні { #separate-openapi-schemas-for-input-and-output-or-not }

Відколи вийшов **Pydantic v2**, згенерований OpenAPI став трохи точнішим і більш коректним, ніж раніше. 😎

Насправді подекуди буде навіть **дві схеми JSON** в OpenAPI для тієї самої моделі Pydantic: для введення та для виведення - залежно від наявності значень за замовчуванням.

Розгляньмо, як це працює, і як це змінити за потреби.

## Моделі Pydantic для введення та виведення { #pydantic-models-for-input-and-output }

Припустімо, у вас є модель Pydantic зі значеннями за замовчуванням, наприклад:

{* ../../docs_src/separate_openapi_schemas/tutorial001_py310.py ln[1:7] hl[7] *}

### Модель для введення { #model-for-input }

Якщо ви використовуєте цю модель як введення, як тут:

{* ../../docs_src/separate_openapi_schemas/tutorial001_py310.py ln[1:15] hl[14] *}

…тоді поле `description` не буде обов'язковим, адже воно має значення за замовчуванням `None`.

### Модель для введення в документації { #input-model-in-docs }

У документації ви побачите, що поле `description` не має **червоної зірочки** - воно не позначене як обов'язкове:

<div class="screenshot">
<img src="/img/tutorial/separate-openapi-schemas/image01.png">
</div>

### Модель для виведення { #model-for-output }

Але якщо ви використовуєте цю саму модель для виведення, як тут:

{* ../../docs_src/separate_openapi_schemas/tutorial001_py310.py hl[19] *}

…тоді, оскільки `description` має значення за замовчуванням, якщо ви нічого не повернете для цього поля, воно все одно матиме це **значення за замовчуванням**.

### Модель для даних відповіді при виведенні { #model-for-output-response-data }

Якщо ви скористаєтеся документацією та перевірите відповідь, навіть попри те, що код нічого не додав в одне з полів `description`, JSON-відповідь містить значення за замовчуванням (`null`):

<div class="screenshot">
<img src="/img/tutorial/separate-openapi-schemas/image02.png">
</div>

Це означає, що воно **завжди матиме значення** - просто іноді це значення може бути `None` (або `null` у JSON).

Отже, клієнтам, які використовують ваш API, не потрібно перевіряти, чи існує значення - вони можуть **припустити, що поле завжди буде присутнє**, але в окремих випадках воно матиме значення за замовчуванням `None`.

У OpenAPI це описується тим, що поле позначається як **обов'язкове**, адже воно завжди присутнє.

Тому Схема JSON для моделі може відрізнятися залежно від того, чи використовується вона для **введення або виведення**:
- для **введення** `description` не буде обов'язковим
- для **виведення** воно буде **обов'язковим** (і можливо `None`, або в термінах JSON - `null`)

### Модель для виведення в документації { #model-for-output-in-docs }

У документації ви також можете перевірити модель для виведення: **і** `name`, і `description` позначені як **обов'язкові** червоною зірочкою:

<div class="screenshot">
<img src="/img/tutorial/separate-openapi-schemas/image03.png">
</div>

### Модель для введення та виведення в документації { #model-for-input-and-output-in-docs }

Якщо відкрити всі наявні Схеми (схеми JSON) в OpenAPI, то ви побачите дві: `Item-Input` і `Item-Output`.

Для `Item-Input` поле `description` **не є обов'язковим** - червоної зірочки немає.

А для `Item-Output` `description` **є обов'язковим** - є червона зірочка.

<div class="screenshot">
<img src="/img/tutorial/separate-openapi-schemas/image04.png">
</div>

Завдяки цій можливості у **Pydantic v2** ваша документація API стає більш **точною**, а якщо у вас є згенеровані клієнти та SDK, вони також будуть точнішими - з кращим **досвідом розробника** та узгодженістю. 🎉

## Не розділяти схеми { #do-not-separate-schemas }

Втім іноді може знадобитися мати **одну й ту саму схему для введення та виведення**.

Основний випадок - коли у вас вже є згенерований клієнтський код/SDK, і ви поки не бажаєте оновлювати весь такий згенерований код/SDK. Ймовірно, ви зробите це пізніше, але не зараз.

У такому разі ви можете вимкнути цю можливість у **FastAPI** параметром `separate_input_output_schemas=False`.

/// info | Інформація

Підтримку `separate_input_output_schemas` додано у FastAPI `0.102.0`. 🤓

///

{* ../../docs_src/separate_openapi_schemas/tutorial002_py310.py hl[10] *}

### Одна схема для моделей введення та виведення в документації { #same-schema-for-input-and-output-models-in-docs }

Тепер для цієї моделі буде лише одна спільна схема для введення та виведення - тільки `Item`, і в ній `description` буде **не обов'язковим**:

<div class="screenshot">
<img src="/img/tutorial/separate-openapi-schemas/image05.png">
</div>
