# Query параметри { #query-parameters }

Коли ви оголошуєте інші параметри функції, які не є частиною параметрів шляху, вони автоматично інтерпретуються як параметри «query».

{* ../../docs_src/query_params/tutorial001_py39.py hl[9] *}

Query — це набір пар ключ-значення, що йдуть після символу `?` в URL, розділені символами `&`.

Наприклад, в URL:

```
http://127.0.0.1:8000/items/?skip=0&limit=10
```

...параметрами query є:

* `skip`: зі значенням `0`
* `limit`: зі значенням `10`

Оскільки вони є частиною URL, вони «природно» є рядками.

Але коли ви оголошуєте їх із типами Python (у наведеному прикладі як `int`), вони перетворюються на цей тип і проходять перевірку відповідності.

Увесь той самий процес, який застосовується до параметрів шляху, також застосовується до параметрів query:

* Підтримка в редакторі (очевидно)
* <abbr title="converting the string that comes from an HTTP request into Python data – перетворення рядка, що надходить з HTTP-запиту, у дані Python">«parsing»</abbr> даних
* Валідація даних
* Автоматична документація

## Значення за замовчуванням { #defaults }

Оскільки параметри query не є фіксованою частиною шляху, вони можуть бути необов’язковими та мати значення за замовчуванням.

У наведеному вище прикладі вони мають значення за замовчуванням: `skip=0` і `limit=10`.

Отже, перехід за URL:

```
http://127.0.0.1:8000/items/
```

буде таким самим, як і перехід за посиланням:

```
http://127.0.0.1:8000/items/?skip=0&limit=10
```

Але якщо ви перейдете, наприклад, за посиланням:

```
http://127.0.0.1:8000/items/?skip=20
```

Значення параметрів у вашій функції будуть такими:

* `skip=20`: оскільки ви вказали його в URL
* `limit=10`: оскільки це значення за замовчуванням

## Необов'язкові параметри { #optional-parameters }

Так само ви можете оголосити необов’язкові параметри query, встановивши для них значення за замовчуванням `None`:

{* ../../docs_src/query_params/tutorial002_py310.py hl[7] *}

У цьому випадку параметр функції `q` буде необов’язковим і за замовчуванням матиме значення `None`.

/// check | Примітка

Також зверніть увагу, що **FastAPI** достатньо розумний, щоб визначити, що параметр шляху `item_id` є параметром шляху, а `q` — ні, отже, це параметр query.

///

## Перетворення типу параметра query { #query-parameter-type-conversion }

Ви також можете оголошувати параметри типу `bool`, і вони будуть автоматично конвертовані:

{* ../../docs_src/query_params/tutorial003_py310.py hl[7] *}

У цьому випадку, якщо ви перейдете за:

```
http://127.0.0.1:8000/items/foo?short=1
```

або

```
http://127.0.0.1:8000/items/foo?short=True
```

або

```
http://127.0.0.1:8000/items/foo?short=true
```

або

```
http://127.0.0.1:8000/items/foo?short=on
```

або

```
http://127.0.0.1:8000/items/foo?short=yes
```

або будь-який інший варіант написання (великі літери, перша літера велика тощо), ваша функція побачить параметр `short` зі значенням `True` типу `bool`. В іншому випадку — `False`.


## Кілька path і query параметрів { #multiple-path-and-query-parameters }

Ви можете одночасно оголошувати кілька параметрів шляху та параметрів query, **FastAPI** знає, який з них який.

І вам не потрібно оголошувати їх у якомусь конкретному порядку.

Вони визначаються за назвою:

{* ../../docs_src/query_params/tutorial004_py310.py hl[6,8] *}

## Обов’язкові параметри query { #required-query-parameters }

Коли ви оголошуєте значення за замовчуванням для не-path-параметрів (поки що ми бачили лише параметри query), тоді вони не є обов’язковими.

Якщо ви не хочете задавати конкретне значення, а просто зробити параметр необов’язковим, задайте `None` як значення за замовчуванням.

Але якщо ви хочете зробити параметр query обов’язковим, просто не вказуйте для нього значення за замовчуванням:

{* ../../docs_src/query_params/tutorial005_py39.py hl[6:7] *}

Тут параметр query `needy` — обов’язковий параметр query типу `str`.

Якщо ви відкриєте у браузері URL-адресу:

```
http://127.0.0.1:8000/items/foo-item
```

...без додавання обов’язкового параметра `needy`, ви побачите помилку на кшталт:

```JSON
{
  "detail": [
    {
      "type": "missing",
      "loc": [
        "query",
        "needy"
      ],
      "msg": "Field required",
      "input": null
    }
  ]
}
```

Оскільки `needy` є обов’язковим параметром, вам потрібно вказати його в URL:

```
http://127.0.0.1:8000/items/foo-item?needy=sooooneedy
```

...це спрацює:

```JSON
{
    "item_id": "foo-item",
    "needy": "sooooneedy"
}
```

І звісно, ви можете визначити деякі параметри як обов’язкові, деякі — зі значенням за замовчуванням, а деякі — повністю необов’язкові:

{* ../../docs_src/query_params/tutorial006_py310.py hl[8] *}

У цьому випадку є 3 параметри query:

* `needy`, обов’язковий `str`.
* `skip`, `int` зі значенням за замовчуванням `0`.
* `limit`, необов’язковий `int`.

/// tip | Порада

Ви також можете використовувати `Enum` так само, як і з [Path Parameters](path-params.md#predefined-values){.internal-link target=_blank}.

///
