# FastAPI'ye Yardım Et - Yardım Al { #help-fastapi-get-help }

**FastAPI**'yi seviyor musunuz?

FastAPI'ye, diğer kullanıcılara ve yazara yardım etmek ister misiniz?

Yoksa **FastAPI** ile ilgili yardım mı almak istiyorsunuz?

Yardım etmenin çok basit yolları var (bazıları sadece bir-iki tıklama gerektirir).

Yardım almanın da birkaç yolu var.

## Bültene abone olun { #subscribe-to-the-newsletter }

Şunlardan haberdar olmak için (seyrek yayımlanan) [**FastAPI and friends** bültenine](newsletter.md){.internal-link target=_blank} abone olabilirsiniz:

* FastAPI ve friends ile ilgili haberler 🚀
* Rehberler 📝
* Özellikler ✨
* Geriye dönük uyumsuz değişiklikler 🚨
* İpuçları ve püf noktaları ✅

## X (Twitter) üzerinden FastAPI'yi takip edin { #follow-fastapi-on-x-twitter }

**FastAPI** ile ilgili en güncel haberleri almak için <a href="https://x.com/fastapi" class="external-link" target="_blank">@fastapi hesabını **X (Twitter)** üzerinde takip edin</a>. 🐦

## GitHub'da **FastAPI**'ye yıldız verin { #star-fastapi-in-github }

GitHub'da FastAPI'ye "star" verebilirsiniz (sağ üstteki yıldız butonuna tıklayarak): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Yıldız verince, diğer kullanıcılar projeyi daha kolay bulabilir ve başkaları için de faydalı olduğunu görebilir.

## GitHub repository'sini release'ler için izleyin { #watch-the-github-repository-for-releases }

GitHub'da FastAPI'yi "watch" edebilirsiniz (sağ üstteki "watch" butonuna tıklayarak): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Orada "Releases only" seçebilirsiniz.

Böylece **FastAPI**'nin bug fix'ler ve yeni özelliklerle gelen her yeni release'inde (yeni versiyonunda) email ile bildirim alırsınız.

## Yazarla bağlantı kurun { #connect-with-the-author }

Yazar olan <a href="https://tiangolo.com" class="external-link" target="_blank">benimle (Sebastián Ramírez / `tiangolo`)</a> bağlantı kurabilirsiniz.

Şunları yapabilirsiniz:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Beni **GitHub**'da takip edin</a>.
    * Size yardımcı olabilecek oluşturduğum diğer Open Source projelere göz atın.
    * Yeni bir Open Source proje oluşturduğumda haberdar olmak için beni takip edin.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Beni **X (Twitter)** üzerinde</a> veya <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>'da takip edin.
    * FastAPI'yi nasıl kullandığınızı anlatın (bunu duymayı seviyorum).
    * Duyuru yaptığımda veya yeni araçlar yayınladığımda haberdar olun.
    * Ayrıca (ayrı bir hesap olan) <a href="https://x.com/fastapi" class="external-link" target="_blank">X (Twitter) üzerinde @fastapi hesabını da takip edebilirsiniz</a>.
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Beni **LinkedIn**'de takip edin</a>.
    * Duyuru yaptığımda veya yeni araçlar yayınladığımda haberdar olun (gerçi X (Twitter)'ı daha sık kullanıyorum 🤷‍♂).
* <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> veya <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a> üzerinde yazdıklarımı okuyun (ya da beni takip edin).
    * Diğer fikirleri, yazıları ve oluşturduğum araçlarla ilgili içerikleri okuyun.
    * Yeni bir şey yayınladığımda görmek için beni takip edin.

## **FastAPI** hakkında tweet atın { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">**FastAPI** hakkında tweet atın</a> ve neden sevdiğinizi bana ve diğerlerine söyleyin. 🎉

**FastAPI**'nin nasıl kullanıldığını, nelerini sevdiğinizi, hangi projede/şirkette kullandığınızı vb. duymayı seviyorum.

## FastAPI için oy verin { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Slant'ta **FastAPI** için oy verin</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">AlternativeTo'da **FastAPI** için oy verin</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">StackShare'de **FastAPI** kullandığınızı belirtin</a>.

## GitHub'da sorularla başkalarına yardım edin { #help-others-with-questions-in-github }

Şuralarda insanların sorularına yardımcı olmayı deneyebilirsiniz:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

Birçok durumda bu soruların cevabını zaten biliyor olabilirsiniz. 🤓

Eğer insanların sorularına çok yardım ederseniz, resmi bir [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank} olabilirsiniz. 🎉

Şunu unutmayın: en önemli nokta, nazik olmaya çalışmak. İnsanlar çoğu zaman biriken stresle geliyor ve birçok durumda soruyu en iyi şekilde sormuyor; yine de elinizden geldiğince nazik olmaya çalışın. 🤗

Amaç, **FastAPI** topluluğunun nazik ve kapsayıcı olması. Aynı zamanda başkalarına zorbalık ya da saygısız davranışları da kabul etmeyin. Birbirimizi kollamalıyız.

---

Sorularda (discussions veya issues içinde) başkalarına yardım etmek için şunları yapabilirsiniz:

### Soruyu anlayın { #understand-the-question }

* Soru soran kişinin **amacının** ve kullanım senaryosunun ne olduğunu anlayabiliyor musunuz, kontrol edin.

* Sonra sorunun (büyük çoğunluğu soru olur) **net** olup olmadığına bakın.

* Birçok durumda kullanıcı kafasında hayali bir çözüm kurup onu sorar; ancak **daha iyi** bir çözüm olabilir. Problemi ve kullanım senaryosunu daha iyi anladıysanız daha iyi bir **alternatif çözüm** önerebilirsiniz.

* Soruyu anlayamıyorsanız daha fazla **detay** isteyin.

### Problemi yeniden üretin { #reproduce-the-problem }

Çoğu durumda ve çoğu soruda, kişinin **orijinal kodu** ile ilgili bir şey vardır.

Birçok kişi sadece kodun bir parçasını kopyalar, ama bu **problemi yeniden üretmek** için yeterli olmaz.

* Çalıştırıp aynı hatayı/davranışı görebileceğiniz veya kullanım senaryosunu daha iyi anlayabileceğiniz, yerelde **kopyala-yapıştır** yaparak çalıştırılabilen bir <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">minimal, reproducible, example</a> paylaşmalarını isteyebilirsiniz.

* Çok cömert hissediyorsanız, problemi anlatan açıklamadan yola çıkarak kendiniz de böyle bir **örnek oluşturmayı** deneyebilirsiniz. Ancak bunun çok zaman alabileceğini unutmayın; çoğu zaman önce problemi netleştirmelerini istemek daha iyidir.

### Çözüm önerin { #suggest-solutions }

* Soruyu anlayabildikten sonra olası bir **cevap** verebilirsiniz.

* Çoğu durumda, yapmak istediklerinden ziyade alttaki **asıl problemi veya kullanım senaryosunu** anlamak daha iyidir; çünkü denedikleri yöntemden daha iyi bir çözüm yolu olabilir.

### Kapatılmasını isteyin { #ask-to-close }

Eğer yanıt verirlerse, büyük ihtimalle problemi çözmüşsünüzdür, tebrikler, **kahramansınız**! 🦸

* Eğer çözüm işe yaradıysa şunları yapmalarını isteyebilirsiniz:

    * GitHub Discussions'ta: ilgili yorumu **answer** olarak işaretlemeleri.
    * GitHub Issues'ta: issue'yu **close** etmeleri.

## GitHub repository'sini izleyin { #watch-the-github-repository }

GitHub'da FastAPI'yi "watch" edebilirsiniz (sağ üstteki "watch" butonuna tıklayarak): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

"Releases only" yerine "Watching" seçerseniz biri yeni bir issue veya soru oluşturduğunda bildirim alırsınız. Ayrıca sadece yeni issue'lar, ya da discussions, ya da PR'lar vb. için bildirim almak istediğinizi belirtebilirsiniz.

Sonra da bu soruları çözmelerine yardımcı olmayı deneyebilirsiniz.

## Soru Sorun { #ask-questions }

GitHub repository'sinde örneğin şunlar için <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">yeni bir soru oluşturabilirsiniz</a>:

* Bir **soru** sorun veya bir **problem** hakkında danışın.
* Yeni bir **feature** önerin.

**Not**: Bunu yaparsanız, ben de sizden başkalarına yardım etmenizi isteyeceğim. 😉

## Pull Request'leri İnceleyin { #review-pull-requests }

Başkalarının gönderdiği pull request'leri incelememde bana yardımcı olabilirsiniz.

Yine, lütfen elinizden geldiğince nazik olmaya çalışın. 🤗

---

Bir pull request'i incelerken akılda tutmanız gerekenler:

### Problemi anlayın { #understand-the-problem }

* Önce, pull request'in çözmeye çalıştığı **problemi anladığınızdan** emin olun. GitHub Discussion veya issue içinde daha uzun bir tartışması olabilir.

* Pull request'in aslında hiç gerekmiyor olma ihtimali de yüksektir; çünkü problem **farklı bir şekilde** çözülebilir. Bu durumda bunu önerebilir veya bununla ilgili soru sorabilirsiniz.

### Style konusunda çok dert etmeyin { #dont-worry-about-style }

* Commit message tarzı gibi şeyleri çok dert etmeyin; ben commit'leri manuel olarak düzenleyerek squash and merge yapacağım.

* Style kuralları için de endişelenmeyin; bunları kontrol eden otomatik araçlar zaten var.

Ek bir style veya tutarlılık ihtiyacı olursa, bunu doğrudan isterim ya da gerekli değişikliklerle üstüne commit eklerim.

### Kodu kontrol edin { #check-the-code }

* Kodu okuyup kontrol edin; mantıklı mı bakın, **yerelde çalıştırın** ve gerçekten problemi çözüyor mu görün.

* Ardından bunu yaptığınızı belirten bir **yorum** yazın; böylece gerçekten kontrol ettiğinizi anlarım.

/// info | Bilgi

Ne yazık ki sadece birkaç onayı olan PR'lara körü körüne güvenemem.

Defalarca, 3, 5 veya daha fazla onayı olan PR'lar oldu; muhtemelen açıklaması çekici olduğu için onay aldılar. Ama PR'lara baktığımda aslında bozuk olduklarını, bug içerdiğini veya iddia ettikleri problemi çözmediklerini gördüm. 😅

Bu yüzden kodu gerçekten okuyup çalıştırmanız ve bunu yorumlarda bana bildirmeniz çok önemli. 🤓

///

* PR bir şekilde basitleştirilebiliyorsa bunu isteyebilirsiniz. Ancak çok didik didik etmeye gerek yok; konuya göre birçok öznel bakış açısı olabilir (benim de olacaktır 🙈). Bu yüzden temel noktalara odaklanmak daha iyi.

### Testler { #tests }

* PR'da **testler** olduğunu kontrol etmemde bana yardımcı olun.

* PR'dan önce testlerin **fail** ettiğini kontrol edin. 🚨

* PR'dan sonra testlerin **pass** ettiğini kontrol edin. ✅

* Birçok PR test içermez; test eklemelerini **hatırlatabilirsiniz** veya hatta kendiniz bazı testler **önerebilirsiniz**. Bu, en çok zaman alan işlerden biridir ve burada çok yardımcı olabilirsiniz.

* Ayrıca neleri denediğinizi yorumlara yazın; böylece kontrol ettiğinizi anlarım. 🤓

## Pull Request Oluşturun { #create-a-pull-request }

Örneğin şunlar için Pull Request'lerle kaynak koda [katkıda bulunabilirsiniz](contributing.md){.internal-link target=_blank}:

* Dokümantasyonda bulduğunuz bir yazım hatasını düzeltmek.
* FastAPI hakkında oluşturduğunuz veya bulduğunuz bir makaleyi, videoyu ya da podcast'i <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">bu dosyayı düzenleyerek</a> paylaşmak.
    * Link'inizi ilgili bölümün başına eklediğinizden emin olun.
* Dokümantasyonu kendi dilinize [çevirmeye yardımcı olmak](contributing.md#translations){.internal-link target=_blank}.
    * Başkalarının yaptığı çevirileri gözden geçirmeye de yardımcı olabilirsiniz.
* Yeni dokümantasyon bölümleri önermek.
* Mevcut bir issue/bug'ı düzeltmek.
    * Test eklediğinizden emin olun.
* Yeni bir feature eklemek.
    * Test eklediğinizden emin olun.
    * İlgiliyse dokümantasyon da eklediğinizden emin olun.

## FastAPI'nin Bakımına Yardım Edin { #help-maintain-fastapi }

**FastAPI**'nin bakımını yapmama yardımcı olun! 🤓

Yapılacak çok iş var ve bunların çoğunu **SİZ** yapabilirsiniz.

Şu anda yapabileceğiniz ana işler:

* [GitHub'da sorularla başkalarına yardım edin](#help-others-with-questions-in-github){.internal-link target=_blank} (yukarıdaki bölüme bakın).
* [Pull Request'leri inceleyin](#review-pull-requests){.internal-link target=_blank} (yukarıdaki bölüme bakın).

Bu iki iş, **en çok zamanı alan** işlerdir. FastAPI bakımının ana yükü buradadır.

Burada yardımcı olursanız, **FastAPI'nin bakımını yapmama yardım etmiş** ve daha **hızlı ve daha iyi ilerlemesini** sağlamış olursunuz. 🚀

## Sohbete katılın { #join-the-chat }

FastAPI topluluğundan diğer kişilerle takılmak için 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord chat server</a> 👥 sohbetine katılın.

/// tip | İpucu

Sorular için <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>'a sorun; [FastAPI Experts](fastapi-people.md#fastapi-experts){.internal-link target=_blank} tarafından yardım alma ihtimaliniz çok daha yüksektir.

Chat'i sadece genel sohbetler için kullanın.

///

### Sorular için chat'i kullanmayın { #dont-use-the-chat-for-questions }

Chat sistemleri daha "serbest sohbet"e izin verdiği için, çok genel ve yanıtlaması daha zor sorular sormak kolaylaşır; bu nedenle cevap alamayabilirsiniz.

GitHub'da ise şablon (template) doğru soruyu yazmanız için sizi yönlendirir; böylece daha kolay iyi bir cevap alabilir, hatta bazen sormadan önce problemi kendiniz çözebilirsiniz. Ayrıca GitHub'da (zaman alsa bile) her şeye mutlaka cevap verdiğimden emin olabilirim. Chat sistemlerinde bunu kişisel olarak yapamam. 😅

Chat sistemlerindeki konuşmalar GitHub kadar kolay aranabilir değildir; bu yüzden soru ve cevaplar sohbet içinde kaybolabilir. Ayrıca [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank} olmak için sadece GitHub'daki katkılar sayılır; dolayısıyla büyük olasılıkla GitHub'da daha fazla ilgi görürsünüz.

Öte yandan chat sistemlerinde binlerce kullanıcı vardır; bu yüzden neredeyse her zaman konuşacak birini bulma ihtimaliniz yüksektir. 😄

## Yazara sponsor olun { #sponsor-the-author }

Eğer **ürününüz/şirketiniz** **FastAPI**'ye bağlıysa veya onunla ilişkiliyse ve FastAPI kullanıcılarına ulaşmak istiyorsanız, <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a> üzerinden yazara (bana) sponsor olabilirsiniz. Tier'a göre dokümantasyonda bir rozet gibi ek faydalar elde edebilirsiniz. 🎁

---

Teşekkürler! 🚀
