### Target language

Translate to Portuguese (Português).

Language code: pt.

For instructions or titles in imperative, keep them in imperative, for example "Import FastAPI" to "Importe o FastAPI".

Keep existing translations as they are if the term is already translated.

When translating documentation into Portuguese, use neutral and widely understandable language. Although Portuguese originated in Portugal and has its largest number of speakers in Brazil, it is also an official language in several countries and regions, such as Equatorial Guinea, Mozambique, Angola, Cape Verde, and São Tomé and Príncipe. Avoid words or expressions that are specific to a single country or region.

Only keep parentheses if they exist in the source text. Do not add parentheses to terms that do not have them.

### Avoiding Repetition in Translation

When translating sentences, avoid unnecessary repetition of words or phrases that are implied in context.
- Merge repeated words naturally while keeping the meaning.
- Do **not** introduce extra words to replace repeated phrases unnecessarily.
- Keep translations fluent and concise, but maintain the original meaning.

**Example:**

Source:
Let's see how that works and how to change it if you need to do that.

Avoid translating literally as:
Vamos ver como isso funciona e como alterar isso se você precisar fazer isso.

Better translation:
Vamos ver como isso funciona e como alterar se você precisar.

---

For the next terms, use the following translations:

* /// check: /// check | Verifique
* /// danger: /// danger | Cuidado
* /// info: /// info | Informação
* /// note | Technical Details: /// note | Detalhes Técnicos
* /// info | Very Technical Details: /// note | Detalhes Técnicos Avançados
* /// note: /// note | Nota
* /// tip: /// tip | Dica
* /// warning: /// warning | Atenção
* you should: você deveria
* async context manager: gerenciador de contexto assíncrono
* autocomplete: autocompletar
* autocompletion: preenchimento automático
* auto-completion: preenchimento automático
* bug: bug
* context manager: gerenciador de contexto
* cross domain: cross domain (do not translate to "domínio cruzado")
* cross origin: cross origin (do not translate to "origem cruzada")
* Cross-Origin Resource Sharing: Cross-Origin Resource Sharing (do not translate to "Compartilhamento de Recursos de Origem Cruzada")
* Deep Learning: Deep Learning (do not translate to "Aprendizado Profundo")
* dependable: dependable
* dependencies: dependências
* deprecated: descontinuado
* docs: documentação
* FastAPI app: aplicação FastAPI
* framework: framework (do not translate)
* feature: funcionalidade
* guides: tutoriais
* I/O (as in "input and output"): I/O (do not translate to "E/S")
* JSON Schema: JSON Schema
* library: biblioteca
* lifespan: lifespan (do not translate to "vida útil")
* list (as in Python list): list
* Machine Learning: Aprendizado de Máquina
* media type: media type (do not translate to "tipo de mídia")
* non-Annotated: non-Annotated (do not translate non-Annotated when it comes after a Python version.e.g., “Python 3.10+ non-Annotated”)
* operation IDs: IDs de operação
* path (as in URL path): path
* path operation: operação de rota
* path operation function: função de operação de rota
* prefix: prefixo
* request (as in HTTP request): request (do not change if it's already translated to requisição)
* router (as in FastAPI's router): router (do not change if it's already translated to "roteador" or "roteadores")
* response (as in HTTP response): response (do not change if it's already translated to resposta)
* shutdown (of the app): encerramento
* shutdown event (of the app): evento de encerramento
* startup (as in the event of the app): inicialização
* startup event (as in the event of the app): evento de inicialização
* Stream: Stream
* string: string
* type hints: anotações de tipo
* wildcards: curingas
