# Конфигурация операций пути { #path-operation-configuration }

Существует несколько параметров, которые вы можете передать вашему *декоратору операций пути* для его настройки.

/// warning | Внимание

Помните, что эти параметры передаются непосредственно *декоратору операций пути*, а не вашей *функции-обработчику операций пути*.

///

## Статус-код ответа { #response-status-code }

Вы можете определить (HTTP) `status_code`, который будет использован в ответах вашей *операции пути*.

Вы можете передать только `int`-значение кода, например `404`.

Но если вы не помните, для чего нужен каждый числовой код, вы можете использовать сокращенные константы в параметре `status`:

{* ../../docs_src/path_operation_configuration/tutorial001_py310.py hl[1,15] *}

Этот статус-код будет использован в ответе и будет добавлен в схему OpenAPI.

/// note | Технические детали

Вы также можете использовать `from starlette import status`.

**FastAPI** предоставляет тот же `starlette.status` под псевдонимом `fastapi.status` для удобства разработчика. Но его источник - это непосредственно Starlette.

///

## Теги { #tags }

Вы можете добавлять теги к вашим *операциям пути*, добавив параметр `tags` с `list` заполненным `str`-значениями (обычно в нём только одна строка):

{* ../../docs_src/path_operation_configuration/tutorial002_py310.py hl[15,20,25] *}

Они будут добавлены в схему OpenAPI и будут использованы в автоматической документации интерфейса:

<img src="/img/tutorial/path-operation-configuration/image01.png">

### Теги с перечислениями { #tags-with-enums }

Если у вас большое приложение, вы можете прийти к необходимости добавить **несколько тегов**, и возможно, вы захотите убедиться в том, что всегда используете **один и тот же тег** для связанных *операций пути*.

В этих случаях, имеет смысл хранить теги в классе `Enum`.

**FastAPI** поддерживает это так же, как и в случае с обычными строками:

{* ../../docs_src/path_operation_configuration/tutorial002b.py hl[1,8:10,13,18] *}

## Краткое и развёрнутое содержание { #summary-and-description }

Вы можете добавить параметры `summary` и `description`:

{* ../../docs_src/path_operation_configuration/tutorial003_py310.py hl[18:19] *}

## Описание из строк документации { #description-from-docstring }

Так как описания обычно длинные и содержат много строк, вы можете объявить описание *операции пути* в функции <abbr title="многострочный текст, первое выражение внутри функции (не присвоенный какой-либо переменной), используемый для документации">строки документации</abbr> и **FastAPI** прочитает её отсюда.

Вы можете использовать <a href="https://en.wikipedia.org/wiki/Markdown" class="external-link" target="_blank">Markdown</a> в строке документации, и он будет интерпретирован и отображён корректно (с учетом отступа в строке документации).

{* ../../docs_src/path_operation_configuration/tutorial004_py310.py hl[17:25] *}

Он будет использован в интерактивной документации:

<img src="/img/tutorial/path-operation-configuration/image02.png">

## Описание ответа { #response-description }

Вы можете указать описание ответа с помощью параметра `response_description`:

{* ../../docs_src/path_operation_configuration/tutorial005_py310.py hl[19] *}

/// info | Дополнительная информация

Помните, что `response_description` относится конкретно к ответу, а `description` относится к *операции пути* в целом.

///

/// check

OpenAPI указывает, что каждой *операции пути* необходимо описание ответа.

Если вдруг вы не укажете его, то **FastAPI** автоматически сгенерирует это описание с текстом "Successful response".

///

<img src="/img/tutorial/path-operation-configuration/image03.png">

## Обозначение *операции пути* как устаревшей { #deprecate-a-path-operation }

Если вам необходимо пометить *операцию пути* как <abbr title="устаревшее, не рекомендовано к использованию">устаревшую</abbr>, при этом не удаляя её, передайте параметр `deprecated`:

{* ../../docs_src/path_operation_configuration/tutorial006.py hl[16] *}

Он будет четко помечен как устаревший в интерактивной документации:

<img src="/img/tutorial/path-operation-configuration/image04.png">

Проверьте, как будут выглядеть устаревшие и не устаревшие *операции пути*:

<img src="/img/tutorial/path-operation-configuration/image05.png">

## Резюме { #recap }

Вы можете легко конфигурировать и добавлять метаданные в ваши *операции пути*, передавая параметры *декораторам операций пути*.
