// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_H_
#define V8_ROOTS_STATIC_ROOTS_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/roots/roots.h"

// Disabling Wasm or Intl invalidates the contents of static-roots.h.
// TODO(olivf): To support static roots for multiple build configurations we
//              will need to generate target specific versions of this file.
static_assert(V8_ENABLE_WEBASSEMBLY);
static_assert(V8_INTL_SUPPORT);

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kUndefinedValue = 0x69;
  static constexpr Tagged_t kNullValue = 0x85;
  static constexpr Tagged_t kempty_string = 0xa1;
  static constexpr Tagged_t kFalseValue = 0xad;
  static constexpr Tagged_t kTrueValue = 0xc9;
  static constexpr Tagged_t kSeqTwoByteStringMap = 0xe5;
  static constexpr Tagged_t kSeqOneByteStringMap = 0x10d;
  static constexpr Tagged_t kSharedSeqTwoByteStringMap = 0x135;
  static constexpr Tagged_t kSharedSeqOneByteStringMap = 0x15d;
  static constexpr Tagged_t kInternalizedTwoByteStringMap = 0x185;
  static constexpr Tagged_t kInternalizedOneByteStringMap = 0x1ad;
  static constexpr Tagged_t kExternalInternalizedTwoByteStringMap = 0x1d5;
  static constexpr Tagged_t kExternalInternalizedOneByteStringMap = 0x1fd;
  static constexpr Tagged_t kUncachedExternalInternalizedTwoByteStringMap =
      0x225;
  static constexpr Tagged_t kUncachedExternalInternalizedOneByteStringMap =
      0x24d;
  static constexpr Tagged_t kUncachedExternalTwoByteStringMap = 0x275;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x29d;
  static constexpr Tagged_t kSharedUncachedExternalTwoByteStringMap = 0x2c5;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x2ed;
  static constexpr Tagged_t kExternalTwoByteStringMap = 0x315;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x33d;
  static constexpr Tagged_t kSharedExternalTwoByteStringMap = 0x365;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x38d;
  static constexpr Tagged_t kConsTwoByteStringMap = 0x3b5;
  static constexpr Tagged_t kConsOneByteStringMap = 0x3dd;
  static constexpr Tagged_t kSlicedTwoByteStringMap = 0x405;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x42d;
  static constexpr Tagged_t kThinTwoByteStringMap = 0x455;
  static constexpr Tagged_t kThinOneByteStringMap = 0x47d;
  static constexpr Tagged_t kSymbolMap = 0x4a5;
  static constexpr Tagged_t kMetaMap = 0x4cd;
  static constexpr Tagged_t kUndefinedMap = 0x4f5;
  static constexpr Tagged_t kNullMap = 0x51d;
  static constexpr Tagged_t kBooleanMap = 0x545;
  static constexpr Tagged_t kHeapNumberMap = 0x56d;
  static constexpr Tagged_t kBigIntMap = 0x595;
  static constexpr Tagged_t kFixedArrayMap = 0x5bd;
  static constexpr Tagged_t kTrustedFixedArrayMap = 0x5e5;
  static constexpr Tagged_t kProtectedFixedArrayMap = 0x60d;
  static constexpr Tagged_t kWeakFixedArrayMap = 0x635;
  static constexpr Tagged_t kTrustedWeakFixedArrayMap = 0x65d;
  static constexpr Tagged_t kWeakArrayListMap = 0x685;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x6ad;
  static constexpr Tagged_t kDescriptorArrayMap = 0x6d5;
  static constexpr Tagged_t kHoleMap = 0x6fd;
  static constexpr Tagged_t kCallSiteInfoMap = 0x725;
  static constexpr Tagged_t kEnumCacheMap = 0x74d;
  static constexpr Tagged_t kEmptyFixedArray = 0x775;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x77d;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x785;
  static constexpr Tagged_t kTheHoleValue = 0x791;
  static constexpr Tagged_t kEmptyEnumCache = 0x79d;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x7a9;
  static constexpr Tagged_t kScopeInfoMap = 0x7b9;
  static constexpr Tagged_t kModuleInfoMap = 0x7e1;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x809;
  static constexpr Tagged_t kFeedbackVectorMap = 0x831;
  static constexpr Tagged_t kForeignMap = 0x859;
  static constexpr Tagged_t kTrustedForeignMap = 0x881;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x8a9;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x8d1;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x8f9;
  static constexpr Tagged_t kByteArrayMap = 0x921;
  static constexpr Tagged_t kTrustedByteArrayMap = 0x949;
  static constexpr Tagged_t kBytecodeArrayMap = 0x971;
  static constexpr Tagged_t kFreeSpaceMap = 0x999;
  static constexpr Tagged_t kPropertyArrayMap = 0x9c1;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0x9e9;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0xa11;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0xa39;
  static constexpr Tagged_t kInstructionStreamMap = 0xa61;
  static constexpr Tagged_t kCellMap = 0xa89;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xab1;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xab9;
  static constexpr Tagged_t kOnePointerFillerMap = 0xae1;
  static constexpr Tagged_t kTwoPointerFillerMap = 0xb09;
  static constexpr Tagged_t kNoClosuresCellMap = 0xb31;
  static constexpr Tagged_t kOneClosureCellMap = 0xb59;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb81;
  static constexpr Tagged_t kTransitionArrayMap = 0xba9;
  static constexpr Tagged_t kHashTableMap = 0xbd1;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xbf9;
  static constexpr Tagged_t kNameDictionaryMap = 0xc21;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xc49;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xc71;
  static constexpr Tagged_t kNumberDictionaryMap = 0xc99;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xcc1;
  static constexpr Tagged_t kArrayListMap = 0xce9;
  static constexpr Tagged_t kAccessorInfoMap = 0xd11;
  static constexpr Tagged_t kPreparseDataMap = 0xd39;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xd61;
  static constexpr Tagged_t kCodeMap = 0xd89;
  static constexpr Tagged_t kHashSeed = 0xdb1;
  static constexpr Tagged_t klength_string = 0xdc1;
  static constexpr Tagged_t kprototype_string = 0xdd5;
  static constexpr Tagged_t kname_string = 0xded;
  static constexpr Tagged_t kenumerable_string = 0xdfd;
  static constexpr Tagged_t kconfigurable_string = 0xe15;
  static constexpr Tagged_t kvalue_string = 0xe2d;
  static constexpr Tagged_t kwritable_string = 0xe41;
  static constexpr Tagged_t knot_mapped_symbol = 0xe55;
  static constexpr Tagged_t kuninitialized_symbol = 0xe65;
  static constexpr Tagged_t kmegamorphic_symbol = 0xe75;
  static constexpr Tagged_t kelements_transition_symbol = 0xe85;
  static constexpr Tagged_t kmega_dom_symbol = 0xe95;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xea5;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xed1;
  static constexpr Tagged_t kEmptyByteArray = 0xee9;
  static constexpr Tagged_t kEmptyScopeInfo = 0xef1;
  static constexpr Tagged_t kEmptyPropertyArray = 0xf09;
  static constexpr Tagged_t kMinusZeroValue = 0xf11;
  static constexpr Tagged_t kNanValue = 0xf1d;
  static constexpr Tagged_t kHoleNanValue = 0xf29;
  static constexpr Tagged_t kInfinityValue = 0xf35;
  static constexpr Tagged_t kMinusInfinityValue = 0xf41;
  static constexpr Tagged_t kMaxSafeInteger = 0xf4d;
  static constexpr Tagged_t kMaxUInt32 = 0xf59;
  static constexpr Tagged_t kSmiMinValue = 0xf65;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xf71;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xf7d;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0xfa5;
  static constexpr Tagged_t kCallableTaskMap = 0xfcd;
  static constexpr Tagged_t kCallbackTaskMap = 0xff5;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0x101d;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x1045;
  static constexpr Tagged_t kAccessorPairMap = 0x106d;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x1095;
  static constexpr Tagged_t kAllocationMementoMap = 0x10bd;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x10e5;
  static constexpr Tagged_t kAsmWasmDataMap = 0x110d;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x1135;
  static constexpr Tagged_t kBreakPointMap = 0x115d;
  static constexpr Tagged_t kBreakPointInfoMap = 0x1185;
  static constexpr Tagged_t kBytecodeWrapperMap = 0x11ad;
  static constexpr Tagged_t kClassBoilerplateMap = 0x11d5;
  static constexpr Tagged_t kClassPositionsMap = 0x11fd;
  static constexpr Tagged_t kCodeWrapperMap = 0x1225;
  static constexpr Tagged_t kDebugInfoMap = 0x124d;
  static constexpr Tagged_t kErrorStackDataMap = 0x1275;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x129d;
  static constexpr Tagged_t kInterceptorInfoMap = 0x12c5;
  static constexpr Tagged_t kModuleRequestMap = 0x12ed;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x1315;
  static constexpr Tagged_t kPromiseReactionMap = 0x133d;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x1365;
  static constexpr Tagged_t kPrototypeInfoMap = 0x138d;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x13b5;
  static constexpr Tagged_t kRegExpDataWrapperMap = 0x13dd;
  static constexpr Tagged_t kScriptMap = 0x1405;
  static constexpr Tagged_t kScriptOrModuleMap = 0x142d;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x1455;
  static constexpr Tagged_t kStackFrameInfoMap = 0x147d;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x14a5;
  static constexpr Tagged_t kTuple2Map = 0x14cd;
  static constexpr Tagged_t kWasmExceptionTagMap = 0x14f5;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x151d;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x1545;
  static constexpr Tagged_t kLoadHandler1Map = 0x156d;
  static constexpr Tagged_t kLoadHandler2Map = 0x1595;
  static constexpr Tagged_t kLoadHandler3Map = 0x15bd;
  static constexpr Tagged_t kStoreHandler0Map = 0x15e5;
  static constexpr Tagged_t kStoreHandler1Map = 0x160d;
  static constexpr Tagged_t kStoreHandler2Map = 0x1635;
  static constexpr Tagged_t kStoreHandler3Map = 0x165d;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x1685;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x16ad;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x16d5;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x16fd;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x1725;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x174d;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x1775;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x179d;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x17c5;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x17ed;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x1815;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x183d;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x1865;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x188d;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x18b5;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x18dd;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x1905;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x192d;
  static constexpr Tagged_t kInternalClassMap = 0x1955;
  static constexpr Tagged_t kSmiPairMap = 0x197d;
  static constexpr Tagged_t kSmiBoxMap = 0x19a5;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x19cd;
  static constexpr Tagged_t kExportedSubClassMap = 0x19f5;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x1a1d;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x1a45;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1a6d;
  static constexpr Tagged_t kSortStateMap = 0x1a95;
  static constexpr Tagged_t kWasmFastApiCallDataMap = 0x1abd;
  static constexpr Tagged_t kWasmStringViewIterMap = 0x1ae5;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x1b0d;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x1b35;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1b5d;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1b85;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1bad;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1bd5;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1bfd;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1c25;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1c4d;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1c75;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1c9d;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1cc5;
  static constexpr Tagged_t kScriptContextTableMap = 0x1ced;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1d15;
  static constexpr Tagged_t kCoverageInfoMap = 0x1d3d;
  static constexpr Tagged_t kRegExpMatchInfoMap = 0x1d65;
  static constexpr Tagged_t kRegExpDataMap = 0x1d8d;
  static constexpr Tagged_t kAtomRegExpDataMap = 0x1db5;
  static constexpr Tagged_t kIrRegExpDataMap = 0x1ddd;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1e05;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1e2d;
  static constexpr Tagged_t kGlobalConstTrackingLetCellMap = 0x1e55;
  static constexpr Tagged_t kWasmImportDataMap = 0x1e7d;
  static constexpr Tagged_t kWasmCapiFunctionDataMap = 0x1ea5;
  static constexpr Tagged_t kWasmExportedFunctionDataMap = 0x1ecd;
  static constexpr Tagged_t kWasmInternalFunctionMap = 0x1ef5;
  static constexpr Tagged_t kWasmFuncRefMap = 0x1f1d;
  static constexpr Tagged_t kWasmJSFunctionDataMap = 0x1f45;
  static constexpr Tagged_t kWasmResumeDataMap = 0x1f6d;
  static constexpr Tagged_t kWasmSuspenderObjectMap = 0x1f95;
  static constexpr Tagged_t kWasmTypeInfoMap = 0x1fbd;
  static constexpr Tagged_t kWasmContinuationObjectMap = 0x1fe5;
  static constexpr Tagged_t kWasmNullMap = 0x200d;
  static constexpr Tagged_t kWasmTrustedInstanceDataMap = 0x2035;
  static constexpr Tagged_t kWasmDispatchTableMap = 0x205d;
  static constexpr Tagged_t kWeakCellMap = 0x2085;
  static constexpr Tagged_t kExternalPointerArrayMap = 0x20ad;
  static constexpr Tagged_t kInterpreterDataMap = 0x20d5;
  static constexpr Tagged_t kSharedFunctionInfoWrapperMap = 0x20fd;
  static constexpr Tagged_t kDictionaryTemplateInfoMap = 0x2125;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x214d;
  static constexpr Tagged_t kEmptyArrayList = 0x2175;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x2181;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x2191;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x219d;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x21b1;
  static constexpr Tagged_t kSingleCharacterStringTable = 0x21d1;
  static constexpr Tagged_t kdot_string = 0x28b9;
  static constexpr Tagged_t kzero_string = 0x28d9;
  static constexpr Tagged_t kone_string = 0x28e9;
  static constexpr Tagged_t kadoptText_string = 0x35d9;
  static constexpr Tagged_t kapproximatelySign_string = 0x35f1;
  static constexpr Tagged_t kbaseName_string = 0x3611;
  static constexpr Tagged_t kaccounting_string = 0x3625;
  static constexpr Tagged_t kbreakType_string = 0x363d;
  static constexpr Tagged_t kcalendars_string = 0x3655;
  static constexpr Tagged_t kcardinal_string = 0x366d;
  static constexpr Tagged_t kcaseFirst_string = 0x3681;
  static constexpr Tagged_t kceil_string = 0x3699;
  static constexpr Tagged_t kcompare_string = 0x36a9;
  static constexpr Tagged_t kcollation_string = 0x36bd;
  static constexpr Tagged_t kcollations_string = 0x36d5;
  static constexpr Tagged_t kcompact_string = 0x36ed;
  static constexpr Tagged_t kcompactDisplay_string = 0x3701;
  static constexpr Tagged_t kcurrency_string = 0x371d;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x3731;
  static constexpr Tagged_t kcurrencySign_string = 0x374d;
  static constexpr Tagged_t kdateStyle_string = 0x3765;
  static constexpr Tagged_t kdateTimeField_string = 0x377d;
  static constexpr Tagged_t kdayPeriod_string = 0x3799;
  static constexpr Tagged_t kdaysDisplay_string = 0x37b1;
  static constexpr Tagged_t kdecimal_string = 0x37c9;
  static constexpr Tagged_t kdialect_string = 0x37dd;
  static constexpr Tagged_t kdigital_string = 0x37f1;
  static constexpr Tagged_t kdirection_string = 0x3805;
  static constexpr Tagged_t kendRange_string = 0x381d;
  static constexpr Tagged_t kengineering_string = 0x3831;
  static constexpr Tagged_t kexceptZero_string = 0x3849;
  static constexpr Tagged_t kexpand_string = 0x3861;
  static constexpr Tagged_t kexponentInteger_string = 0x3875;
  static constexpr Tagged_t kexponentMinusSign_string = 0x3891;
  static constexpr Tagged_t kexponentSeparator_string = 0x38b1;
  static constexpr Tagged_t kfallback_string = 0x38d1;
  static constexpr Tagged_t kfirst_string = 0x38e5;
  static constexpr Tagged_t kfirstDay_string = 0x38f9;
  static constexpr Tagged_t kfirstDayOfWeek_string = 0x390d;
  static constexpr Tagged_t kfloor_string = 0x3929;
  static constexpr Tagged_t kformat_string = 0x393d;
  static constexpr Tagged_t kfraction_string = 0x3951;
  static constexpr Tagged_t kfractionalDigits_string = 0x3965;
  static constexpr Tagged_t kfractionalSecond_string = 0x3981;
  static constexpr Tagged_t kfull_string = 0x399d;
  static constexpr Tagged_t kgranularity_string = 0x39ad;
  static constexpr Tagged_t kgrapheme_string = 0x39c5;
  static constexpr Tagged_t kgroup_string = 0x39d9;
  static constexpr Tagged_t kh11_string = 0x39ed;
  static constexpr Tagged_t kh12_string = 0x39fd;
  static constexpr Tagged_t kh23_string = 0x3a0d;
  static constexpr Tagged_t kh24_string = 0x3a1d;
  static constexpr Tagged_t khalfCeil_string = 0x3a2d;
  static constexpr Tagged_t khalfEven_string = 0x3a41;
  static constexpr Tagged_t khalfExpand_string = 0x3a55;
  static constexpr Tagged_t khalfFloor_string = 0x3a6d;
  static constexpr Tagged_t khalfTrunc_string = 0x3a85;
  static constexpr Tagged_t khour12_string = 0x3a9d;
  static constexpr Tagged_t khourCycle_string = 0x3ab1;
  static constexpr Tagged_t khourCycles_string = 0x3ac9;
  static constexpr Tagged_t khoursDisplay_string = 0x3ae1;
  static constexpr Tagged_t kideo_string = 0x3af9;
  static constexpr Tagged_t kignorePunctuation_string = 0x3b09;
  static constexpr Tagged_t kInvalid_Date_string = 0x3b29;
  static constexpr Tagged_t kinteger_string = 0x3b41;
  static constexpr Tagged_t kisWordLike_string = 0x3b55;
  static constexpr Tagged_t kkana_string = 0x3b6d;
  static constexpr Tagged_t klanguage_string = 0x3b7d;
  static constexpr Tagged_t klanguageDisplay_string = 0x3b91;
  static constexpr Tagged_t klessPrecision_string = 0x3bad;
  static constexpr Tagged_t kletter_string = 0x3bc9;
  static constexpr Tagged_t klist_string = 0x3bdd;
  static constexpr Tagged_t kliteral_string = 0x3bed;
  static constexpr Tagged_t klocale_string = 0x3c01;
  static constexpr Tagged_t kloose_string = 0x3c15;
  static constexpr Tagged_t klower_string = 0x3c29;
  static constexpr Tagged_t kltr_string = 0x3c3d;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x3c4d;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x3c71;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x3c95;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x3cb5;
  static constexpr Tagged_t kmin2_string = 0x3cd5;
  static constexpr Tagged_t kminimalDays_string = 0x3ce5;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x3cfd;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x3d21;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x3d41;
  static constexpr Tagged_t kminus_0 = 0x3d65;
  static constexpr Tagged_t kminusSign_string = 0x3d75;
  static constexpr Tagged_t kminutesDisplay_string = 0x3d8d;
  static constexpr Tagged_t kmonthsDisplay_string = 0x3da9;
  static constexpr Tagged_t kmorePrecision_string = 0x3dc5;
  static constexpr Tagged_t knan_string = 0x3de1;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x3df1;
  static constexpr Tagged_t knarrowSymbol_string = 0x3e11;
  static constexpr Tagged_t knegative_string = 0x3e29;
  static constexpr Tagged_t knever_string = 0x3e3d;
  static constexpr Tagged_t knone_string = 0x3e51;
  static constexpr Tagged_t knotation_string = 0x3e61;
  static constexpr Tagged_t knormal_string = 0x3e75;
  static constexpr Tagged_t knumberingSystem_string = 0x3e89;
  static constexpr Tagged_t knumberingSystems_string = 0x3ea5;
  static constexpr Tagged_t knumeric_string = 0x3ec1;
  static constexpr Tagged_t kordinal_string = 0x3ed5;
  static constexpr Tagged_t kpercentSign_string = 0x3ee9;
  static constexpr Tagged_t kplusSign_string = 0x3f01;
  static constexpr Tagged_t kquarter_string = 0x3f15;
  static constexpr Tagged_t kregion_string = 0x3f29;
  static constexpr Tagged_t krelatedYear_string = 0x3f3d;
  static constexpr Tagged_t kroundingMode_string = 0x3f55;
  static constexpr Tagged_t kroundingPriority_string = 0x3f6d;
  static constexpr Tagged_t krtl_string = 0x3f89;
  static constexpr Tagged_t kscientific_string = 0x3f99;
  static constexpr Tagged_t ksecondsDisplay_string = 0x3fb1;
  static constexpr Tagged_t ksegment_string = 0x3fcd;
  static constexpr Tagged_t kSegmentIterator_string = 0x3fe1;
  static constexpr Tagged_t kSegments_string = 0x3ffd;
  static constexpr Tagged_t ksensitivity_string = 0x4011;
  static constexpr Tagged_t ksep_string = 0x4029;
  static constexpr Tagged_t kshared_string = 0x4039;
  static constexpr Tagged_t ksignDisplay_string = 0x404d;
  static constexpr Tagged_t kstandard_string = 0x4065;
  static constexpr Tagged_t kstartRange_string = 0x4079;
  static constexpr Tagged_t kstrict_string = 0x4091;
  static constexpr Tagged_t kstripIfInteger_string = 0x40a5;
  static constexpr Tagged_t kstyle_string = 0x40c1;
  static constexpr Tagged_t kterm_string = 0x40d5;
  static constexpr Tagged_t ktextInfo_string = 0x40e5;
  static constexpr Tagged_t ktimeStyle_string = 0x40f9;
  static constexpr Tagged_t ktimeZones_string = 0x4111;
  static constexpr Tagged_t ktimeZoneName_string = 0x4129;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x4141;
  static constexpr Tagged_t ktrunc_string = 0x4161;
  static constexpr Tagged_t ktwo_digit_string = 0x4175;
  static constexpr Tagged_t ktype_string = 0x4189;
  static constexpr Tagged_t kunknown_string = 0x4199;
  static constexpr Tagged_t kupper_string = 0x41ad;
  static constexpr Tagged_t kusage_string = 0x41c1;
  static constexpr Tagged_t kuseGrouping_string = 0x41d5;
  static constexpr Tagged_t kunitDisplay_string = 0x41ed;
  static constexpr Tagged_t kweekday_string = 0x4205;
  static constexpr Tagged_t kweekend_string = 0x4219;
  static constexpr Tagged_t kweeksDisplay_string = 0x422d;
  static constexpr Tagged_t kweekInfo_string = 0x4245;
  static constexpr Tagged_t kyearName_string = 0x4259;
  static constexpr Tagged_t kyearsDisplay_string = 0x426d;
  static constexpr Tagged_t kadd_string = 0x4285;
  static constexpr Tagged_t kAggregateError_string = 0x4295;
  static constexpr Tagged_t kalways_string = 0x42b1;
  static constexpr Tagged_t kanonymous_string = 0x42c5;
  static constexpr Tagged_t kapply_string = 0x42dd;
  static constexpr Tagged_t kArguments_string = 0x42f1;
  static constexpr Tagged_t karguments_string = 0x4309;
  static constexpr Tagged_t karguments_to_string = 0x4321;
  static constexpr Tagged_t kArray_string = 0x4341;
  static constexpr Tagged_t karray_to_string = 0x4355;
  static constexpr Tagged_t kArrayBuffer_string = 0x4371;
  static constexpr Tagged_t kArrayIterator_string = 0x4389;
  static constexpr Tagged_t kas_string = 0x43a5;
  static constexpr Tagged_t kassert_string = 0x43b5;
  static constexpr Tagged_t kasync_string = 0x43c9;
  static constexpr Tagged_t kAtomicsCondition_string = 0x43dd;
  static constexpr Tagged_t kAtomicsMutex_string = 0x43fd;
  static constexpr Tagged_t kauto_string = 0x4419;
  static constexpr Tagged_t kBigInt_string = 0x4429;
  static constexpr Tagged_t kbigint_string = 0x443d;
  static constexpr Tagged_t kBigInt64Array_string = 0x4451;
  static constexpr Tagged_t kBigUint64Array_string = 0x446d;
  static constexpr Tagged_t kbind_string = 0x4489;
  static constexpr Tagged_t kblank_string = 0x4499;
  static constexpr Tagged_t kBoolean_string = 0x44ad;
  static constexpr Tagged_t kboolean_string = 0x44c1;
  static constexpr Tagged_t kboolean_to_string = 0x44d5;
  static constexpr Tagged_t kbound__string = 0x44f1;
  static constexpr Tagged_t kbuffer_string = 0x4505;
  static constexpr Tagged_t kbyte_length_string = 0x4519;
  static constexpr Tagged_t kbyte_offset_string = 0x4531;
  static constexpr Tagged_t kCompileError_string = 0x4549;
  static constexpr Tagged_t kcalendar_string = 0x4561;
  static constexpr Tagged_t kcallee_string = 0x4575;
  static constexpr Tagged_t kcaller_string = 0x4589;
  static constexpr Tagged_t kcause_string = 0x459d;
  static constexpr Tagged_t kcharacter_string = 0x45b1;
  static constexpr Tagged_t kcode_string = 0x45c9;
  static constexpr Tagged_t kcolumn_string = 0x45d9;
  static constexpr Tagged_t kcomputed_string = 0x45ed;
  static constexpr Tagged_t kconjunction_string = 0x4605;
  static constexpr Tagged_t kconsole_string = 0x461d;
  static constexpr Tagged_t kconstrain_string = 0x4631;
  static constexpr Tagged_t kconstruct_string = 0x4649;
  static constexpr Tagged_t kcurrent_string = 0x4661;
  static constexpr Tagged_t kDate_string = 0x4675;
  static constexpr Tagged_t kdate_to_string = 0x4685;
  static constexpr Tagged_t kdateAdd_string = 0x46a1;
  static constexpr Tagged_t kdateFromFields_string = 0x46b5;
  static constexpr Tagged_t kdateUntil_string = 0x46d1;
  static constexpr Tagged_t kday_string = 0x46e9;
  static constexpr Tagged_t kdayOfWeek_string = 0x46f9;
  static constexpr Tagged_t kdayOfYear_string = 0x4711;
  static constexpr Tagged_t kdays_string = 0x4729;
  static constexpr Tagged_t kdaysInMonth_string = 0x4739;
  static constexpr Tagged_t kdaysInWeek_string = 0x4751;
  static constexpr Tagged_t kdaysInYear_string = 0x4769;
  static constexpr Tagged_t kdefault_string = 0x4781;
  static constexpr Tagged_t kdefineProperty_string = 0x4795;
  static constexpr Tagged_t kdeleteProperty_string = 0x47b1;
  static constexpr Tagged_t kdetached_string = 0x47cd;
  static constexpr Tagged_t kdisjunction_string = 0x47e1;
  static constexpr Tagged_t kdone_string = 0x47f9;
  static constexpr Tagged_t kdot_brand_string = 0x4809;
  static constexpr Tagged_t kdot_catch_string = 0x481d;
  static constexpr Tagged_t kdot_default_string = 0x4831;
  static constexpr Tagged_t kdot_for_string = 0x4845;
  static constexpr Tagged_t kdot_generator_object_string = 0x4855;
  static constexpr Tagged_t kdot_home_object_string = 0x4875;
  static constexpr Tagged_t kdot_new_target_string = 0x488d;
  static constexpr Tagged_t knew_target_string = 0x488d;
  static constexpr Tagged_t kdot_result_string = 0x48a5;
  static constexpr Tagged_t kdot_repl_result_string = 0x48b9;
  static constexpr Tagged_t kdot_static_home_object_string = 0x48d1;
  static constexpr Tagged_t kdot_switch_tag_string = 0x48f1;
  static constexpr Tagged_t kdotAll_string = 0x4909;
  static constexpr Tagged_t kError_string = 0x491d;
  static constexpr Tagged_t kEvalError_string = 0x4931;
  static constexpr Tagged_t kelement_string = 0x4949;
  static constexpr Tagged_t kepochMicroseconds_string = 0x495d;
  static constexpr Tagged_t kepochMilliseconds_string = 0x497d;
  static constexpr Tagged_t kepochNanoseconds_string = 0x499d;
  static constexpr Tagged_t kepochSeconds_string = 0x49b9;
  static constexpr Tagged_t kera_string = 0x49d1;
  static constexpr Tagged_t keraYear_string = 0x49e1;
  static constexpr Tagged_t kerror_string = 0x49f5;
  static constexpr Tagged_t kerrors_string = 0x4a09;
  static constexpr Tagged_t kerror_to_string = 0x4a1d;
  static constexpr Tagged_t keval_string = 0x4a39;
  static constexpr Tagged_t kexception_string = 0x4a49;
  static constexpr Tagged_t kexec_string = 0x4a61;
  static constexpr Tagged_t kfalse_string = 0x4a71;
  static constexpr Tagged_t kfields_string = 0x4a85;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4a99;
  static constexpr Tagged_t kflags_string = 0x4ab9;
  static constexpr Tagged_t kFloat16Array_string = 0x4acd;
  static constexpr Tagged_t kFloat32Array_string = 0x4ae5;
  static constexpr Tagged_t kFloat64Array_string = 0x4afd;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x4b15;
  static constexpr Tagged_t kfrom_string = 0x4b39;
  static constexpr Tagged_t kFunction_string = 0x4b49;
  static constexpr Tagged_t kfunction_native_code_string = 0x4b5d;
  static constexpr Tagged_t kfunction_string = 0x4b89;
  static constexpr Tagged_t kfunction_to_string = 0x4b9d;
  static constexpr Tagged_t kGenerator_string = 0x4bbd;
  static constexpr Tagged_t kget_space_string = 0x4bd5;
  static constexpr Tagged_t kget_string = 0x4be5;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x4bf5;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x4c19;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x4c3d;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4c61;
  static constexpr Tagged_t kglobal_string = 0x4c7d;
  static constexpr Tagged_t kglobalThis_string = 0x4c91;
  static constexpr Tagged_t kgroups_string = 0x4ca9;
  static constexpr Tagged_t kgrowable_string = 0x4cbd;
  static constexpr Tagged_t khas_string = 0x4cd1;
  static constexpr Tagged_t khasIndices_string = 0x4ce1;
  static constexpr Tagged_t khour_string = 0x4cf9;
  static constexpr Tagged_t khours_string = 0x4d09;
  static constexpr Tagged_t khoursInDay_string = 0x4d1d;
  static constexpr Tagged_t kignoreCase_string = 0x4d35;
  static constexpr Tagged_t kid_string = 0x4d4d;
  static constexpr Tagged_t killegal_access_string = 0x4d5d;
  static constexpr Tagged_t killegal_argument_string = 0x4d79;
  static constexpr Tagged_t kinLeapYear_string = 0x4d95;
  static constexpr Tagged_t kindex_string = 0x4dad;
  static constexpr Tagged_t kindices_string = 0x4dc1;
  static constexpr Tagged_t kInfinity_string = 0x4dd5;
  static constexpr Tagged_t kinfinity_string = 0x4de9;
  static constexpr Tagged_t kinput_string = 0x4dfd;
  static constexpr Tagged_t kinstance_members_initializer_string = 0x4e11;
  static constexpr Tagged_t kInt16Array_string = 0x4e3d;
  static constexpr Tagged_t kInt32Array_string = 0x4e55;
  static constexpr Tagged_t kInt8Array_string = 0x4e6d;
  static constexpr Tagged_t kisExtensible_string = 0x4e85;
  static constexpr Tagged_t kiso8601_string = 0x4e9d;
  static constexpr Tagged_t kisoDay_string = 0x4eb1;
  static constexpr Tagged_t kisoHour_string = 0x4ec5;
  static constexpr Tagged_t kisoMicrosecond_string = 0x4ed9;
  static constexpr Tagged_t kisoMillisecond_string = 0x4ef5;
  static constexpr Tagged_t kisoMinute_string = 0x4f11;
  static constexpr Tagged_t kisoMonth_string = 0x4f29;
  static constexpr Tagged_t kisoNanosecond_string = 0x4f3d;
  static constexpr Tagged_t kisoSecond_string = 0x4f59;
  static constexpr Tagged_t kisoYear_string = 0x4f71;
  static constexpr Tagged_t kIterator_string = 0x4f85;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4f99;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4fb5;
  static constexpr Tagged_t kkeys_string = 0x4fd1;
  static constexpr Tagged_t klargestUnit_string = 0x4fe1;
  static constexpr Tagged_t klastIndex_string = 0x4ff9;
  static constexpr Tagged_t klet_string = 0x5011;
  static constexpr Tagged_t kline_string = 0x5021;
  static constexpr Tagged_t klinear_string = 0x5031;
  static constexpr Tagged_t kLinkError_string = 0x5045;
  static constexpr Tagged_t klong_string = 0x505d;
  static constexpr Tagged_t kMap_string = 0x506d;
  static constexpr Tagged_t kMapIterator_string = 0x507d;
  static constexpr Tagged_t kmax_byte_length_string = 0x5095;
  static constexpr Tagged_t kmedium_string = 0x50b1;
  static constexpr Tagged_t kmergeFields_string = 0x50c5;
  static constexpr Tagged_t kmessage_string = 0x50dd;
  static constexpr Tagged_t kmeta_string = 0x50f1;
  static constexpr Tagged_t kminus_Infinity_string = 0x5101;
  static constexpr Tagged_t kmicrosecond_string = 0x5119;
  static constexpr Tagged_t kmicroseconds_string = 0x5131;
  static constexpr Tagged_t kmillisecond_string = 0x5149;
  static constexpr Tagged_t kmilliseconds_string = 0x5161;
  static constexpr Tagged_t kminute_string = 0x5179;
  static constexpr Tagged_t kminutes_string = 0x518d;
  static constexpr Tagged_t kModule_string = 0x51a1;
  static constexpr Tagged_t kmonth_string = 0x51b5;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x51c9;
  static constexpr Tagged_t kmonths_string = 0x51e9;
  static constexpr Tagged_t kmonthsInYear_string = 0x51fd;
  static constexpr Tagged_t kmonthCode_string = 0x5215;
  static constexpr Tagged_t kmultiline_string = 0x522d;
  static constexpr Tagged_t kNaN_string = 0x5245;
  static constexpr Tagged_t knanosecond_string = 0x5255;
  static constexpr Tagged_t knanoseconds_string = 0x526d;
  static constexpr Tagged_t knarrow_string = 0x5285;
  static constexpr Tagged_t knative_string = 0x5299;
  static constexpr Tagged_t kNFC_string = 0x52ad;
  static constexpr Tagged_t kNFD_string = 0x52bd;
  static constexpr Tagged_t kNFKC_string = 0x52cd;
  static constexpr Tagged_t kNFKD_string = 0x52dd;
  static constexpr Tagged_t knot_equal_string = 0x52ed;
  static constexpr Tagged_t knull_string = 0x5305;
  static constexpr Tagged_t knull_to_string = 0x5315;
  static constexpr Tagged_t kNumber_string = 0x5331;
  static constexpr Tagged_t knumber_string = 0x5345;
  static constexpr Tagged_t knumber_to_string = 0x5359;
  static constexpr Tagged_t kObject_string = 0x5375;
  static constexpr Tagged_t kobject_string = 0x5389;
  static constexpr Tagged_t kobject_to_string = 0x539d;
  static constexpr Tagged_t kObject_prototype_string = 0x53b9;
  static constexpr Tagged_t koffset_string = 0x53d5;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x53e9;
  static constexpr Tagged_t kok_string = 0x5409;
  static constexpr Tagged_t kother_string = 0x5419;
  static constexpr Tagged_t koverflow_string = 0x542d;
  static constexpr Tagged_t kownKeys_string = 0x5441;
  static constexpr Tagged_t kpercent_string = 0x5455;
  static constexpr Tagged_t kplainDate_string = 0x5469;
  static constexpr Tagged_t kplainTime_string = 0x5481;
  static constexpr Tagged_t kposition_string = 0x5499;
  static constexpr Tagged_t kpreventExtensions_string = 0x54ad;
  static constexpr Tagged_t kprivate_constructor_string = 0x54cd;
  static constexpr Tagged_t kPromise_string = 0x54e5;
  static constexpr Tagged_t kpromise_string = 0x54f9;
  static constexpr Tagged_t kproto_string = 0x550d;
  static constexpr Tagged_t kproxy_string = 0x5525;
  static constexpr Tagged_t kProxy_string = 0x5539;
  static constexpr Tagged_t kquery_colon_string = 0x554d;
  static constexpr Tagged_t kRangeError_string = 0x555d;
  static constexpr Tagged_t kraw_json_string = 0x5575;
  static constexpr Tagged_t kraw_string = 0x5589;
  static constexpr Tagged_t kReferenceError_string = 0x5599;
  static constexpr Tagged_t kReflectGet_string = 0x55b5;
  static constexpr Tagged_t kReflectHas_string = 0x55cd;
  static constexpr Tagged_t kRegExp_string = 0x55e5;
  static constexpr Tagged_t kregexp_to_string = 0x55f9;
  static constexpr Tagged_t kreject_string = 0x5615;
  static constexpr Tagged_t krelativeTo_string = 0x5629;
  static constexpr Tagged_t kresizable_string = 0x5641;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x5659;
  static constexpr Tagged_t kreturn_string = 0x5679;
  static constexpr Tagged_t krevoke_string = 0x568d;
  static constexpr Tagged_t kroundingIncrement_string = 0x56a1;
  static constexpr Tagged_t kRuntimeError_string = 0x56c1;
  static constexpr Tagged_t kWebAssemblyException_string = 0x56d9;
  static constexpr Tagged_t kWebAssemblyModule_string = 0x56fd;
  static constexpr Tagged_t kScript_string = 0x571d;
  static constexpr Tagged_t kscript_string = 0x5731;
  static constexpr Tagged_t ksecond_string = 0x5745;
  static constexpr Tagged_t kseconds_string = 0x5759;
  static constexpr Tagged_t kshort_string = 0x576d;
  static constexpr Tagged_t kSet_string = 0x5781;
  static constexpr Tagged_t ksentence_string = 0x5791;
  static constexpr Tagged_t kset_space_string = 0x57a5;
  static constexpr Tagged_t kset_string = 0x57b5;
  static constexpr Tagged_t kSetIterator_string = 0x57c5;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x57dd;
  static constexpr Tagged_t kShadowRealm_string = 0x57f9;
  static constexpr Tagged_t kSharedArray_string = 0x5811;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x5829;
  static constexpr Tagged_t kSharedStruct_string = 0x5849;
  static constexpr Tagged_t ksign_string = 0x5861;
  static constexpr Tagged_t ksize_string = 0x5871;
  static constexpr Tagged_t ksmallestUnit_string = 0x5881;
  static constexpr Tagged_t ksource_string = 0x5899;
  static constexpr Tagged_t ksourceText_string = 0x58ad;
  static constexpr Tagged_t kstack_string = 0x58c5;
  static constexpr Tagged_t kstackTraceLimit_string = 0x58d9;
  static constexpr Tagged_t kstatic_initializer_string = 0x58f5;
  static constexpr Tagged_t ksticky_string = 0x5915;
  static constexpr Tagged_t kString_string = 0x5929;
  static constexpr Tagged_t kstring_string = 0x593d;
  static constexpr Tagged_t kstring_to_string = 0x5951;
  static constexpr Tagged_t ksuppressed_string = 0x596d;
  static constexpr Tagged_t kSuppressedError_string = 0x5985;
  static constexpr Tagged_t kSymbol_iterator_string = 0x59a1;
  static constexpr Tagged_t kSymbol_match_all_string = 0x59bd;
  static constexpr Tagged_t kSymbol_replace_string = 0x59d9;
  static constexpr Tagged_t ksymbol_species_string = 0x59f5;
  static constexpr Tagged_t kSymbol_species_string = 0x5a11;
  static constexpr Tagged_t kSymbol_split_string = 0x5a2d;
  static constexpr Tagged_t kSymbol_string = 0x5a45;
  static constexpr Tagged_t ksymbol_string = 0x5a59;
  static constexpr Tagged_t kSyntaxError_string = 0x5a6d;
  static constexpr Tagged_t ktarget_string = 0x5a85;
  static constexpr Tagged_t kthis_function_string = 0x5a99;
  static constexpr Tagged_t kthis_string = 0x5ab5;
  static constexpr Tagged_t kthrow_string = 0x5ac5;
  static constexpr Tagged_t ktimed_out_string = 0x5ad9;
  static constexpr Tagged_t ktimeZone_string = 0x5af1;
  static constexpr Tagged_t ktoJSON_string = 0x5b05;
  static constexpr Tagged_t ktoString_string = 0x5b19;
  static constexpr Tagged_t ktrue_string = 0x5b2d;
  static constexpr Tagged_t ktotal_string = 0x5b3d;
  static constexpr Tagged_t kTypeError_string = 0x5b51;
  static constexpr Tagged_t kUint16Array_string = 0x5b69;
  static constexpr Tagged_t kUint32Array_string = 0x5b81;
  static constexpr Tagged_t kUint8Array_string = 0x5b99;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x5bb1;
  static constexpr Tagged_t kundefined_string = 0x5bd1;
  static constexpr Tagged_t kundefined_to_string = 0x5be9;
  static constexpr Tagged_t kunicode_string = 0x5c09;
  static constexpr Tagged_t kunicodeSets_string = 0x5c1d;
  static constexpr Tagged_t kunit_string = 0x5c35;
  static constexpr Tagged_t kURIError_string = 0x5c45;
  static constexpr Tagged_t kUTC_string = 0x5c59;
  static constexpr Tagged_t kWeakMap_string = 0x5c69;
  static constexpr Tagged_t kWeakRef_string = 0x5c7d;
  static constexpr Tagged_t kWeakSet_string = 0x5c91;
  static constexpr Tagged_t kweek_string = 0x5ca5;
  static constexpr Tagged_t kweeks_string = 0x5cb5;
  static constexpr Tagged_t kweekOfYear_string = 0x5cc9;
  static constexpr Tagged_t kwith_string = 0x5ce1;
  static constexpr Tagged_t kword_string = 0x5cf1;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x5d01;
  static constexpr Tagged_t kyear_string = 0x5d21;
  static constexpr Tagged_t kyears_string = 0x5d31;
  static constexpr Tagged_t kPropertyCellHoleValue = 0x5d45;
  static constexpr Tagged_t kHashTableHoleValue = 0x5d51;
  static constexpr Tagged_t kPromiseHoleValue = 0x5d5d;
  static constexpr Tagged_t kUninitializedValue = 0x5d69;
  static constexpr Tagged_t kArgumentsMarker = 0x5d75;
  static constexpr Tagged_t kTerminationException = 0x5d81;
  static constexpr Tagged_t kException = 0x5d8d;
  static constexpr Tagged_t kOptimizedOut = 0x5d99;
  static constexpr Tagged_t kStaleRegister = 0x5da5;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5db1;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5dbd;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5dc9;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5dd9;
  static constexpr Tagged_t kclass_fields_symbol = 0x5de9;
  static constexpr Tagged_t kclass_positions_symbol = 0x5df9;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5e09;
  static constexpr Tagged_t kerror_message_symbol = 0x5e19;
  static constexpr Tagged_t kerror_script_symbol = 0x5e29;
  static constexpr Tagged_t kerror_stack_symbol = 0x5e39;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5e49;
  static constexpr Tagged_t kfrozen_symbol = 0x5e59;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5e69;
  static constexpr Tagged_t knative_context_index_symbol = 0x5e79;
  static constexpr Tagged_t knonextensible_symbol = 0x5e89;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5e99;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5ea9;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5eb9;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5ec9;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5ed9;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5ee9;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5ef9;
  static constexpr Tagged_t ksealed_symbol = 0x5f09;
  static constexpr Tagged_t kshared_struct_map_elements_template_symbol =
      0x5f19;
  static constexpr Tagged_t kshared_struct_map_registry_key_symbol = 0x5f29;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5f39;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5f49;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5f59;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5f69;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5f79;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5f89;
  static constexpr Tagged_t kwasm_wrapped_object_symbol = 0x5f99;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5fa9;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5fb9;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5fc9;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5ff9;
  static constexpr Tagged_t kmatch_symbol = 0x6031;
  static constexpr Tagged_t ksearch_symbol = 0x6059;
  static constexpr Tagged_t kunscopables_symbol = 0x6085;
  static constexpr Tagged_t kdispose_symbol = 0x60b5;
  static constexpr Tagged_t kasync_dispose_symbol = 0x60e1;
  static constexpr Tagged_t khas_instance_symbol = 0x6111;
  static constexpr Tagged_t kto_string_tag_symbol = 0x6141;
  static constexpr Tagged_t kconstructor_string = 0x61b9;
  static constexpr Tagged_t knext_string = 0x61d1;
  static constexpr Tagged_t kresolve_string = 0x61e1;
  static constexpr Tagged_t kthen_string = 0x61f5;
  static constexpr Tagged_t kvalueOf_string = 0x6205;
  static constexpr Tagged_t kiterator_symbol = 0x6219;
  static constexpr Tagged_t kmatch_all_symbol = 0x6229;
  static constexpr Tagged_t kreplace_symbol = 0x6239;
  static constexpr Tagged_t kspecies_symbol = 0x6249;
  static constexpr Tagged_t ksplit_symbol = 0x6259;
  static constexpr Tagged_t kto_primitive_symbol = 0x6269;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x6279;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x6289;
  static constexpr Tagged_t kEmptySymbolTable = 0x62ad;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x62c9;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x62dd;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x62f1;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x62fd;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x631d;
  static constexpr Tagged_t kNativeScopeInfo = 0x6341;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x6359;
  static constexpr Tagged_t kEmptyExternalPointerArray = 0x6371;
  static constexpr Tagged_t kWasmNullPadding = 0x6379;
  static constexpr Tagged_t kWasmNull = 0xfffd;
  static constexpr Tagged_t kJSSharedArrayMap = 0x20001;
  static constexpr Tagged_t kJSAtomicsMutexMap = 0x20045;
  static constexpr Tagged_t kJSAtomicsConditionMap = 0x2006d;

  static constexpr Tagged_t kFirstAllocatedRoot = 0x69;
  static constexpr Tagged_t kLastAllocatedRoot = 0x2006d;
};

static constexpr std::array<Tagged_t, 767> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kSeqOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kPropertyCellHoleValue,
    StaticReadOnlyRoot::kHashTableHoleValue,
    StaticReadOnlyRoot::kPromiseHoleValue,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kDictionaryTemplateInfoMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kGlobalConstTrackingLetCellMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kRegExpMatchInfoMap,
    StaticReadOnlyRoot::kRegExpDataMap,
    StaticReadOnlyRoot::kAtomRegExpDataMap,
    StaticReadOnlyRoot::kIrRegExpDataMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWasmImportDataMap,
    StaticReadOnlyRoot::kWasmCapiFunctionDataMap,
    StaticReadOnlyRoot::kWasmContinuationObjectMap,
    StaticReadOnlyRoot::kWasmDispatchTableMap,
    StaticReadOnlyRoot::kWasmExportedFunctionDataMap,
    StaticReadOnlyRoot::kWasmInternalFunctionMap,
    StaticReadOnlyRoot::kWasmFuncRefMap,
    StaticReadOnlyRoot::kWasmJSFunctionDataMap,
    StaticReadOnlyRoot::kWasmNullMap,
    StaticReadOnlyRoot::kWasmResumeDataMap,
    StaticReadOnlyRoot::kWasmSuspenderObjectMap,
    StaticReadOnlyRoot::kWasmTrustedInstanceDataMap,
    StaticReadOnlyRoot::kWasmTypeInfoMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kExternalPointerArrayMap,
    StaticReadOnlyRoot::kTrustedFixedArrayMap,
    StaticReadOnlyRoot::kTrustedWeakFixedArrayMap,
    StaticReadOnlyRoot::kTrustedByteArrayMap,
    StaticReadOnlyRoot::kProtectedFixedArrayMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kSharedFunctionInfoWrapperMap,
    StaticReadOnlyRoot::kTrustedForeignMap,
    StaticReadOnlyRoot::kSeqTwoByteStringMap,
    StaticReadOnlyRoot::kConsTwoByteStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kThinTwoByteStringMap,
    StaticReadOnlyRoot::kThinOneByteStringMap,
    StaticReadOnlyRoot::kSlicedTwoByteStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalTwoByteStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqTwoByteStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kHoleMap,
    StaticReadOnlyRoot::kJSSharedArrayMap,
    StaticReadOnlyRoot::kJSAtomicsMutexMap,
    StaticReadOnlyRoot::kJSAtomicsConditionMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyExternalPointerArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSingleCharacterStringTable,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kWasmNullPadding,
    StaticReadOnlyRoot::kWasmNull,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfirstDayOfWeek_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMicroseconds_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kepochSeconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerror_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat16Array_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kinstance_members_initializer_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kIterator_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kpromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kWebAssemblyModule_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksize_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::kstatic_initializer_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::ksuppressed_string,
    StaticReadOnlyRoot::kSuppressedError_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_match_all_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_split_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kwith_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_message_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kshared_struct_map_elements_template_symbol,
    StaticReadOnlyRoot::kshared_struct_map_registry_key_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_wrapped_object_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::kdispose_symbol,
    StaticReadOnlyRoot::kasync_dispose_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsmWasmDataMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kBytecodeWrapperMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassBoilerplateMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kCodeWrapperMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kRegExpDataWrapperMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kWasmExceptionTagMap,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kWasmFastApiCallDataMap,
    StaticReadOnlyRoot::kWasmStringViewIterMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_H_
