define_property(GLOBAL PROPERTY LICENSE_TEXT
    BRIEF_DOCS "Embedded licenses"
    FULL_DOCS  "Global string containing all aggregated licenses"
)

function(license_add_file NAME FILE)
    if(NOT IS_ABSOLUTE "${FILE}")
        set(FILE "${CMAKE_CURRENT_SOURCE_DIR}/${FILE}")
    endif()
    if(EXISTS "${FILE}")
        set(TITLE "License for ${NAME}")
        string(REGEX REPLACE "." "=" UNDERLINE "${TITLE}")
        file(READ "${FILE}" TEXT)
        get_property(TMP GLOBAL PROPERTY LICENSE_TEXT)
        string(APPEND TMP "R\"=L=(${TITLE}\n${UNDERLINE}\n\n${TEXT})=L=\",\n")
        set_property(GLOBAL PROPERTY LICENSE_TEXT "${TMP}")
    else()
        message(WARNING "License file '${FILE}' not found")
    endif()
endfunction()

function(license_generate TARGET_NAME)
    message(STATUS "Generating embedded license file for target: ${TARGET_NAME}")
    get_property(TEXT GLOBAL PROPERTY LICENSE_TEXT)

    set(CPP_CONTENT "// Generated by CMake\n\n")
    string(APPEND CPP_CONTENT "const char* LICENSES[] = {\n")
    string(APPEND CPP_CONTENT "${TEXT}")
    string(APPEND CPP_CONTENT "nullptr\n")
    string(APPEND CPP_CONTENT "};\n")

    set(CPP_FILE "${CMAKE_BINARY_DIR}/license.cpp")
    file(WRITE "${CPP_FILE}" "${CPP_CONTENT}")

    if(TARGET ${TARGET_NAME})
        target_sources(${TARGET_NAME} PRIVATE "${CPP_FILE}")
    else()
        message(FATAL_ERROR "Target '${TARGET_NAME}' does not exist")
    endif()
endfunction()
