/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_23 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4585, "epsg", 4585,
        "New Beijing / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 111E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4585\"]]");
    p = add_epsg_def_ex (filter, first, last, 4586, "epsg", 4586,
        "New Beijing / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 117E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",117");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4586\"]]");
    p = add_epsg_def_ex (filter, first, last, 4587, "epsg", 4587,
        "New Beijing / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 123E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",123");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4587\"]]");
    p = add_epsg_def_ex (filter, first, last, 4588, "epsg", 4588,
        "New Beijing / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 129E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",129");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4588\"]]");
    p = add_epsg_def_ex (filter, first, last, 4589, "epsg", 4589,
        "New Beijing / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / Gauss-Kruger CM 135E\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ew Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"Krassowsky");
    add_srs_wkt (p, 2,
        " 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"455");
    add_srs_wkt (p, 6,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",135");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"4589\"]]");
    p = add_epsg_def_ex (filter, first, last, 4600, "epsg", 4600,
        "Anguilla 1957", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Anguilla_1957", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Anguilla 1957\",DATUM[\"Anguilla_1957\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6600\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4600\"]]");
    p = add_epsg_def_ex (filter, first, last, 4601, "epsg", 4601,
        "Antigua 1943", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Antigua_1943", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Antigua 1943\",DATUM[\"Antigua_1943\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6601\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4601\"]]");
    p = add_epsg_def_ex (filter, first, last, 4602, "epsg", 4602,
        "Dominica 1945", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Dominica_1945", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dominica 1945\",DATUM[\"Dominica_1945\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6602\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4602\"]]");
    p = add_epsg_def_ex (filter, first, last, 4603, "epsg", 4603,
        "Grenada 1953", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Grenada_1953", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grenada 1953\",DATUM[\"Grenada_1953\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6603\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4603\"]]");
    p = add_epsg_def_ex (filter, first, last, 4604, "epsg", 4604,
        "Montserrat 1958", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Montserrat_1958", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Montserrat 1958\",DATUM[\"Montserrat_1958\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6604\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4604\"]]");
    p = add_epsg_def_ex (filter, first, last, 4605, "epsg", 4605,
        "St. Kitts 1955", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Kitts_1955", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Kitts 1955\",DATUM[\"St_Kitts_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6605\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4605\"]]");
    p = add_epsg_def_ex (filter, first, last, 4606, "epsg", 4606,
        "St. Lucia 1955", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Lucia_1955", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Lucia 1955\",DATUM[\"St_Lucia_1955\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6606\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4606\"]]");
    p = add_epsg_def_ex (filter, first, last, 4607, "epsg", 4607,
        "St. Vincent 1945", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Vincent_1945", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274");
    add_proj4text (p, 1,
        ".607,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Vincent 1945\",DATUM[\"St_Vincent_1945\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6607\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4607\"]]");
    p = add_epsg_def_ex (filter, first, last, 4608, "epsg", 4608,
        "NAD27(76)", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(76)\",DATUM[\"North_American_Datum_1927_1");
    add_srs_wkt (p, 1,
        "976\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 2,
        "8,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"660");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4608\"]]");
    p = add_epsg_def_ex (filter, first, last, 4609, "epsg", 4609,
        "NAD27(CGQ77)", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27(CGQ77)\",DATUM[\"North_American_Datum_192");
    add_srs_wkt (p, 1,
        "7_CGQ77\",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982");
    add_srs_wkt (p, 2,
        "13898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6609\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4609\"]]");
    p = add_epsg_def_ex (filter, first, last, 4610, "epsg", 4610,
        "Xian 1980", 1, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG ");
    add_srs_wkt (p, 1,
        "1975\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 5,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]]");
    p = add_epsg_def_ex (filter, first, last, 4611, "epsg", 4611,
        "Hong Kong 1980", 1, 1,
        "International 1924", "Greenwich",
        "Hong_Kong_1980", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-16");
    add_proj4text (p, 1,
        "1.764,0.067753,-2.243649,-1.158827,-1.094246 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hong Kong 1980\",DATUM[\"Hong_Kong_1980\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6611\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4611\"]]");
    p = add_epsg_def_ex (filter, first, last, 4612, "epsg", 4612,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4612\"]]");
    p = add_epsg_def_ex (filter, first, last, 4613, "epsg", 4613,
        "Segara", 1, 1,
        "Bessel 1841", "Greenwich",
        "Gunung_Segara", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara\",DATUM[\"Gunung_Segara\",SPHEROID[\"Bes");
    add_srs_wkt (p, 1,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],AUTHORITY[\"EPSG\",\"6613\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4613\"]]");
    p = add_epsg_def_ex (filter, first, last, 4614, "epsg", 4614,
        "QND95", 1, 1,
        "International 1924", "Greenwich",
        "Qatar_National_Datum_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-119.4248,-303.65872,");
    add_proj4text (p, 1,
        "-11.00061,1.164298,0.174458,1.096259,3.657065 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"QND95\",DATUM[\"Qatar_National_Datum_1995\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6614\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4614\"]]");
    p = add_epsg_def_ex (filter, first, last, 4615, "epsg", 4615,
        "Porto Santo", 1, 1,
        "International 1924", "Greenwich",
        "Porto_Santo_1936", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Porto Santo\",DATUM[\"Porto_Santo_1936\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6615\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4615\"]]");
    p = add_epsg_def_ex (filter, first, last, 4616, "epsg", 4616,
        "Selvagem Grande", 1, 1,
        "International 1924", "Greenwich",
        "Selvagem_Grande", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-289,-124,60,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Selvagem Grande\",DATUM[\"Selvagem_Grande\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6616\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4616\"]]");
    p = add_epsg_def_ex (filter, first, last, 4617, "epsg", 4617,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Re");
    add_srs_wkt (p, 1,
        "ference_System\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4617\"]]");
    p = add_epsg_def_ex (filter, first, last, 4618, "epsg", 4618,
        "SAD69", 1, 1,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-66.87,4.37,-38.52");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69\",DATUM[\"South_American_Datum_1969\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7050\"]],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4618\"]]");
    p = add_epsg_def_ex (filter, first, last, 4619, "epsg", 4619,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4619");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4620, "epsg", 4620,
        "Point 58", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Point_58", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Point 58\",DATUM[\"Point_58\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],AUTHORITY[\"EPSG\",\"6620\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4620\"]]");
    p = add_epsg_def_ex (filter, first, last, 4621, "epsg", 4621,
        "Fort Marigot", 1, 1,
        "International 1924", "Greenwich",
        "Fort_Marigot", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fort Marigot\",DATUM[\"Fort_Marigot\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6621\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4621\"]]");
    p = add_epsg_def_ex (filter, first, last, 4622, "epsg", 4622,
        "Guadeloupe 1948", 1, 1,
        "International 1924", "Greenwich",
        "Guadeloupe_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-467,-16,-300,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guadeloupe 1948\",DATUM[\"Guadeloupe_1948\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6622\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4622\"]]");
    p = add_epsg_def_ex (filter, first, last, 4623, "epsg", 4623,
        "CSG67", 1, 1,
        "International 1924", "Greenwich",
        "Centre_Spatial_Guyanais_1967", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CSG67\",DATUM[\"Centre_Spatial_Guyanais_1967\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6623\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4623\"]]");
    p = add_epsg_def_ex (filter, first, last, 4624, "epsg", 4624,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGFG95\",DATUM[\"Reseau_Geodesique_Francais_Guy");
    add_srs_wkt (p, 1,
        "ane_1995\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6624\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4624\"]]");
    p = add_epsg_def_ex (filter, first, last, 4625, "epsg", 4625,
        "Martinique 1938", 1, 1,
        "International 1924", "Greenwich",
        "Martinique_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=186,482,151,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Martinique 1938\",DATUM[\"Martinique_1938\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6625\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4625\"]]");
    p = add_epsg_def_ex (filter, first, last, 4626, "epsg", 4626,
        "Reunion 1947", 1, 1,
        "International 1924", "Greenwich",
        "Reunion_1947", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=94,-948,-1262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Reunion 1947\",DATUM[\"Reunion_1947\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6626\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4626\"]]");
    p = add_epsg_def_ex (filter, first, last, 4627, "epsg", 4627,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGR92\",DATUM[\"Reseau_Geodesique_de_la_Reunion");
    add_srs_wkt (p, 1,
        "_1992\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6627\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4627\"]]");
    p = add_epsg_def_ex (filter, first, last, 4628, "epsg", 4628,
        "Tahiti 52", 1, 1,
        "International 1924", "Greenwich",
        "Tahiti_52", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahiti 52\",DATUM[\"Tahiti_52\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6628\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "28\"]]");
    p = add_epsg_def_ex (filter, first, last, 4629, "epsg", 4629,
        "Tahaa 54", 1, 1,
        "International 1924", "Greenwich",
        "Tahaa_54", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486");
    add_proj4text (p, 1,
        ",1.6045,0.8823,0.5565,1.3746 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahaa 54\",DATUM[\"Tahaa_54\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6629\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4629");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4630, "epsg", 4630,
        "IGN72 Nuku Hiva", 1, 1,
        "International 1924", "Greenwich",
        "IGN72_Nuku_Hiva", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=84,274,65,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Nuku Hiva\",DATUM[\"IGN72_Nuku_Hiva\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6630\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4630\"]]");
    p = add_epsg_def_ex (filter, first, last, 4631, "epsg", 4631,
        "K0 1949 (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "K0_1949", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"K0 1949 (deprecated)\",DATUM[\"K0_1949\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6631\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4631\"]]");
    p = add_epsg_def_ex (filter, first, last, 4632, "epsg", 4632,
        "Combani 1950", 1, 1,
        "International 1924", "Greenwich",
        "Combani_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Combani 1950\",DATUM[\"Combani_1950\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6632\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4632\"]]");
    p = add_epsg_def_ex (filter, first, last, 4633, "epsg", 4633,
        "IGN56 Lifou", 1, 1,
        "International 1924", "Greenwich",
        "IGN56_Lifou", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN56 Lifou\",DATUM[\"IGN56_Lifou\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6633\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4633\"]]");
    p = add_epsg_def_ex (filter, first, last, 4634, "epsg", 4634,
        "IGN72 Grand Terre (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "IGN72_Grande_Terre", "none", "degree minute second hemisphere",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Grand Terre (deprecated)\",DATUM[\"IGN72_");
    add_srs_wkt (p, 1,
        "Grande_Terre\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 3,
        "34\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree minute second hemisphere\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4634");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4635, "epsg", 4635,
        "ST87 Ouvea (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "ST87_Ouvea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103");
    add_proj4text (p, 1,
        ".344,3.5107,-4.9668,-5.7047,4.4798 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST87 Ouvea (deprecated)\",DATUM[\"ST87_Ouvea\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6635\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4635\"]]");
    p = add_epsg_def_ex (filter, first, last, 4636, "epsg", 4636,
        "Petrels 1972", 1, 1,
        "International 1924", "Greenwich",
        "Petrels_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=365,194,166,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Petrels 1972\",DATUM[\"Petrels_1972\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6636\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4636\"]]");
    p = add_epsg_def_ex (filter, first, last, 4637, "epsg", 4637,
        "Perroud 1950", 1, 1,
        "International 1924", "Greenwich",
        "Pointe_Geologie_Perroud_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Perroud 1950\",DATUM[\"Pointe_Geologie_Perroud_");
    add_srs_wkt (p, 1,
        "1950\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6637\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4637\"]]");
    p = add_epsg_def_ex (filter, first, last, 4638, "epsg", 4638,
        "Saint Pierre et Miquelon 1950", 1, 1,
        "Clarke 1866", "Greenwich",
        "Saint_Pierre_et_Miquelon_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Saint Pierre et Miquelon 1950\",DATUM[\"Saint_P");
    add_srs_wkt (p, 1,
        "ierre_et_Miquelon_1950\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6638\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4638\"]]");
    p = add_epsg_def_ex (filter, first, last, 4639, "epsg", 4639,
        "MOP78", 1, 1,
        "International 1924", "Greenwich",
        "MOP78", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=253,-132,-127,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MOP78\",DATUM[\"MOP78\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"6639\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4639\"]]");
    p = add_epsg_def_ex (filter, first, last, 4640, "epsg", 4640,
        "RRAF 1991 (deprecated)", 1, 1,
        "WGS 84", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RRAF 1991 (deprecated)\",DATUM[\"Reseau_de_Refe");
    add_srs_wkt (p, 1,
        "rence_des_Antilles_Francaises_1991\",SPHEROID[\"WGS 84\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6640\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4640\"]]");
    p = add_epsg_def_ex (filter, first, last, 4641, "epsg", 4641,
        "IGN53 Mare", 1, 1,
        "International 1924", "Greenwich",
        "IGN53_Mare", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=287.58,177.78,-135.41");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN53 Mare\",DATUM[\"IGN53_Mare\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6641\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4641\"]]");
    p = add_epsg_def_ex (filter, first, last, 4642, "epsg", 4642,
        "ST84 Ile des Pins", 1, 1,
        "International 1924", "Greenwich",
        "ST84_Ile_des_Pins", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST84 Ile des Pins\",DATUM[\"ST84_Ile_des_Pins\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6642\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4642\"]]");
    p = add_epsg_def_ex (filter, first, last, 4643, "epsg", 4643,
        "ST71 Belep", 1, 1,
        "International 1924", "Greenwich",
        "ST71_Belep", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.");
    add_proj4text (p, 1,
        "429,16.3119,20.1721,-4.0349,-111.7002 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ST71 Belep\",DATUM[\"ST71_Belep\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6643\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4643\"]]");
    p = add_epsg_def_ex (filter, first, last, 4644, "epsg", 4644,
        "NEA74 Noumea", 1, 1,
        "International 1924", "Greenwich",
        "NEA74_Noumea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-10.18,-350.43,291.37");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NEA74 Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6644\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4644\"]]");
    p = add_epsg_def_ex (filter, first, last, 4645, "epsg", 4645,
        "RGNC 1991 (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_Geodesique_Nouvelle_Caledonie_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGNC 1991 (deprecated)\",DATUM[\"Reseau_Geodesi");
    add_srs_wkt (p, 1,
        "que_Nouvelle_Caledonie_1991\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6645\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4645\"]]");
    p = add_epsg_def_ex (filter, first, last, 4646, "epsg", 4646,
        "Grand Comoros", 1, 1,
        "International 1924", "Greenwich",
        "Grand_Comoros", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-963,510,-359,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Grand Comoros\",DATUM[\"Grand_Comoros\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6646\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4646\"]]");
    p = add_epsg_def_ex (filter, first, last, 4647, "epsg", 4647,
        "ETRS89 / UTM zone 32N (zE-N)", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / UTM zone 32N (zE-N)\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",9],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",32500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"4647\"]]");
    p = add_epsg_def_ex (filter, first, last, 4652, "epsg", 4652,
        "New Beijing / 3-degree Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 25\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",75],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",25500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4652\"]]");
    p = add_epsg_def_ex (filter, first, last, 4653, "epsg", 4653,
        "New Beijing / 3-degree Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 26\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",78],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",26500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4653\"]]");
    p = add_epsg_def_ex (filter, first, last, 4654, "epsg", 4654,
        "New Beijing / 3-degree Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 27\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",81],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",27500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4654\"]]");
    p = add_epsg_def_ex (filter, first, last, 4655, "epsg", 4655,
        "New Beijing / 3-degree Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 28\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",84],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",28500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4655\"]]");
    p = add_epsg_def_ex (filter, first, last, 4656, "epsg", 4656,
        "New Beijing / 3-degree Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger zone 29\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",87],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",29500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"4656\"]]");
    p = add_epsg_def_ex (filter, first, last, 4657, "epsg", 4657,
        "Reykjavik 1900", 1, 1,
        "Danish 1876", "Greenwich",
        "Reykjavik_1900", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28");
    add_proj4text (p, 1,
        ",199,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Reykjavik 1900\",DATUM[\"Reykjavik_1900\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Danish 1876\",6377019.27,300,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7051\"]],AUTHORITY[\"EPSG\",\"6657\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4657\"]]");
    p = add_epsg_def_ex (filter, first, last, 4658, "epsg", 4658,
        "Hjorsey 1955", 1, 1,
        "International 1924", "Greenwich",
        "Hjorsey_1955", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-73,47,-83,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hjorsey 1955\",DATUM[\"Hjorsey_1955\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6658\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4658\"]]");
    p = add_epsg_def_ex (filter, first, last, 4659, "epsg", 4659,
        "ISN93", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ISN93\",DATUM[\"Islands_Net_1993\",SPHEROID[\"G");
    add_srs_wkt (p, 1,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 2,
        "9\"]],AUTHORITY[\"EPSG\",\"6659\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4659\"]]");
    p = add_epsg_def_ex (filter, first, last, 4660, "epsg", 4660,
        "Helle 1954", 1, 1,
        "International 1924", "Greenwich",
        "Helle_1954", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=982.6087,552.753,-540");
    add_proj4text (p, 1,
        ".873,6.6816266,-31.6114924,-19.84816,16.805 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Helle 1954\",DATUM[\"Helle_1954\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6660\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4660\"]]");
    p = add_epsg_def_ex (filter, first, last, 4661, "epsg", 4661,
        "LKS92", 1, 1,
        "GRS 1980", "Greenwich",
        "Latvia_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LKS92\",DATUM[\"Latvia_1992\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 1,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6661\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4661");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4662, "epsg", 4662,
        "IGN72 Grande Terre", 1, 1,
        "International 1924", "Greenwich",
        "IGN72_Grande_Terre", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-11.64,-348.6,291.98,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN72 Grande Terre\",DATUM[\"IGN72_Grande_Terre");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6634\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4662\"]]");
    p = add_epsg_def_ex (filter, first, last, 4663, "epsg", 4663,
        "Porto Santo 1995", 1, 1,
        "International 1924", "Greenwich",
        "Porto_Santo_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-502.862,-247.438,312");
    add_proj4text (p, 1,
        ".724,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Porto Santo 1995\",DATUM[\"Porto_Santo_1995\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6663\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4663\"]]");
    p = add_epsg_def_ex (filter, first, last, 4664, "epsg", 4664,
        "Azores Oriental 1995", 1, 1,
        "International 1924", "Greenwich",
        "Azores_Oriental_Islands_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-204.619,140.176,55.2");
    add_proj4text (p, 1,
        "26,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Oriental 1995\",DATUM[\"Azores_Oriental_");
    add_srs_wkt (p, 1,
        "Islands_1995\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 3,
        "64\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4664\"]]");
    p = add_epsg_def_ex (filter, first, last, 4665, "epsg", 4665,
        "Azores Central 1995", 1, 1,
        "International 1924", "Greenwich",
        "Azores_Central_Islands_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-106.226,166.366,-37.");
    add_proj4text (p, 1,
        "893,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Azores Central 1995\",DATUM[\"Azores_Central_Is");
    add_srs_wkt (p, 1,
        "lands_1995\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6665");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4665\"]]");
    p = add_epsg_def_ex (filter, first, last, 4666, "epsg", 4666,
        "Lisbon 1890", 1, 1,
        "Bessel 1841", "Greenwich",
        "Lisbon_1890", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,56");
    add_proj4text (p, 1,
        "5.223,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon 1890\",DATUM[\"Lisbon_1890\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6666\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4666\"]]");
    p = add_epsg_def_ex (filter, first, last, 4667, "epsg", 4667,
        "IKBD-92", 1, 1,
        "WGS 84", "Greenwich",
        "Iraq-Kuwait_Boundary_Datum_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IKBD-92\",DATUM[\"Iraq-Kuwait_Boundary_Datum_19");
    add_srs_wkt (p, 1,
        "92\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6667\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4667\"]]");
    p = add_epsg_def_ex (filter, first, last, 4668, "epsg", 4668,
        "ED79", 1, 1,
        "International 1924", "Greenwich",
        "European_Datum_1979", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-86,-98,-119,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED79\",DATUM[\"European_Datum_1979\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6668\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4668\"]]");
    p = add_epsg_def_ex (filter, first, last, 4669, "epsg", 4669,
        "LKS94", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"LKS94\",DATUM[\"Lithuania_1994_ETRS89\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7019\"]],AUTHORITY[\"EPSG\",\"6126\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4669\"]]");
    p = add_epsg_def_ex (filter, first, last, 4670, "epsg", 4670,
        "IGM95", 1, 1,
        "GRS 1980", "Greenwich",
        "Istituto_Geografico_Militaire_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGM95\",DATUM[\"Istituto_Geografico_Militaire_1");
    add_srs_wkt (p, 1,
        "995\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6670\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4670\"]]");
    p = add_epsg_def_ex (filter, first, last, 4671, "epsg", 4671,
        "Voirol 1879", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4671\"]]");
    p = add_epsg_def_ex (filter, first, last, 4672, "epsg", 4672,
        "Chatham Islands 1971", 1, 1,
        "International 1924", "Greenwich",
        "Chatham_Islands_Datum_1971", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=175,-38,113,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chatham Islands 1971\",DATUM[\"Chatham_Islands_");
    add_srs_wkt (p, 1,
        "Datum_1971\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6672");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4672\"]]");
    p = add_epsg_def_ex (filter, first, last, 4673, "epsg", 4673,
        "Chatham Islands 1979", 1, 1,
        "International 1924", "Greenwich",
        "Chatham_Islands_Datum_1979", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=174.05,-25.49,112.57,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chatham Islands 1979\",DATUM[\"Chatham_Islands_");
    add_srs_wkt (p, 1,
        "Datum_1979\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6673");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4673\"]]");
    p = add_epsg_def_ex (filter, first, last, 4674, "epsg", 4674,
        "SIRGAS 2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS 2000\",DATUM[\"Sistema_de_Referencia_Geo");
    add_srs_wkt (p, 1,
        "centrico_para_las_AmericaS_2000\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4674\"]]");
    p = add_epsg_def_ex (filter, first, last, 4675, "epsg", 4675,
        "Guam 1963", 1, 1,
        "Clarke 1866", "Greenwich",
        "Guam_1963", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-100,-248,259,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Guam 1963\",DATUM[\"Guam_1963\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6675\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4675\"]]");
    p = add_epsg_def_ex (filter, first, last, 4676, "epsg", 4676,
        "Vientiane 1982", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Vientiane_1982", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Vientiane 1982\",DATUM[\"Vientiane_1982\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7024\"]],AUTHORITY[\"EPSG\",\"6676\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4676\"]]");
    p = add_epsg_def_ex (filter, first, last, 4677, "epsg", 4677,
        "Lao 1993", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Lao_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lao 1993\",DATUM[\"Lao_1993\",SPHEROID[\"Krasso");
    add_srs_wkt (p, 1,
        "wsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"6677\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 4,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 5,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4677\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4678, "epsg", 4678,
        "Lao 1997", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Lao_National_Datum_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.");
    add_proj4text (p, 1,
        "544,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lao 1997\",DATUM[\"Lao_National_Datum_1997\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6678\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4678\"]]");
    p = add_epsg_def_ex (filter, first, last, 4679, "epsg", 4679,
        "Jouik 1961", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Jouik_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-80.01,253.26,291.1");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Jouik 1961\",DATUM[\"Jouik_1961\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6679\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4679\"]]");
    p = add_epsg_def_ex (filter, first, last, 4680, "epsg", 4680,
        "Nouakchott 1965", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nouakchott_1965", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=124.5,-63.5,-281,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nouakchott 1965\",DATUM[\"Nouakchott_1965\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6680\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4680\"]]");
    p = add_epsg_def_ex (filter, first, last, 4681, "epsg", 4681,
        "Mauritania 1999 (deprecated)", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Mauritania_1999", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mauritania 1999 (deprecated)\",DATUM[\"Mauritan");
    add_srs_wkt (p, 1,
        "ia_1999\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293");
    add_srs_wkt (p, 2,
        ".465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6681\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4681\"]]");
    p = add_epsg_def_ex (filter, first, last, 4682, "epsg", 4682,
        "Gulshan 303", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Gulshan_303", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=283.7,735.9,261.1,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gulshan 303\",DATUM[\"Gulshan_303\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6682\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4682\"]]");
    p = add_epsg_def_ex (filter, first, last, 4683, "epsg", 4683,
        "PRS92", 1, 1,
        "Clarke 1866", "Greenwich",
        "Philippine_Reference_System_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.");
    add_proj4text (p, 1,
        "04,-3.068,4.903,1.578,-1.06 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PRS92\",DATUM[\"Philippine_Reference_System_199");
    add_srs_wkt (p, 1,
        "2\",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6683\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4683\"]]");
    p = add_epsg_def_ex (filter, first, last, 4684, "epsg", 4684,
        "Gan 1970", 1, 1,
        "International 1924", "Greenwich",
        "Gan_1970", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gan 1970\",DATUM[\"Gan_1970\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6684\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4684");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4685, "epsg", 4685,
        "Gandajika (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Gandajika", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gandajika (deprecated)\",DATUM[\"Gandajika\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6685\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4685\"]]");
    p = add_epsg_def_ex (filter, first, last, 4686, "epsg", 4686,
        "MAGNA-SIRGAS", 1, 1,
        "GRS 1980", "Greenwich",
        "Marco_Geocentrico_Nacional_de_Referencia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MAGNA-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacion");
    add_srs_wkt (p, 1,
        "al_de_Referencia\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6686\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4686\"]]");
    p = add_epsg_def_ex (filter, first, last, 4687, "epsg", 4687,
        "RGPF", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Polynesie_Francaise", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,");
    add_proj4text (p, 1,
        "-0.0183,0.0003,-0.007,-0.0093 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGPF\",DATUM[\"Reseau_Geodesique_de_la_Polynesi");
    add_srs_wkt (p, 1,
        "e_Francaise\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 3,
        "7\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4687\"]]");
    p = add_epsg_def_ex (filter, first, last, 4688, "epsg", 4688,
        "Fatu Iva 72", 1, 1,
        "International 1924", "Greenwich",
        "Fatu_Iva_72", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=347.103,1078.125,2623");
    add_proj4text (p, 1,
        ".922,-33.8875,70.6773,-9.3943,186.074 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fatu Iva 72\",DATUM[\"Fatu_Iva_72\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6688\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4688\"]]");
    p = add_epsg_def_ex (filter, first, last, 4689, "epsg", 4689,
        "IGN63 Hiva Oa", 1, 1,
        "International 1924", "Greenwich",
        "IGN63_Hiva_Oa", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=410.721,55.049,80.746");
    add_proj4text (p, 1,
        ",2.5779,2.3514,0.6664,17.3311 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN63 Hiva Oa\",DATUM[\"IGN63_Hiva_Oa\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6689\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4689\"]]");
    p = add_epsg_def_ex (filter, first, last, 4690, "epsg", 4690,
        "Tahiti 79", 1, 1,
        "International 1924", "Greenwich",
        "Tahiti_79", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=221.525,152.948,176.7");
    add_proj4text (p, 1,
        "68,-2.3847,-1.3896,-0.877,11.4741 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tahiti 79\",DATUM[\"Tahiti_79\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6690\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "90\"]]");
    p = add_epsg_def_ex (filter, first, last, 4691, "epsg", 4691,
        "Moorea 87", 1, 1,
        "International 1924", "Greenwich",
        "Moorea_87", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=215.525,149.593,176.2");
    add_proj4text (p, 1,
        "29,-3.2624,-1.692,-1.1571,10.4773 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Moorea 87\",DATUM[\"Moorea_87\",SPHEROID[\"Inte");
    add_srs_wkt (p, 1,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6691\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"46");
    add_srs_wkt (p, 6,
        "91\"]]");
    p = add_epsg_def_ex (filter, first, last, 4692, "epsg", 4692,
        "Maupiti 83", 1, 1,
        "International 1924", "Greenwich",
        "Maupiti_83", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Maupiti 83\",DATUM[\"Maupiti_83\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6692\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4692\"]]");
    p = add_epsg_def_ex (filter, first, last, 4693, "epsg", 4693,
        "Nakhl-e Ghanem", 1, 1,
        "WGS 84", "Greenwich",
        "Nakhl-e_Ghanem", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nakhl-e Ghanem\",DATUM[\"Nakhl-e_Ghanem\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7030\"]],AUTHORITY[\"EPSG\",\"6693\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4693\"]]");
    p = add_epsg_def_ex (filter, first, last, 4694, "epsg", 4694,
        "POSGAR 94", 1, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR 94\",DATUM[\"Posiciones_Geodesicas_Argen");
    add_srs_wkt (p, 1,
        "tinas_1994\",SPHEROID[\"WGS 84\",6378137,298.257223563,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6694\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4694\"]]");
    p = add_epsg_def_ex (filter, first, last, 4695, "epsg", 4695,
        "Katanga 1955", 1, 1,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-103.746,-9.614,-25");
    add_proj4text (p, 1,
        "5.95,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Katanga 1955\",DATUM[\"Katanga_1955\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4695\"]]");
    p = add_epsg_def_ex (filter, first, last, 4696, "epsg", 4696,
        "Kasai 1953", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kasai_1953", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kasai 1953\",DATUM[\"Kasai_1953\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6696\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4696\"]]");
    p = add_epsg_def_ex (filter, first, last, 4697, "epsg", 4697,
        "IGC 1962 6th Parallel South", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "IGC_1962_Arc_of_the_6th_Parallel_South", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGC 1962 6th Parallel South\",DATUM[\"IGC_1962_");
    add_srs_wkt (p, 1,
        "Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke 1880 (");
    add_srs_wkt (p, 2,
        "RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6697\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4697");
    add_srs_wkt (p, 7,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4698, "epsg", 4698,
        "IGN 1962 Kerguelen", 1, 1,
        "International 1924", "Greenwich",
        "IGN_1962_Kerguelen", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGN 1962 Kerguelen\",DATUM[\"IGN_1962_Kerguelen");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6698\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4698\"]]");
    p = add_epsg_def_ex (filter, first, last, 4699, "epsg", 4699,
        "Le Pouce 1934", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Le_Pouce_1934", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-770.1,158.4,-498.2");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Le Pouce 1934\",DATUM[\"Le_Pouce_1934\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6699\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4699\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

