/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-alpha.

Abstract: This is an autogenerated C++ header file in order to allow easy
development of the 3MF Library. The implementer of the 3MF Library needs to
derive concrete classes from the abstract classes in this header.

Interface version: 2.4.1

*/


#ifndef __LIB3MF_CPPINTERFACES
#define __LIB3MF_CPPINTERFACES

#include <string>
#include <memory>

#include "lib3mf_types.hpp"



namespace Lib3MF {
namespace Impl {

/**
 Forward declarations of class interfaces
*/
class IBase;
class IWriter;
class IReader;
class IPackagePart;
class IResource;
class IResourceIterator;
class ISliceStackIterator;
class IObjectIterator;
class IMeshObjectIterator;
class IComponentsObjectIterator;
class ITexture2DIterator;
class IBaseMaterialGroupIterator;
class IColorGroupIterator;
class ITexture2DGroupIterator;
class ICompositeMaterialsIterator;
class IMultiPropertyGroupIterator;
class IImage3DIterator;
class IFunctionIterator;
class ILevelSetIterator;
class IMetaData;
class IMetaDataGroup;
class ITriangleSet;
class IObject;
class IMeshObject;
class ILevelSet;
class IBeamLattice;
class IFunctionReference;
class IVolumeDataColor;
class IMaterialMapping;
class IVolumeDataComposite;
class IVolumeDataProperty;
class IVolumeData;
class IComponent;
class IComponentsObject;
class IBeamSet;
class IBaseMaterialGroup;
class IColorGroup;
class ITexture2DGroup;
class ICompositeMaterials;
class IMultiPropertyGroup;
class IImage3D;
class IImageStack;
class IAttachment;
class ITexture2D;
class IImplicitPort;
class IIterator;
class IImplicitPortIterator;
class IImplicitNode;
class IOneInputNode;
class ISinNode;
class ICosNode;
class ITanNode;
class IArcSinNode;
class IArcCosNode;
class IArcTanNode;
class ISinhNode;
class ICoshNode;
class ITanhNode;
class IRoundNode;
class ICeilNode;
class IFloorNode;
class ISignNode;
class IFractNode;
class IAbsNode;
class IExpNode;
class ILogNode;
class ILog2Node;
class ILog10Node;
class ILengthNode;
class ITransposeNode;
class IInverseNode;
class ISqrtNode;
class IResourceIdNode;
class ITwoInputNode;
class IAdditionNode;
class ISubtractionNode;
class IMultiplicationNode;
class IDivisionNode;
class IDotNode;
class ICrossNode;
class IArcTan2Node;
class IMatVecMultiplicationNode;
class IMinNode;
class IMaxNode;
class IFmodNode;
class IModNode;
class IPowNode;
class ISelectNode;
class IClampNode;
class IComposeVectorNode;
class IVectorFromScalarNode;
class IDecomposeVectorNode;
class IComposeMatrixNode;
class IMatrixFromRowsNode;
class IMatrixFromColumnsNode;
class IConstantNode;
class IConstVecNode;
class IConstMatNode;
class IMeshNode;
class IUnsignedMeshNode;
class IFunctionCallNode;
class INodeIterator;
class IFunction;
class IImplicitFunction;
class IFunctionFromImage3D;
class IBuildItem;
class IBuildItemIterator;
class ISlice;
class ISliceStack;
class IConsumer;
class IAccessRight;
class IContentEncryptionParams;
class IResourceData;
class IResourceDataGroup;
class IKeyStore;
class IModel;



/*************************************************************************************************************************
 Parameter Cache definitions
**************************************************************************************************************************/

class ParameterCache {
	public:
		virtual ~ParameterCache() {}
};

template <class T1> class ParameterCache_1 : public ParameterCache {
	private:
		T1 m_param1;
	public:
		ParameterCache_1 (const T1 & param1)
			: m_param1 (param1)
		{
		}

		void retrieveData (T1 & param1)
		{
			param1 = m_param1;
		}
};

template <class T1, class T2> class ParameterCache_2 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
	public:
		ParameterCache_2 (const T1 & param1, const T2 & param2)
			: m_param1 (param1), m_param2 (param2)
		{
		}

		void retrieveData (T1 & param1, T2 & param2)
		{
			param1 = m_param1;
			param2 = m_param2;
		}
};

template <class T1, class T2, class T3> class ParameterCache_3 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
		T3 m_param3;
	public:
		ParameterCache_3 (const T1 & param1, const T2 & param2, const T3 & param3)
			: m_param1 (param1), m_param2 (param2), m_param3 (param3)
		{
		}

		void retrieveData (T1 & param1, T2 & param2, T3 & param3)
		{
			param1 = m_param1;
			param2 = m_param2;
			param3 = m_param3;
		}
};

template <class T1, class T2, class T3, class T4> class ParameterCache_4 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
		T3 m_param3;
		T4 m_param4;
	public:
		ParameterCache_4 (const T1 & param1, const T2 & param2, const T3 & param3, const T4 & param4)
			: m_param1 (param1), m_param2 (param2), m_param3 (param3), m_param4 (param4)
		{
		}

		void retrieveData (T1 & param1, T2 & param2, T3 & param3, T4 & param4)
		{
			param1 = m_param1;
			param2 = m_param2;
			param3 = m_param3;
			param4 = m_param4;
		}
};


/*************************************************************************************************************************
 Class interface for Base 
**************************************************************************************************************************/

class IBase {
private:
	std::unique_ptr<ParameterCache> m_ParameterCache;
public:
	/**
	* IBase::~IBase - virtual destructor of IBase
	*/
	virtual ~IBase() {};

	/**
	* IBase::ReleaseBaseClassInterface - Releases ownership of a base class interface. Deletes the reference, if necessary.
	* @param[in] pIBase - The base class instance to release
	*/
	static void ReleaseBaseClassInterface(IBase* pIBase)
	{
		if (pIBase) {
			pIBase->DecRefCount();
		}
	};

	/**
	* IBase::AcquireBaseClassInterface - Acquires shared ownership of a base class interface.
	* @param[in] pIBase - The base class instance to acquire
	*/
	static void AcquireBaseClassInterface(IBase* pIBase)
	{
		if (pIBase) {
			pIBase->IncRefCount();
		}
	};


	/**
	* IBase::GetLastErrorMessage - Returns the last error registered of this class instance
	* @param[out] sErrorMessage - Message of the last error registered
	* @return Has an error been registered already
	*/
	virtual bool GetLastErrorMessage(std::string & sErrorMessage) = 0;

	/**
	* IBase::ClearErrorMessages - Clears all registered messages of this class instance
	*/
	virtual void ClearErrorMessages() = 0;

	/**
	* IBase::RegisterErrorMessage - Registers an error message with this class instance
	* @param[in] sErrorMessage - Error message to register
	*/
	virtual void RegisterErrorMessage(const std::string & sErrorMessage) = 0;

	/**
	* IBase::IncRefCount - Increases the reference count of a class instance
	*/
	virtual void IncRefCount() = 0;

	/**
	* IBase::DecRefCount - Decreases the reference count of a class instance and free releases it, if the last reference has been removed
	* @return Has the object been released
	*/
	virtual bool DecRefCount() = 0;

	/**
	* IBase::_setCache - set parameter cache of object
	*/
	void _setCache(ParameterCache * pCache)
	{
		m_ParameterCache.reset(pCache);
	}

	/**
	* IBase::_getCache - returns parameter cache of object
	*/
	ParameterCache* _getCache()
	{
		return m_ParameterCache.get();
	}

	/**
	* IBase::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	virtual Lib3MF_uint64 ClassTypeId() = 0;
};


/**
 Definition of a shared pointer class for IBase
*/
template<class T>
class IBaseSharedPtr : public std::shared_ptr<T>
{
public:
	explicit IBaseSharedPtr(T* t = nullptr)
		: std::shared_ptr<T>(t, IBase::ReleaseBaseClassInterface)
	{
		t->IncRefCount();
	}

	// Reset function, as it also needs to properly set the deleter.
	void reset(T* t = nullptr)
	{
		std::shared_ptr<T>::reset(t, IBase::ReleaseBaseClassInterface);
	}

	// Get-function that increases the Base class's reference count
	T* getCoOwningPtr()
	{
		T* t = this->get();
		t->IncRefCount();
		return t;
	}
};


typedef IBaseSharedPtr<IBase> PIBase;


/*************************************************************************************************************************
 Class interface for Writer 
**************************************************************************************************************************/

class IWriter : public virtual IBase {
public:
	/**
	* IWriter::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE76F642F363FD7E9UL; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
	}

	/**
	* IWriter::WriteToFile - Writes out the model as file. The file type is specified by the Model Writer class.
	* @param[in] sFilename - Filename to write into
	*/
	virtual void WriteToFile(const std::string & sFilename) = 0;

	/**
	* IWriter::GetStreamSize - Retrieves the size of the full 3MF file stream.
	* @return the stream size
	*/
	virtual Lib3MF_uint64 GetStreamSize() = 0;

	/**
	* IWriter::WriteToBuffer - Writes out the 3MF file into a memory buffer
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of buffer to write into
	*/
	virtual void WriteToBuffer(Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IWriter::WriteToCallback - Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	* @param[in] pTheWriteCallback - callback function
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void WriteToCallback(const Lib3MF::WriteCallback pTheWriteCallback, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - callback function
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	virtual void SetProgressCallback(const Lib3MF::ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::GetDecimalPrecision - Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @return The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	virtual Lib3MF_uint32 GetDecimalPrecision() = 0;

	/**
	* IWriter::SetDecimalPrecision - Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	virtual void SetDecimalPrecision(const Lib3MF_uint32 nDecimalPrecision) = 0;

	/**
	* IWriter::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	virtual void SetStrictModeActive(const bool bStrictModeActive) = 0;

	/**
	* IWriter::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	virtual bool GetStrictModeActive() = 0;

	/**
	* IWriter::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	virtual std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode) = 0;

	/**
	* IWriter::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	virtual Lib3MF_uint32 GetWarningCount() = 0;

	/**
	* IWriter::AddKeyWrappingCallback - Registers a callback to deal with data key encryption/decryption from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void AddKeyWrappingCallback(const std::string & sConsumerID, const Lib3MF::KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void SetContentEncryptionCallback(const Lib3MF::ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

};

typedef IBaseSharedPtr<IWriter> PIWriter;


/*************************************************************************************************************************
 Class interface for Reader 
**************************************************************************************************************************/

class IReader : public virtual IBase {
public:
	/**
	* IReader::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2D86831DA59FBE72UL; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
	}

	/**
	* IReader::ReadFromFile - Reads a model from a file. The file type is specified by the Model Reader class
	* @param[in] sFilename - Filename to read from
	*/
	virtual void ReadFromFile(const std::string & sFilename) = 0;

	/**
	* IReader::ReadFromBuffer - Reads a model from a memory buffer.
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[in] pBufferBuffer - Buffer to read from
	*/
	virtual void ReadFromBuffer(const Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IReader::ReadFromCallback - Reads a model and from the data provided by a callback function
	* @param[in] pTheReadCallback - callback function
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void ReadFromCallback(const Lib3MF::ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - callback function
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	virtual void SetProgressCallback(const Lib3MF::ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::AddRelationToRead - Adds a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	virtual void AddRelationToRead(const std::string & sRelationShipType) = 0;

	/**
	* IReader::RemoveRelationToRead - Removes a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	virtual void RemoveRelationToRead(const std::string & sRelationShipType) = 0;

	/**
	* IReader::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	virtual void SetStrictModeActive(const bool bStrictModeActive) = 0;

	/**
	* IReader::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	virtual bool GetStrictModeActive() = 0;

	/**
	* IReader::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	virtual std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode) = 0;

	/**
	* IReader::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	virtual Lib3MF_uint32 GetWarningCount() = 0;

	/**
	* IReader::AddKeyWrappingCallback - Registers a callback to deal with key wrapping mechanism from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void AddKeyWrappingCallback(const std::string & sConsumerID, const Lib3MF::KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void SetContentEncryptionCallback(const Lib3MF::ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

};

typedef IBaseSharedPtr<IReader> PIReader;


/*************************************************************************************************************************
 Class interface for PackagePart 
**************************************************************************************************************************/

class IPackagePart : public virtual IBase {
public:
	/**
	* IPackagePart::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE55A826D377483EUL; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
	}

	/**
	* IPackagePart::GetPath - Returns the absolute path of this PackagePart.
	* @return Returns the absolute path of this PackagePart
	*/
	virtual std::string GetPath() = 0;

	/**
	* IPackagePart::SetPath - Sets the absolute path of this PackagePart.
	* @param[in] sPath - Sets the absolute path of this PackagePart.
	*/
	virtual void SetPath(const std::string & sPath) = 0;

};

typedef IBaseSharedPtr<IPackagePart> PIPackagePart;


/*************************************************************************************************************************
 Class interface for Resource 
**************************************************************************************************************************/

class IResource : public virtual IBase {
public:
	/**
	* IResource::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xDFE3889D1B269CBBUL; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
	}

	/**
	* IResource::GetResourceID - Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	* @return Retrieves the unique id of this resource within a package.
	*/
	virtual Lib3MF_uint32 GetResourceID() = 0;

	/**
	* IResource::GetUniqueResourceID - Retrieves the unique id of this resource within a package.
	* @return Retrieves the unique id of this resource within a package.
	*/
	virtual Lib3MF_uint32 GetUniqueResourceID() = 0;

	/**
	* IResource::PackagePart - Returns the PackagePart within which this resource resides
	* @return the PackagePart within which this resource resides.
	*/
	virtual IPackagePart * PackagePart() = 0;

	/**
	* IResource::SetPackagePart - Sets the new PackagePart within which this resource resides
	* @param[in] pPackagePart - the new PackagePart within which this resource resides.
	*/
	virtual void SetPackagePart(IPackagePart* pPackagePart) = 0;

	/**
	* IResource::GetModelResourceID - Retrieves the id of this resource within a model.
	* @return Retrieves the id of this resource within a model.
	*/
	virtual Lib3MF_uint32 GetModelResourceID() = 0;

};

typedef IBaseSharedPtr<IResource> PIResource;


/*************************************************************************************************************************
 Class interface for ResourceIterator 
**************************************************************************************************************************/

class IResourceIterator : public virtual IBase {
public:
	/**
	* IResourceIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x460F3515E2621DBEUL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
	}

	/**
	* IResourceIterator::MoveNext - Iterates to the next resource in the list.
	* @return Iterates to the next resource in the list.
	*/
	virtual bool MoveNext() = 0;

	/**
	* IResourceIterator::MovePrevious - Iterates to the previous resource in the list.
	* @return Iterates to the previous resource in the list.
	*/
	virtual bool MovePrevious() = 0;

	/**
	* IResourceIterator::GetCurrent - Returns the resource the iterator points at.
	* @return returns the resource instance.
	*/
	virtual IResource * GetCurrent() = 0;

	/**
	* IResourceIterator::Clone - Creates a new resource iterator with the same resource list.
	* @return returns the cloned Iterator instance
	*/
	virtual IResourceIterator * Clone() = 0;

	/**
	* IResourceIterator::Count - Returns the number of resoucres the iterator captures.
	* @return returns the number of resoucres the iterator captures.
	*/
	virtual Lib3MF_uint64 Count() = 0;

};

typedef IBaseSharedPtr<IResourceIterator> PIResourceIterator;


/*************************************************************************************************************************
 Class interface for SliceStackIterator 
**************************************************************************************************************************/

class ISliceStackIterator : public virtual IResourceIterator {
public:
	/**
	* ISliceStackIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x69684DB99FA813F6UL; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
	}

	/**
	* ISliceStackIterator::GetCurrentSliceStack - Returns the SliceStack the iterator points at.
	* @return returns the SliceStack instance.
	*/
	virtual ISliceStack * GetCurrentSliceStack() = 0;

};

typedef IBaseSharedPtr<ISliceStackIterator> PISliceStackIterator;


/*************************************************************************************************************************
 Class interface for ObjectIterator 
**************************************************************************************************************************/

class IObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xDE92510BD2112288UL; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
	}

	/**
	* IObjectIterator::GetCurrentObject - Returns the Object the iterator points at.
	* @return returns the Object instance.
	*/
	virtual IObject * GetCurrentObject() = 0;

};

typedef IBaseSharedPtr<IObjectIterator> PIObjectIterator;


/*************************************************************************************************************************
 Class interface for MeshObjectIterator 
**************************************************************************************************************************/

class IMeshObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IMeshObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xF4196034E2B9FDE6UL; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
	}

	/**
	* IMeshObjectIterator::GetCurrentMeshObject - Returns the MeshObject the iterator points at.
	* @return returns the MeshObject instance.
	*/
	virtual IMeshObject * GetCurrentMeshObject() = 0;

};

typedef IBaseSharedPtr<IMeshObjectIterator> PIMeshObjectIterator;


/*************************************************************************************************************************
 Class interface for ComponentsObjectIterator 
**************************************************************************************************************************/

class IComponentsObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IComponentsObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x564DE4217ED7614AUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
	}

	/**
	* IComponentsObjectIterator::GetCurrentComponentsObject - Returns the ComponentsObject the iterator points at.
	* @return returns the ComponentsObject instance.
	*/
	virtual IComponentsObject * GetCurrentComponentsObject() = 0;

};

typedef IBaseSharedPtr<IComponentsObjectIterator> PIComponentsObjectIterator;


/*************************************************************************************************************************
 Class interface for Texture2DIterator 
**************************************************************************************************************************/

class ITexture2DIterator : public virtual IResourceIterator {
public:
	/**
	* ITexture2DIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4BD32B4870FFC03BUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
	}

	/**
	* ITexture2DIterator::GetCurrentTexture2D - Returns the Texture2D the iterator points at.
	* @return returns the Texture2D instance.
	*/
	virtual ITexture2D * GetCurrentTexture2D() = 0;

};

typedef IBaseSharedPtr<ITexture2DIterator> PITexture2DIterator;


/*************************************************************************************************************************
 Class interface for BaseMaterialGroupIterator 
**************************************************************************************************************************/

class IBaseMaterialGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IBaseMaterialGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x65E6EDD9362C79CBUL; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
	}

	/**
	* IBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup - Returns the MaterialGroup the iterator points at.
	* @return returns the BaseMaterialGroup instance.
	*/
	virtual IBaseMaterialGroup * GetCurrentBaseMaterialGroup() = 0;

};

typedef IBaseSharedPtr<IBaseMaterialGroupIterator> PIBaseMaterialGroupIterator;


/*************************************************************************************************************************
 Class interface for ColorGroupIterator 
**************************************************************************************************************************/

class IColorGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IColorGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x10274A1757C729C0UL; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
	}

	/**
	* IColorGroupIterator::GetCurrentColorGroup - Returns the ColorGroup the iterator points at.
	* @return returns the ColorGroup instance.
	*/
	virtual IColorGroup * GetCurrentColorGroup() = 0;

};

typedef IBaseSharedPtr<IColorGroupIterator> PIColorGroupIterator;


/*************************************************************************************************************************
 Class interface for Texture2DGroupIterator 
**************************************************************************************************************************/

class ITexture2DGroupIterator : public virtual IResourceIterator {
public:
	/**
	* ITexture2DGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x30D55F4DB88FE0CAUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
	}

	/**
	* ITexture2DGroupIterator::GetCurrentTexture2DGroup - Returns the Texture2DGroup the iterator points at.
	* @return returns the Texture2DGroup instance.
	*/
	virtual ITexture2DGroup * GetCurrentTexture2DGroup() = 0;

};

typedef IBaseSharedPtr<ITexture2DGroupIterator> PITexture2DGroupIterator;


/*************************************************************************************************************************
 Class interface for CompositeMaterialsIterator 
**************************************************************************************************************************/

class ICompositeMaterialsIterator : public virtual IResourceIterator {
public:
	/**
	* ICompositeMaterialsIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA99CC6C3F70FB6F9UL; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
	}

	/**
	* ICompositeMaterialsIterator::GetCurrentCompositeMaterials - Returns the CompositeMaterials the iterator points at.
	* @return returns the CompositeMaterials instance.
	*/
	virtual ICompositeMaterials * GetCurrentCompositeMaterials() = 0;

};

typedef IBaseSharedPtr<ICompositeMaterialsIterator> PICompositeMaterialsIterator;


/*************************************************************************************************************************
 Class interface for MultiPropertyGroupIterator 
**************************************************************************************************************************/

class IMultiPropertyGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IMultiPropertyGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC2BDF5D8CBBDB1F0UL; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
	}

	/**
	* IMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup - Returns the MultiPropertyGroup the iterator points at.
	* @return returns the MultiPropertyGroup instance.
	*/
	virtual IMultiPropertyGroup * GetCurrentMultiPropertyGroup() = 0;

};

typedef IBaseSharedPtr<IMultiPropertyGroupIterator> PIMultiPropertyGroupIterator;


/*************************************************************************************************************************
 Class interface for Image3DIterator 
**************************************************************************************************************************/

class IImage3DIterator : public virtual IResourceIterator {
public:
	/**
	* IImage3DIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC4B8EC00A82BF336UL; // First 64 bits of SHA1 of a string: "Lib3MF::Image3DIterator"
	}

	/**
	* IImage3DIterator::GetCurrentImage3D - Returns the Image3D the iterator points at.
	* @return returns the Image3D instance.
	*/
	virtual IImage3D * GetCurrentImage3D() = 0;

};

typedef IBaseSharedPtr<IImage3DIterator> PIImage3DIterator;


/*************************************************************************************************************************
 Class interface for FunctionIterator 
**************************************************************************************************************************/

class IFunctionIterator : public virtual IResourceIterator {
public:
	/**
	* IFunctionIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x40E9035363ACE65EUL; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionIterator"
	}

	/**
	* IFunctionIterator::GetCurrentFunction - Returns the Function the iterator points at.
	* @return returns the Function instance.
	*/
	virtual IFunction * GetCurrentFunction() = 0;

};

typedef IBaseSharedPtr<IFunctionIterator> PIFunctionIterator;


/*************************************************************************************************************************
 Class interface for LevelSetIterator 
**************************************************************************************************************************/

class ILevelSetIterator : public virtual IResourceIterator {
public:
	/**
	* ILevelSetIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA0C005C035D5371DUL; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSetIterator"
	}

	/**
	* ILevelSetIterator::GetCurrentLevelSet - Returns the LevelSet the iterator points at.
	* @return returns the MeshObject instance.
	*/
	virtual ILevelSet * GetCurrentLevelSet() = 0;

};

typedef IBaseSharedPtr<ILevelSetIterator> PILevelSetIterator;


/*************************************************************************************************************************
 Class interface for MetaData 
**************************************************************************************************************************/

class IMetaData : public virtual IBase {
public:
	/**
	* IMetaData::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD17716D063DE2C22UL; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
	}

	/**
	* IMetaData::GetNameSpace - returns the namespace URL of the metadata
	* @return the namespace URL of the metadata
	*/
	virtual std::string GetNameSpace() = 0;

	/**
	* IMetaData::SetNameSpace - sets a new namespace URL of the metadata
	* @param[in] sNameSpace - the new namespace URL of the metadata
	*/
	virtual void SetNameSpace(const std::string & sNameSpace) = 0;

	/**
	* IMetaData::GetName - returns the name of a metadata
	* @return the name of the metadata
	*/
	virtual std::string GetName() = 0;

	/**
	* IMetaData::SetName - sets a new name of a metadata
	* @param[in] sName - the new name of the metadata
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IMetaData::GetKey - returns the (namespace+name) of a metadata
	* @return the key (namespace+name) of the metadata
	*/
	virtual std::string GetKey() = 0;

	/**
	* IMetaData::GetMustPreserve - returns, whether a metadata must be preserved
	* @return returns, whether a metadata must be preserved
	*/
	virtual bool GetMustPreserve() = 0;

	/**
	* IMetaData::SetMustPreserve - sets whether a metadata must be preserved
	* @param[in] bMustPreserve - a new value whether a metadata must be preserved
	*/
	virtual void SetMustPreserve(const bool bMustPreserve) = 0;

	/**
	* IMetaData::GetType - returns the type of a metadata
	* @return the type of the metadata
	*/
	virtual std::string GetType() = 0;

	/**
	* IMetaData::SetType - sets a new type of a metadata. This must be a simple XML type
	* @param[in] sType - a new type of the metadata
	*/
	virtual void SetType(const std::string & sType) = 0;

	/**
	* IMetaData::GetValue - returns the value of the metadata
	* @return the value of the metadata
	*/
	virtual std::string GetValue() = 0;

	/**
	* IMetaData::SetValue - sets a new value of the metadata
	* @param[in] sValue - a new value of the metadata
	*/
	virtual void SetValue(const std::string & sValue) = 0;

};

typedef IBaseSharedPtr<IMetaData> PIMetaData;


/*************************************************************************************************************************
 Class interface for MetaDataGroup 
**************************************************************************************************************************/

class IMetaDataGroup : public virtual IBase {
public:
	/**
	* IMetaDataGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC3B85369E9B25D3UL; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
	}

	/**
	* IMetaDataGroup::GetMetaDataCount - returns the number of metadata in this metadatagroup
	* @return returns the number metadata
	*/
	virtual Lib3MF_uint32 GetMetaDataCount() = 0;

	/**
	* IMetaDataGroup::GetMetaData - returns a metadata value within this metadatagroup
	* @param[in] nIndex - Index of the Metadata.
	* @return an instance of the metadata
	*/
	virtual IMetaData * GetMetaData(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMetaDataGroup::GetMetaDataByKey - returns a metadata value within this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the Metadata
	* @return an instance of the metadata
	*/
	virtual IMetaData * GetMetaDataByKey(const std::string & sNameSpace, const std::string & sName) = 0;

	/**
	* IMetaDataGroup::RemoveMetaDataByIndex - removes metadata by index from the model.
	* @param[in] nIndex -  Index of the metadata to remove
	*/
	virtual void RemoveMetaDataByIndex(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMetaDataGroup::RemoveMetaData - removes metadata from the model.
	* @param[in] pTheMetaData - The metadata to remove
	*/
	virtual void RemoveMetaData(IMetaData* pTheMetaData) = 0;

	/**
	* IMetaDataGroup::AddMetaData - adds a new metadata to this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the metadata
	* @param[in] sValue - the value of the metadata
	* @param[in] sType - the type of the metadata
	* @param[in] bMustPreserve - should the metadata be preserved
	* @return a new instance of the metadata
	*/
	virtual IMetaData * AddMetaData(const std::string & sNameSpace, const std::string & sName, const std::string & sValue, const std::string & sType, const bool bMustPreserve) = 0;

};

typedef IBaseSharedPtr<IMetaDataGroup> PIMetaDataGroup;


/*************************************************************************************************************************
 Class interface for TriangleSet 
**************************************************************************************************************************/

class ITriangleSet : public virtual IBase {
public:
	/**
	* ITriangleSet::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x5950BB3EE8A82090UL; // First 64 bits of SHA1 of a string: "Lib3MF::TriangleSet"
	}

	/**
	* ITriangleSet::SetName - sets the name of the triangle set
	* @param[in] sName - the new name
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* ITriangleSet::GetName - returns the name of the triangle set
	* @return returns the name
	*/
	virtual std::string GetName() = 0;

	/**
	* ITriangleSet::SetIdentifier - sets the identifier of the triangle set.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* ITriangleSet::GetIdentifier - returns the identifier of the triangle set
	* @return returns the identifier
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* ITriangleSet::AddTriangle - adds a triangle to the set. Does nothing if triangle is already in the set.
	* @param[in] nTriangleIndex - Triangle index to add. MUST be between 0 and TriangleCount - 1.
	*/
	virtual void AddTriangle(const Lib3MF_uint32 nTriangleIndex) = 0;

	/**
	* ITriangleSet::RemoveTriangle - removes a triangle from the set
	* @param[in] nTriangleIndex - Triangle index to remove. MUST be between 0 and TriangleCount - 1.
	*/
	virtual void RemoveTriangle(const Lib3MF_uint32 nTriangleIndex) = 0;

	/**
	* ITriangleSet::Clear - clears all triangles from the list
	*/
	virtual void Clear() = 0;

	/**
	* ITriangleSet::SetTriangleList - Sets all triangles in the list, while clearing old values. Duplicates will be merged.
	* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
	* @param[in] pTriangleIndicesBuffer - Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	*/
	virtual void SetTriangleList(const Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer) = 0;

	/**
	* ITriangleSet::GetTriangleList - Retrieves all the triangles in the TriangleSet
	* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
	* @param[out] pTriangleIndicesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pTriangleIndicesBuffer - uint32 buffer of retrieves the indices of the triangles in this TriangleSet
	*/
	virtual void GetTriangleList(Lib3MF_uint64 nTriangleIndicesBufferSize, Lib3MF_uint64* pTriangleIndicesNeededCount, Lib3MF_uint32 * pTriangleIndicesBuffer) = 0;

	/**
	* ITriangleSet::AddTriangleList - Adds multiple triangles in the list. Duplicates will be merged.
	* @param[in] nTriangleIndicesBufferSize - Number of elements in buffer
	* @param[in] pTriangleIndicesBuffer - Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	*/
	virtual void AddTriangleList(const Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer) = 0;

	/**
	* ITriangleSet::Merge - Merges another Triangle set.
	* @param[in] pOtherTriangleSet - Other triangle set to merge.
	* @param[in] bDeleteOther - Flag if other triangle set is getting removed.
	*/
	virtual void Merge(ITriangleSet* pOtherTriangleSet, const bool bDeleteOther) = 0;

	/**
	* ITriangleSet::DeleteSet - Deletes the whole set from the mesh.
	*/
	virtual void DeleteSet() = 0;

	/**
	* ITriangleSet::Duplicate - Duplicates the set in the mesh.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	* @return Copy of the triangle set.
	*/
	virtual ITriangleSet * Duplicate(const std::string & sIdentifier) = 0;

};

typedef IBaseSharedPtr<ITriangleSet> PITriangleSet;


/*************************************************************************************************************************
 Class interface for Object 
**************************************************************************************************************************/

class IObject : public virtual IResource {
public:
	/**
	* IObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2DA2136F577A779CUL; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
	}

	/**
	* IObject::GetType - Retrieves an object's type
	* @return returns object type enum.
	*/
	virtual Lib3MF::eObjectType GetType() = 0;

	/**
	* IObject::SetType - Sets an object's type
	* @param[in] eObjectType - object type enum.
	*/
	virtual void SetType(const Lib3MF::eObjectType eObjectType) = 0;

	/**
	* IObject::GetName - Retrieves an object's name
	* @return returns object name.
	*/
	virtual std::string GetName() = 0;

	/**
	* IObject::SetName - Sets an object's name string
	* @param[in] sName - new object name.
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IObject::GetPartNumber - Retrieves an object's part number
	* @return returns object part number.
	*/
	virtual std::string GetPartNumber() = 0;

	/**
	* IObject::SetPartNumber - Sets an objects partnumber string
	* @param[in] sPartNumber - new object part number.
	*/
	virtual void SetPartNumber(const std::string & sPartNumber) = 0;

	/**
	* IObject::IsMeshObject - Retrieves, if an object is a mesh object
	* @return returns, whether the object is a mesh object
	*/
	virtual bool IsMeshObject() = 0;

	/**
	* IObject::IsComponentsObject - Retrieves, if an object is a components object
	* @return returns, whether the object is a components object
	*/
	virtual bool IsComponentsObject() = 0;

	/**
	* IObject::IsLevelSetObject - Retrieves, if an object is a level set object
	* @return returns, whether the object is a level set object
	*/
	virtual bool IsLevelSetObject() = 0;

	/**
	* IObject::IsValid - Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
	* @return returns whether the object is a valid object description
	*/
	virtual bool IsValid() = 0;

	/**
	* IObject::SetAttachmentAsThumbnail - Use an existing attachment as thumbnail for this object
	* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
	*/
	virtual void SetAttachmentAsThumbnail(IAttachment* pAttachment) = 0;

	/**
	* IObject::GetThumbnailAttachment - Get the attachment containing the object thumbnail.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	virtual IAttachment * GetThumbnailAttachment() = 0;

	/**
	* IObject::ClearThumbnailAttachment - Clears the attachment. The attachment instance is not removed from the package.
	*/
	virtual void ClearThumbnailAttachment() = 0;

	/**
	* IObject::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

	/**
	* IObject::GetUUID - Retrieves an object's uuid string (see production extension specification)
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return returns object uuid.
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IObject::SetUUID - Sets a build object's uuid string (see production extension specification)
	* @param[in] sUUID - new object uuid string.
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IObject::GetMetaDataGroup - Returns the metadatagroup of this object
	* @return returns an Instance of the metadatagroup of this object
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IObject::SetSlicesMeshResolution - set the meshresolution of the mesh object
	* @param[in] eMeshResolution - meshresolution of this object
	*/
	virtual void SetSlicesMeshResolution(const Lib3MF::eSlicesMeshResolution eMeshResolution) = 0;

	/**
	* IObject::GetSlicesMeshResolution - get the meshresolution of the mesh object
	* @return meshresolution of this object
	*/
	virtual Lib3MF::eSlicesMeshResolution GetSlicesMeshResolution() = 0;

	/**
	* IObject::HasSlices - returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
	* @param[in] bRecursive - check also all referenced objects?
	* @return does the object have a slice stack?
	*/
	virtual bool HasSlices(const bool bRecursive) = 0;

	/**
	* IObject::ClearSliceStack - unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
	*/
	virtual void ClearSliceStack() = 0;

	/**
	* IObject::GetSliceStack - get the Slicestack attached to the object
	* @return returns the slicestack instance
	*/
	virtual ISliceStack * GetSliceStack() = 0;

	/**
	* IObject::AssignSliceStack - assigns a slicestack to the object
	* @param[in] pSliceStackInstance - the new slice stack of this Object
	*/
	virtual void AssignSliceStack(ISliceStack* pSliceStackInstance) = 0;

};

typedef IBaseSharedPtr<IObject> PIObject;


/*************************************************************************************************************************
 Class interface for MeshObject 
**************************************************************************************************************************/

class IMeshObject : public virtual IObject {
public:
	/**
	* IMeshObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x3B3A6DC6EC610497UL; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
	}

	/**
	* IMeshObject::GetVertexCount - Returns the vertex count of a mesh object.
	* @return filled with the vertex count.
	*/
	virtual Lib3MF_uint32 GetVertexCount() = 0;

	/**
	* IMeshObject::GetTriangleCount - Returns the triangle count of a mesh object.
	* @return filled with the triangle count.
	*/
	virtual Lib3MF_uint32 GetTriangleCount() = 0;

	/**
	* IMeshObject::GetVertex - Returns the vertex count of a mesh object.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @return filled with the vertex coordinates.
	*/
	virtual Lib3MF::sPosition GetVertex(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMeshObject::SetVertex - Sets the coordinates of a single vertex of a mesh object
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[in] Coordinates - contains the vertex coordinates.
	*/
	virtual void SetVertex(const Lib3MF_uint32 nIndex, const Lib3MF::sPosition Coordinates) = 0;

	/**
	* IMeshObject::AddVertex - Adds a single vertex to a mesh object
	* @param[in] Coordinates - contains the vertex coordinates.
	* @return Index of the new vertex
	*/
	virtual Lib3MF_uint32 AddVertex(const Lib3MF::sPosition Coordinates) = 0;

	/**
	* IMeshObject::GetVertices - Obtains all vertex positions of a mesh object
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pVerticesBuffer - Position buffer of contains the vertex coordinates.
	*/
	virtual void GetVertices(Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, Lib3MF::sPosition * pVerticesBuffer) = 0;

	/**
	* IMeshObject::GetTriangle - Returns indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @return filled with the triangle indices.
	*/
	virtual Lib3MF::sTriangle GetTriangle(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMeshObject::SetTriangle - Sets the indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Indices - contains the triangle indices.
	*/
	virtual void SetTriangle(const Lib3MF_uint32 nIndex, const Lib3MF::sTriangle Indices) = 0;

	/**
	* IMeshObject::AddTriangle - Adds a single triangle to a mesh object
	* @param[in] Indices - contains the triangle indices.
	* @return Index of the new triangle
	*/
	virtual Lib3MF_uint32 AddTriangle(const Lib3MF::sTriangle Indices) = 0;

	/**
	* IMeshObject::GetTriangleIndices - Get all triangles of a mesh object
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pIndicesBuffer - Triangle buffer of contains the triangle indices.
	*/
	virtual void GetTriangleIndices(Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF::sTriangle * pIndicesBuffer) = 0;

	/**
	* IMeshObject::SetObjectLevelProperty - Sets the property at the object-level of the mesh object.
	* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[in] nPropertyID - the object-level PropertyID.
	*/
	virtual void SetObjectLevelProperty(const Lib3MF_uint32 nUniqueResourceID, const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IMeshObject::GetObjectLevelProperty - Gets the property at the object-level of the mesh object.
	* @param[out] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[out] nPropertyID - the object-level PropertyID.
	* @return Has an object-level property been specified?
	*/
	virtual bool GetObjectLevelProperty(Lib3MF_uint32 & nUniqueResourceID, Lib3MF_uint32 & nPropertyID) = 0;

	/**
	* IMeshObject::SetTriangleProperties - Sets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Properties - contains the triangle properties.
	*/
	virtual void SetTriangleProperties(const Lib3MF_uint32 nIndex, const Lib3MF::sTriangleProperties Properties) = 0;

	/**
	* IMeshObject::GetTriangleProperties - Gets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[out] sProperty - returns the triangle properties.
	*/
	virtual void GetTriangleProperties(const Lib3MF_uint32 nIndex, Lib3MF::sTriangleProperties & sProperty) = 0;

	/**
	* IMeshObject::SetAllTriangleProperties - Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
	* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
	* @param[in] pPropertiesArrayBuffer - contains the triangle properties array. Must have trianglecount elements.
	*/
	virtual void SetAllTriangleProperties(const Lib3MF_uint64 nPropertiesArrayBufferSize, const Lib3MF::sTriangleProperties * pPropertiesArrayBuffer) = 0;

	/**
	* IMeshObject::GetAllTriangleProperties - Gets the properties of all triangles of a mesh object.
	* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
	* @param[out] pPropertiesArrayNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertiesArrayBuffer - TriangleProperties buffer of returns the triangle properties array. Must have trianglecount elements.
	*/
	virtual void GetAllTriangleProperties(Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, Lib3MF::sTriangleProperties * pPropertiesArrayBuffer) = 0;

	/**
	* IMeshObject::ClearAllProperties - Clears all properties of this mesh object (triangle and object-level).
	*/
	virtual void ClearAllProperties() = 0;

	/**
	* IMeshObject::SetGeometry - Set all triangles of a mesh object
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[in] pVerticesBuffer - contains the positions.
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - contains the triangle indices.
	*/
	virtual void SetGeometry(const Lib3MF_uint64 nVerticesBufferSize, const Lib3MF::sPosition * pVerticesBuffer, const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF::sTriangle * pIndicesBuffer) = 0;

	/**
	* IMeshObject::IsManifoldAndOriented - Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
	* @return returns, if the object is oriented and manifold.
	*/
	virtual bool IsManifoldAndOriented() = 0;

	/**
	* IMeshObject::BeamLattice - Retrieves the BeamLattice within this MeshObject.
	* @return the BeamLattice within this MeshObject
	*/
	virtual IBeamLattice * BeamLattice() = 0;

	/**
	* IMeshObject::GetVolumeData - Retrieves the VolumeData of this MeshObject.
	* @return the VolumeData of this MeshObject
	*/
	virtual IVolumeData * GetVolumeData() = 0;

	/**
	* IMeshObject::SetVolumeData - Sets the VolumeData of this MeshObject.
	* @param[in] pTheVolumeData - the VolumeData of this MeshObject
	*/
	virtual void SetVolumeData(IVolumeData* pTheVolumeData) = 0;

	/**
	* IMeshObject::AddTriangleSet - Adds a new triangle set.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	* @param[in] sName - the human readable name. MUST NOT be an empty string
	* @return the new Triangle Set Instance.
	*/
	virtual ITriangleSet * AddTriangleSet(const std::string & sIdentifier, const std::string & sName) = 0;

	/**
	* IMeshObject::HasTriangleSet - Checks if a triangle set exists.
	* @param[in] sIdentifier - the identifier to be found.
	* @return flag if the triangles set exists.
	*/
	virtual bool HasTriangleSet(const std::string & sIdentifier) = 0;

	/**
	* IMeshObject::FindTriangleSet - Finds a new triangle set by identifier. Fails if not existing.
	* @param[in] sIdentifier - the identifier to be found.
	* @return the triangle Set Instance.
	*/
	virtual ITriangleSet * FindTriangleSet(const std::string & sIdentifier) = 0;

	/**
	* IMeshObject::GetTriangleSetCount - Returns number of triangle sets.
	* @return the number of triangle sets of this mesh.
	*/
	virtual Lib3MF_uint32 GetTriangleSetCount() = 0;

	/**
	* IMeshObject::GetTriangleSet - Returns a specific triangle set by index.
	* @param[in] nIndex - the index of the triangle set.
	* @return the triangle Set Instance.
	*/
	virtual ITriangleSet * GetTriangleSet(const Lib3MF_uint32 nIndex) = 0;

};

typedef IBaseSharedPtr<IMeshObject> PIMeshObject;


/*************************************************************************************************************************
 Class interface for LevelSet 
**************************************************************************************************************************/

class ILevelSet : public virtual IObject {
public:
	/**
	* ILevelSet::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE8A7D9C192EFD0E2UL; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSet"
	}

	/**
	* ILevelSet::GetFunction - Returns the function that is used as boundary shape.
	* @return the function to use as boundary shape
	*/
	virtual IFunction * GetFunction() = 0;

	/**
	* ILevelSet::SetFunction - Sets the function to use as boundary shape.
	* @param[in] pTheFunction - the function to use as boundary shape
	*/
	virtual void SetFunction(IFunction* pTheFunction) = 0;

	/**
	* ILevelSet::GetTransform - Returns the transformation matrix into the coordinate system of the referenced Function.
	* @return the transformation matrix
	*/
	virtual Lib3MF::sTransform GetTransform() = 0;

	/**
	* ILevelSet::SetTransform - Sets the transformation matrix into the coordinate system of the referenced Function.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetTransform(const Lib3MF::sTransform Transform) = 0;

	/**
	* ILevelSet::GetChannelName - Returns the name of the function output channel to use.
	* @return the name of the function output channel
	*/
	virtual std::string GetChannelName() = 0;

	/**
	* ILevelSet::SetChannelName - Sets the name of the function output channel to use.
	* @param[in] sChannelName - new name of the function output channel
	*/
	virtual void SetChannelName(const std::string & sChannelName) = 0;

	/**
	* ILevelSet::SetMinFeatureSize - Sets the minimal feature size as a hint for the function evaluator
	* @param[in] dMinFeatureSize - minimal feature size
	*/
	virtual void SetMinFeatureSize(const Lib3MF_double dMinFeatureSize) = 0;

	/**
	* ILevelSet::GetMinFeatureSize - Returns the minimal feature size as a hint for the function evaluator
	* @return minimal feature size
	*/
	virtual Lib3MF_double GetMinFeatureSize() = 0;

	/**
	* ILevelSet::SetFallBackValue - Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @param[in] dFallBackValue - fallback value
	*/
	virtual void SetFallBackValue(const Lib3MF_double dFallBackValue) = 0;

	/**
	* ILevelSet::GetFallBackValue - Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @return fallback value
	*/
	virtual Lib3MF_double GetFallBackValue() = 0;

	/**
	* ILevelSet::SetMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	* @param[in] bMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	*/
	virtual void SetMeshBBoxOnly(const bool bMeshBBoxOnly) = 0;

	/**
	* ILevelSet::GetMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	* @return If set only the bounding box of the mesh is intersected with the boundary
	*/
	virtual bool GetMeshBBoxOnly() = 0;

	/**
	* ILevelSet::SetMesh - Sets the mesh to use as evaluation domain
	* @param[in] pTheMesh - The mesh
	*/
	virtual void SetMesh(IMeshObject* pTheMesh) = 0;

	/**
	* ILevelSet::GetMesh - Returns the mesh that is used as evaluation domain
	* @return The mesh
	*/
	virtual IMeshObject * GetMesh() = 0;

	/**
	* ILevelSet::GetVolumeData - Retrieves the VolumeData this Object.
	* @return the VolumeData of this Object
	*/
	virtual IVolumeData * GetVolumeData() = 0;

	/**
	* ILevelSet::SetVolumeData - Sets the VolumeData of this LevelSet.
	* @param[in] pTheVolumeData - the VolumeData of this MeshObject
	*/
	virtual void SetVolumeData(IVolumeData* pTheVolumeData) = 0;

};

typedef IBaseSharedPtr<ILevelSet> PILevelSet;


/*************************************************************************************************************************
 Class interface for BeamLattice 
**************************************************************************************************************************/

class IBeamLattice : public virtual IBase {
public:
	/**
	* IBeamLattice::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x63B3B461B30B4BA5UL; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
	}

	/**
	* IBeamLattice::GetMinLength - Returns the minimal length of beams for the beamlattice.
	* @return minimal length of beams for the beamlattice
	*/
	virtual Lib3MF_double GetMinLength() = 0;

	/**
	* IBeamLattice::SetMinLength - Sets the minimal length of beams for the beamlattice.
	* @param[in] dMinLength - minimal length of beams for the beamlattice
	*/
	virtual void SetMinLength(const Lib3MF_double dMinLength) = 0;

	/**
	* IBeamLattice::GetClipping - Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[out] eClipMode - contains the clip mode of this mesh
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
	*/
	virtual void GetClipping(Lib3MF::eBeamLatticeClipMode & eClipMode, Lib3MF_uint32 & nUniqueResourceID) = 0;

	/**
	* IBeamLattice::SetClipping - Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[in] eClipMode - contains the clip mode of this mesh
	* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
	*/
	virtual void SetClipping(const Lib3MF::eBeamLatticeClipMode eClipMode, const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IBeamLattice::GetRepresentation - Returns the representation-mesh for the beamlattice of this mesh.
	* @return flag whether the beamlattice has a representation mesh.
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
	*/
	virtual bool GetRepresentation(Lib3MF_uint32 & nUniqueResourceID) = 0;

	/**
	* IBeamLattice::SetRepresentation - Sets the representation-mesh for the beamlattice of this mesh.
	* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
	*/
	virtual void SetRepresentation(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IBeamLattice::GetBallOptions - Returns the ball mode and the default ball radius for the beamlattice of this mesh.
	* @param[out] eBallMode - contains the ball mode of this mesh
	* @param[out] dBallRadius - default ball radius of balls for the beamlattice
	*/
	virtual void GetBallOptions(Lib3MF::eBeamLatticeBallMode & eBallMode, Lib3MF_double & dBallRadius) = 0;

	/**
	* IBeamLattice::SetBallOptions - Sets the ball mode and thedefault ball radius for the beamlattice.
	* @param[in] eBallMode - contains the ball mode of this mesh
	* @param[in] dBallRadius - default ball radius of balls for the beamlattice
	*/
	virtual void SetBallOptions(const Lib3MF::eBeamLatticeBallMode eBallMode, const Lib3MF_double dBallRadius) = 0;

	/**
	* IBeamLattice::GetBeamCount - Returns the beam count of a mesh object.
	* @return filled with the beam count.
	*/
	virtual Lib3MF_uint32 GetBeamCount() = 0;

	/**
	* IBeamLattice::GetBeam - Returns indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @return filled with the beam indices, radii and capmodes.
	*/
	virtual Lib3MF::sBeam GetBeam(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IBeamLattice::AddBeam - Adds a single beam to a mesh object.
	* @param[in] BeamInfo - contains the node indices, radii and capmodes.
	* @return filled with the new Index of the beam.
	*/
	virtual Lib3MF_uint32 AddBeam(const Lib3MF::sBeam BeamInfo) = 0;

	/**
	* IBeamLattice::SetBeam - Sets the indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[in] BeamInfo - filled with the beam indices, radii and capmodes.
	*/
	virtual void SetBeam(const Lib3MF_uint32 nIndex, const Lib3MF::sBeam BeamInfo) = 0;

	/**
	* IBeamLattice::SetBeams - Sets all beam indices, radii and capmodes of a mesh object.
	* @param[in] nBeamInfoBufferSize - Number of elements in buffer
	* @param[in] pBeamInfoBuffer - contains information of a number of  beams
	*/
	virtual void SetBeams(const Lib3MF_uint64 nBeamInfoBufferSize, const Lib3MF::sBeam * pBeamInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBeams - obtains all beam indices, radii and capmodes of a mesh object.
	* @param[in] nBeamInfoBufferSize - Number of elements in buffer
	* @param[out] pBeamInfoNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBeamInfoBuffer - Beam buffer of contains information of all beams
	*/
	virtual void GetBeams(Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, Lib3MF::sBeam * pBeamInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBallCount - Returns the ball count of a mesh object.
	* @return filled with the ball count.
	*/
	virtual Lib3MF_uint32 GetBallCount() = 0;

	/**
	* IBeamLattice::GetBall - Returns index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @return filled with the ball node index and radius.
	*/
	virtual Lib3MF::sBall GetBall(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IBeamLattice::AddBall - Adds a single ball to a mesh object.
	* @param[in] BallInfo - contains the node index and radius.
	* @return filled with the new Index of the ball.
	*/
	virtual Lib3MF_uint32 AddBall(const Lib3MF::sBall BallInfo) = 0;

	/**
	* IBeamLattice::SetBall - Sets the index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[in] BallInfo - filled with the ball node index and radius.
	*/
	virtual void SetBall(const Lib3MF_uint32 nIndex, const Lib3MF::sBall BallInfo) = 0;

	/**
	* IBeamLattice::SetBalls - Sets all ball indices and radii of a mesh object.
	* @param[in] nBallInfoBufferSize - Number of elements in buffer
	* @param[in] pBallInfoBuffer - contains information of a number of  balls
	*/
	virtual void SetBalls(const Lib3MF_uint64 nBallInfoBufferSize, const Lib3MF::sBall * pBallInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBalls - obtains all ball indices and radii of a mesh object.
	* @param[in] nBallInfoBufferSize - Number of elements in buffer
	* @param[out] pBallInfoNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBallInfoBuffer - Ball buffer of contains information of all balls
	*/
	virtual void GetBalls(Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, Lib3MF::sBall * pBallInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBeamSetCount - Returns the number of beamsets of a mesh object.
	* @return filled with the beamset count.
	*/
	virtual Lib3MF_uint32 GetBeamSetCount() = 0;

	/**
	* IBeamLattice::AddBeamSet - Adds an empty beamset to a mesh object
	* @return the new beamset
	*/
	virtual IBeamSet * AddBeamSet() = 0;

	/**
	* IBeamLattice::GetBeamSet - Returns a beamset of a mesh object
	* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
	* @return the requested beamset
	*/
	virtual IBeamSet * GetBeamSet(const Lib3MF_uint32 nIndex) = 0;

};

typedef IBaseSharedPtr<IBeamLattice> PIBeamLattice;


/*************************************************************************************************************************
 Class interface for FunctionReference 
**************************************************************************************************************************/

class IFunctionReference : public virtual IBase {
public:
	/**
	* IFunctionReference::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4DF17E76926221C2UL; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionReference"
	}

	/**
	* IFunctionReference::GetFunctionResourceID - Returns the UniqueResourceID of the Function. Only functions with a 'pos'-input are allowed.
	* @return returns the UniqueResourceID.
	*/
	virtual Lib3MF_uint32 GetFunctionResourceID() = 0;

	/**
	* IFunctionReference::SetFunctionResourceID - Sets the UniqueResourceID to refer to.
	* @param[in] nUniqueResourceID - UniqueResourceID of the function
	*/
	virtual void SetFunctionResourceID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IFunctionReference::GetTransform - Returns the transformation matrix into the coordinate system of the referenced Function.
	* @return the transformation matrix
	*/
	virtual Lib3MF::sTransform GetTransform() = 0;

	/**
	* IFunctionReference::SetTransform - Sets the transformation matrix into the coordinate system of the referenced Function.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetTransform(const Lib3MF::sTransform Transform) = 0;

	/**
	* IFunctionReference::GetChannelName - Returns the name of the function output channel to use.
	* @return the name of the function output channel
	*/
	virtual std::string GetChannelName() = 0;

	/**
	* IFunctionReference::SetChannelName - Sets the name of the function output channel to use.
	* @param[in] sChannelName - new name of the function output channel
	*/
	virtual void SetChannelName(const std::string & sChannelName) = 0;

	/**
	* IFunctionReference::SetMinFeatureSize - Sets the minimal feature size as a hint for the function evaluator
	* @param[in] dMinFeatureSize - minimal feature size
	*/
	virtual void SetMinFeatureSize(const Lib3MF_double dMinFeatureSize) = 0;

	/**
	* IFunctionReference::GetMinFeatureSize - Returns the minimal feature size as a hint for the function evaluator
	* @return minimal feature size
	*/
	virtual Lib3MF_double GetMinFeatureSize() = 0;

	/**
	* IFunctionReference::SetFallBackValue - Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @param[in] dFallBackValue - fallback value
	*/
	virtual void SetFallBackValue(const Lib3MF_double dFallBackValue) = 0;

	/**
	* IFunctionReference::GetFallBackValue - Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @return fallback value
	*/
	virtual Lib3MF_double GetFallBackValue() = 0;

};

typedef IBaseSharedPtr<IFunctionReference> PIFunctionReference;


/*************************************************************************************************************************
 Class interface for VolumeDataColor 
**************************************************************************************************************************/

class IVolumeDataColor : public virtual IFunctionReference {
public:
	/**
	* IVolumeDataColor::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD85B5B6143E787E3UL; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataColor"
	}

};

typedef IBaseSharedPtr<IVolumeDataColor> PIVolumeDataColor;


/*************************************************************************************************************************
 Class interface for MaterialMapping 
**************************************************************************************************************************/

class IMaterialMapping : public virtual IFunctionReference {
public:
	/**
	* IMaterialMapping::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x241FE6B4817C3FE4UL; // First 64 bits of SHA1 of a string: "Lib3MF::MaterialMapping"
	}

};

typedef IBaseSharedPtr<IMaterialMapping> PIMaterialMapping;


/*************************************************************************************************************************
 Class interface for VolumeDataComposite 
**************************************************************************************************************************/

class IVolumeDataComposite : public virtual IBase {
public:
	/**
	* IVolumeDataComposite::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x46F1DAC40581B304UL; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataComposite"
	}

	/**
	* IVolumeDataComposite::GetBaseMaterialGroup - Returns the BaseMaterialGroup used within this volume data item
	* @return The BaseMaterialGroup instance of this VolumeDataComposite element
	*/
	virtual IBaseMaterialGroup * GetBaseMaterialGroup() = 0;

	/**
	* IVolumeDataComposite::SetBaseMaterialGroup - Sets the BaseMaterialGroup to use within this volume data item.
	* @param[in] pBaseMaterialGroupInstance - The new BaseMaterialGroup instance of this VolumeDataComposite element
	*/
	virtual void SetBaseMaterialGroup(IBaseMaterialGroup* pBaseMaterialGroupInstance) = 0;

	/**
	* IVolumeDataComposite::GetMaterialMappingCount - Returns the number of material mappings of this VolumeDataComposite element
	* @return the number of material mappings.
	*/
	virtual Lib3MF_uint32 GetMaterialMappingCount() = 0;

	/**
	* IVolumeDataComposite::GetMaterialMapping - Returns MaterialMappting with given index
	* @param[in] nIndex - Index of the MaterialMapping in question.
	* @return MaterialMapping used in this element
	*/
	virtual IMaterialMapping * GetMaterialMapping(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IVolumeDataComposite::AddMaterialMapping - Adds a the MaterialMapping
	* @param[in] Transform - new transformation matrix
	* @return The new MaterialMapping
	*/
	virtual IMaterialMapping * AddMaterialMapping(const Lib3MF::sTransform Transform) = 0;

	/**
	* IVolumeDataComposite::RemoveMaterialMapping - Removes the MaterialMapping with given index
	* @param[in] nIndex - The index of the MaterialMapping to be removed.
	*/
	virtual void RemoveMaterialMapping(const Lib3MF_uint32 nIndex) = 0;

};

typedef IBaseSharedPtr<IVolumeDataComposite> PIVolumeDataComposite;


/*************************************************************************************************************************
 Class interface for VolumeDataProperty 
**************************************************************************************************************************/

class IVolumeDataProperty : public virtual IFunctionReference {
public:
	/**
	* IVolumeDataProperty::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xFC368AA44ACE42DAUL; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataProperty"
	}

	/**
	* IVolumeDataProperty::GetName - Gets the qualified name of this property.
	* @return The qualified name of this property.
	*/
	virtual std::string GetName() = 0;

	/**
	* IVolumeDataProperty::SetIsRequired - Sets whether this property is required to process this 3MF document instance.
	* @param[in] bIsRequired - New value for whether this property is required to process this 3MF document instance.
	*/
	virtual void SetIsRequired(const bool bIsRequired) = 0;

	/**
	* IVolumeDataProperty::IsRequired - Returns whether this property is required to process this 3MF document instance.
	* @return Is this property required to process this 3MF document instance?
	*/
	virtual bool IsRequired() = 0;

};

typedef IBaseSharedPtr<IVolumeDataProperty> PIVolumeDataProperty;


/*************************************************************************************************************************
 Class interface for VolumeData 
**************************************************************************************************************************/

class IVolumeData : public virtual IResource {
public:
	/**
	* IVolumeData::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9200586FB91587A7UL; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeData"
	}

	/**
	* IVolumeData::GetComposite - Returns the VolumeDataComposite of this VolumeData instance
	* @return filled with the VolumeDataComposite of this VolumeData instance.
	*/
	virtual IVolumeDataComposite * GetComposite() = 0;

	/**
	* IVolumeData::CreateNewComposite - Creates a new VolumeDataComposite for this VolumeData instance
	* @return The new VolumeDataComposite of this VolumeData instance.
	*/
	virtual IVolumeDataComposite * CreateNewComposite() = 0;

	/**
	* IVolumeData::RemoveComposite - Removes the VolumeDataComposite of this VolumeData instance
	*/
	virtual void RemoveComposite() = 0;

	/**
	* IVolumeData::GetColor - Returns the VolumeDataColor of this VolumeData instance
	* @return filled with the VolumeDataColor of this VolumeData instance.
	*/
	virtual IVolumeDataColor * GetColor() = 0;

	/**
	* IVolumeData::CreateNewColor - Creates a new VolumeDataColor for this VolumeData instance
	* @param[in] pTheFunction - Function used in this element
	* @return The new VolumeDataColor of this VolumeData instance.
	*/
	virtual IVolumeDataColor * CreateNewColor(IFunction* pTheFunction) = 0;

	/**
	* IVolumeData::RemoveColor - Removes the VolumeDataColor of this VolumeData instance
	*/
	virtual void RemoveColor() = 0;

	/**
	* IVolumeData::GetPropertyCount - Returns the number of VolumeDataProperty
	* @return the number of VolumeDataProperty-elements within this VolumdeData
	*/
	virtual Lib3MF_uint32 GetPropertyCount() = 0;

	/**
	* IVolumeData::GetProperty - Returns the VolumeDataProperty at a given Index
	* @param[in] nIndex - the index of the VolumeDataProperty to be returned.
	* @return the VolumeDataProperty at the given index.
	*/
	virtual IVolumeDataProperty * GetProperty(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IVolumeData::AddPropertyFromFunction - Adds a new VolumeDataProperty from a Function
	* @param[in] sName - the qualified name (namespace+name) of the Property
	* @param[in] pTheFunction - Function used in this element
	* @return the newly created VolumeDataProperty.
	*/
	virtual IVolumeDataProperty * AddPropertyFromFunction(const std::string & sName, IFunction* pTheFunction) = 0;

	/**
	* IVolumeData::RemoveProperty - Removes the VolumeDataProperty with a given index
	* @param[in] nIndex - the index of the VolumeDataProperty to be removed.
	*/
	virtual void RemoveProperty(const Lib3MF_uint32 nIndex) = 0;

};

typedef IBaseSharedPtr<IVolumeData> PIVolumeData;


/*************************************************************************************************************************
 Class interface for Component 
**************************************************************************************************************************/

class IComponent : public virtual IBase {
public:
	/**
	* IComponent::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4ECDB6A6F69F2BEBUL; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
	}

	/**
	* IComponent::GetObjectResource - Returns the Resource Instance of the component.
	* @return filled with the Resource Instance.
	*/
	virtual IObject * GetObjectResource() = 0;

	/**
	* IComponent::GetObjectResourceID - Returns the UniqueResourceID of the component.
	* @return returns the UniqueResourceID.
	*/
	virtual Lib3MF_uint32 GetObjectResourceID() = 0;

	/**
	* IComponent::GetUUID - returns, whether a component has a UUID and, if true, the component's UUID
	* @param[out] bHasUUID - flag whether the component has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IComponent::SetUUID - sets the component's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IComponent::HasTransform - Returns, if the component has a different transformation than the identity matrix
	* @return if true is returned, the transformation is not equal than the identity
	*/
	virtual bool HasTransform() = 0;

	/**
	* IComponent::GetTransform - Returns the transformation matrix of the component.
	* @return filled with the component transformation matrix
	*/
	virtual Lib3MF::sTransform GetTransform() = 0;

	/**
	* IComponent::SetTransform - Sets the transformation matrix of the component.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetTransform(const Lib3MF::sTransform Transform) = 0;

};

typedef IBaseSharedPtr<IComponent> PIComponent;


/*************************************************************************************************************************
 Class interface for ComponentsObject 
**************************************************************************************************************************/

class IComponentsObject : public virtual IObject {
public:
	/**
	* IComponentsObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6522CF04EB283FEDUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
	}

	/**
	* IComponentsObject::AddComponent - Adds a new component to a components object.
	* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
	* @param[in] Transform - optional transform matrix for the component.
	* @return new component instance
	*/
	virtual IComponent * AddComponent(IObject* pObjectResource, const Lib3MF::sTransform Transform) = 0;

	/**
	* IComponentsObject::GetComponent - Retrieves a component from a component object.
	* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
	* @return component instance
	*/
	virtual IComponent * GetComponent(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IComponentsObject::GetComponentCount - Retrieves a component count of a component object.
	* @return returns the component count
	*/
	virtual Lib3MF_uint32 GetComponentCount() = 0;

};

typedef IBaseSharedPtr<IComponentsObject> PIComponentsObject;


/*************************************************************************************************************************
 Class interface for BeamSet 
**************************************************************************************************************************/

class IBeamSet : public virtual IBase {
public:
	/**
	* IBeamSet::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x30CCDBE90E00B55BUL; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
	}

	/**
	* IBeamSet::SetName - Sets a beamset's name string
	* @param[in] sName - new name of the beamset.
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IBeamSet::GetName - Retrieves a beamset's name string
	* @return returns the name of the beamset.
	*/
	virtual std::string GetName() = 0;

	/**
	* IBeamSet::SetIdentifier - Sets a beamset's identifier string
	* @param[in] sIdentifier - new name of the beamset.
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* IBeamSet::GetIdentifier - Retrieves a beamset's identifier string
	* @return returns the identifier of the beamset.
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* IBeamSet::GetReferenceCount - Retrieves the reference count of a beamset
	* @return returns the reference count
	*/
	virtual Lib3MF_uint32 GetReferenceCount() = 0;

	/**
	* IBeamSet::SetReferences - Sets the references of a beamset
	* @param[in] nReferencesBufferSize - Number of elements in buffer
	* @param[in] pReferencesBuffer - the new indices of all beams in this beamset
	*/
	virtual void SetReferences(const Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer) = 0;

	/**
	* IBeamSet::GetReferences - Retrieves the references of a beamset
	* @param[in] nReferencesBufferSize - Number of elements in buffer
	* @param[out] pReferencesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pReferencesBuffer - uint32 buffer of retrieves the indices of all beams in this beamset
	*/
	virtual void GetReferences(Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer) = 0;

	/**
	* IBeamSet::GetBallReferenceCount - Retrieves the ball reference count of a beamset
	* @return returns the ball reference count
	*/
	virtual Lib3MF_uint32 GetBallReferenceCount() = 0;

	/**
	* IBeamSet::SetBallReferences - Sets the ball references of a beamset
	* @param[in] nBallReferencesBufferSize - Number of elements in buffer
	* @param[in] pBallReferencesBuffer - the new indices of all balls in this beamset
	*/
	virtual void SetBallReferences(const Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer) = 0;

	/**
	* IBeamSet::GetBallReferences - Retrieves the ball references of a beamset
	* @param[in] nBallReferencesBufferSize - Number of elements in buffer
	* @param[out] pBallReferencesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBallReferencesBuffer - uint32 buffer of retrieves the indices of all balls in this beamset
	*/
	virtual void GetBallReferences(Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer) = 0;

};

typedef IBaseSharedPtr<IBeamSet> PIBeamSet;


/*************************************************************************************************************************
 Class interface for BaseMaterialGroup 
**************************************************************************************************************************/

class IBaseMaterialGroup : public virtual IResource {
public:
	/**
	* IBaseMaterialGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB27D4656E16609FAUL; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
	}

	/**
	* IBaseMaterialGroup::GetCount - Retrieves the count of base materials in the material group.
	* @return returns the count of base materials.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IBaseMaterialGroup::GetAllPropertyIDs - returns all the PropertyIDs of all materials in this group
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the material in the material group.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IBaseMaterialGroup::AddMaterial - Adds a new material to the material group
	* @param[in] sName - new name of the base material.
	* @param[in] DisplayColor - Display color of the material
	* @return returns new PropertyID of the new material in the material group.
	*/
	virtual Lib3MF_uint32 AddMaterial(const std::string & sName, const Lib3MF::sColor DisplayColor) = 0;

	/**
	* IBaseMaterialGroup::RemoveMaterial - Removes a material from the material group.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	*/
	virtual void RemoveMaterial(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IBaseMaterialGroup::GetName - Returns the base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return returns the name of the base material.
	*/
	virtual std::string GetName(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IBaseMaterialGroup::SetName - Sets a base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] sName - new name of the base material.
	*/
	virtual void SetName(const Lib3MF_uint32 nPropertyID, const std::string & sName) = 0;

	/**
	* IBaseMaterialGroup::SetDisplayColor - Sets a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] TheColor - The base material's display color
	*/
	virtual void SetDisplayColor(const Lib3MF_uint32 nPropertyID, const Lib3MF::sColor TheColor) = 0;

	/**
	* IBaseMaterialGroup::GetDisplayColor - Returns a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return The base material's display color
	*/
	virtual Lib3MF::sColor GetDisplayColor(const Lib3MF_uint32 nPropertyID) = 0;

};

typedef IBaseSharedPtr<IBaseMaterialGroup> PIBaseMaterialGroup;


/*************************************************************************************************************************
 Class interface for ColorGroup 
**************************************************************************************************************************/

class IColorGroup : public virtual IResource {
public:
	/**
	* IColorGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD085FB2E49CDB5B1UL; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
	}

	/**
	* IColorGroup::GetCount - Retrieves the count of base materials in this Color Group.
	* @return returns the count of colors within this color group.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IColorGroup::GetAllPropertyIDs - returns all the PropertyIDs of all colors within this group
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the color in the color group.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IColorGroup::AddColor - Adds a new value.
	* @param[in] TheColor - The new color
	* @return PropertyID of the new color within this color group.
	*/
	virtual Lib3MF_uint32 AddColor(const Lib3MF::sColor TheColor) = 0;

	/**
	* IColorGroup::RemoveColor - Removes a color from the color group.
	* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
	*/
	virtual void RemoveColor(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IColorGroup::SetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[in] TheColor - The color
	*/
	virtual void SetColor(const Lib3MF_uint32 nPropertyID, const Lib3MF::sColor TheColor) = 0;

	/**
	* IColorGroup::GetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @return The color
	*/
	virtual Lib3MF::sColor GetColor(const Lib3MF_uint32 nPropertyID) = 0;

};

typedef IBaseSharedPtr<IColorGroup> PIColorGroup;


/*************************************************************************************************************************
 Class interface for Texture2DGroup 
**************************************************************************************************************************/

class ITexture2DGroup : public virtual IResource {
public:
	/**
	* ITexture2DGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xBC1208397E37055DUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
	}

	/**
	* ITexture2DGroup::GetCount - Retrieves the count of tex2coords in the Texture2DGroup.
	* @return returns the count of tex2coords.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* ITexture2DGroup::GetAllPropertyIDs - returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the tex2coords in the Texture2DGroup.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* ITexture2DGroup::AddTex2Coord - Adds a new tex2coord to the Texture2DGroup
	* @param[in] UVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @return returns new PropertyID of the new tex2coord in the Texture2DGroup.
	*/
	virtual Lib3MF_uint32 AddTex2Coord(const Lib3MF::sTex2Coord UVCoordinate) = 0;

	/**
	* ITexture2DGroup::GetTex2Coord - Obtains a tex2coord to the Texture2DGroup
	* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
	* @return The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	*/
	virtual Lib3MF::sTex2Coord GetTex2Coord(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ITexture2DGroup::RemoveTex2Coord - Removes a tex2coords from the Texture2DGroup.
	* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
	*/
	virtual void RemoveTex2Coord(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ITexture2DGroup::GetTexture2D - Obtains the texture2D instance of this group.
	* @return the texture2D instance of this group.
	*/
	virtual ITexture2D * GetTexture2D() = 0;

};

typedef IBaseSharedPtr<ITexture2DGroup> PITexture2DGroup;


/*************************************************************************************************************************
 Class interface for CompositeMaterials 
**************************************************************************************************************************/

class ICompositeMaterials : public virtual IResource {
public:
	/**
	* ICompositeMaterials::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xCE16224D688B86F2UL; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
	}

	/**
	* ICompositeMaterials::GetCount - Retrieves the count of Composite-s in the CompositeMaterials.
	* @return returns the count of Composite-s
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* ICompositeMaterials::GetAllPropertyIDs - returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* ICompositeMaterials::GetBaseMaterialGroup - Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	* @return returns the BaseMaterialGroup instance of this CompositeMaterials
	*/
	virtual IBaseMaterialGroup * GetBaseMaterialGroup() = 0;

	/**
	* ICompositeMaterials::AddComposite - Adds a new Composite-Mixing Values to the CompositeMaterials.
	* @param[in] nCompositeBufferSize - Number of elements in buffer
	* @param[in] pCompositeBuffer - The Composite Constituents to be added as composite
	* @return returns new PropertyID of the new Composite in the CompositeMaterials.
	*/
	virtual Lib3MF_uint32 AddComposite(const Lib3MF_uint64 nCompositeBufferSize, const Lib3MF::sCompositeConstituent * pCompositeBuffer) = 0;

	/**
	* ICompositeMaterials::RemoveComposite - Removes a Composite-Maxing Ratio from the CompositeMaterials.
	* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	*/
	virtual void RemoveComposite(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ICompositeMaterials::GetComposite - Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	* @param[in] nCompositeBufferSize - Number of elements in buffer
	* @param[out] pCompositeNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pCompositeBuffer - CompositeConstituent buffer of The Composite-Mixing Values with the given PropertyID
	*/
	virtual void GetComposite(const Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, Lib3MF::sCompositeConstituent * pCompositeBuffer) = 0;

};

typedef IBaseSharedPtr<ICompositeMaterials> PICompositeMaterials;


/*************************************************************************************************************************
 Class interface for MultiPropertyGroup 
**************************************************************************************************************************/

class IMultiPropertyGroup : public virtual IResource {
public:
	/**
	* IMultiPropertyGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB989E02E43158FE6UL; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
	}

	/**
	* IMultiPropertyGroup::GetCount - Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
	* @return returns the count of MultiProperty-s
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IMultiPropertyGroup::GetAllPropertyIDs - returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the MultiProperty-s in the MultiPropertyGroup.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::AddMultiProperty - Adds a new MultiProperty to the MultiPropertyGroup.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - The PropertyIDs of the new MultiProperty.
	* @return returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
	*/
	virtual Lib3MF_uint32 AddMultiProperty(const Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::SetMultiProperty - Sets the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - The new PropertyIDs of the MultiProperty
	*/
	virtual void SetMultiProperty(const Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::GetMultiProperty - Obtains the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the MultiProperty
	*/
	virtual void GetMultiProperty(const Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::RemoveMultiProperty - Removes a MultiProperty from this MultiPropertyGroup.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
	*/
	virtual void RemoveMultiProperty(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IMultiPropertyGroup::GetLayerCount - Retrieves the number of layers of this MultiPropertyGroup.
	* @return returns the number of layers
	*/
	virtual Lib3MF_uint32 GetLayerCount() = 0;

	/**
	* IMultiPropertyGroup::AddLayer - Adds a MultiPropertyLayer to this MultiPropertyGroup.
	* @param[in] TheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
	* @return returns the index of this MultiPropertyLayer
	*/
	virtual Lib3MF_uint32 AddLayer(const Lib3MF::sMultiPropertyLayer TheLayer) = 0;

	/**
	* IMultiPropertyGroup::GetLayer - Obtains a MultiPropertyLayer of this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
	* @return The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
	*/
	virtual Lib3MF::sMultiPropertyLayer GetLayer(const Lib3MF_uint32 nLayerIndex) = 0;

	/**
	* IMultiPropertyGroup::RemoveLayer - Removes a MultiPropertyLayer from this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
	*/
	virtual void RemoveLayer(const Lib3MF_uint32 nLayerIndex) = 0;

};

typedef IBaseSharedPtr<IMultiPropertyGroup> PIMultiPropertyGroup;


/*************************************************************************************************************************
 Class interface for Image3D 
**************************************************************************************************************************/

class IImage3D : public virtual IResource {
public:
	/**
	* IImage3D::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xBD938FF2D2663D61UL; // First 64 bits of SHA1 of a string: "Lib3MF::Image3D"
	}

	/**
	* IImage3D::GetName - returns the name of this Image3D
	* @return the name of this Image3D
	*/
	virtual std::string GetName() = 0;

	/**
	* IImage3D::SetName - sets a new name of this Image3D
	* @param[in] sName - the new name of this Image3D
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IImage3D::IsImageStack - Retrieves, if this Image3D is a ImageStack
	* @return returns, whether the Image3D is an ImageStack
	*/
	virtual bool IsImageStack() = 0;

};

typedef IBaseSharedPtr<IImage3D> PIImage3D;


/*************************************************************************************************************************
 Class interface for ImageStack 
**************************************************************************************************************************/

class IImageStack : public virtual IImage3D {
public:
	/**
	* IImageStack::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x13A2561F0CFB712AUL; // First 64 bits of SHA1 of a string: "Lib3MF::ImageStack"
	}

	/**
	* IImageStack::GetRowCount - Retrieves the number of rows in each image of this image3d
	* @return number of rows
	*/
	virtual Lib3MF_uint32 GetRowCount() = 0;

	/**
	* IImageStack::SetRowCount - Sets the number of rows in each image of this image3d
	* @param[in] nRowCount - number of rows
	*/
	virtual void SetRowCount(const Lib3MF_uint32 nRowCount) = 0;

	/**
	* IImageStack::GetColumnCount - Retrieves the number of columns in each image of this image3d
	* @return number of columns
	*/
	virtual Lib3MF_uint32 GetColumnCount() = 0;

	/**
	* IImageStack::SetColumnCount - Sets the number of columns in each image of this image3d
	* @param[in] nColumnCount - number of columns
	*/
	virtual void SetColumnCount(const Lib3MF_uint32 nColumnCount) = 0;

	/**
	* IImageStack::GetSheetCount - Retrieves the number of images in the stack.
	* @return number of images
	*/
	virtual Lib3MF_uint32 GetSheetCount() = 0;

	/**
	* IImageStack::GetSheet - Retrieves a sheet of the stack. Raises an error if sheet is not set.
	* @param[in] nIndex - index of the image (0-based)
	* @return attachment containing the image
	*/
	virtual IAttachment * GetSheet(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IImageStack::SetSheet - Sets a sheet to an existing attachment.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] pSheet - attachment containing the image
	*/
	virtual void SetSheet(const Lib3MF_uint32 nIndex, IAttachment* pSheet) = 0;

	/**
	* IImageStack::CreateEmptySheet - Creates a new sheet attachment with empty data.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @return attachment containing the image
	*/
	virtual IAttachment * CreateEmptySheet(const Lib3MF_uint32 nIndex, const std::string & sPath) = 0;

	/**
	* IImageStack::CreateSheetFromBuffer - Creates a new sheet attachment from a memory buffer.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @param[in] nDataBufferSize - Number of elements in buffer
	* @param[in] pDataBuffer - binary image data
	* @return attachment containing the image
	*/
	virtual IAttachment * CreateSheetFromBuffer(const Lib3MF_uint32 nIndex, const std::string & sPath, const Lib3MF_uint64 nDataBufferSize, const Lib3MF_uint8 * pDataBuffer) = 0;

	/**
	* IImageStack::CreateSheetFromFile - Creates a new sheet attachment from a file on disk.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @param[in] sFileName - file name to read from
	* @return attachment containing the image
	*/
	virtual IAttachment * CreateSheetFromFile(const Lib3MF_uint32 nIndex, const std::string & sPath, const std::string & sFileName) = 0;

};

typedef IBaseSharedPtr<IImageStack> PIImageStack;


/*************************************************************************************************************************
 Class interface for Attachment 
**************************************************************************************************************************/

class IAttachment : public virtual IBase {
public:
	/**
	* IAttachment::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x8CE7A1191A63A35DUL; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
	}

	/**
	* IAttachment::GetPath - Retrieves an attachment's package path. This function will be removed in a later release.
	* @return returns the attachment's package path string
	*/
	virtual std::string GetPath() = 0;

	/**
	* IAttachment::SetPath - Sets an attachment's package path. This function will be removed in a later release.
	* @param[in] sPath - new path of the attachment.
	*/
	virtual void SetPath(const std::string & sPath) = 0;

	/**
	* IAttachment::PackagePart - Returns the PackagePart that is this attachment.
	* @return The PackagePart of this attachment.
	*/
	virtual IPackagePart * PackagePart() = 0;

	/**
	* IAttachment::GetRelationShipType - Retrieves an attachment's relationship type
	* @return returns the attachment's package relationship type string
	*/
	virtual std::string GetRelationShipType() = 0;

	/**
	* IAttachment::SetRelationShipType - Sets an attachment's relationship type.
	* @param[in] sPath - new relationship type string.
	*/
	virtual void SetRelationShipType(const std::string & sPath) = 0;

	/**
	* IAttachment::WriteToFile - Writes out the attachment as file.
	* @param[in] sFileName - file to write into.
	*/
	virtual void WriteToFile(const std::string & sFileName) = 0;

	/**
	* IAttachment::ReadFromFile - Reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	* @param[in] sFileName - file to read from.
	*/
	virtual void ReadFromFile(const std::string & sFileName) = 0;

	/**
	* IAttachment::ReadFromCallback - Reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	* @param[in] pTheReadCallback - callback function
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void ReadFromCallback(const Lib3MF::ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IAttachment::GetStreamSize - Retrieves the size of the attachment stream
	* @return the stream size
	*/
	virtual Lib3MF_uint64 GetStreamSize() = 0;

	/**
	* IAttachment::WriteToBuffer - Writes out the attachment into a buffer
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of Buffer to write into
	*/
	virtual void WriteToBuffer(Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IAttachment::ReadFromBuffer - Reads an attachment from a memory buffer. This buffer is immediatly read (in contrast to the ReadFromCallback and ReadFromFile-methods).
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[in] pBufferBuffer - Buffer to read from
	*/
	virtual void ReadFromBuffer(const Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer) = 0;

};

typedef IBaseSharedPtr<IAttachment> PIAttachment;


/*************************************************************************************************************************
 Class interface for Texture2D 
**************************************************************************************************************************/

class ITexture2D : public virtual IResource {
public:
	/**
	* ITexture2D::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE0441CF976B36319UL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
	}

	/**
	* ITexture2D::GetAttachment - Retrieves the attachment located at the path of the texture.
	* @return attachment that holds the texture's image information.
	*/
	virtual IAttachment * GetAttachment() = 0;

	/**
	* ITexture2D::SetAttachment - Sets the texture's package path to the path of the attachment.
	* @param[in] pAttachment - attachment that holds the texture's image information.
	*/
	virtual void SetAttachment(IAttachment* pAttachment) = 0;

	/**
	* ITexture2D::GetContentType - Retrieves a texture's content type.
	* @return returns content type enum.
	*/
	virtual Lib3MF::eTextureType GetContentType() = 0;

	/**
	* ITexture2D::SetContentType - Retrieves a texture's content type.
	* @param[in] eContentType - new Content Type
	*/
	virtual void SetContentType(const Lib3MF::eTextureType eContentType) = 0;

	/**
	* ITexture2D::GetTileStyleUV - Retrieves a texture's tilestyle type.
	* @param[out] eTileStyleU - returns tilestyle type enum.
	* @param[out] eTileStyleV - returns tilestyle type enum.
	*/
	virtual void GetTileStyleUV(Lib3MF::eTextureTileStyle & eTileStyleU, Lib3MF::eTextureTileStyle & eTileStyleV) = 0;

	/**
	* ITexture2D::SetTileStyleUV - Sets a texture's tilestyle type.
	* @param[in] eTileStyleU - new tilestyle type enum.
	* @param[in] eTileStyleV - new tilestyle type enum.
	*/
	virtual void SetTileStyleUV(const Lib3MF::eTextureTileStyle eTileStyleU, const Lib3MF::eTextureTileStyle eTileStyleV) = 0;

	/**
	* ITexture2D::GetFilter - Retrieves a texture's filter type.
	* @return returns filter type enum.
	*/
	virtual Lib3MF::eTextureFilter GetFilter() = 0;

	/**
	* ITexture2D::SetFilter - Sets a texture's filter type.
	* @param[in] eFilter - sets new filter type enum.
	*/
	virtual void SetFilter(const Lib3MF::eTextureFilter eFilter) = 0;

};

typedef IBaseSharedPtr<ITexture2D> PITexture2D;


/*************************************************************************************************************************
 Class interface for ImplicitPort 
**************************************************************************************************************************/

class IImplicitPort : public virtual IBase {
public:
	/**
	* IImplicitPort::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD5C49B04AF1963CDUL; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPort"
	}

	/**
	* IImplicitPort::GetIdentifier - Retrieves the identifier of the port
	* @return the identifier
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* IImplicitPort::SetIdentifier - Sets the identifier of the port
	* @param[in] sIdentifier - the identifier
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* IImplicitPort::GetDisplayName - Retrieves the display name of the port
	* @return the display name
	*/
	virtual std::string GetDisplayName() = 0;

	/**
	* IImplicitPort::SetDisplayName - Sets the display name of the port
	* @param[in] sDisplayName - the display name
	*/
	virtual void SetDisplayName(const std::string & sDisplayName) = 0;

	/**
	* IImplicitPort::SetType - Sets the type of the port
	* @param[in] eImplicitPortType - the type
	*/
	virtual void SetType(const Lib3MF::eImplicitPortType eImplicitPortType) = 0;

	/**
	* IImplicitPort::GetType - Retrieves the type of the port
	* @return the type
	*/
	virtual Lib3MF::eImplicitPortType GetType() = 0;

	/**
	* IImplicitPort::GetReference - Retrieves the reference of the port, only used for input ports
	* @return the reference
	*/
	virtual std::string GetReference() = 0;

	/**
	* IImplicitPort::SetReference - Sets the reference of the port, only used for input ports
	* @param[in] sReference - the reference
	*/
	virtual void SetReference(const std::string & sReference) = 0;

};

typedef IBaseSharedPtr<IImplicitPort> PIImplicitPort;


/*************************************************************************************************************************
 Class interface for Iterator 
**************************************************************************************************************************/

class IIterator : public virtual IBase {
public:
	/**
	* IIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x52F06268CD098EFEUL; // First 64 bits of SHA1 of a string: "Lib3MF::Iterator"
	}

	/**
	* IIterator::MoveNext - Iterates to the next item in the list.
	* @return Iterates to the next item in the list.
	*/
	virtual bool MoveNext() = 0;

	/**
	* IIterator::MovePrevious - Iterates to the previous item in the list.
	* @return Iterates to the previous item in the list.
	*/
	virtual bool MovePrevious() = 0;

	/**
	* IIterator::Count - Returns the number of items the iterator captures.
	* @return returns the number of items the iterator captures.
	*/
	virtual Lib3MF_uint64 Count() = 0;

};

typedef IBaseSharedPtr<IIterator> PIIterator;


/*************************************************************************************************************************
 Class interface for ImplicitPortIterator 
**************************************************************************************************************************/

class IImplicitPortIterator : public virtual IIterator {
public:
	/**
	* IImplicitPortIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC62268F2D7C7012CUL; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPortIterator"
	}

	/**
	* IImplicitPortIterator::GetCurrent - Returns the current element
	* @return The current element
	*/
	virtual IImplicitPort * GetCurrent() = 0;

};

typedef IBaseSharedPtr<IImplicitPortIterator> PIImplicitPortIterator;


/*************************************************************************************************************************
 Class interface for ImplicitNode 
**************************************************************************************************************************/

class IImplicitNode : public virtual IBase {
public:
	/**
	* IImplicitNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE72592A7725AB29BUL; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitNode"
	}

	/**
	* IImplicitNode::GetIdentifier - Retrieves the identifier of the node
	* @return the identifier
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* IImplicitNode::SetIdentifier - Sets the identifier of the node
	* @param[in] sIdentifier - the identifier
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* IImplicitNode::GetDisplayName - Retrieves the display name of the node
	* @return the display name
	*/
	virtual std::string GetDisplayName() = 0;

	/**
	* IImplicitNode::SetDisplayName - Sets the display name of the node
	* @param[in] sDisplayName - the display name
	*/
	virtual void SetDisplayName(const std::string & sDisplayName) = 0;

	/**
	* IImplicitNode::GetTag - Retrieves the tag of the node
	* @return the tag
	*/
	virtual std::string GetTag() = 0;

	/**
	* IImplicitNode::SetTag - Sets the tag of the node
	* @param[in] sTag - the tag
	*/
	virtual void SetTag(const std::string & sTag) = 0;

	/**
	* IImplicitNode::GetNodeType - Retrieves the type of the node
	* @return the type of the node
	*/
	virtual Lib3MF::eImplicitNodeType GetNodeType() = 0;

	/**
	* IImplicitNode::AddInput - Add an input
	* @param[in] sIdentifier - the identifier of the input
	* @param[in] sDisplayName - the display name of the input
	* @return 
	*/
	virtual IImplicitPort * AddInput(const std::string & sIdentifier, const std::string & sDisplayName) = 0;

	/**
	* IImplicitNode::GetInputs - Retrieves the inputs
	* @return the iterator for the inputs
	*/
	virtual IImplicitPortIterator * GetInputs() = 0;

	/**
	* IImplicitNode::AddOutput - Add an output
	* @param[in] sIdentifier - the identifier of the output
	* @param[in] sDisplayName - the display name of the output
	* @return 
	*/
	virtual IImplicitPort * AddOutput(const std::string & sIdentifier, const std::string & sDisplayName) = 0;

	/**
	* IImplicitNode::GetOutputs - Retrieves the outputs
	* @return the iterator the outputs
	*/
	virtual IImplicitPortIterator * GetOutputs() = 0;

	/**
	* IImplicitNode::FindInput - Retrieves an input
	* @param[in] sIdentifier - the identifier of the input
	* @return the input port
	*/
	virtual IImplicitPort * FindInput(const std::string & sIdentifier) = 0;

	/**
	* IImplicitNode::FindOutput - Retrieves an output
	* @param[in] sIdentifier - the identifier of the output
	* @return the output port
	*/
	virtual IImplicitPort * FindOutput(const std::string & sIdentifier) = 0;

	/**
	* IImplicitNode::AreTypesValid - Checks if the types of the input and output ports are valid for the node type
	* @return true, if the types are valid
	*/
	virtual bool AreTypesValid() = 0;

};

typedef IBaseSharedPtr<IImplicitNode> PIImplicitNode;


/*************************************************************************************************************************
 Class interface for OneInputNode 
**************************************************************************************************************************/

class IOneInputNode : public virtual IImplicitNode {
public:
	/**
	* IOneInputNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB19B9FDA94B0A5E7UL; // First 64 bits of SHA1 of a string: "Lib3MF::OneInputNode"
	}

	/**
	* IOneInputNode::GetInputA - Retrieves the input
	* @return the input
	*/
	virtual IImplicitPort * GetInputA() = 0;

	/**
	* IOneInputNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputResult() = 0;

};

typedef IBaseSharedPtr<IOneInputNode> PIOneInputNode;


/*************************************************************************************************************************
 Class interface for SinNode 
**************************************************************************************************************************/

class ISinNode : public virtual IOneInputNode {
public:
	/**
	* ISinNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD5AEA50A56306722UL; // First 64 bits of SHA1 of a string: "Lib3MF::SinNode"
	}

};

typedef IBaseSharedPtr<ISinNode> PISinNode;


/*************************************************************************************************************************
 Class interface for CosNode 
**************************************************************************************************************************/

class ICosNode : public virtual IOneInputNode {
public:
	/**
	* ICosNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x59BC328F6FB5C5FFUL; // First 64 bits of SHA1 of a string: "Lib3MF::CosNode"
	}

};

typedef IBaseSharedPtr<ICosNode> PICosNode;


/*************************************************************************************************************************
 Class interface for TanNode 
**************************************************************************************************************************/

class ITanNode : public virtual IOneInputNode {
public:
	/**
	* ITanNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2614CC572AF350B7UL; // First 64 bits of SHA1 of a string: "Lib3MF::TanNode"
	}

};

typedef IBaseSharedPtr<ITanNode> PITanNode;


/*************************************************************************************************************************
 Class interface for ArcSinNode 
**************************************************************************************************************************/

class IArcSinNode : public virtual IOneInputNode {
public:
	/**
	* IArcSinNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE554C8A7E72AAF4DUL; // First 64 bits of SHA1 of a string: "Lib3MF::ArcSinNode"
	}

};

typedef IBaseSharedPtr<IArcSinNode> PIArcSinNode;


/*************************************************************************************************************************
 Class interface for ArcCosNode 
**************************************************************************************************************************/

class IArcCosNode : public virtual IOneInputNode {
public:
	/**
	* IArcCosNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x943AF6AE0EFD2B8AUL; // First 64 bits of SHA1 of a string: "Lib3MF::ArcCosNode"
	}

};

typedef IBaseSharedPtr<IArcCosNode> PIArcCosNode;


/*************************************************************************************************************************
 Class interface for ArcTanNode 
**************************************************************************************************************************/

class IArcTanNode : public virtual IOneInputNode {
public:
	/**
	* IArcTanNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE47D547615816BADUL; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTanNode"
	}

};

typedef IBaseSharedPtr<IArcTanNode> PIArcTanNode;


/*************************************************************************************************************************
 Class interface for SinhNode 
**************************************************************************************************************************/

class ISinhNode : public virtual IOneInputNode {
public:
	/**
	* ISinhNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x3C7756A456F2D089UL; // First 64 bits of SHA1 of a string: "Lib3MF::SinhNode"
	}

};

typedef IBaseSharedPtr<ISinhNode> PISinhNode;


/*************************************************************************************************************************
 Class interface for CoshNode 
**************************************************************************************************************************/

class ICoshNode : public virtual IOneInputNode {
public:
	/**
	* ICoshNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4A993F91E1DE256DUL; // First 64 bits of SHA1 of a string: "Lib3MF::CoshNode"
	}

};

typedef IBaseSharedPtr<ICoshNode> PICoshNode;


/*************************************************************************************************************************
 Class interface for TanhNode 
**************************************************************************************************************************/

class ITanhNode : public virtual IOneInputNode {
public:
	/**
	* ITanhNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xCF077B19B0B78E9DUL; // First 64 bits of SHA1 of a string: "Lib3MF::TanhNode"
	}

};

typedef IBaseSharedPtr<ITanhNode> PITanhNode;


/*************************************************************************************************************************
 Class interface for RoundNode 
**************************************************************************************************************************/

class IRoundNode : public virtual IOneInputNode {
public:
	/**
	* IRoundNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD9F5A53C657765AEUL; // First 64 bits of SHA1 of a string: "Lib3MF::RoundNode"
	}

};

typedef IBaseSharedPtr<IRoundNode> PIRoundNode;


/*************************************************************************************************************************
 Class interface for CeilNode 
**************************************************************************************************************************/

class ICeilNode : public virtual IOneInputNode {
public:
	/**
	* ICeilNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x627E211653E11D93UL; // First 64 bits of SHA1 of a string: "Lib3MF::CeilNode"
	}

};

typedef IBaseSharedPtr<ICeilNode> PICeilNode;


/*************************************************************************************************************************
 Class interface for FloorNode 
**************************************************************************************************************************/

class IFloorNode : public virtual IOneInputNode {
public:
	/**
	* IFloorNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x392A0F4C041D249CUL; // First 64 bits of SHA1 of a string: "Lib3MF::FloorNode"
	}

};

typedef IBaseSharedPtr<IFloorNode> PIFloorNode;


/*************************************************************************************************************************
 Class interface for SignNode 
**************************************************************************************************************************/

class ISignNode : public virtual IOneInputNode {
public:
	/**
	* ISignNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x8A45165E6C9646D7UL; // First 64 bits of SHA1 of a string: "Lib3MF::SignNode"
	}

};

typedef IBaseSharedPtr<ISignNode> PISignNode;


/*************************************************************************************************************************
 Class interface for FractNode 
**************************************************************************************************************************/

class IFractNode : public virtual IOneInputNode {
public:
	/**
	* IFractNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x53E62FD67F4D9A65UL; // First 64 bits of SHA1 of a string: "Lib3MF::FractNode"
	}

};

typedef IBaseSharedPtr<IFractNode> PIFractNode;


/*************************************************************************************************************************
 Class interface for AbsNode 
**************************************************************************************************************************/

class IAbsNode : public virtual IOneInputNode {
public:
	/**
	* IAbsNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6B641C7060040BE3UL; // First 64 bits of SHA1 of a string: "Lib3MF::AbsNode"
	}

};

typedef IBaseSharedPtr<IAbsNode> PIAbsNode;


/*************************************************************************************************************************
 Class interface for ExpNode 
**************************************************************************************************************************/

class IExpNode : public virtual IOneInputNode {
public:
	/**
	* IExpNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x3390243A8E2410F3UL; // First 64 bits of SHA1 of a string: "Lib3MF::ExpNode"
	}

};

typedef IBaseSharedPtr<IExpNode> PIExpNode;


/*************************************************************************************************************************
 Class interface for LogNode 
**************************************************************************************************************************/

class ILogNode : public virtual IOneInputNode {
public:
	/**
	* ILogNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x70021D73AA89FDUL; // First 64 bits of SHA1 of a string: "Lib3MF::LogNode"
	}

};

typedef IBaseSharedPtr<ILogNode> PILogNode;


/*************************************************************************************************************************
 Class interface for Log2Node 
**************************************************************************************************************************/

class ILog2Node : public virtual IOneInputNode {
public:
	/**
	* ILog2Node::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE8C0ABF7C5DC7068UL; // First 64 bits of SHA1 of a string: "Lib3MF::Log2Node"
	}

};

typedef IBaseSharedPtr<ILog2Node> PILog2Node;


/*************************************************************************************************************************
 Class interface for Log10Node 
**************************************************************************************************************************/

class ILog10Node : public virtual IOneInputNode {
public:
	/**
	* ILog10Node::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x87740AD53454E0DFUL; // First 64 bits of SHA1 of a string: "Lib3MF::Log10Node"
	}

};

typedef IBaseSharedPtr<ILog10Node> PILog10Node;


/*************************************************************************************************************************
 Class interface for LengthNode 
**************************************************************************************************************************/

class ILengthNode : public virtual IOneInputNode {
public:
	/**
	* ILengthNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD85889E2739A74B1UL; // First 64 bits of SHA1 of a string: "Lib3MF::LengthNode"
	}

};

typedef IBaseSharedPtr<ILengthNode> PILengthNode;


/*************************************************************************************************************************
 Class interface for TransposeNode 
**************************************************************************************************************************/

class ITransposeNode : public virtual IOneInputNode {
public:
	/**
	* ITransposeNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA808B7599C158CE6UL; // First 64 bits of SHA1 of a string: "Lib3MF::TransposeNode"
	}

};

typedef IBaseSharedPtr<ITransposeNode> PITransposeNode;


/*************************************************************************************************************************
 Class interface for InverseNode 
**************************************************************************************************************************/

class IInverseNode : public virtual IOneInputNode {
public:
	/**
	* IInverseNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE8601F66A23A0540UL; // First 64 bits of SHA1 of a string: "Lib3MF::InverseNode"
	}

};

typedef IBaseSharedPtr<IInverseNode> PIInverseNode;


/*************************************************************************************************************************
 Class interface for SqrtNode 
**************************************************************************************************************************/

class ISqrtNode : public virtual IOneInputNode {
public:
	/**
	* ISqrtNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9F831944A3DE31DAUL; // First 64 bits of SHA1 of a string: "Lib3MF::SqrtNode"
	}

};

typedef IBaseSharedPtr<ISqrtNode> PISqrtNode;


/*************************************************************************************************************************
 Class interface for ResourceIdNode 
**************************************************************************************************************************/

class IResourceIdNode : public virtual IImplicitNode {
public:
	/**
	* IResourceIdNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xCA86A77C71CD3FAEUL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIdNode"
	}

	/**
	* IResourceIdNode::SetResource - Sets the Resource that the resourceid attribute of the node will point to
	* @param[in] pResource - the resource
	*/
	virtual void SetResource(IResource* pResource) = 0;

	/**
	* IResourceIdNode::GetResource - Retrieves the resource of the node
	* @return the resource
	*/
	virtual IResource * GetResource() = 0;

	/**
	* IResourceIdNode::GetOutputValue - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputValue() = 0;

};

typedef IBaseSharedPtr<IResourceIdNode> PIResourceIdNode;


/*************************************************************************************************************************
 Class interface for TwoInputNode 
**************************************************************************************************************************/

class ITwoInputNode : public virtual IOneInputNode {
public:
	/**
	* ITwoInputNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x7DE3951BA4C1064CUL; // First 64 bits of SHA1 of a string: "Lib3MF::TwoInputNode"
	}

	/**
	* ITwoInputNode::GetInputB - Retrieves the second input
	* @return the second input
	*/
	virtual IImplicitPort * GetInputB() = 0;

};

typedef IBaseSharedPtr<ITwoInputNode> PITwoInputNode;


/*************************************************************************************************************************
 Class interface for AdditionNode 
**************************************************************************************************************************/

class IAdditionNode : public virtual ITwoInputNode {
public:
	/**
	* IAdditionNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x57A2236998DF5248UL; // First 64 bits of SHA1 of a string: "Lib3MF::AdditionNode"
	}

};

typedef IBaseSharedPtr<IAdditionNode> PIAdditionNode;


/*************************************************************************************************************************
 Class interface for SubtractionNode 
**************************************************************************************************************************/

class ISubtractionNode : public virtual ITwoInputNode {
public:
	/**
	* ISubtractionNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6079B12FFF345D02UL; // First 64 bits of SHA1 of a string: "Lib3MF::SubtractionNode"
	}

};

typedef IBaseSharedPtr<ISubtractionNode> PISubtractionNode;


/*************************************************************************************************************************
 Class interface for MultiplicationNode 
**************************************************************************************************************************/

class IMultiplicationNode : public virtual ITwoInputNode {
public:
	/**
	* IMultiplicationNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA3C27CF54C2AA76CUL; // First 64 bits of SHA1 of a string: "Lib3MF::MultiplicationNode"
	}

};

typedef IBaseSharedPtr<IMultiplicationNode> PIMultiplicationNode;


/*************************************************************************************************************************
 Class interface for DivisionNode 
**************************************************************************************************************************/

class IDivisionNode : public virtual ITwoInputNode {
public:
	/**
	* IDivisionNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB896B6413C08CF39UL; // First 64 bits of SHA1 of a string: "Lib3MF::DivisionNode"
	}

};

typedef IBaseSharedPtr<IDivisionNode> PIDivisionNode;


/*************************************************************************************************************************
 Class interface for DotNode 
**************************************************************************************************************************/

class IDotNode : public virtual ITwoInputNode {
public:
	/**
	* IDotNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xFE60932A66375FADUL; // First 64 bits of SHA1 of a string: "Lib3MF::DotNode"
	}

};

typedef IBaseSharedPtr<IDotNode> PIDotNode;


/*************************************************************************************************************************
 Class interface for CrossNode 
**************************************************************************************************************************/

class ICrossNode : public virtual ITwoInputNode {
public:
	/**
	* ICrossNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x106182D38CA5CFE3UL; // First 64 bits of SHA1 of a string: "Lib3MF::CrossNode"
	}

};

typedef IBaseSharedPtr<ICrossNode> PICrossNode;


/*************************************************************************************************************************
 Class interface for ArcTan2Node 
**************************************************************************************************************************/

class IArcTan2Node : public virtual ITwoInputNode {
public:
	/**
	* IArcTan2Node::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB6153EF5DE7E5E11UL; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTan2Node"
	}

};

typedef IBaseSharedPtr<IArcTan2Node> PIArcTan2Node;


/*************************************************************************************************************************
 Class interface for MatVecMultiplicationNode 
**************************************************************************************************************************/

class IMatVecMultiplicationNode : public virtual ITwoInputNode {
public:
	/**
	* IMatVecMultiplicationNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x7570C43B9721D0C0UL; // First 64 bits of SHA1 of a string: "Lib3MF::MatVecMultiplicationNode"
	}

};

typedef IBaseSharedPtr<IMatVecMultiplicationNode> PIMatVecMultiplicationNode;


/*************************************************************************************************************************
 Class interface for MinNode 
**************************************************************************************************************************/

class IMinNode : public virtual ITwoInputNode {
public:
	/**
	* IMinNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x846AFDE9A091E997UL; // First 64 bits of SHA1 of a string: "Lib3MF::MinNode"
	}

};

typedef IBaseSharedPtr<IMinNode> PIMinNode;


/*************************************************************************************************************************
 Class interface for MaxNode 
**************************************************************************************************************************/

class IMaxNode : public virtual ITwoInputNode {
public:
	/**
	* IMaxNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x73F910381BF250DUL; // First 64 bits of SHA1 of a string: "Lib3MF::MaxNode"
	}

};

typedef IBaseSharedPtr<IMaxNode> PIMaxNode;


/*************************************************************************************************************************
 Class interface for FmodNode 
**************************************************************************************************************************/

class IFmodNode : public virtual ITwoInputNode {
public:
	/**
	* IFmodNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1EF703D298223F2AUL; // First 64 bits of SHA1 of a string: "Lib3MF::FmodNode"
	}

};

typedef IBaseSharedPtr<IFmodNode> PIFmodNode;


/*************************************************************************************************************************
 Class interface for ModNode 
**************************************************************************************************************************/

class IModNode : public virtual ITwoInputNode {
public:
	/**
	* IModNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xEA57335849379F22UL; // First 64 bits of SHA1 of a string: "Lib3MF::ModNode"
	}

};

typedef IBaseSharedPtr<IModNode> PIModNode;


/*************************************************************************************************************************
 Class interface for PowNode 
**************************************************************************************************************************/

class IPowNode : public virtual ITwoInputNode {
public:
	/**
	* IPowNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x7700AA17CA1AC0F8UL; // First 64 bits of SHA1 of a string: "Lib3MF::PowNode"
	}

};

typedef IBaseSharedPtr<IPowNode> PIPowNode;


/*************************************************************************************************************************
 Class interface for SelectNode 
**************************************************************************************************************************/

class ISelectNode : public virtual IOneInputNode {
public:
	/**
	* ISelectNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1127ED71E05A9BD4UL; // First 64 bits of SHA1 of a string: "Lib3MF::SelectNode"
	}

	/**
	* ISelectNode::GetInputB - Retrieves the second input
	* @return the second input
	*/
	virtual IImplicitPort * GetInputB() = 0;

	/**
	* ISelectNode::GetInputC - Retrieves the third input
	* @return the third input
	*/
	virtual IImplicitPort * GetInputC() = 0;

	/**
	* ISelectNode::GetInputD - Retrieves the fourth input
	* @return the fourth input
	*/
	virtual IImplicitPort * GetInputD() = 0;

};

typedef IBaseSharedPtr<ISelectNode> PISelectNode;


/*************************************************************************************************************************
 Class interface for ClampNode 
**************************************************************************************************************************/

class IClampNode : public virtual IOneInputNode {
public:
	/**
	* IClampNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x77AF68C971B1485FUL; // First 64 bits of SHA1 of a string: "Lib3MF::ClampNode"
	}

	/**
	* IClampNode::GetInputMin - Retrieves the input for the lower limit
	* @return the input for the lower limit
	*/
	virtual IImplicitPort * GetInputMin() = 0;

	/**
	* IClampNode::GetInputMax - Retrieves the input for the upper limit
	* @return the input for the upper limit
	*/
	virtual IImplicitPort * GetInputMax() = 0;

};

typedef IBaseSharedPtr<IClampNode> PIClampNode;


/*************************************************************************************************************************
 Class interface for ComposeVectorNode 
**************************************************************************************************************************/

class IComposeVectorNode : public virtual IImplicitNode {
public:
	/**
	* IComposeVectorNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x49C24B8840C01F7EUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeVectorNode"
	}

	/**
	* IComposeVectorNode::GetInputX - Retrieves the input for the x component
	* @return the input for the x component
	*/
	virtual IImplicitPort * GetInputX() = 0;

	/**
	* IComposeVectorNode::GetInputY - Retrieves the input for the y component
	* @return the input for the y component
	*/
	virtual IImplicitPort * GetInputY() = 0;

	/**
	* IComposeVectorNode::GetInputZ - Retrieves the input for the z component
	* @return the input for the z component
	*/
	virtual IImplicitPort * GetInputZ() = 0;

	/**
	* IComposeVectorNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputResult() = 0;

};

typedef IBaseSharedPtr<IComposeVectorNode> PIComposeVectorNode;


/*************************************************************************************************************************
 Class interface for VectorFromScalarNode 
**************************************************************************************************************************/

class IVectorFromScalarNode : public virtual IOneInputNode {
public:
	/**
	* IVectorFromScalarNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2E417B93351375E2UL; // First 64 bits of SHA1 of a string: "Lib3MF::VectorFromScalarNode"
	}

};

typedef IBaseSharedPtr<IVectorFromScalarNode> PIVectorFromScalarNode;


/*************************************************************************************************************************
 Class interface for DecomposeVectorNode 
**************************************************************************************************************************/

class IDecomposeVectorNode : public virtual IImplicitNode {
public:
	/**
	* IDecomposeVectorNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xCC4F8D561CCE35D4UL; // First 64 bits of SHA1 of a string: "Lib3MF::DecomposeVectorNode"
	}

	/**
	* IDecomposeVectorNode::GetInputA - Retrieves the input
	* @return the input port for the vector to decompose
	*/
	virtual IImplicitPort * GetInputA() = 0;

	/**
	* IDecomposeVectorNode::GetOutputX - Retrieves the output for the x component
	* @return the output for the x component
	*/
	virtual IImplicitPort * GetOutputX() = 0;

	/**
	* IDecomposeVectorNode::GetOutputY - Retrieves the output for the y component
	* @return the output for the y component
	*/
	virtual IImplicitPort * GetOutputY() = 0;

	/**
	* IDecomposeVectorNode::GetOutputZ - Retrieves the output for the z component
	* @return the output for the z component
	*/
	virtual IImplicitPort * GetOutputZ() = 0;

};

typedef IBaseSharedPtr<IDecomposeVectorNode> PIDecomposeVectorNode;


/*************************************************************************************************************************
 Class interface for ComposeMatrixNode 
**************************************************************************************************************************/

class IComposeMatrixNode : public virtual IImplicitNode {
public:
	/**
	* IComposeMatrixNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9EF9EB54A53AA40DUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeMatrixNode"
	}

	/**
	* IComposeMatrixNode::GetInputM00 - Retrieves the input for the element 0 0
	* @return the input for the m00 element
	*/
	virtual IImplicitPort * GetInputM00() = 0;

	/**
	* IComposeMatrixNode::GetInputM01 - Retrieves the input for the element 0 1
	* @return the input for the m01 element
	*/
	virtual IImplicitPort * GetInputM01() = 0;

	/**
	* IComposeMatrixNode::GetInputM02 - Retrieves the input for the element 0 2
	* @return the input for the m02 element
	*/
	virtual IImplicitPort * GetInputM02() = 0;

	/**
	* IComposeMatrixNode::GetInputM03 - Retrieves the input for the element 0 3
	* @return the input for the m03 element
	*/
	virtual IImplicitPort * GetInputM03() = 0;

	/**
	* IComposeMatrixNode::GetInputM10 - Retrieves the input for the element 1 0
	* @return the input for the m10 element
	*/
	virtual IImplicitPort * GetInputM10() = 0;

	/**
	* IComposeMatrixNode::GetInputM11 - Retrieves the input for the element 1 1
	* @return the input for the m11 element
	*/
	virtual IImplicitPort * GetInputM11() = 0;

	/**
	* IComposeMatrixNode::GetInputM12 - Retrieves the input for the element 1 2
	* @return the input for the m12 element
	*/
	virtual IImplicitPort * GetInputM12() = 0;

	/**
	* IComposeMatrixNode::GetInputM13 - Retrieves the input for the element 1 3
	* @return the input for the m13 element
	*/
	virtual IImplicitPort * GetInputM13() = 0;

	/**
	* IComposeMatrixNode::GetInputM20 - Retrieves the input for the element 2 0
	* @return the input for the m20 element
	*/
	virtual IImplicitPort * GetInputM20() = 0;

	/**
	* IComposeMatrixNode::GetInputM21 - Retrieves the input for the element 2 1
	* @return 
	*/
	virtual IImplicitPort * GetInputM21() = 0;

	/**
	* IComposeMatrixNode::GetInputM22 - Retrieves the input for the element 2 2
	* @return the input for the m22 element
	*/
	virtual IImplicitPort * GetInputM22() = 0;

	/**
	* IComposeMatrixNode::GetInputM23 - Retrieves the input for the element 2 3
	* @return the input for the m23 element
	*/
	virtual IImplicitPort * GetInputM23() = 0;

	/**
	* IComposeMatrixNode::GetInputM30 - Retrieves the input for the element 3 0
	* @return the input for the m30 element
	*/
	virtual IImplicitPort * GetInputM30() = 0;

	/**
	* IComposeMatrixNode::GetInputM31 - Retrieves the input for the element 3 1
	* @return the input for the m31 element
	*/
	virtual IImplicitPort * GetInputM31() = 0;

	/**
	* IComposeMatrixNode::GetInputM32 - Retrieves the input for the element 3 2
	* @return the input for the m32 element
	*/
	virtual IImplicitPort * GetInputM32() = 0;

	/**
	* IComposeMatrixNode::GetInputM33 - Retrieves the input for the element 3 3
	* @return the input for the m33 element
	*/
	virtual IImplicitPort * GetInputM33() = 0;

	/**
	* IComposeMatrixNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputResult() = 0;

};

typedef IBaseSharedPtr<IComposeMatrixNode> PIComposeMatrixNode;


/*************************************************************************************************************************
 Class interface for MatrixFromRowsNode 
**************************************************************************************************************************/

class IMatrixFromRowsNode : public virtual IImplicitNode {
public:
	/**
	* IMatrixFromRowsNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD6DFD0A7EB64AC33UL; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromRowsNode"
	}

	/**
	* IMatrixFromRowsNode::GetInputA - Retrieves the input for the first row
	* @return the input for the first row
	*/
	virtual IImplicitPort * GetInputA() = 0;

	/**
	* IMatrixFromRowsNode::GetInputB - Retrieves the input for the second row
	* @return the input for the second row
	*/
	virtual IImplicitPort * GetInputB() = 0;

	/**
	* IMatrixFromRowsNode::GetInputC - Retrieves the input for the third row
	* @return the input for the third row
	*/
	virtual IImplicitPort * GetInputC() = 0;

	/**
	* IMatrixFromRowsNode::GetInputD - Retrieves the input for the fourth row
	* @return the input for the fourth row
	*/
	virtual IImplicitPort * GetInputD() = 0;

	/**
	* IMatrixFromRowsNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputResult() = 0;

};

typedef IBaseSharedPtr<IMatrixFromRowsNode> PIMatrixFromRowsNode;


/*************************************************************************************************************************
 Class interface for MatrixFromColumnsNode 
**************************************************************************************************************************/

class IMatrixFromColumnsNode : public virtual IImplicitNode {
public:
	/**
	* IMatrixFromColumnsNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xDCBEAFCF83F3AACUL; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromColumnsNode"
	}

	/**
	* IMatrixFromColumnsNode::GetInputA - Retrieves the input for the first column
	* @return the input for the first column
	*/
	virtual IImplicitPort * GetInputA() = 0;

	/**
	* IMatrixFromColumnsNode::GetInputB - Retrieves the input for the second column
	* @return the input for the second column
	*/
	virtual IImplicitPort * GetInputB() = 0;

	/**
	* IMatrixFromColumnsNode::GetInputC - Retrieves the input for the third column
	* @return the input for the third column
	*/
	virtual IImplicitPort * GetInputC() = 0;

	/**
	* IMatrixFromColumnsNode::GetInputD - Retrieves the input for the fourth column
	* @return the input for the fourth column
	*/
	virtual IImplicitPort * GetInputD() = 0;

	/**
	* IMatrixFromColumnsNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputResult() = 0;

};

typedef IBaseSharedPtr<IMatrixFromColumnsNode> PIMatrixFromColumnsNode;


/*************************************************************************************************************************
 Class interface for ConstantNode 
**************************************************************************************************************************/

class IConstantNode : public virtual IImplicitNode {
public:
	/**
	* IConstantNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x3F8E5D082F966B1BUL; // First 64 bits of SHA1 of a string: "Lib3MF::ConstantNode"
	}

	/**
	* IConstantNode::SetConstant - Sets the constant value of the node
	* @param[in] dValue - the value
	*/
	virtual void SetConstant(const Lib3MF_double dValue) = 0;

	/**
	* IConstantNode::GetConstant - Retrieves the constant value of the node
	* @return the value
	*/
	virtual Lib3MF_double GetConstant() = 0;

	/**
	* IConstantNode::GetOutputValue - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputValue() = 0;

};

typedef IBaseSharedPtr<IConstantNode> PIConstantNode;


/*************************************************************************************************************************
 Class interface for ConstVecNode 
**************************************************************************************************************************/

class IConstVecNode : public virtual IImplicitNode {
public:
	/**
	* IConstVecNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9C9363B3F708D556UL; // First 64 bits of SHA1 of a string: "Lib3MF::ConstVecNode"
	}

	/**
	* IConstVecNode::SetVector - Sets the vector value of the node
	* @param[in] Value - the value
	*/
	virtual void SetVector(const Lib3MF::sVector Value) = 0;

	/**
	* IConstVecNode::GetVector - Retrieves the vector value of the node
	* @return the value
	*/
	virtual Lib3MF::sVector GetVector() = 0;

	/**
	* IConstVecNode::GetOutputVector - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputVector() = 0;

};

typedef IBaseSharedPtr<IConstVecNode> PIConstVecNode;


/*************************************************************************************************************************
 Class interface for ConstMatNode 
**************************************************************************************************************************/

class IConstMatNode : public virtual IImplicitNode {
public:
	/**
	* IConstMatNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xF85C90EDCE6F90A4UL; // First 64 bits of SHA1 of a string: "Lib3MF::ConstMatNode"
	}

	/**
	* IConstMatNode::SetMatrix - Sets the matrix value of the node
	* @param[in] Value - the value
	*/
	virtual void SetMatrix(const Lib3MF::sMatrix4x4 Value) = 0;

	/**
	* IConstMatNode::GetMatrix - Retrieves the matrix value of the node
	* @return the matrix
	*/
	virtual Lib3MF::sMatrix4x4 GetMatrix() = 0;

	/**
	* IConstMatNode::GetOutputMatrix - Retrieves the output
	* @return the output
	*/
	virtual IImplicitPort * GetOutputMatrix() = 0;

};

typedef IBaseSharedPtr<IConstMatNode> PIConstMatNode;


/*************************************************************************************************************************
 Class interface for MeshNode 
**************************************************************************************************************************/

class IMeshNode : public virtual IImplicitNode {
public:
	/**
	* IMeshNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x53601FD432E3DEF4UL; // First 64 bits of SHA1 of a string: "Lib3MF::MeshNode"
	}

	/**
	* IMeshNode::GetInputMesh - Retrieves the input for the model resource id of the mesh
	* @return the input port for the model resource id of the mesh
	*/
	virtual IImplicitPort * GetInputMesh() = 0;

	/**
	* IMeshNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	virtual IImplicitPort * GetInputPos() = 0;

	/**
	* IMeshNode::GetOutputDistance - Retrieves the output
	* @return the output port for the signed distance to the mesh
	*/
	virtual IImplicitPort * GetOutputDistance() = 0;

};

typedef IBaseSharedPtr<IMeshNode> PIMeshNode;


/*************************************************************************************************************************
 Class interface for UnsignedMeshNode 
**************************************************************************************************************************/

class IUnsignedMeshNode : public virtual IImplicitNode {
public:
	/**
	* IUnsignedMeshNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x29985A628251A9CDUL; // First 64 bits of SHA1 of a string: "Lib3MF::UnsignedMeshNode"
	}

	/**
	* IUnsignedMeshNode::GetInputMesh - Retrieves the input for the model resource id of the mesh
	* @return the input port for the model resource id of the mesh
	*/
	virtual IImplicitPort * GetInputMesh() = 0;

	/**
	* IUnsignedMeshNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	virtual IImplicitPort * GetInputPos() = 0;

	/**
	* IUnsignedMeshNode::GetOutputDistance - Retrieves the output
	* @return the output port for the unsigned distance to the mesh
	*/
	virtual IImplicitPort * GetOutputDistance() = 0;

};

typedef IBaseSharedPtr<IUnsignedMeshNode> PIUnsignedMeshNode;


/*************************************************************************************************************************
 Class interface for FunctionCallNode 
**************************************************************************************************************************/

class IFunctionCallNode : public virtual IImplicitNode {
public:
	/**
	* IFunctionCallNode::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x765C17C952F24E3UL; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionCallNode"
	}

	/**
	* IFunctionCallNode::GetInputFunctionID - Retrieves the input for the function id
	* @return the input port for the function
	*/
	virtual IImplicitPort * GetInputFunctionID() = 0;

};

typedef IBaseSharedPtr<IFunctionCallNode> PIFunctionCallNode;


/*************************************************************************************************************************
 Class interface for NodeIterator 
**************************************************************************************************************************/

class INodeIterator : public virtual IIterator {
public:
	/**
	* INodeIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xFC006BC888CAB4D0UL; // First 64 bits of SHA1 of a string: "Lib3MF::NodeIterator"
	}

	/**
	* INodeIterator::GetCurrent - Returns the current element
	* @return The current element
	*/
	virtual IImplicitNode * GetCurrent() = 0;

};

typedef IBaseSharedPtr<INodeIterator> PINodeIterator;


/*************************************************************************************************************************
 Class interface for Function 
**************************************************************************************************************************/

class IFunction : public virtual IResource {
public:
	/**
	* IFunction::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9EFB2757CA1A5231UL; // First 64 bits of SHA1 of a string: "Lib3MF::Function"
	}

	/**
	* IFunction::GetDisplayName - Retrieves the display name of the function
	* @return the display name
	*/
	virtual std::string GetDisplayName() = 0;

	/**
	* IFunction::SetDisplayName - Sets the display name of the function
	* @param[in] sDisplayName - the display name
	*/
	virtual void SetDisplayName(const std::string & sDisplayName) = 0;

	/**
	* IFunction::AddInput - Add an input
	* @param[in] sIdentifier - the identifier of the input
	* @param[in] sDisplayName - the display name of the input
	* @param[in] eType - the type of the input
	* @return The added input port
	*/
	virtual IImplicitPort * AddInput(const std::string & sIdentifier, const std::string & sDisplayName, const Lib3MF::eImplicitPortType eType) = 0;

	/**
	* IFunction::GetInputs - Retrieves the inputs
	* @return iterator for the list of inputs
	*/
	virtual IImplicitPortIterator * GetInputs() = 0;

	/**
	* IFunction::RemoveInput - Removes an input
	* @param[in] pInput - The input to be removed
	*/
	virtual void RemoveInput(IImplicitPort* pInput) = 0;

	/**
	* IFunction::AddOutput - Add an output
	* @param[in] sIdentifier - the identifier of the output
	* @param[in] sDisplayName - the display name of the output
	* @param[in] eType - the type of the input
	* @return The added input port
	*/
	virtual IImplicitPort * AddOutput(const std::string & sIdentifier, const std::string & sDisplayName, const Lib3MF::eImplicitPortType eType) = 0;

	/**
	* IFunction::GetOutputs - Retrieves the outputs
	* @return iterator for the outputs
	*/
	virtual IImplicitPortIterator * GetOutputs() = 0;

	/**
	* IFunction::RemoveOutput - Removes an output
	* @param[in] pOutput - The output to be removed
	*/
	virtual void RemoveOutput(IImplicitPort* pOutput) = 0;

	/**
	* IFunction::FindInput - Retrieves an input
	* @param[in] sIdentifier - the identifier of the input
	* @return the input port
	*/
	virtual IImplicitPort * FindInput(const std::string & sIdentifier) = 0;

	/**
	* IFunction::FindOutput - Retrieves an output
	* @param[in] sIdentifier - the identifier of the output
	* @return the output port
	*/
	virtual IImplicitPort * FindOutput(const std::string & sIdentifier) = 0;

};

typedef IBaseSharedPtr<IFunction> PIFunction;


/*************************************************************************************************************************
 Class interface for ImplicitFunction 
**************************************************************************************************************************/

class IImplicitFunction : public virtual IFunction {
public:
	/**
	* IImplicitFunction::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6CE54469EEA83BC1UL; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitFunction"
	}

	/**
	* IImplicitFunction::GetIdentifier - Retrieves the identifier of the function
	* @return the identifier
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* IImplicitFunction::SetIdentifier - Sets the identifier of the function
	* @param[in] sIdentifier - the identifier
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* IImplicitFunction::AddNode - Add a node
	* @param[in] eNodeType - the type of the node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IImplicitNode * AddNode(const Lib3MF::eImplicitNodeType eNodeType, const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSinNode - Add a SinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISinNode * AddSinNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddCosNode - Add a CosNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ICosNode * AddCosNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddTanNode - Add a TanNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ITanNode * AddTanNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddArcSinNode - Add a ArcSinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IArcSinNode * AddArcSinNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddArcCosNode - Add a ArcCosNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IArcCosNode * AddArcCosNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddArcTan2Node - Add a ArcTan2Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IArcTan2Node * AddArcTan2Node(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSinhNode - Add a SinhNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISinhNode * AddSinhNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddCoshNode - Add a CoshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ICoshNode * AddCoshNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddTanhNode - Add a TanhNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ITanhNode * AddTanhNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddRoundNode - Add a RoundNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IRoundNode * AddRoundNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddCeilNode - Add a CeilNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ICeilNode * AddCeilNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddFloorNode - Add a FloorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IFloorNode * AddFloorNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSignNode - Add a SignNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISignNode * AddSignNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddFractNode - Add a FractNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IFractNode * AddFractNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddAbsNode - Add a AbsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IAbsNode * AddAbsNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddExpNode - Add a ExpNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IExpNode * AddExpNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddLogNode - Add a LogNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ILogNode * AddLogNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddLog2Node - Add a Log2Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ILog2Node * AddLog2Node(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddLog10Node - Add a Log10Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ILog10Node * AddLog10Node(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddLengthNode - Add a LengthNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ILengthNode * AddLengthNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddTransposeNode - Add a TransposeNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ITransposeNode * AddTransposeNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddInverseNode - Add a InverseNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IInverseNode * AddInverseNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSqrtNode - Add a SqrtNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISqrtNode * AddSqrtNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddResourceIdNode - Add a ResourceIdNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IResourceIdNode * AddResourceIdNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddAdditionNode - Add an AdditionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IAdditionNode * AddAdditionNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSubtractionNode - Add a SubtractionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISubtractionNode * AddSubtractionNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMultiplicationNode - Add a MultiplicationNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMultiplicationNode * AddMultiplicationNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddDivisionNode - Add a DivisionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IDivisionNode * AddDivisionNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddDotNode - Add a DotNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IDotNode * AddDotNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddCrossNode - Add a CrossNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ICrossNode * AddCrossNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMatVecMultiplicationNode - Add a MatVecMultiplicationNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMatVecMultiplicationNode * AddMatVecMultiplicationNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMinNode - Add a MinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMinNode * AddMinNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMaxNode - Add a MaxNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMaxNode * AddMaxNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddFmodNode - Add a FmodNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IFmodNode * AddFmodNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddPowNode - Add a PowNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IPowNode * AddPowNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddSelectNode - Add a SelectNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual ISelectNode * AddSelectNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddClampNode - Add a ClampNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IClampNode * AddClampNode(const std::string & sIdentifier, const Lib3MF::eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddComposeVectorNode - Add a ComposeVectorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IComposeVectorNode * AddComposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddVectorFromScalarNode - Add a VectorFromScalar
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IVectorFromScalarNode * AddVectorFromScalarNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddDecomposeVectorNode - Add a DecomposeVectorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IDecomposeVectorNode * AddDecomposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddComposeMatrixNode - Add a ComposeMatrixNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IComposeMatrixNode * AddComposeMatrixNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMatrixFromRowsNode - Add a MatrixFromRowsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMatrixFromRowsNode * AddMatrixFromRowsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMatrixFromColumnsNode - Add a MatrixFromColumnsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMatrixFromColumnsNode * AddMatrixFromColumnsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddConstantNode - Add a ConstantNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IConstantNode * AddConstantNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddConstVecNode - Add a ConstVecNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IConstVecNode * AddConstVecNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddConstMatNode - Add a ConstMatNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IConstMatNode * AddConstMatNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddMeshNode - Add a MeshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IMeshNode * AddMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddUnsignedMeshNode - Add a UnsignedMeshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IUnsignedMeshNode * AddUnsignedMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::AddFunctionCallNode - Add a FunctionCallNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	virtual IFunctionCallNode * AddFunctionCallNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag) = 0;

	/**
	* IImplicitFunction::GetNodes - Retrieves the nodes
	* @return iterator for the list of nodes
	*/
	virtual INodeIterator * GetNodes() = 0;

	/**
	* IImplicitFunction::RemoveNode - Removes a node
	* @param[in] pNode - The node to be removed
	*/
	virtual void RemoveNode(IImplicitNode* pNode) = 0;

	/**
	* IImplicitFunction::AddLink - Add a link
	* @param[in] pSource - the source port
	* @param[in] pTarget - the target port
	*/
	virtual void AddLink(IImplicitPort* pSource, IImplicitPort* pTarget) = 0;

	/**
	* IImplicitFunction::AddLinkByNames - Add a link
	* @param[in] sSource - name of the source port in the format nodename.portname
	* @param[in] sTarget - name of the target port in the format nodename.portname
	*/
	virtual void AddLinkByNames(const std::string & sSource, const std::string & sTarget) = 0;

	/**
	* IImplicitFunction::Clear - Clears the function
	*/
	virtual void Clear() = 0;

	/**
	* IImplicitFunction::SortNodesTopologically - Sorts the nodes topologically
	*/
	virtual void SortNodesTopologically() = 0;

};

typedef IBaseSharedPtr<IImplicitFunction> PIImplicitFunction;


/*************************************************************************************************************************
 Class interface for FunctionFromImage3D 
**************************************************************************************************************************/

class IFunctionFromImage3D : public virtual IFunction {
public:
	/**
	* IFunctionFromImage3D::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x9BD7D3C2026B8CE8UL; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionFromImage3D"
	}

	/**
	* IFunctionFromImage3D::GetImage3D - Returns the selected 3D image.
	* @return image instance
	*/
	virtual IImage3D * GetImage3D() = 0;

	/**
	* IFunctionFromImage3D::SetImage3D - Sets the 3D image of the selector.
	* @param[in] pImage3D - image instance
	*/
	virtual void SetImage3D(IImage3D* pImage3D) = 0;

	/**
	* IFunctionFromImage3D::SetFilter - Sets the texture filter of the selector.
	* @param[in] eFilter - texture filter
	*/
	virtual void SetFilter(const Lib3MF::eTextureFilter eFilter) = 0;

	/**
	* IFunctionFromImage3D::GetFilter - Returns the texture filter of the selector.
	* @return texture filter
	*/
	virtual Lib3MF::eTextureFilter GetFilter() = 0;

	/**
	* IFunctionFromImage3D::SetTileStyles - Sets the tile styles of the selector.
	* @param[in] eTileStyleU - tile style in U
	* @param[in] eTileStyleV - tile style in V
	* @param[in] eTileStyleW - tile style in W
	*/
	virtual void SetTileStyles(const Lib3MF::eTextureTileStyle eTileStyleU, const Lib3MF::eTextureTileStyle eTileStyleV, const Lib3MF::eTextureTileStyle eTileStyleW) = 0;

	/**
	* IFunctionFromImage3D::GetTileStyles - Retrieves the tile styles of the selector.
	* @param[out] eTileStyleU - tile style in U
	* @param[out] eTileStyleV - tile style in V
	* @param[out] eTileStyleW - tile style in W
	*/
	virtual void GetTileStyles(Lib3MF::eTextureTileStyle & eTileStyleU, Lib3MF::eTextureTileStyle & eTileStyleV, Lib3MF::eTextureTileStyle & eTileStyleW) = 0;

	/**
	* IFunctionFromImage3D::GetOffset - returns the offset value for the pixel values in the Image3D
	* @return the offset value for the pixel values in the Image3D
	*/
	virtual Lib3MF_double GetOffset() = 0;

	/**
	* IFunctionFromImage3D::SetOffset - Sets the offset value for the pixel values in the Image3D
	* @param[in] dOffset - the offset value for the pixel values in the Image3D
	*/
	virtual void SetOffset(const Lib3MF_double dOffset) = 0;

	/**
	* IFunctionFromImage3D::GetScale - returns the scale value for the pixel values in the Image3D
	* @return the scale value for the pixel values in the Image3D
	*/
	virtual Lib3MF_double GetScale() = 0;

	/**
	* IFunctionFromImage3D::SetScale - Sets the scale value for the pixel values in the Image3D
	* @param[in] dScale - the scale value for the pixel values in the Image3D
	*/
	virtual void SetScale(const Lib3MF_double dScale) = 0;

};

typedef IBaseSharedPtr<IFunctionFromImage3D> PIFunctionFromImage3D;


/*************************************************************************************************************************
 Class interface for BuildItem 
**************************************************************************************************************************/

class IBuildItem : public virtual IBase {
public:
	/**
	* IBuildItem::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x68FB2D5FFC4BA12AUL; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
	}

	/**
	* IBuildItem::GetObjectResource - Retrieves the object resource associated to a build item
	* @return returns the associated resource instance
	*/
	virtual IObject * GetObjectResource() = 0;

	/**
	* IBuildItem::GetUUID - returns, whether a build item has a UUID and, if true, the build item's UUID
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IBuildItem::SetUUID - sets the build item's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IBuildItem::GetObjectResourceID - Retrieves the object UniqueResourceID associated to a build item
	* @return returns the UniqueResourceID of the object
	*/
	virtual Lib3MF_uint32 GetObjectResourceID() = 0;

	/**
	* IBuildItem::HasObjectTransform - Checks, if a build item has a non-identity transformation matrix
	* @return returns true, if the transformation matrix is not the identity
	*/
	virtual bool HasObjectTransform() = 0;

	/**
	* IBuildItem::GetObjectTransform - Retrieves a build item's transformation matrix.
	* @return returns the transformation matrix
	*/
	virtual Lib3MF::sTransform GetObjectTransform() = 0;

	/**
	* IBuildItem::SetObjectTransform - Sets a build item's transformation matrix.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetObjectTransform(const Lib3MF::sTransform Transform) = 0;

	/**
	* IBuildItem::GetPartNumber - Retrieves a build item's part number string
	* @return Returns a build item's part number string
	*/
	virtual std::string GetPartNumber() = 0;

	/**
	* IBuildItem::SetPartNumber - Sets a build item's part number string
	* @param[in] sSetPartnumber - new part number string for referencing parts from the outside world
	*/
	virtual void SetPartNumber(const std::string & sSetPartnumber) = 0;

	/**
	* IBuildItem::GetMetaDataGroup - Returns the metadatagroup of this build item
	* @return returns an Instance of the metadatagroup of this build item
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IBuildItem::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

};

typedef IBaseSharedPtr<IBuildItem> PIBuildItem;


/*************************************************************************************************************************
 Class interface for BuildItemIterator 
**************************************************************************************************************************/

class IBuildItemIterator : public virtual IBase {
public:
	/**
	* IBuildItemIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA7D21BD364910860UL; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
	}

	/**
	* IBuildItemIterator::MoveNext - Iterates to the next build item in the list.
	* @return Iterates to the next build item in the list.
	*/
	virtual bool MoveNext() = 0;

	/**
	* IBuildItemIterator::MovePrevious - Iterates to the previous build item in the list.
	* @return Iterates to the previous build item in the list.
	*/
	virtual bool MovePrevious() = 0;

	/**
	* IBuildItemIterator::GetCurrent - Returns the build item the iterator points at.
	* @return returns the build item instance.
	*/
	virtual IBuildItem * GetCurrent() = 0;

	/**
	* IBuildItemIterator::Clone - Creates a new build item iterator with the same build item list.
	* @return returns the cloned Iterator instance
	*/
	virtual IBuildItemIterator * Clone() = 0;

	/**
	* IBuildItemIterator::Count - Returns the number of build items the iterator captures.
	* @return returns the number of build items the iterator captures.
	*/
	virtual Lib3MF_uint64 Count() = 0;

};

typedef IBaseSharedPtr<IBuildItemIterator> PIBuildItemIterator;


/*************************************************************************************************************************
 Class interface for Slice 
**************************************************************************************************************************/

class ISlice : public virtual IBase {
public:
	/**
	* ISlice::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2198BCF4D8DF9C40UL; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
	}

	/**
	* ISlice::SetVertices - Set all vertices of a slice. All polygons will be cleared.
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[in] pVerticesBuffer - contains the positions.
	*/
	virtual void SetVertices(const Lib3MF_uint64 nVerticesBufferSize, const Lib3MF::sPosition2D * pVerticesBuffer) = 0;

	/**
	* ISlice::GetVertices - Get all vertices of a slice
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pVerticesBuffer - Position2D buffer of contains the positions.
	*/
	virtual void GetVertices(Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, Lib3MF::sPosition2D * pVerticesBuffer) = 0;

	/**
	* ISlice::GetVertexCount - Get the number of vertices in a slice
	* @return the number of vertices in the slice
	*/
	virtual Lib3MF_uint64 GetVertexCount() = 0;

	/**
	* ISlice::AddPolygon - Add a new polygon to this slice
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - the new indices of the new polygon
	* @return the index of the new polygon
	*/
	virtual Lib3MF_uint64 AddPolygon(const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonCount - Get the number of polygons in the slice
	* @return the number of polygons in the slice
	*/
	virtual Lib3MF_uint64 GetPolygonCount() = 0;

	/**
	* ISlice::SetPolygonIndices - Set all indices of a polygon
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - the new indices of the index-th polygon
	*/
	virtual void SetPolygonIndices(const Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonIndices - Get all vertices of a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pIndicesBuffer - uint32 buffer of the indices of the index-th polygon 
	*/
	virtual void GetPolygonIndices(const Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonIndexCount - Get the number of vertices in a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @return the number of indices of the index-th polygon
	*/
	virtual Lib3MF_uint64 GetPolygonIndexCount(const Lib3MF_uint64 nIndex) = 0;

	/**
	* ISlice::GetZTop - Get the upper Z-Coordinate of this slice.
	* @return the upper Z-Coordinate of this slice
	*/
	virtual Lib3MF_double GetZTop() = 0;

};

typedef IBaseSharedPtr<ISlice> PISlice;


/*************************************************************************************************************************
 Class interface for SliceStack 
**************************************************************************************************************************/

class ISliceStack : public virtual IResource {
public:
	/**
	* ISliceStack::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6594B031B6096238UL; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
	}

	/**
	* ISliceStack::GetBottomZ - Get the lower Z-Coordinate of the slice stack.
	* @return the lower Z-Coordinate the slice stack
	*/
	virtual Lib3MF_double GetBottomZ() = 0;

	/**
	* ISliceStack::GetSliceCount - Returns the number of slices
	* @return the number of slices
	*/
	virtual Lib3MF_uint64 GetSliceCount() = 0;

	/**
	* ISliceStack::GetSlice - Query a slice from the slice stack
	* @param[in] nSliceIndex - the index of the slice
	* @return the Slice instance
	*/
	virtual ISlice * GetSlice(const Lib3MF_uint64 nSliceIndex) = 0;

	/**
	* ISliceStack::AddSlice - Returns the number of slices
	* @param[in] dZTop - upper Z coordinate of the slice
	* @return a new Slice instance
	*/
	virtual ISlice * AddSlice(const Lib3MF_double dZTop) = 0;

	/**
	* ISliceStack::GetSliceRefCount - Returns the number of slice refs
	* @return the number of slicereferences
	*/
	virtual Lib3MF_uint64 GetSliceRefCount() = 0;

	/**
	* ISliceStack::AddSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] pTheSliceStack - the slicestack to use as sliceref
	*/
	virtual void AddSliceStackReference(ISliceStack* pTheSliceStack) = 0;

	/**
	* ISliceStack::GetSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] nSliceRefIndex - the index of the slice ref
	* @return the slicestack that is used as sliceref
	*/
	virtual ISliceStack * GetSliceStackReference(const Lib3MF_uint64 nSliceRefIndex) = 0;

	/**
	* ISliceStack::CollapseSliceReferences - Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
	*/
	virtual void CollapseSliceReferences() = 0;

	/**
	* ISliceStack::SetOwnPath - Sets the package path where this Slice should be stored. Input an empty string to reset the path
	* @param[in] sPath - the package path where this Slice should be stored
	*/
	virtual void SetOwnPath(const std::string & sPath) = 0;

	/**
	* ISliceStack::GetOwnPath - Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
	* @return the package path where this Slice will be stored
	*/
	virtual std::string GetOwnPath() = 0;

};

typedef IBaseSharedPtr<ISliceStack> PISliceStack;


/*************************************************************************************************************************
 Class interface for Consumer 
**************************************************************************************************************************/

class IConsumer : public virtual IBase {
public:
	/**
	* IConsumer::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD9E46D5E6D8118EEUL; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
	}

	/**
	* IConsumer::GetConsumerID - Gets the consumerid
	* @return A unique identifier for the consumers
	*/
	virtual std::string GetConsumerID() = 0;

	/**
	* IConsumer::GetKeyID - Getts the keyid
	* @return The identifier for the key of this consumer
	*/
	virtual std::string GetKeyID() = 0;

	/**
	* IConsumer::GetKeyValue - Gets the keyvalue associated with this consumer
	* @return The public key, when available, of this consumer
	*/
	virtual std::string GetKeyValue() = 0;

};

typedef IBaseSharedPtr<IConsumer> PIConsumer;


/*************************************************************************************************************************
 Class interface for AccessRight 
**************************************************************************************************************************/

class IAccessRight : public virtual IBase {
public:
	/**
	* IAccessRight::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x385C42FC5609498AUL; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
	}

	/**
	* IAccessRight::GetConsumer - Gets the consumer associated with this access right
	* @return The consumer instance
	*/
	virtual IConsumer * GetConsumer() = 0;

	/**
	* IAccessRight::GetWrappingAlgorithm - Gets the associated encryption algorithm
	* @return The algorithm used for the key in this accessright
	*/
	virtual Lib3MF::eWrappingAlgorithm GetWrappingAlgorithm() = 0;

	/**
	* IAccessRight::GetMgfAlgorithm - Gets the associated mask generation function algorithm
	* @return The MFG1 algorithm
	*/
	virtual Lib3MF::eMgfAlgorithm GetMgfAlgorithm() = 0;

	/**
	* IAccessRight::GetDigestMethod - Gets the digest method assoicated
	* @return The digest method for this accessright
	*/
	virtual Lib3MF::eDigestMethod GetDigestMethod() = 0;

};

typedef IBaseSharedPtr<IAccessRight> PIAccessRight;


/*************************************************************************************************************************
 Class interface for ContentEncryptionParams 
**************************************************************************************************************************/

class IContentEncryptionParams : public virtual IBase {
public:
	/**
	* IContentEncryptionParams::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x7FB36B91D4CE4671UL; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
	}

	/**
	* IContentEncryptionParams::GetEncryptionAlgorithm - Returns the encryption method to be used in this encryption process
	* @return 
	*/
	virtual Lib3MF::eEncryptionAlgorithm GetEncryptionAlgorithm() = 0;

	/**
	* IContentEncryptionParams::GetKey - Gets the key for the resource associated
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the key.
	*/
	virtual void GetKey(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetInitializationVector - Gets the IV data
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	*/
	virtual void GetInitializationVector(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetAuthenticationTag - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	*/
	virtual void GetAuthenticationTag(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::SetAuthenticationTag - Sets the authentication tag
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[in] pByteDataBuffer - The authentication tag size
	*/
	virtual void SetAuthenticationTag(const Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetAdditionalAuthenticationData - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Buffer where the data will be placed
	*/
	virtual void GetAdditionalAuthenticationData(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetDescriptor - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @return 
	*/
	virtual Lib3MF_uint64 GetDescriptor() = 0;

	/**
	* IContentEncryptionParams::GetKeyUUID - Gets the resourcedatagroup keyuuid
	* @return The resourcedatagroup keyuuid that may be use to reference an external key
	*/
	virtual std::string GetKeyUUID() = 0;

};

typedef IBaseSharedPtr<IContentEncryptionParams> PIContentEncryptionParams;


/*************************************************************************************************************************
 Class interface for ResourceData 
**************************************************************************************************************************/

class IResourceData : public virtual IBase {
public:
	/**
	* IResourceData::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1A47A5E258E22EF9UL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
	}

	/**
	* IResourceData::GetPath - Gets the encrypted part path
	* @return The part path
	*/
	virtual IPackagePart * GetPath() = 0;

	/**
	* IResourceData::GetEncryptionAlgorithm - Gets the encryption algorithm used to encrypt this ResourceData
	* @return The encryption algorithm
	*/
	virtual Lib3MF::eEncryptionAlgorithm GetEncryptionAlgorithm() = 0;

	/**
	* IResourceData::GetCompression - Tells whether this ResourceData is compressed or not
	* @return The compression method
	*/
	virtual Lib3MF::eCompression GetCompression() = 0;

	/**
	* IResourceData::GetAdditionalAuthenticationData - Tells whether this ResourceData is compressed or not
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of The compression method
	*/
	virtual void GetAdditionalAuthenticationData(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

};

typedef IBaseSharedPtr<IResourceData> PIResourceData;


/*************************************************************************************************************************
 Class interface for ResourceDataGroup 
**************************************************************************************************************************/

class IResourceDataGroup : public virtual IBase {
public:
	/**
	* IResourceDataGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD59067227E428AA4UL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
	}

	/**
	* IResourceDataGroup::GetKeyUUID - Sets the resourcedatagroup keyuuid
	* @return The new resourcedatagroup keyuuid.
	*/
	virtual std::string GetKeyUUID() = 0;

	/**
	* IResourceDataGroup::AddAccessRight - Add accessright to resourcedatagroup element
	* @param[in] pConsumer - The Consumer reference
	* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
	* @param[in] eMgfAlgorithm - The mask generation function to be used
	* @param[in] eDigestMethod - The digest mechanism to be used
	* @return The acess right instance
	*/
	virtual IAccessRight * AddAccessRight(IConsumer* pConsumer, const Lib3MF::eWrappingAlgorithm eWrappingAlgorithm, const Lib3MF::eMgfAlgorithm eMgfAlgorithm, const Lib3MF::eDigestMethod eDigestMethod) = 0;

	/**
	* IResourceDataGroup::FindAccessRightByConsumer - Finds the AccessRight associated with a Consumer
	* @param[in] pConsumer - The Consumer instance
	* @return The AcessRight instance
	*/
	virtual IAccessRight * FindAccessRightByConsumer(IConsumer* pConsumer) = 0;

	/**
	* IResourceDataGroup::RemoveAccessRight - Removes access from a Consumer on this resource data group
	* @param[in] pConsumer - The Consumer instance
	*/
	virtual void RemoveAccessRight(IConsumer* pConsumer) = 0;

};

typedef IBaseSharedPtr<IResourceDataGroup> PIResourceDataGroup;


/*************************************************************************************************************************
 Class interface for KeyStore 
**************************************************************************************************************************/

class IKeyStore : public virtual IBase {
public:
	/**
	* IKeyStore::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1CC9E0CC082253C6UL; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
	}

	/**
	* IKeyStore::AddConsumer - Adds a consumer to the keystore
	* @param[in] sConsumerID - A unique identifier for the consumer
	* @param[in] sKeyID - The id of the key of the consumer
	* @param[in] sKeyValue - The public key for this consumer in PEM format
	* @return The consumer instance
	*/
	virtual IConsumer * AddConsumer(const std::string & sConsumerID, const std::string & sKeyID, const std::string & sKeyValue) = 0;

	/**
	* IKeyStore::GetConsumerCount - Gets the number of consumers in the keystore
	* @return The consumer count
	*/
	virtual Lib3MF_uint64 GetConsumerCount() = 0;

	/**
	* IKeyStore::GetConsumer - Get a consumer from the keystore
	* @param[in] nConsumerIndex - The index of the consumer
	* @return The consumer instance
	*/
	virtual IConsumer * GetConsumer(const Lib3MF_uint64 nConsumerIndex) = 0;

	/**
	* IKeyStore::RemoveConsumer - Removes a consumer from the keystore
	* @param[in] pConsumer - The consumer instance to remove
	*/
	virtual void RemoveConsumer(IConsumer* pConsumer) = 0;

	/**
	* IKeyStore::FindConsumer - Finds a consumer by ID
	* @param[in] sConsumerID - The ID of the consumer
	* @return The consumer instance
	*/
	virtual IConsumer * FindConsumer(const std::string & sConsumerID) = 0;

	/**
	* IKeyStore::GetResourceDataGroupCount - Gets the number of resource data group in the keysore
	* @return The number of resource data available
	*/
	virtual Lib3MF_uint64 GetResourceDataGroupCount() = 0;

	/**
	* IKeyStore::AddResourceDataGroup - Adds a resource data group into the keystore.
	* @return The resource data group instance
	*/
	virtual IResourceDataGroup * AddResourceDataGroup() = 0;

	/**
	* IKeyStore::GetResourceDataGroup - Gets a resource data group
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The resource data group instance
	*/
	virtual IResourceDataGroup * GetResourceDataGroup(const Lib3MF_uint64 nResourceDataIndex) = 0;

	/**
	* IKeyStore::RemoveResourceDataGroup - Removes a resource data group
	* @param[in] pResourceDataGroup - The resource data group instance
	*/
	virtual void RemoveResourceDataGroup(IResourceDataGroup* pResourceDataGroup) = 0;

	/**
	* IKeyStore::FindResourceDataGroup - Finds a resource data group that contains a particular resourcedata
	* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
	* @return The data resource instance
	*/
	virtual IResourceDataGroup * FindResourceDataGroup(IPackagePart* pPartPath) = 0;

	/**
	* IKeyStore::AddResourceData - Add resourcedata to resourcedatagroup element
	* @param[in] pResourceDataGroup - The resource data group where to add this resource data
	* @param[in] pPartPath - The path of the part to be encrypted
	* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
	* @param[in] eCompression - Whether compression should be used prior to encryption
	* @param[in] nAdditionalAuthenticationDataBufferSize - Number of elements in buffer
	* @param[in] pAdditionalAuthenticationDataBuffer - Additional data to be encrypted along the contents for better security
	* @return The data resource instance
	*/
	virtual IResourceData * AddResourceData(IResourceDataGroup* pResourceDataGroup, IPackagePart* pPartPath, const Lib3MF::eEncryptionAlgorithm eAlgorithm, const Lib3MF::eCompression eCompression, const Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer) = 0;

	/**
	* IKeyStore::RemoveResourceData - Removes a resource data
	* @param[in] pResourceData - The resource data to be removed
	*/
	virtual void RemoveResourceData(IResourceData* pResourceData) = 0;

	/**
	* IKeyStore::FindResourceData - Finds a resource data on this resource group
	* @param[in] pResourcePath - The target path for the resourcedata
	* @return The resource data instance
	*/
	virtual IResourceData * FindResourceData(IPackagePart* pResourcePath) = 0;

	/**
	* IKeyStore::GetResourceDataCount - Gets the number of resource data in the keysore
	* @return The number of resource data available
	*/
	virtual Lib3MF_uint64 GetResourceDataCount() = 0;

	/**
	* IKeyStore::GetResourceData - Gets a resource data
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The data resource instance
	*/
	virtual IResourceData * GetResourceData(const Lib3MF_uint64 nResourceDataIndex) = 0;

	/**
	* IKeyStore::GetUUID - Gets the keystore UUID
	* @param[out] bHasUUID - flag whether the keystore has a UUID
	* @return returns the keystore uuid.
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IKeyStore::SetUUID - Sets the keystore UUID
	* @param[in] sUUID - The new keystore uuid.
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

};

typedef IBaseSharedPtr<IKeyStore> PIKeyStore;


/*************************************************************************************************************************
 Class interface for Model 
**************************************************************************************************************************/

class IModel : public virtual IBase {
public:
	/**
	* IModel::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x5A8164ECEDB03F09UL; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
	}

	/**
	* IModel::RootModelPart - Returns the PackagePart within the OPC package that holds the root model.
	* @return the PackagePart within the OPC package that holds the model-file
	*/
	virtual IPackagePart * RootModelPart() = 0;

	/**
	* IModel::FindOrCreatePackagePart - Returns a new PackagePart for use within the OPC package.
	* @param[in] sAbsolutePath - the absolute Path (physical location) within the OPC package
	* @return the new PackagePart within the OPC package
	*/
	virtual IPackagePart * FindOrCreatePackagePart(const std::string & sAbsolutePath) = 0;

	/**
	* IModel::SetUnit - sets the units of a model.
	* @param[in] eUnit - Unit enum value for the model unit
	*/
	virtual void SetUnit(const Lib3MF::eModelUnit eUnit) = 0;

	/**
	* IModel::GetUnit - returns the units of a model.
	* @return Unit enum value for the model unit
	*/
	virtual Lib3MF::eModelUnit GetUnit() = 0;

	/**
	* IModel::GetLanguage - retrieves the language of a model
	* @return language identifier
	*/
	virtual std::string GetLanguage() = 0;

	/**
	* IModel::SetLanguage - sets the language of a model
	* @param[in] sLanguage - language identifier
	*/
	virtual void SetLanguage(const std::string & sLanguage) = 0;

	/**
	* IModel::QueryWriter - creates a model writer instance for a specific file type
	* @param[in] sWriterClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	virtual IWriter * QueryWriter(const std::string & sWriterClass) = 0;

	/**
	* IModel::QueryReader - creates a model reader instance for a specific file type
	* @param[in] sReaderClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	virtual IReader * QueryReader(const std::string & sReaderClass) = 0;

	/**
	* IModel::GetResourceByID - finds a model resource by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the resource instance
	*/
	virtual IResource * GetResourceByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetTexture2DByID - finds a model texture by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the texture2d instance
	*/
	virtual ITexture2D * GetTexture2DByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetPropertyTypeByID - returns a Property's type
	* @param[in] nUniqueResourceID - Resource ID of the Property to Query
	* @return returns a Property's type
	*/
	virtual Lib3MF::ePropertyType GetPropertyTypeByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetBaseMaterialGroupByID - finds a model base material group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the BaseMaterialGroup instance
	*/
	virtual IBaseMaterialGroup * GetBaseMaterialGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetTexture2DGroupByID - finds a model texture2d group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the Texture2DGroup instance
	*/
	virtual ITexture2DGroup * GetTexture2DGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetCompositeMaterialsByID - finds a model CompositeMaterials by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the CompositeMaterials instance
	*/
	virtual ICompositeMaterials * GetCompositeMaterialsByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetMultiPropertyGroupByID - finds a model MultiPropertyGroup by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the MultiPropertyGroup instance
	*/
	virtual IMultiPropertyGroup * GetMultiPropertyGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetMeshObjectByID - finds a mesh object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the mesh object instance
	*/
	virtual IMeshObject * GetMeshObjectByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetComponentsObjectByID - finds a components object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the components object instance
	*/
	virtual IComponentsObject * GetComponentsObjectByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetColorGroupByID - finds a model color group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the ColorGroup instance
	*/
	virtual IColorGroup * GetColorGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetSliceStackByID - finds a model slicestack by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the slicestack instance
	*/
	virtual ISliceStack * GetSliceStackByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetLevelSetByID - finds a level set object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the level set object instance
	*/
	virtual ILevelSet * GetLevelSetByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetBuildUUID - returns, whether a build has a UUID and, if true, the build's UUID
	* @param[out] bHasUUID - flag whether the build has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetBuildUUID(bool & bHasUUID) = 0;

	/**
	* IModel::SetBuildUUID - sets the build's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetBuildUUID(const std::string & sUUID) = 0;

	/**
	* IModel::GetBuildItems - creates a build item iterator instance with all build items.
	* @return returns the iterator instance.
	*/
	virtual IBuildItemIterator * GetBuildItems() = 0;

	/**
	* IModel::GetOutbox - Returns the outbox of a Model
	* @return Outbox of this Model
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

	/**
	* IModel::GetResources - creates a resource iterator instance with all resources.
	* @return returns the iterator instance.
	*/
	virtual IResourceIterator * GetResources() = 0;

	/**
	* IModel::GetObjects - creates a resource iterator instance with all object resources.
	* @return returns the iterator instance.
	*/
	virtual IObjectIterator * GetObjects() = 0;

	/**
	* IModel::GetMeshObjects - creates a resource iterator instance with all mesh object resources.
	* @return returns the iterator instance.
	*/
	virtual IMeshObjectIterator * GetMeshObjects() = 0;

	/**
	* IModel::GetComponentsObjects - creates a resource iterator instance with all components object resources.
	* @return returns the iterator instance.
	*/
	virtual IComponentsObjectIterator * GetComponentsObjects() = 0;

	/**
	* IModel::GetTexture2Ds - creates a Texture2DIterator instance with all texture2d resources.
	* @return returns the iterator instance.
	*/
	virtual ITexture2DIterator * GetTexture2Ds() = 0;

	/**
	* IModel::GetBaseMaterialGroups - creates a BaseMaterialGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	virtual IBaseMaterialGroupIterator * GetBaseMaterialGroups() = 0;

	/**
	* IModel::GetColorGroups - creates a ColorGroupIterator instance with all ColorGroup resources.
	* @return returns the iterator instance.
	*/
	virtual IColorGroupIterator * GetColorGroups() = 0;

	/**
	* IModel::GetTexture2DGroups - creates a Texture2DGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	virtual ITexture2DGroupIterator * GetTexture2DGroups() = 0;

	/**
	* IModel::GetCompositeMaterials - creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
	* @return returns the iterator instance.
	*/
	virtual ICompositeMaterialsIterator * GetCompositeMaterials() = 0;

	/**
	* IModel::GetMultiPropertyGroups - creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
	* @return returns the iterator instance.
	*/
	virtual IMultiPropertyGroupIterator * GetMultiPropertyGroups() = 0;

	/**
	* IModel::GetSliceStacks - creates a resource iterator instance with all slice stack resources.
	* @return returns the iterator instance.
	*/
	virtual ISliceStackIterator * GetSliceStacks() = 0;

	/**
	* IModel::GetImage3Ds - creates a resource iterator instance with all image3d resources.
	* @return returns the iterator instance.
	*/
	virtual IImage3DIterator * GetImage3Ds() = 0;

	/**
	* IModel::MergeToModel - Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
	* @return returns the merged model instance
	*/
	virtual IModel * MergeToModel() = 0;

	/**
	* IModel::MergeFromModel - Merges the given model into this model.
	* @param[in] pModelInstance - model to be merged
	*/
	virtual void MergeFromModel(IModel* pModelInstance) = 0;

	/**
	* IModel::AddMeshObject - adds an empty mesh object to the model.
	* @return  returns the mesh object instance
	*/
	virtual IMeshObject * AddMeshObject() = 0;

	/**
	* IModel::AddComponentsObject - adds an empty component object to the model.
	* @return  returns the components object instance
	*/
	virtual IComponentsObject * AddComponentsObject() = 0;

	/**
	* IModel::AddSliceStack - creates a new model slicestack by its id
	* @param[in] dZBottom - Bottom Z value of the slicestack
	* @return returns the new slicestack instance
	*/
	virtual ISliceStack * AddSliceStack(const Lib3MF_double dZBottom) = 0;

	/**
	* IModel::AddTexture2DFromAttachment - adds a texture2d resource to the model. Its path is given by that of an existing attachment.
	* @param[in] pTextureAttachment - attachment containing the image data.
	* @return returns the new texture instance.
	*/
	virtual ITexture2D * AddTexture2DFromAttachment(IAttachment* pTextureAttachment) = 0;

	/**
	* IModel::AddBaseMaterialGroup - adds an empty BaseMaterialGroup resource to the model.
	* @return returns the new base material instance.
	*/
	virtual IBaseMaterialGroup * AddBaseMaterialGroup() = 0;

	/**
	* IModel::AddColorGroup - adds an empty ColorGroup resource to the model.
	* @return returns the new ColorGroup instance.
	*/
	virtual IColorGroup * AddColorGroup() = 0;

	/**
	* IModel::AddTexture2DGroup - adds an empty Texture2DGroup resource to the model.
	* @param[in] pTexture2DInstance - The texture2D instance of the created Texture2DGroup.
	* @return returns the new Texture2DGroup instance.
	*/
	virtual ITexture2DGroup * AddTexture2DGroup(ITexture2D* pTexture2DInstance) = 0;

	/**
	* IModel::AddCompositeMaterials - adds an empty CompositeMaterials resource to the model.
	* @param[in] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
	* @return returns the new CompositeMaterials instance.
	*/
	virtual ICompositeMaterials * AddCompositeMaterials(IBaseMaterialGroup* pBaseMaterialGroupInstance) = 0;

	/**
	* IModel::AddMultiPropertyGroup - adds an empty MultiPropertyGroup resource to the model.
	* @return returns the new MultiPropertyGroup instance.
	*/
	virtual IMultiPropertyGroup * AddMultiPropertyGroup() = 0;

	/**
	* IModel::AddImageStack - creates a new 3D Image Resource
	* @param[in] nColumnCount - the number of columns in each sheet.
	* @param[in] nRowCount - the number of rows in each sheet.
	* @param[in] nSheetCount - the number of sheets in the image stack.
	* @return returns the new ImageStack instance
	*/
	virtual IImageStack * AddImageStack(const Lib3MF_uint32 nColumnCount, const Lib3MF_uint32 nRowCount, const Lib3MF_uint32 nSheetCount) = 0;

	/**
	* IModel::GetImageStackByID - finds an ImageStack object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the image stack instance
	*/
	virtual IImageStack * GetImageStackByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::AddBuildItem - adds a build item to the model.
	* @param[in] pObject - Object instance.
	* @param[in] Transform - Transformation matrix.
	* @return returns the build item instance.
	*/
	virtual IBuildItem * AddBuildItem(IObject* pObject, const Lib3MF::sTransform Transform) = 0;

	/**
	* IModel::RemoveBuildItem - removes a build item from the model
	* @param[in] pBuildItemInstance - Build item to remove.
	*/
	virtual void RemoveBuildItem(IBuildItem* pBuildItemInstance) = 0;

	/**
	* IModel::GetMetaDataGroup - Returns the metadata of the model as MetaDataGroup
	* @return returns an Instance of the metadatagroup of the model
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IModel::AddAttachment - adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
	* @param[in] sURI - Path of the attachment
	* @param[in] sRelationShipType - Relationship type of the attachment
	* @return Instance of the attachment object
	*/
	virtual IAttachment * AddAttachment(const std::string & sURI, const std::string & sRelationShipType) = 0;

	/**
	* IModel::RemoveAttachment - Removes attachment from the model.
	* @param[in] pAttachmentInstance - Attachment instance to remove
	*/
	virtual void RemoveAttachment(IAttachment* pAttachmentInstance) = 0;

	/**
	* IModel::GetAttachment - retrieves an attachment stream object from the model..
	* @param[in] nIndex - Index of the attachment stream
	* @return Instance of the attachment object
	*/
	virtual IAttachment * GetAttachment(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IModel::FindAttachment - retrieves an attachment stream object from the model.
	* @param[in] sURI - Path URI in the package
	* @return Instance of the attachment object
	*/
	virtual IAttachment * FindAttachment(const std::string & sURI) = 0;

	/**
	* IModel::GetAttachmentCount - retrieves the number of attachments of the model.
	* @return Returns the number of attachments.
	*/
	virtual Lib3MF_uint32 GetAttachmentCount() = 0;

	/**
	* IModel::HasPackageThumbnailAttachment - Retrieve whether the OPC package contains a package thumbnail.
	* @return returns whether the OPC package contains a package thumbnail
	*/
	virtual bool HasPackageThumbnailAttachment() = 0;

	/**
	* IModel::CreatePackageThumbnailAttachment - Create a new or the existing package thumbnail for the OPC package.
	* @return Instance of a new or the existing thumbnailattachment object.
	*/
	virtual IAttachment * CreatePackageThumbnailAttachment() = 0;

	/**
	* IModel::GetPackageThumbnailAttachment - Get the attachment to the OPC package containing the package thumbnail.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	virtual IAttachment * GetPackageThumbnailAttachment() = 0;

	/**
	* IModel::RemovePackageThumbnailAttachment - Remove the attachment to the OPC package containing the package thumbnail.
	*/
	virtual void RemovePackageThumbnailAttachment() = 0;

	/**
	* IModel::AddCustomContentType - Adds a new Content Type to the model.
	* @param[in] sExtension - File Extension
	* @param[in] sContentType - Content Type Identifier
	*/
	virtual void AddCustomContentType(const std::string & sExtension, const std::string & sContentType) = 0;

	/**
	* IModel::RemoveCustomContentType - Removes a custom Content Type from the model (UTF8 version).
	* @param[in] sExtension - File Extension
	*/
	virtual void RemoveCustomContentType(const std::string & sExtension) = 0;

	/**
	* IModel::SetRandomNumberCallback - Sets the random number generator callback for use in the library
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata to be passed to the callback function
	*/
	virtual void SetRandomNumberCallback(const Lib3MF::RandomNumberCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IModel::GetKeyStore - Gets the keystore associated with this model
	* @return The package keystore
	*/
	virtual IKeyStore * GetKeyStore() = 0;

	/**
	* IModel::GetFunctions - creates a resource iterator for all functions
	* @return returns the resource iterator
	*/
	virtual IFunctionIterator * GetFunctions() = 0;

	/**
	* IModel::AddImplicitFunction - adds a function described by nodes to the model
	* @return returns the function instance
	*/
	virtual IImplicitFunction * AddImplicitFunction() = 0;

	/**
	* IModel::AddFunctionFromImage3D - adds a function defined by an image3d to the model
	* @param[in] pImage3DInstance - the Image3D-instance used for this function
	* @return returns the function instance
	*/
	virtual IFunctionFromImage3D * AddFunctionFromImage3D(IImage3D* pImage3DInstance) = 0;

	/**
	* IModel::AddVolumeData - adds a volume data resource to the model.
	* @return returns the new volume data instance.
	*/
	virtual IVolumeData * AddVolumeData() = 0;

	/**
	* IModel::AddLevelSet - adds an empty boundary shape object to the model.
	* @return  returns the mesh object instance
	*/
	virtual ILevelSet * AddLevelSet() = 0;

	/**
	* IModel::GetLevelSets - creates a resource iterator instance with all boundary shape resources.
	* @return returns the iterator instance.
	*/
	virtual ILevelSetIterator * GetLevelSets() = 0;

	/**
	* IModel::RemoveResource - Removes a resource from the model
	* @param[in] pResource - The resource to remove
	*/
	virtual void RemoveResource(IResource* pResource) = 0;

};

typedef IBaseSharedPtr<IModel> PIModel;


/*************************************************************************************************************************
 Global functions declarations
**************************************************************************************************************************/
class CWrapper {
public:
	/**
	* Ilib3mf::GetLibraryVersion - retrieves the binary version of this library.
	* @param[out] nMajor - returns the major version of this library
	* @param[out] nMinor - returns the minor version of this library
	* @param[out] nMicro - returns the micro version of this library
	*/
	static void GetLibraryVersion(Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);

	/**
	* Ilib3mf::GetPrereleaseInformation - retrieves prerelease information of this library.
	* @return Does the library provide prerelease version?
	* @param[out] sPrereleaseInfo - retrieves prerelease information of this library.
	*/
	static bool GetPrereleaseInformation(std::string & sPrereleaseInfo);

	/**
	* Ilib3mf::GetBuildInformation - retrieves build information of this library.
	* @return Does the library provide build version?
	* @param[out] sBuildInformation - retrieves build information of this library.
	*/
	static bool GetBuildInformation(std::string & sBuildInformation);

	/**
	* Ilib3mf::GetSpecificationVersion - retrieves whether a specification is supported, and if so, which version.
	* @param[in] sSpecificationURL - URL of extension to check
	* @param[out] bIsSupported - returns whether this specification is supported
	* @param[out] nMajor - returns the major version of the extension (if IsSupported)
	* @param[out] nMinor - returns the minor version of the extension (if IsSupported)
	* @param[out] nMicro - returns the micro version of the extension (if IsSupported)
	*/
	static void GetSpecificationVersion(const std::string & sSpecificationURL, bool & bIsSupported, Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);

	/**
	* Ilib3mf::CreateModel - creates an empty model instance.
	* @return returns an empty model instance
	*/
	static IModel * CreateModel();

	/**
	* Ilib3mf::Release - releases shared ownership of an object instance
	* @param[in] pInstance - the object instance to release
	*/
	static void Release(IBase* pInstance);

	/**
	* Ilib3mf::Acquire - acquires shared ownership of an object instance
	* @param[in] pInstance - the object instance to acquire
	*/
	static void Acquire(IBase* pInstance);

	/**
	* Ilib3mf::GetLastError - Retrieves the last error string of an instance
	* @param[in] pInstance - Object where the error occured.
	* @param[out] sLastErrorString - Last Error String
	* @return Returns if the instance has a last error.
	*/
	static bool GetLastError(IBase* pInstance, std::string & sLastErrorString);

	/**
	* Ilib3mf::RetrieveProgressMessage - Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
	* @param[out] sProgressMessage - English text for the progress identifier
	*/
	static void RetrieveProgressMessage(const Lib3MF::eProgressIdentifier eTheProgressIdentifier, std::string & sProgressMessage);

	/**
	* Ilib3mf::RGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] nRed - Red value of color (0-255)
	* @param[in] nGreen - Green value of color (0-255)
	* @param[in] nBlue - Blue value of color (0-255)
	* @param[in] nAlpha - Alpha value of color (0-255)
	* @return Assembled color
	*/
	static Lib3MF::sColor RGBAToColor(const Lib3MF_uint8 nRed, const Lib3MF_uint8 nGreen, const Lib3MF_uint8 nBlue, const Lib3MF_uint8 nAlpha);

	/**
	* Ilib3mf::FloatRGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] fRed - Red value of color (0-1)
	* @param[in] fGreen - Green value of color (0-1)
	* @param[in] fBlue - Blue value of color (0-1)
	* @param[in] fAlpha - Alpha value of color (0-1)
	* @return Assembled color
	*/
	static Lib3MF::sColor FloatRGBAToColor(const Lib3MF_single fRed, const Lib3MF_single fGreen, const Lib3MF_single fBlue, const Lib3MF_single fAlpha);

	/**
	* Ilib3mf::ColorToRGBA - Calculates uint8-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] nRed - Red value of color (0-255)
	* @param[out] nGreen - Green value of color (0-255)
	* @param[out] nBlue - Blue value of color (0-255)
	* @param[out] nAlpha - Alpha value of color (0-255)
	*/
	static void ColorToRGBA(const Lib3MF::sColor TheColor, Lib3MF_uint8 & nRed, Lib3MF_uint8 & nGreen, Lib3MF_uint8 & nBlue, Lib3MF_uint8 & nAlpha);

	/**
	* Ilib3mf::ColorToFloatRGBA - Calculates float-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] fRed - Red value of color (0-1)
	* @param[out] fGreen - Green value of color (0-1)
	* @param[out] fBlue - Blue value of color (0-1)
	* @param[out] fAlpha - Alpha value of color (0-1)
	*/
	static void ColorToFloatRGBA(const Lib3MF::sColor TheColor, Lib3MF_single & fRed, Lib3MF_single & fGreen, Lib3MF_single & fBlue, Lib3MF_single & fAlpha);

	/**
	* Ilib3mf::GetIdentityTransform - Creates an identity transform
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetIdentityTransform();

	/**
	* Ilib3mf::GetUniformScaleTransform - Creates a uniform scale transform
	* @param[in] fFactor - Factor in X, Y and Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetUniformScaleTransform(const Lib3MF_single fFactor);

	/**
	* Ilib3mf::GetScaleTransform - Creates a scale transform
	* @param[in] fFactorX - Factor in X
	* @param[in] fFactorY - Factor in Y
	* @param[in] fFactorZ - Factor in Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetScaleTransform(const Lib3MF_single fFactorX, const Lib3MF_single fFactorY, const Lib3MF_single fFactorZ);

	/**
	* Ilib3mf::GetTranslationTransform - Creates an translation transform
	* @param[in] fVectorX - Translation in X
	* @param[in] fVectorY - Translation in Y
	* @param[in] fVectorZ - Translation in Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetTranslationTransform(const Lib3MF_single fVectorX, const Lib3MF_single fVectorY, const Lib3MF_single fVectorZ);

};

Lib3MFResult Lib3MF_GetProcAddress (const char * pProcName, void ** ppProcAddress);

} // namespace Impl
} // namespace Lib3MF

#endif // __LIB3MF_CPPINTERFACES
