/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { promises as fs } from 'node:fs';
import { join } from 'node:path';
import { Storage } from '@google/gemini-cli-core';
const cleanupFunctions = [];
export function registerCleanup(fn) {
    cleanupFunctions.push(fn);
}
export async function runExitCleanup() {
    for (const fn of cleanupFunctions) {
        try {
            await fn();
        }
        catch (_) {
            // Ignore errors during cleanup.
        }
    }
    cleanupFunctions.length = 0; // Clear the array
}
export async function cleanupCheckpoints() {
    const storage = new Storage(process.cwd());
    const tempDir = storage.getProjectTempDir();
    const checkpointsDir = join(tempDir, 'checkpoints');
    try {
        await fs.rm(checkpointsDir, { recursive: true, force: true });
    }
    catch {
        // Ignore errors if the directory doesn't exist or fails to delete.
    }
}
//# sourceMappingURL=cleanup.js.map