#pragma once

#include <ostream>
#include <vector>

#include "expresscpp/console.hpp"
#include "expresscpp/nextrouter.hpp"
#include "expresscpp/request.hpp"
#include "expresscpp/response.hpp"

namespace expresscpp {

class FaviconProvider {
 public:
  FaviconProvider();
  ~FaviconProvider();

  void UseFavicon(std::vector<unsigned char> favicon_ico);

  void HandleRequest(request_t req, response_t res, next_t next);

  void operator()(request_t req, response_t res, next_t next);

  std::vector<unsigned char> GetFavicon() const;

 private:
  std::vector<unsigned char> favicon_ico_ = {
      0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x10, 0x10, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x68, 0x04, 0x00, 0x00, 0x16,
      0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x12, 0x0b, 0x00, 0x00, 0x12, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xfd, 0xff, 0xfd, 0xfc,
      0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xb7, 0x9d, 0xff, 0x8a, 0x4f, 0x10, 0xff, 0x8a,
      0x50, 0x10, 0xff, 0xd0, 0xb8, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc, 0xfb, 0xff,
      0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xfc,
      0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xd7, 0xc8, 0xff, 0xa1, 0x72, 0x3e, 0xff, 0x7e, 0x3e,
      0x00, 0xff, 0x82, 0x44, 0x02, 0xff, 0x82, 0x43, 0x02, 0xff, 0x7e, 0x3e, 0x00, 0xff, 0xa1, 0x73, 0x3f, 0xff, 0xe5,
      0xd8, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xff, 0xfe, 0xfd, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xeb, 0xe4, 0xff, 0xb0, 0x89, 0x5d, 0xff, 0x7f, 0x40, 0x01,
      0xff, 0x78, 0x35, 0x00, 0xff, 0x7a, 0x38, 0x00, 0xff, 0x7c, 0x3c, 0x00, 0xff, 0x7c, 0x3c, 0x00, 0xff, 0x7a, 0x38,
      0x00, 0xff, 0x78, 0x35, 0x00, 0xff, 0x7f, 0x40, 0x01, 0xff, 0xb1, 0x8a, 0x5e, 0xff, 0xf2, 0xec, 0xe5, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xae, 0x90, 0xff, 0x81, 0x44, 0x06, 0xff,
      0x7c, 0x3b, 0x00, 0xff, 0x7c, 0x3c, 0x00, 0xff, 0x8f, 0x57, 0x1d, 0xff, 0xc1, 0xa3, 0x81, 0xff, 0xdb, 0xc9, 0xb5,
      0xff, 0xda, 0xc8, 0xb4, 0xff, 0xc1, 0xa2, 0x7f, 0xff, 0x8e, 0x57, 0x1c, 0xff, 0x7c, 0x3b, 0x00, 0xff, 0x7b, 0x39,
      0x00, 0xff, 0x84, 0x47, 0x0a, 0xff, 0xcb, 0xb2, 0x96, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf4, 0xed, 0xff, 0xbb,
      0x80, 0x47, 0xff, 0x90, 0x52, 0x10, 0xff, 0x7a, 0x39, 0x00, 0xff, 0xa1, 0x72, 0x42, 0xff, 0xf8, 0xf4, 0xef, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xf1, 0xeb,
      0xff, 0xa2, 0x75, 0x44, 0xff, 0x7f, 0x40, 0x00, 0xff, 0x85, 0x44, 0x00, 0xff, 0x95, 0x53, 0x0c, 0xff, 0xf4, 0xeb,
      0xe0, 0xff, 0xf7, 0xed, 0xe4, 0xff, 0xd9, 0xa3, 0x71, 0xff, 0xd3, 0x9a, 0x64, 0xff, 0xb8, 0x83, 0x4d, 0xff, 0xf2,
      0xec, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xf6, 0xf3, 0xff, 0xd6, 0xc1, 0xaa, 0xff, 0xd5, 0xc1, 0xaa, 0xff,
      0xf9, 0xf5, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe8, 0xdb, 0xcb, 0xff, 0x94, 0x54, 0x05, 0xff, 0x9d, 0x5a, 0x01,
      0xff, 0xa2, 0x61, 0x0c, 0xff, 0xef, 0xe4, 0xd8, 0xff, 0xf8, 0xef, 0xe6, 0xff, 0xd3, 0x9d, 0x69, 0xff, 0xcf, 0x92,
      0x59, 0xff, 0xeb, 0xcf, 0xb5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfc, 0xfa, 0xff, 0xa3, 0x75, 0x43, 0xff, 0x73,
      0x2f, 0x00, 0xff, 0x76, 0x34, 0x00, 0xff, 0xa6, 0x79, 0x48, 0xff, 0xd4, 0xb6, 0x8e, 0xff, 0x9d, 0x5b, 0x07, 0xff,
      0x99, 0x52, 0x00, 0xff, 0x97, 0x50, 0x00, 0xff, 0x9a, 0x57, 0x07, 0xff, 0xf0, 0xe6, 0xd8, 0xff, 0xf8, 0xef, 0xe6,
      0xff, 0xd3, 0x9d, 0x6a, 0xff, 0xcf, 0x94, 0x5c, 0xff, 0xf1, 0xe0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdd,
      0xcc, 0xff, 0xbf, 0x82, 0x46, 0xff, 0x9c, 0x61, 0x24, 0xff, 0x89, 0x4a, 0x01, 0xff, 0x93, 0x4f, 0x02, 0xff, 0x93,
      0x4a, 0x00, 0xff, 0xc8, 0xa4, 0x75, 0xff, 0xbf, 0x94, 0x5b, 0xff, 0xc5, 0x9f, 0x6b, 0xff, 0xc4, 0x9c, 0x67, 0xff,
      0xeb, 0xdd, 0xcb, 0xff, 0xf8, 0xef, 0xe6, 0xff, 0xd3, 0x9d, 0x6a, 0xff, 0xcf, 0x94, 0x5c, 0xff, 0xf1, 0xe0, 0xd0,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdd, 0xcb, 0xff, 0xd2, 0x96, 0x5d, 0xff, 0xd7, 0xa1, 0x6e, 0xff, 0xc4, 0x8a,
      0x4a, 0xff, 0xa6, 0x64, 0x10, 0xff, 0x92, 0x49, 0x00, 0xff, 0xc8, 0xa2, 0x72, 0xff, 0xbf, 0x94, 0x5a, 0xff, 0xc5,
      0x9d, 0x68, 0xff, 0xc3, 0x9a, 0x64, 0xff, 0xeb, 0xdd, 0xcb, 0xff, 0xf8, 0xef, 0xe6, 0xff, 0xd4, 0x9e, 0x6b, 0xff,
      0xcf, 0x92, 0x59, 0xff, 0xe8, 0xcb, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfb, 0xf9, 0xff, 0xdd, 0xb4, 0x8c,
      0xff, 0xce, 0x91, 0x58, 0xff, 0xd1, 0x95, 0x5e, 0xff, 0xdf, 0xb8, 0x93, 0xff, 0xd4, 0xb8, 0x91, 0xff, 0x9d, 0x5c,
      0x0a, 0xff, 0x94, 0x4d, 0x00, 0xff, 0x97, 0x50, 0x00, 0xff, 0x9b, 0x58, 0x07, 0xff, 0xf0, 0xe6, 0xd8, 0xff, 0xf7,
      0xee, 0xe5, 0xff, 0xd3, 0x9d, 0x6a, 0xff, 0xd1, 0x98, 0x61, 0xff, 0xd6, 0xa3, 0x73, 0xff, 0xfb, 0xf6, 0xf1, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfd, 0xfa, 0xf8, 0xff, 0xf0, 0xde, 0xcd, 0xff, 0xf0, 0xde, 0xcc, 0xff, 0xfc, 0xfa, 0xf7,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xe6, 0xd8, 0xff, 0xb4, 0x76, 0x2d, 0xff, 0x9b, 0x58, 0x00, 0xff, 0x9d, 0x5c,
      0x07, 0xff, 0xef, 0xe5, 0xd8, 0xff, 0xf9, 0xf2, 0xeb, 0xff, 0xd2, 0x99, 0x64, 0xff, 0xd1, 0x98, 0x62, 0xff, 0xd1,
      0x97, 0x60, 0xff, 0xdd, 0xb2, 0x89, 0xff, 0xfc, 0xf8, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
      0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xf5, 0xf0, 0xff, 0xde, 0xb5, 0x8e, 0xff, 0xd6, 0x9e, 0x6b,
      0xff, 0xc6, 0x8b, 0x4e, 0xff, 0xac, 0x6d, 0x1e, 0xff, 0xf2, 0xea, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xd6,
      0xc1, 0xff, 0xd3, 0x9d, 0x6a, 0xff, 0xcf, 0x94, 0x5c, 0xff, 0xd0, 0x95, 0x5e, 0xff, 0xd6, 0xa4, 0x74, 0xff, 0xe8,
      0xcc, 0xb1, 0xff, 0xf1, 0xe0, 0xd0, 0xff, 0xf1, 0xe0, 0xd0, 0xff, 0xe8, 0xcb, 0xb0, 0xff, 0xd6, 0xa3, 0x73, 0xff,
      0xcf, 0x94, 0x5d, 0xff, 0xce, 0x93, 0x5a, 0xff, 0xd6, 0xa0, 0x6f, 0xff, 0xef, 0xd9, 0xc5, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf5, 0xf0, 0xff, 0xe3, 0xc1, 0xa0, 0xff, 0xd1, 0x98,
      0x62, 0xff, 0xce, 0x92, 0x59, 0xff, 0xcf, 0x94, 0x5b, 0xff, 0xd0, 0x95, 0x5e, 0xff, 0xd0, 0x95, 0x5e, 0xff, 0xcf,
      0x94, 0x5b, 0xff, 0xce, 0x92, 0x59, 0xff, 0xd1, 0x98, 0x63, 0xff, 0xe4, 0xc1, 0xa1, 0xff, 0xfa, 0xf5, 0xf0, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xfe, 0xfe,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xeb, 0xe0, 0xff, 0xde, 0xb4, 0x8d, 0xff, 0xd1, 0x97, 0x61, 0xff, 0xd2, 0x9a,
      0x64, 0xff, 0xd2, 0x9a, 0x64, 0xff, 0xd1, 0x97, 0x61, 0xff, 0xde, 0xb5, 0x8e, 0xff, 0xf6, 0xeb, 0xe1, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xee, 0xda, 0xc6, 0xff, 0xd5, 0xa1, 0x70, 0xff, 0xd5, 0xa2, 0x71, 0xff, 0xef, 0xda, 0xc7, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  };
};

}  // namespace expresscpp
