;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Test that memory-packing does the right thing in the presence of array.new_data.

;; RUN: foreach %s %t wasm-opt --memory-packing --all-features -S -o - | filecheck %s

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  (data "hello")

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (data $0 "hello")

  ;; CHECK:      (func $array-new-data (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $array-new-data (result (ref $array))
    ;; The segment is referenced by array.new_data, so it should not be optimized out.
    (array.new_data $array 0
      (i32.const 0)
      (i32.const 5)
    )
  )
)

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hello\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (data $0 "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hello\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (func $no-drop-ends (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $no-drop-ends (result (ref $array))
    ;; The referenced segment should not have its zeros trimmed.
    (array.new_data $array 0
      (i32.const 0)
      (i32.const 5)
    )
  )
)

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (memory $mem 1 1)
  (memory $mem 1 1)

  (data "optimize\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (data $0 "optimize\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (func $no-split (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $0
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $no-split (result (ref $array))
    ;; The referenced segment should not be split.
    (array.new_data $array 0
      (i32.const 0)
      (i32.const 8)
    )
  )
)

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (memory $mem 1 1)
  (memory $mem 1 1)

  (data (i32.const 0) "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00optimize\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (data $0 (i32.const 0) "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00optimize\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (func $no-split-active (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $0
  ;; CHECK-NEXT:   (i32.const 16)
  ;; CHECK-NEXT:   (i32.const 8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $no-split-active (result (ref $array))
    ;; The segment should still not be optimized, even though it is an active segment.
    ;; TODO: We could optimize this better by realizing the array.new_data will trap.
    (array.new_data $array 0
      (i32.const 16)
      (i32.const 8)
    )
  )
)

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  (data (i32.const 0) "optimize\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  (data "but not\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (memory $mem 1 1)
  (memory $mem 1 1)

  ;; CHECK:      (data $0 (i32.const 0) "optimize")

  ;; CHECK:      (data $0.1 (i32.const 24) "me")

  ;; CHECK:      (data $1 "but not\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (func $renumber-segment (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $renumber-segment (result (ref $array))
    ;; Segment 0 is optimized out, so the segment referenced here should be updated.
    (array.new_data $array 1
      (i32.const 0)
      (i32.const 7)
    )
  )
)

(module
  ;; CHECK:      (type $array (array i8))
  (type $array (array i8))

  (data "dead\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00segment")

  (data "but not\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (type $1 (func (result (ref $array))))

  ;; CHECK:      (memory $mem 1 1)
  (memory $mem 1 1)

  ;; CHECK:      (data $1 "but not\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00me")

  ;; CHECK:      (func $renumber-segment (type $1) (result (ref $array))
  ;; CHECK-NEXT:  (array.new_data $array $1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $renumber-segment (result (ref $array))
    ;; Segment 0 is split in two, so the segment referenced here should be updated.
    (array.new_data $array 1
      (i32.const 0)
      (i32.const 7)
    )
  )
)
