;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Check that public tag types are correctly considered public and do not become
;; part of the single, large rec group.

;; RUN: foreach %s %t wasm-opt --remove-unused-types --closed-world -all -S -o - | filecheck %s

;; Neither imported nor exported tag. The tag type is private.
(module
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $other-2 (struct (field i8)))

  ;; CHECK:       (type $other-1 (struct))

  ;; CHECK:       (type $tag-type (func))
  (type $tag-type (func))
  (type $other-1 (struct))
  (type $other-2 (struct (field i8)))

  ;; CHECK:      (global $tag-type (ref null $tag-type) (ref.null nofunc))

  ;; CHECK:      (global $other-1 (ref null $other-1) (ref.null none))

  ;; CHECK:      (global $other-2 (ref null $other-2) (ref.null none))

  ;; CHECK:      (tag $exported (type $tag-type))
  (tag $exported (type $tag-type))

  ;; Use all the types.
  (global $tag-type (ref null $tag-type) (ref.null nofunc))
  (global $other-1 (ref null $other-1) (ref.null none))
  (global $other-2 (ref null $other-2) (ref.null none))
)

;; Imported tag.
(module
  ;; CHECK:      (type $tag-type (func))
  (type $tag-type (func))
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $other-2 (struct (field i8)))

  ;; CHECK:       (type $other-1 (struct))
  (type $other-1 (struct))
  (type $other-2 (struct (field i8)))

  (tag $imported (import "" "") (type $tag-type))

  ;; Use all the types.
  ;; CHECK:      (import "" "" (tag $imported (type $tag-type)))

  ;; CHECK:      (global $tag-type (ref null $tag-type) (ref.null nofunc))
  (global $tag-type (ref null $tag-type) (ref.null nofunc))
  ;; CHECK:      (global $other-1 (ref null $other-1) (ref.null none))
  (global $other-1 (ref null $other-1) (ref.null none))
  ;; CHECK:      (global $other-2 (ref null $other-2) (ref.null none))
  (global $other-2 (ref null $other-2) (ref.null none))
)

;; Exported tag.
(module
  ;; CHECK:      (type $tag-type (func))
  (type $tag-type (func))
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $other-2 (struct (field i8)))

  ;; CHECK:       (type $other-1 (struct))
  (type $other-1 (struct))
  (type $other-2 (struct (field i8)))

  ;; CHECK:      (global $tag-type (ref null $tag-type) (ref.null nofunc))

  ;; CHECK:      (global $other-1 (ref null $other-1) (ref.null none))

  ;; CHECK:      (global $other-2 (ref null $other-2) (ref.null none))

  ;; CHECK:      (tag $exported (type $tag-type))
  (tag $exported (export "") (type $tag-type))

  ;; Use all the types.
  (global $tag-type (ref null $tag-type) (ref.null nofunc))
  (global $other-1 (ref null $other-1) (ref.null none))
  (global $other-2 (ref null $other-2) (ref.null none))
)
;; CHECK:      (export "" (tag $exported))
