;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: foreach %s %t wasm-opt --precompute-propagate --optimize-level=2 -all -S -o - | filecheck %s

(module
  ;; CHECK:      (type $empty (struct))
  (type $empty (struct))

  ;; CHECK:      (type $i32_any (sub (struct (field i32) (field (ref any)))))
  (type $i32_any (sub (struct (field i32) (field (ref any)))))

  ;; CHECK:      (func $partial-gc-cache (type $1) (result i32)
  ;; CHECK-NEXT:  (local $x i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new $i32_any
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (select (result (ref (exact $empty)))
  ;; CHECK-NEXT:     (struct.new_default $empty)
  ;; CHECK-NEXT:     (struct.new_default $empty)
  ;; CHECK-NEXT:     (i32.trunc_f64_s
  ;; CHECK-NEXT:      (f64.const 562949953421311)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i32.const 0)
  ;; CHECK-NEXT: )
  (func $partial-gc-cache (result i32)
    (local $x i32)
    ;; The select here looks promising for partial computation. We will therefore
    ;; try to precompute variations of the outer struct.new. While doing so we
    ;; should not confuse later computations, and in particular, not store
    ;; anything in the heap value cache - the risk is that these partial
    ;; precomputations will not have the i32.trunc which traps, so they will
    ;; execute without trapping, and if we cached that result for the outer
    ;; struct.new, we'd later think that results applies here (if we did, we'd
    ;; think this does not trap, and precompute it into a nop, removing the
    ;; trap erroneously).
    (drop
      (struct.new $i32_any
        (i32.const 0)
        (select (result (ref $empty))
          (struct.new $empty)
          (struct.new $empty)
          (i32.trunc_f64_s
            (f64.const 562949953421311)
          )
        )
      )
    )
    ;; This local causes propagation to work, which causes the extra
    ;; optimizations that lead to the bug above.
    (local.get $x)
  )
)
