window.search = JSON.parse('{"doc_urls":["index.html","rust-getting-started/index.html#getting-started-with-rust","rust-getting-started/windows-or-windows-sys.html#choosing-between-the-windows-and-windows-sys-crates","rust-getting-started/how-are-crates-built.html#how-are-these-crates-built","rust-getting-started/how-to-find-api.html#how-do-i-find-a-particular-api","rust-getting-started/what-apis-are-included.html#what-apis-are-included","rust-getting-started/where-are-the-macros.html#wheres-my-favorite-macro-from-the-windows-sdk","rust-getting-started/calling-your-first-windows-api.html#calling-your-first-api-with-the-windows-crate","rust-getting-started/calling-your-first-windows-sys-api.html#calling-your-first-api-with-the-windows-sys-crate","rust-getting-started/calling-your-first-com-api.html#calling-your-first-com-api","rust-getting-started/calling-your-first-winrt-api.html#calling-your-first-winrt-api","rust-getting-started/how-to-query-for-com-interface.html#how-do-i-query-for-a-specific-com-interface","rust-getting-started/how-to-implement-com-interface.html#how-do-i-implement-an-existing-com-interface","rust-getting-started/how-to-implement-winrt-collection.html#how-do-i-create-stock-collections-for-winrt-collection-interfaces","rust-getting-started/understanding-windows-targets.html#understanding-the-windows-targets-crate","rust-getting-started/standalone-code-generation.html#standalone-code-generation","rust-getting-started/creating-your-first-dll.html#creating-your-first-dll-in-rust","rust-getting-started/implement-win32-api.html#implement-a-traditional-win32-style-api","rust-getting-started/string-tutorial.html#working-with-strings-in-the-windows-crate","rust-getting-started/string-tutorial.html#types-of-api-functions-narrow-or-wide","rust-getting-started/string-tutorial.html#calling-apis-that-consume-strings","rust-getting-started/string-tutorial.html#calling-apis-that-generate-strings"],"index":{"documentStore":{"docInfo":{"0":{"body":56,"breadcrumbs":1,"title":1},"1":{"body":65,"breadcrumbs":6,"title":3},"10":{"body":294,"breadcrumbs":8,"title":4},"11":{"body":153,"breadcrumbs":8,"title":4},"12":{"body":205,"breadcrumbs":8,"title":4},"13":{"body":217,"breadcrumbs":12,"title":6},"14":{"body":283,"breadcrumbs":8,"title":4},"15":{"body":156,"breadcrumbs":6,"title":3},"16":{"body":308,"breadcrumbs":8,"title":4},"17":{"body":792,"breadcrumbs":10,"title":5},"18":{"body":106,"breadcrumbs":8,"title":4},"19":{"body":49,"breadcrumbs":9,"title":5},"2":{"body":161,"breadcrumbs":12,"title":6},"20":{"body":234,"breadcrumbs":8,"title":4},"21":{"body":407,"breadcrumbs":8,"title":4},"3":{"body":62,"breadcrumbs":4,"title":2},"4":{"body":22,"breadcrumbs":6,"title":3},"5":{"body":125,"breadcrumbs":4,"title":2},"6":{"body":35,"breadcrumbs":10,"title":5},"7":{"body":340,"breadcrumbs":10,"title":5},"8":{"body":370,"breadcrumbs":12,"title":6},"9":{"body":296,"breadcrumbs":8,"title":4}},"docs":{"0":{"body":"Kenny Kerr is a Software Engineer at Microsoft where he works on C++ and Rust tools and libraries for the Windows operating system. He is the creator of C++/WinRT and Rust for Windows . Kenny also wrote recurring columns and feature articles for C/C++ Users Journal, Visual Studio Magazine, MSDN Magazine, originally called Microsoft Systems Journal. Getting Started with Rust Kenny\'s courses on Pluralsight Kenny on GitHub Kenny on YouTube Kenny on LinkedIn Kenny\'s old blog on WordPress Kenny\'s old blog on asp.net","breadcrumbs":"Introduction","id":"0","title":"Introduction"},"1":{"body":"The windows-rs project has been available for some time and while I still have a great deal of work left to do, I thought I should start spending some time writing about Rust for Windows and not simply building Rust for Windows. 😊 As I did for C++/WinRT , I thought I would start writing a few short \\"how to\\" or \\"how it works\\" articles to help developers understand some of the fundamentals of the windows-rs project. Some of these topics will be obvious for Rust developers but perhaps not the Windows developer new to Rust. Other topics might be obvious to Windows developers but less so to the seasoned Rust developer new to Windows. Either way, I hope you find it useful. Feel free to open an issue on the repo if you have any questions.","breadcrumbs":"Getting Started with Rust » Getting Started with Rust","id":"1","title":"Getting Started with Rust"},"10":{"body":"Windows 8 introduced the Windows Runtime, which at its heart, is just COM with a few more conventions thrown in to make language bindings appear more seamless. The windows crate already makes calling COM APIs far more seamless than it is for C++ developers, but WinRT goes further by providing first-class support for modeling things like constructors, events, and class hierarchies. In calling your first COM API , we saw that you still had to bootstrap the API with a C-style DLL export before calling COM interface methods. WinRT works the same way but abstracts this away in a generalized manner. Let\'s use a simple example to illustrate. The XmlDocument \\"class\\" models an XML document that can be loaded from various sources. The Rust docs for the windows crate indicate that this type resides in the Data::Xml::Dom module so we can configure our windows crate dependency as follows: [dependencies.windows]\\nversion = \\"0.52\\" features = [ \\"Data_Xml_Dom\\",\\n] And we can employ a use declaration to make this API a little more accessible. The windows crate\'s core module just provides a few helpers to make it easier to work with Windows APIs, so we\'ll include that as well: use windows::{core::*, Data::Xml::Dom::XmlDocument}; For this example, I\'ll just use a simple main function with a Result type from the windows::core module to provide automatic error propagation and simplify the subsequent API calls: fn main() -> Result<()> { Ok(())\\n} Unlike the previous Win32 and COM examples, you\'ll notice that this main function does not need an unsafe block since WinRT calls are assumed to be safe thanks to its more constrained type-system. To begin, we can simply call the new method to create a new XmlDocument object: let doc = XmlDocument::new()?; This looks a lot more like an idiomatic Rust type than your typical COM API, but under the hood a similar mechanism is used to instantiate the XmlDocument implementation via a DLL export. We can then call the LoadXml method to test it out. There are various other options for loading XML from different sources, which you can read about in the official documentation or from the Rust docs for the XmlDocument API. The windows crate also provides the handy h! macro for creating an HSTRING, the string type used by WinRT APIs: doc.LoadXml(h!(\\"<html>hello world</html>\\"))?; And just like that, we have a fully-formed Xml document that we can inspect. For this example, let\'s just grab the document element and then do some basic queries as follows: let root = doc.DocumentElement()?;\\nassert!(root.NodeName()? == \\"html\\");\\nprintln!(\\"{}\\", root.InnerText()?); First we assert that the element\'s name is in fact \\"html\\" and then print out the element\'s inner text. As with the previous COM example, those methods all invoke virtual functions through COM interfaces, but the windows crate makes it very simple to make such calls directly from Rust. And that\'s it. Running the sample should print something like this: hello world Here\'s the full sample for reference .","breadcrumbs":"Calling your first WinRT API » Calling your first WinRT API","id":"10","title":"Calling your first WinRT API"},"11":{"body":"COM and WinRT interfaces in the windows crate implement the ComInterface trait. This trait provides the cast method that will use QueryInterface under the hood to cast the current interface to another interface supported by the object. The cast method returns a Result<T> so that failure can be handled in a natural way in Rust. For example, it is often necesary to get the IDXGIDevice interface for a given Direct3D device to interop with other rendering APIs. This is how you might create a swap chain for drawing and presenting to a Direct3D device. Let\'s imagine a simple function that accepts a Direct3D device and returns the underlying DXGI factory: fn get_dxgi_factory(device: &ID3D11Device) -> Result<IDXGIFactory2> {\\n} The first thing you need to do is query or cast the Direct3D device for its DXGI interface as follows: let device = device.cast::<IDXGIDevice>()?; If its more convenient, you can also make use of type inference as follows: let device: IDXGIDevice = device.cast()?; With the COM interface in hand, we need an unsafe block to call its methods: unsafe {\\n} Within the unsafe block, we can retrieve the device\'s physical adapter: let adapter = device.GetAdapter()?; And just for fun (or debugging), we might print out the adapter\'s name: if cfg!(debug_assertions) { let mut desc = Default::default(); adapter.GetDesc(&mut desc)?; println!(\\"{}\\", String::from_utf16_lossy(&desc.Description));\\n} Finally, we can return the adapter\'s parent and also the DXGI factory object for the device: adapter.GetParent() Running the sample I get the following impressive results: AMD FirePro W4100 Here\'s a more comprehensive DirectX example . The cast method works equally well for WinRT classes and interfaces. It is particularly useful for interop with WinRT APIs .","breadcrumbs":"How do I query for a specific COM interface? » How do I query for a specific COM interface?","id":"11","title":"How do I query for a specific COM interface?"},"12":{"body":"In some cases, you may need to implement an existing COM interface rather than simply calling an existing implementation provided by the operating system. This is where the implement feature and macro come in handy. The windows crate provides optional implementation support hidden behind the implement feature. Once enabled, the implement macro may be used to implement any number of COM interfaces. The macro takes care of implementing IUnknown itself. Let\'s implement a simple interface defined by Windows to illustrate. The IPersist interface is defined in the Win32::System::Com module, so we\'ll start by adding a dependency on the windows crate and include the Win32_System_Com feature: [dependencies.windows]\\nversion = \\"0.52\\"\\nfeatures = [ \\"implement\\", \\"Win32_System_Com\\",\\n] The implement feature unlocks the implementation support. The implement macro is included by the windows::core module so we\'ll keep things simple by including it all as follows: use windows::{core::*, Win32::System::Com::*}; Now its time for the implementation: #[implement(IPersist)]\\nstruct Persist(GUID); The implement macro will provide the necessary implementation for the IUnknown interface\'s lifetime management and interface discovery for whatever interfaces are included in the attribute. In this case, only IPersist is to be implemented. The implementation itself is defined by a trait that follows the <interface name>_Impl pattern and its up to us to implement it for our implementation as follows: impl IPersist_Impl for Persist_Impl { fn GetClassID(&self) -> Result<GUID> { Ok(self.0) }\\n} The IPersist interface, originally documented here , has a single method that returns a GUID, so we\'ll just implement it by returning the value contained within our implementation. The window crate and implement macro will take care of the rest by providing the actual COM virtual function call and virtual function table layout needed to turn this into a heap-allocated and reference-counted COM object. All that remains is to move, or box, the implementation into the COM implementation provided by the implement macro through the Into trait: let guid = GUID::new()?;\\nlet persist: IPersist = Persist(guid).into(); At this point, we can simply treat persist as the COM object that it is: let guid2 = unsafe { persist.GetClassID()? };\\nassert_eq!(guid, guid2);\\nprintln!(\\"{:?}\\", guid); Here\'s a complete example .","breadcrumbs":"How do I implement an existing COM interface? » How do I implement an existing COM interface?","id":"12","title":"How do I implement an existing COM interface?"},"13":{"body":"Beyond implementing COM interfaces yourself, the windows crate provides stock collection implementations for common WinRT collection interfaces. Implementing WinRT collection interfaces can be quite challenging, so this should save you a lot of effort in many cases. The implement feature is required to make use of these stock implementations. Let\'s consider a few examples. The WinRT collection interfaces are all defined in the Foundation::Collections module, so we\'ll start by adding a dependency on the windows crate and include the Foundation_Collections feature: [dependencies.windows]\\nversion = \\"0.52\\"\\nfeatures = [ \\"implement\\", \\"Foundation_Collections\\",\\n] Creating a collection is as simple as using the TryFrom trait on existing Vec or BTreeMap, depending on the kind of collection: WinRT interface From IIterable<T> Vec<T::Default> IVectorView<T> Vec<T::Default> IMapView<K, V> BTreeMap<K::Default, V::Default> So if you need a IIterable implementation of i32 values you can create it as follows: use windows::{core::*, Foundation::Collections::*}; fn main() -> Result<()> { let collection = IIterable::<i32>::try_from(vec![1, 2, 3])?; for n in collection { println!(\\"{n}\\"); } Ok(())\\n} The resulting collection will implement all of the specialized IIterable<i32> methods. Did you notice the T::Default in the table above? The challenge is that when the WinRT collection contains nullable types, unlike i32, then the collection must necessarily support a backing implementation that support expressing this. The Default associated type just replaces T with Option<T> for such nullable, or reference, types. Let\'s consider a slightly more contrived example. Here we\'ll create an IMapView with strings for keys and interfaces for values. WinRT strings are not nullable but interfaces are. WinRT strings are represented by HSTRING in the windows crate and for the interface we\'ll just use an IStringable implementation: use windows::Foundation::*; #[implement(IStringable)]\\nstruct Value(&\'static str); impl IStringable_Impl for Value { fn ToString(&self) -> Result<HSTRING> { Ok(self.0.into()) }\\n} We can now create a std collection as follows: use std::collections::*; let map = BTreeMap::from([ (\\"hello\\".into(), Some(Value(\\"HELLO\\").into())), (\\"hello\\".into(), Some(Value(\\"WORLD\\").into())),\\n]); The Rust compiler naturally infers the exact type: BTreeMap<HSTRING, Option<IStringable>>. Finally, we can wrap that BTreeMap inside a WinRT collection with the TryInto trait as follows: let map: IMapView<HSTRING, IStringable> = map.try_into()?; for pair in map { println!(\\"{} - {}\\", pair.Key()?, pair.Value()?.ToString()?);\\n}","breadcrumbs":"How do I create stock collections for WinRT collection interfaces? » How do I create stock collections for WinRT collection interfaces?","id":"13","title":"How do I create stock collections for WinRT collection interfaces?"},"14":{"body":"The windows and windows-sys crates depend on the windows-targets crate for linker support. The windows-targets crate includes import libs, supports semantic versioning, and optional support for raw-dylib. It provides explicit import libraries for the following targets: i686_msvc x86_64_msvc aarch64_msvc i686_gnu x86_64_gnu x86_64_gnullvm aarch64_gnullvm An import lib contains information the linker uses to resolve external references to functions exported by DLLs. This allows the operating system to identify a specific DLL and function export at load time. Import libs are both toolchain- and architecture-specific. In other words, different lib files are required depending on whether you\'re compiling with the MSVC or GNU toolchains and whether you\'re compiling for the x86 or ARM64 architectures. Note that import libraries don\'t contain any code, as static libraries do. While the GNU and MSVC toolchains often provide some import libs to support C++ development, those lib files are often incomplete, missing, or just plain wrong. This can lead to linker errors that are very difficult to diagnose. The windows-targets crate ensures that all functions defined by the windows and windows-sys crates can be linked without relying on implicit lib files distributed by the toolchain. This ensures that dependencies can be managed with Cargo and streamlines cross-compilation. The windows-targets crate also contains version-specific lib file names ensuring semver compatibility. Without this capability, the linker will simply pick the first matching lib file name and fail to resolve any missing or mismatched imports. Note : Ordinarily, you don\'t need to think about the windows-targets crate at all. The windows and windows-sys crates depend on the windows-targets crate automatically. Only in rare cases will you need to use it directly. Start by adding the following to your Cargo.toml file: [dependencies.windows-targets]\\nversion = \\"0.52\\" Use the link macro to define the external functions you wish to call: windows_targets::link!(\\"kernel32.dll\\" \\"system\\" fn SetLastError(code: u32));\\nwindows_targets::link!(\\"kernel32.dll\\" \\"system\\" fn GetLastError() -> u32); Make use of any Windows APIs as needed: fn main() { unsafe { SetLastError(1234); assert_eq!(GetLastError(), 1234); }\\n} By default the link macro will cause the linker to use the bundled import libs. Compiling with the windows_raw_dylib Rust build flag will cause Cargo to skip downloading the import libs altogether and instead use raw-dylib to resolve imports automatically. The Rust compiler will then create the import entries directly. This works without having to change any of your code. Without the windows-targets crate, switching between linker and raw-dylib imports requires very intricate code changes. As of this writing, the raw-dylib feature is not yet stable.","breadcrumbs":"Understanding the windows-targets crate » Understanding the windows-targets crate","id":"14","title":"Understanding the windows-targets crate"},"15":{"body":"Even with a choice between the windows and windows-sys crates , some developers may prefer to use completely standalone bindings. The windows-bindgen crate lets you generate entirely standalone bindings for Windows APIs with a single function call that you can run from a test to automate the generation of bindings. This can help to reduce your dependencies while continuing to provide a sustainable path forward for any future API requirements you might have, or just to refresh your bindings from time to time to pick up any bug fixes automatically from Microsoft. Warning : Standalone code generation should only be used as a last resort for the most demanding scenarios. It is much simpler to use the windows-sys crate and let Cargo manage this dependency. This windows-sys crate provides raw bindings, is heavily tested and widely used, and should not meaningfully impact your build time. Start by adding the following to your Cargo.toml file: [dependencies.windows-targets]\\nversion = \\"0.52\\" [dev-dependencies.windows-bindgen]\\nversion = \\"0.52\\" The windows-bindgen crate is only needed for generating bindings and is thus a dev dependency only. The windows-targets crate is a dependency shared by the windows and windows-sys crates and only contains import libs for supported targets. This will ensure that you can link against any Windows API functions you may need. Write a test to generate bindings as follows: #[test]\\nfn bindgen() { let args = [ \\"--out\\", \\"src/bindings.rs\\", \\"--config\\", \\"flatten\\", \\"--filter\\", \\"Windows.Win32.System.SystemInformation.GetTickCount\\", ]; windows_bindgen::bindgen(args).unwrap();\\n} Make use of any Windows APIs as needed. mod bindings; fn main() { unsafe { println!(\\"{}\\", bindings::GetTickCount()); }\\n}","breadcrumbs":"Standalone code generation » Standalone code generation","id":"15","title":"Standalone code generation"},"16":{"body":"As a systems programming language with similar linkage support to that of C and C++, it is quite straightforward to build a DLL in Rust. Rust does however have it\'s own notion of libraries that are quite different to that of C and C++, so it\'s just a matter of finding the right configuration to produce the desired output. As with most Rust projects, you can start with Cargo and get started with a basic template but it\'s so simple we\'ll just build it by hand here to see what\'s involved. Let\'s create a directory structure as follows: > hello_world Cargo.toml > src lib.rs Just two directories and two files. There\'s the hello_world directory that contains the project as a whole. In that directory we have a Cargo.toml file that contains metadata for the project or package, information needed to compile the package: [package]\\nname = \\"hello_world\\"\\nedition = \\"2021\\" [lib]\\ncrate-type = [\\"cdylib\\"] At a minimum, the [package] section includes the name and Rust edition your package is compiled with. Rust-only libraries don\'t generally include a [lib] section. This is necessary when you need to specifically control how the project will be used and linked. In this case, we\'re using \'cdylib\' that represents a dynamic system library and maps to a DLL on Windows. The src sub directory contains the lib.rs Rust source file where we can add any functions that we\'d like to export from the DLL. Here\'s a simple example: #[no_mangle]\\nextern \\"system\\" fn HelloWorld() -> i32 { 123\\n} The [no_mangle] attribute just tells the compiler to disable any name mangling and use the function name verbatim as the exported identifier. The extern \\"system\\" function qualifier indicates the ABI or calling convention expected for the function. The \\"system\\" string represents the system-specific calling convention which generally maps to \\"stdcall\\" on Windows. And that\'s it! You can now build the package and it will produce a DLL: > cargo build -p hello_world Cargo will drop the resulting binaries in the target directory where you can then use them from any other programming language: > dir /b target\\\\debug\\\\hello_world.*\\nhello_world.d\\nhello_world.dll\\nhello_world.dll.exp\\nhello_world.dll.lib\\nhello_world.pdb Here\'s a simple example in C++: #include <stdint.h>\\n#include <stdio.h> extern \\"C\\" { int32_t __stdcall HelloWorld();\\n} int main() { printf(\\"%d\\\\n\\", HelloWorld());\\n} You can build it with MSVC as follows: cl hello_world.cpp hello_world.dll.lib The dumpbin tool can be used to further inspect imports and exports. > dumpbin /nologo /exports hello_world.dll Dump of file hello_world.dll File Type: DLL Section contains the following exports for hello_world.dll 00000000 characteristics FFFFFFFF time date stamp 0.00 version 1 ordinal base 1 number of functions 1 number of names ordinal hint RVA name 1 0 00001000 HelloWorld = HelloWorld > dumpbin /nologo /imports hello_world.exe Dump of file hello_world.exe File Type: EXECUTABLE IMAGE Section contains the following imports: hello_world.dll 140017258 Import Address Table 140021200 Import Name Table 0 time date stamp 0 Index of first forwarder reference 0 HelloWorld","breadcrumbs":"Creating your first DLL in Rust » Creating your first DLL in Rust","id":"16","title":"Creating your first DLL in Rust"},"17":{"body":"Now that we know how to create a DLL in Rust , let\'s consider what it takes to implement a simple Win32-style API. While WinRT is generally a better choice for new operating system APIs, Win32-style APIs continue to be important. You might need to re-implement an existing API in Rust or just need finer control of the type system or activation model for one reason or another. To keep things simple but realistic, let\'s implement a JSON validator API. The idea is to provide a way to efficiently validate a given JSON string against a known schema. Efficiency requires that the schema is pre-compiled, so we can produce a logical JSON validator object that may be created and freed separately from the process of validating the JSON string. You can imagine a hypothetical Win32-style API looking like this: HRESULT __stdcall CreateJsonValidator(char const* schema, size_t schema_len, uintptr_t* handle); HRESULT __stdcall ValidateJson(uintptr_t handle, char const* value, size_t value_len, char** sanitized_value, size_t* sanitized_value_len); void __stdcall CloseJsonValidator(uintptr_t handle); The CreateJsonValidator function should compile the schema and make it available through the returned handle. The handle can then be passed to the ValidateJson function to perform the validation. The function can optionally return a sanitized version of the JSON value. The JSON validator handle can later be freed using the CloseJsonValidator function, causing any memory occupied by the validator \\"object\\" to be freed. Both creation and validation can fail, so those functions return an HRESULT, with rich error information being available via the GetErrorInfo function. Let\'s use the windows crate for basic Windows error handling and type support. The popular serde_json crate will be used for parsing JSON strings. Unfortunately, it doesn\'t provide schema validation. A quick online search reveals the jsonschema crate seems to be the main or only game in town. It will do for this example. The focus here is not really on the particular implementation as much as the process of building such an API in Rust generally. Given these dependencies and what we learned about creating a DLL in Rust, here\'s what the project\'s Cargo.toml file should look like: [package]\\nname = \\"json_validator\\"\\nedition = \\"2021\\" [lib]\\ncrate-type = [\\"cdylib\\"] [dependencies]\\njsonschema = \\"0.17\\"\\nserde_json = \\"1.0\\" [dependencies.windows]\\nversion = \\"0.52\\"\\nfeatures = [ \\"Win32_Foundation\\", \\"Win32_System_Com\\",\\n] We can employ a use declaration to make things a little easier for ourselves: use jsonschema::JSONSchema;\\nuse windows::{core::*, Win32::Foundation::*, Win32::System::Com::*}; And let\'s begin with the CreateJsonValidator API function. Here\'s how the C++ declaration might look in Rust: #[no_mangle]\\nunsafe extern \\"system\\" fn CreateJsonValidator( schema: *const u8, schema_len: usize, handle: *mut usize,\\n) -> HRESULT { create_validator(schema, schema_len, handle).into()\\n} Nothing too exciting here. We\'re just using the definition of HRESULT from the windows crate. The implementation calls a different create_validator function for its implementaion. We\'ll do this so that we can use the syntactic convenience of the standard Result type for error propagation. The specialization of Result provided by the windows crate further supports turning a Result into an HRESULT while discharging its rich error information to the caller. That\'s what the trailing into() is used for. The create_validator function looks as follows: unsafe fn create_validator(schema: *const u8, schema_len: usize, handle: *mut usize) -> Result<()> { // ... Ok(())\\n} As you can see, it carries the exact same parameters and simply switches out the HRESULT for a Result returning the unit type , or nothing other than success or error information. First up, we need to parse the provided schema using serde_json. Since we need to parse JSON in a couple spots, we\'ll just drop this in a reusable helper function: unsafe fn json_from_raw_parts(value: *const u8, value_len: usize) -> Result<serde_json::Value> { if value.is_null() { return Err(E_POINTER.into()); } let value = std::slice::from_raw_parts(value, value_len); let value = std::str::from_utf8(value).map_err(|_| Error::from(ERROR_NO_UNICODE_TRANSLATION))?; serde_json::from_str(value).map_err(|error| Error::new(E_INVALIDARG, format!(\\"{error}\\").into()))\\n} The json_from_raw_parts function starts by checking that the pointer to a UTF-8 string is not null, return E_POINTER in such cases. We can then turn the pointer and length into a Rust slice and from there a string slice, ensuring that it is in fact a valid UTF-8 string. Finally, we call out to serde_json to turn the string into a JSON value for further processing. Now that we can parse JSON, completing the create_validator function is relatively straightforward: unsafe fn create_validator(schema: *const u8, schema_len: usize, handle: *mut usize) -> Result<()> { let schema = json_from_raw_parts(schema, schema_len)?; let compiled = JSONSchema::compile(&schema) .map_err(|error| Error::new(E_INVALIDARG, error.to_string().into()))?; if handle.is_null() { return Err(E_POINTER.into()); } *handle = Box::into_raw(Box::new(compiled)) as usize; Ok(())\\n} The JSON value, in this case the JSON schema, is passed to JSONSchema::compile to produce the compiled representation. While the value is known to be JSON at this point, it may not in fact be a valid JSON schema. In such cases, we\'ll return E_INVALIDARG and include the error message from the JSON schema compiler to aid in debugging. Finally, provided the handle pointer is not null, we can go ahead and box the compiled representation and return it as the \\"handle\\". Now let\'s move on to the CloseJsonValidator function since it\'s closely related to the boxing code above. Boxing just means to move the value on to the heap. The CloseJsonValidator function therefore needs to \\"drop\\" the object and free that heap allocation: #[no_mangle]\\nunsafe extern \\"system\\" fn CloseJsonValidator(handle: usize) { if handle != 0 { _ = Box::from_raw(handle as *mut JSONSchema); }\\n} We can add a little safeguard if a zero handle is provided. This is a pretty standard convenience feature to simplify generic programming for callers, but a caller can generally avoid the indirection cost of calling CloseJsonValidator if they know the handle is zero. Finally, let\'s consider the ValidateJson function\'s implementation: #[no_mangle]\\nunsafe extern \\"system\\" fn ValidateJson( handle: usize, value: *const u8, value_len: usize, sanitized_value: *mut *mut u8, sanitized_value_len: *mut usize,\\n) -> HRESULT { validate( handle, value, value_len, sanitized_value, sanitized_value_len, ) .into()\\n} Here again the implementation forwards to a Result-returning function for convenience: unsafe fn validate( handle: usize, value: *const u8, value_len: usize, sanitized_value: *mut *mut u8, sanitized_value_len: *mut usize,\\n) -> Result<()> { // ...\\n} First up, we need to ensure that we even have a valid handle, before transforming it into a JSONSchema object reference: if handle == 0 { return Err(E_HANDLE.into());\\n} let schema = &*(handle as *const JSONSchema); This looks a bit tricky but we\'re just turning the opaque handle into a JSONSchema pointer and then returning a reference to avoid taking ownership of it. Next, we need to parse the provided JSON value: let value = json_from_raw_parts(value, value_len)?; Here again we use the handy json_from_raw_parts helper function and allow error propagation to be handled automatically via the ? operator. At this point we can perform schema validation, optionally returning a sanitized copy of the JSON value: if schema.is_valid(&value) { if !sanitized_value.is_null() && !sanitized_value_len.is_null() { let value = value.to_string(); *sanitized_value = CoTaskMemAlloc(value.len()) as _; if (*sanitized_value).is_null() { return Err(E_OUTOFMEMORY.into()); } (*sanitized_value).copy_from(value.as_ptr(), value.len()); *sanitized_value_len = value.len(); } Ok(())\\n} else { // ...\\n} Assuming the JSON value checks out against the compiled schema, we see whether the caller provided pointers to return a sanitized copy of the JSON value. In that case, we call to_string to return a string representation straight from the JSON parser, use CoTaskMemAlloc to allocate a buffer to return to the caller and copy the resulting UTF-8 string into this buffer. If things don\'t go well, we can get the compiled schema to produce a handy error message before returning E_INVALIDARG to the caller: let mut message = String::new(); if let Some(error) = schema.validate(&value).unwrap_err().next() { message = error.to_string();\\n} Err(Error::new(E_INVALIDARG, message.into())) The validate method returns a collection of errors. We\'ll just return the first for simplicity. And that\'s it! Your first Win32-style API in Rust. You can find the complete example here .","breadcrumbs":"Implement a traditional Win32-style API » Implement a traditional Win32-style API","id":"17","title":"Implement a traditional Win32-style API"},"18":{"body":"There are several string types in the Windows APIs including: PSTR/PCSTR: A pointer to a null terminated string consisting of chars (u8). Strings should be encoded using the current thread\'s code page. A \'C\' indicates a \\"constant\\" (read-only) string. PWSTR/PCWSTR: A pointer to a null terminated string consisting of \'wide chars\' (u16), encoded using UTF-16. BSTR: A binary string commonly used in COM/OLE functions. It consists of u16 characters followed by a null terminator. The strings have their length prepended before the pointer, and some functions will use them to pass arbitrary binary data (including data containing nulls), relying on the prefix rather than the terminator. However, they usually can be used as normal, null-terminated wide strings. HSTRING: A handle to a Windows Runtime string. HSTRINGS are UTF-16 and immutable. Note that you can pass BSTR or HSTRING to functions expecting a PCWSTR. Unfortunately, none of these types match Rust types one-to-one. However, we can use the windows-strings crate to help us.","breadcrumbs":"Working with strings in the windows crate » Working with strings in the windows crate","id":"18","title":"Working with strings in the windows crate"},"19":{"body":"The Win32 API divides string functions into their \\"narrow\\" version (ending in \'A\', like MessageBoxA), and their \\"wide\\" version (ending in \'W\', like MessageBoxW). Narrow versions of the API expect u8 byte strings, encoded using the current thread\'s code page, while wide versions expect UTF-16. As a general recommendation, you should prefer wide versions; it\'s much easier to convert between Rust\'s UTF-8 strings and Windows\' UTF-16.","breadcrumbs":"Working with strings in the windows crate » Types of API Functions (Narrow or Wide)","id":"19","title":"Types of API Functions (Narrow or Wide)"},"2":{"body":"The windows crate provides bindings for the Windows API, including C-style APIs like CreateThreadpool as well as COM and WinRT APIs like DirectX. This crate provides the most comprehensive API coverage for the Windows operating system. Where possible, the windows crate also attempts to provide a more idiomatic and safe programming model for Rust developers. The windows-sys crate provides raw bindings for the C-style Windows APIs. It lacks support for COM and WinRT APIs. The windows-sys crate was born out of the realization that the most expensive aspect of the windows crate, in terms of build time, is the cost of compiling function bodies. The Rust compiler just spends a great deal of effort compiling function bodies, so a version of the windows crate that only includes declarations is both much smaller and faster by comparison. The trouble is that COM-style virtual function calls require extra code gen in Rust (unlike C++) and this in turn leads to slower compile times. Enter the windows-sys crate. Of course, we continue to work hard at improving performance both in terms of the underlying Rust compiler toolchain as well as the efficiency of the code generated for these crates. We are thus confident that the compile-time will continue to improve. What do you need? windows windows-sys Fast compile times are one of your top concerns ✅ You need no_std support ✅ You need COM or WinRT support ✅ You would prefer to use APIs that feel idiomatic to Rust ✅ Minimum supported Rust version 1.56 1.56","breadcrumbs":"Choosing between the windows and windows-sys crates » Choosing between the windows and windows-sys crates","id":"2","title":"Choosing between the windows and windows-sys crates"},"20":{"body":"Let\'s look at an example using the simple MessageBox function , which displays a pop up dialog box. We\'ll use the wide version (MessageBoxW) for this example. If you want to call a Windows API using a string literal, the windows-strings crate has macros to generate Windows strings from string literals: h! generates an HSTRING from a string literal, adding a null terminator and converting to UTF-16. w! does the same, but generates a PCWSTR instead of an HSTRING. s! generates a PCSTR with a null terminator. Caution: this does not do any conversions, it simply adds a null terminator. If we wanted to call the message box we could use the windows crate with the Win32_UI_WindowsAndMessaging feature, and call: // use string literals when calling a message box. let text = h!(\\"Hello from rust!\\");\\nlet caption = h!(\\"From Rust\\"); unsafe { // call the MessageBox function and return MESSAGEBOX_RESULT UI::WindowsAndMessaging::MessageBoxW(None, text, caption, UI::WindowsAndMessaging::MESSAGEBOX_STYLE(0) // message box OK )\\n} This works, but what if we wanted to call the same function with a Rust string? That gets slightly more complicated. We could manually convert to a UTF-16 series of bytes, and add the null terminator ourselves, like this: // this works for any &str, not just literals\\nlet text = \\"I am a message to display!\\";\\nlet caption = \\"Message from Rust!\\"; // convert our text and caption to UTF-16 bytes,\\n// add null terminators using chain, and then collect\\n// the result into a vec\\nlet text = text.encode_utf16() .chain(iter::once(0u16)) .collect::<Vec<u16>>();\\nlet caption = caption.encode_utf16() .chain(iter::once(0u16)) .collect::<Vec<u16>>(); // call the API, wrapping our vec pointer in a PCWSTR struct.\\nunsafe { UI::WindowsAndMessaging::MessageBoxW(None, PCWSTR(text.as_ptr()), PCWSTR(caption.as_ptr()), UI::WindowsAndMessaging::MESSAGEBOX_STYLE(0) // message box OK )\\n} However, this is cumbersome - we can use the convenience features in the windows-strings crate to make this much simpler by converting the Rust strings to HSTRING. let text = \\"I am a message to display!\\";\\nlet caption = \\"Message from Rust!\\"; // convert our strings into UTF-16 // this incurrs a performance cost because there is a copy + conversion\\n// from the standard rust utf-8 string. // we are using HSTRING, which is an immutable UTF-16 string\\n// in the windows-strings crate. It can be generated from a standard\\n// rust string, and it can be used in place of a PCWSTR anywhere in the\\n// windows API. unsafe { UI::WindowsAndMessaging::MessageBoxW(None, &HSTRING::from(text), &HSTRING::from(caption), UI::WindowsAndMessaging::MESSAGEBOX_STYLE(0) // message box OK ) } This is much more ergonomic - it handles the null termination and UTF-16 conversion for you.","breadcrumbs":"Working with strings in the windows crate » Calling APIs that Consume Strings","id":"20","title":"Calling APIs that Consume Strings"},"21":{"body":"Windows APIs that generate strings usually require a two-step call. The first time you call the API, you pass in a NULL pointer for the string buffer, and retrieve the length of the string to be generated. This allows you to allocate the buffer accordingly, and then call the function again with an appopriately sized buffer. For this example, we\'ll use the GetComputerNameW function . This requires the Win32_System_WindowsProgramming feature from the windows crate. let mut buff_len = 0u32; unsafe { // this function will return an error code because it // did not actually write the string. This is normal. let e = GetComputerNameW(None, &mut buff_len).unwrap_err(); debug_assert_eq!(e.code(), HRESULT::from(ERROR_BUFFER_OVERFLOW));\\n} // buff len now has the length of the string (in UTF-16 characters)\\n// the function would like to write. This *does include* the\\n// null terminator. Let\'s create a vector buffer and feed that to the function.\\nlet mut buffer = Vec::<u16>::with_capacity(buff_len as usize); unsafe { WindowsProgramming::GetComputerNameW( Some(PWSTR(buffer.as_mut_ptr())), &mut buff_len).unwrap(); // set the vector length // buff_len now includes the size, which *does not include* the null terminator. // let\'s set the length to just before the terminator so we don\'t have to worry // about it in later conversions. buffer.set_len(buff_len);\\n} // we can now convert this to a valid Rust string\\n// omitting the null terminator\\nString::from_utf16_lossy(&buffer) It\'s worth calling out how the length parameter works. For GetComputerNameW: On input, it represents the size of the buffer including the null terminator in wchar. If the function returns a buffer overflow, the length parameter returned is how large a buffer it needs including the null terminator in wchars. If the function successfully wrote to the buffer, the length is the number of wchars written not including the null terminator. This behavior is documented in the function\'s documentation - when using the Windows API, be careful and check what the function expectes with respect to null terminators. Regardless, this does work, but we can do better. Computer names can only be up to MAX_COMPUTERNAME_LENGTH which is a meager 16 characters. We can avoid a heap allocation here and just use arrays, since we know our buffer length at compile time. // avoid the heap allocation since we already know how big this // buffer needs to be at compile time. let mut name = [0u16; MAX_COMPUTERNAME_LENGTH as usize + 1];\\nlet mut len = name.len() as u32; // we can also skip the two-step call, since we know our buffer\\n// is already larger than any possible computer name unsafe { GetComputerNameW( Some(PWSTR(name.as_mut_ptr())), &mut len) .unwrap();\\n} // the function writes to len with the number of // UTF-16 characters in the string. We can use this\\n// to slice the buffer. String::from_utf16_lossy(&name[..len as usize]) However, if we don\'t mind the heap allocation (and a few extra system calls), there is a more ergonomic option. The windows-strings crate includes HStringBuilder that we can use in place of the array. This gives us much easier conversions. // pre-allocate a HSTRING buffer on the heap\\n// (you do not need to add one to len for the null terminator,\\n// the hstring builder will handle that automatically) let mut buffer = HStringBuilder::new( MAX_COMPUTERNAME_LENGTH as usize); let mut len = buffer.len() as u32 + 1; unsafe { GetComputerNameW( Some(PWSTR(buffer.as_mut_ptr())), &mut len).unwrap();\\n} // we can now generate a valid HSTRING from the HStringBuilder\\nlet buffer = HSTRING::from(buffer); // and we can now return a rust string from the HSTRING:\\nbuffer.to_string_lossy() If you need to work with UTF-16 strings directly, consider using the widestring crate, which is UTF-16 aware. This will enable you to push/pop/append elements without having to convert the string to a native rust UTF-8 string. For completeness, here\'s an example of returning a widestring, and appending some exclaimation marks. // for this example, we\'ll just use an array again let mut name = [0u16; MAX_COMPUTERNAME_LENGTH as usize + 1];\\nlet mut len = name.len() as u32; unsafe { GetComputerNameW( Some(PWSTR(name.as_mut_ptr())), &mut len) .unwrap();\\n} // we can make a UTF16Str slice directly from the buffer,\\n// without needing to do any copy. This will error if the buffer\\n// isn\'t valid UTF-16. let wstr = Utf16Str::from_slice(&name[..len as usize]) .unwrap(); // this can be displayed as is.\\nprintln!(\\"Computer name is {}\\", wstr); // we can also transfer it into owned string, which can\\n// be appended or modified. let mut wstring = Utf16String::from(wstr); // let\'s append another string. We\'ll use a macro to avoid\\n// any UTF conversion at runtime. wstring = wstring + utf16str!(\\"!!!\\");","breadcrumbs":"Working with strings in the windows crate » Calling APIs that Generate Strings","id":"21","title":"Calling APIs that Generate Strings"},"3":{"body":"The windows and windows-sys crates are generated from metadata describing the Windows API. Originally only WinRT APIs included metadata, but metadata is now provided for older C and COM APIs as well. The win32metadata project provides the tools to produce the metadata and the windows-metadata and windows-bindgen crates are used to read the metadata and generate the windows and windows-sys crates. The bindings are generated differently based on the differing goals of the respective crates. You can find the exact metadata files used to generate a particular version of the windows and windows-sys crates here .","breadcrumbs":"How are these crates built? » How are these crates built?","id":"3","title":"How are these crates built?"},"4":{"body":"First pick the crate you would like to use . Then search the documentation for the chosen crate: windows windows-sys Note that the docs include a note indicating which features to enable in order to access a particular API.","breadcrumbs":"How do I find a particular API? » How do I find a particular API?","id":"4","title":"How do I find a particular API?"},"5":{"body":"All Windows APIs provided by the Windows SDK are included, with a few exceptions. The definitions of these APIs are collected from metadata and transformed into Rust bindings . The process of generating the Rust bindings purposefully omits a few APIs. APIs are only excluded if they are (1) unsuitable for Rust developers and (2) impose a large hit on the overall size of the windows and windows-sys crates. The Xaml API is excluded because it is all but unusable without direct language support that only the Xaml team can provide. Xaml is also focused and tailored for C# app development so this API isn\'t applicable to Rust developers. The MsHtml API is also excluded because it is only intended for Microsoft\'s older scripting languages like JScript and VBScript. It is also by far the single largest module as measured in lines of code. Beyond that, a few deprecrated and unusable APIs are excluded. You can see exactly what the windows crate excludes and what the windows-sys crate excludes . Beyond that, the windows-sys crate currently excludes all COM and WinRT APIs. The windows-sys crate only includes declarations and COM and WinRT calls are far too cumbersome without the abstractions provided by the windows crate. Here are some tips for choosing between the windows and windows-sys crates .","breadcrumbs":"What APIs are included? » What APIs are included?","id":"5","title":"What APIs are included?"},"6":{"body":"The windows and windows-sys crates are generated from metadata . This metadata only includes type definitions and function signatures, not macros, header-only functions, or function bodies. You may find some equivalents of common C/C++ helper macros and functions in the windows crate, but in general the macros don\'t have direct equivalents in the windows or windows-sys crates.","breadcrumbs":"Where\'s my favorite macro from the Windows SDK? » Where\'s my favorite macro from the Windows SDK?","id":"6","title":"Where\'s my favorite macro from the Windows SDK?"},"7":{"body":"So you want to get a feel for calling a simple Windows API. Where to start? Let\'s look at a relatively simple API for submitting callbacks to the thread pool. You can read more about this API here . The first step is to add a dependency on the windows crate and indicate which features you\'d like to access: [dependencies.windows]\\nversion = \\"0.52\\"\\nfeatures = [ \\"Win32_Foundation\\", \\"Win32_System_Threading\\",\\n] Why these two features? Well, the thread pool API is defined in the Win32::System::Threading module and we\'ll also use a handful of definitions from the Win32::Foundation module. If you\'re unsure, the docs for any given API provide a helpful comment indicating which features are required. For example, here are the docs for WaitForThreadpoolWorkCallbacks where you can see it depends on both of these features since it is defined in the Win32::System::Threading module and depends on BOOL which is defined in the Win32::Foundation module. Cargo will now handle the heavy lifting, tracking down the dependencies and making sure the import libs are present, so that we can simply call these APIs in Rust without any further configuration. We can employ a use declaration to make these APIs a little more accessible: use windows::{core::Result, Win32::System::Threading::*}; In order to \\"prove\\" that the code works and yet keep it real simple let\'s just use the thread pool to increment a counter some number of times. Here we can use a reader-writer lock for safe and multi-threaded access to the counter variable: static COUNTER: std::sync::RwLock<i32> = std::sync::RwLock::new(0); For this example, I\'ll just use a simple main function with a big unsafe block since virtually everything here is going to be unsafe. Why is that? Well the windows crate lets you call foreign functions and these are generally assumed to be unsafe. fn main() -> Result<()> { unsafe { } Ok(())\\n} The thread pool API is modeled as a set of \\"objects\\" exposed via a traditional C-style API. The first thing we need to do is create a work object: let work = CreateThreadpoolWork(Some(callback), None, None)?; The first parameter is a pointer to a callback function. The remaining parameters are optional and you can read more about them in my thread pool series on MSDN. The callback itself must be a valid C-style callback according to the signature expected by the thread pool API. Here\'s a simple callback that will increment the count: extern \\"system\\" fn callback(_: PTP_CALLBACK_INSTANCE, _: *mut std::ffi::c_void, _: PTP_WORK) { let mut counter = COUNTER.write().unwrap(); *counter += 1;\\n} The parameters can safely be ignored but do come in handy from time to time. At this point, we have a valid work object but nothing is happening yet. In order to kick off some \\"work\\", we need to submit the work object to the thread pool. You can do so as many times as you\'d like, so lets go ahead and do it ten times: for _ in 0..10 { SubmitThreadpoolWork(work);\\n} You can now expect the callbacks to run concurrently, hence the RwLock above. Of course, with all of that concurrency we need some way to tell when the work is done. That\'s the job of the WaitForThreadpoolWorkCallbacks function: WaitForThreadpoolWorkCallbacks(work, false); The second parameter indicates whether we would like to cancel any pending callbacks that have not started to execute. Passing false here thus indicates that we would like the wait function to block until all of the submitted work has completed. At that point, we can safely close the work object to free its memory: CloseThreadpoolWork(work); And just to prove that it works reliably, we can print out the counter\'s value: let counter = COUNTER.read().unwrap();\\nprintln!(\\"counter: {}\\", *counter); Running the sample should print something like this: counter: 10 Here\'s the full sample for reference .","breadcrumbs":"Calling your first API with the windows crate » Calling your first API with the windows crate","id":"7","title":"Calling your first API with the windows crate"},"8":{"body":"So you want to get a feel for calling a simple Windows API. Where to start? Let\'s look at a relatively simple API for submitting callbacks to the thread pool. You can read more about this API here . The first step is to add a dependency on the windows-sys crate and indicate which features you\'d like to access: [dependencies.windows-sys]\\nversion = \\"0.52\\"\\nfeatures = [ \\"Win32_Foundation\\", \\"Win32_System_Threading\\",\\n] Why these two features? Well, the thread pool API is defined in the Win32::System::Threading module and we\'ll also use a handful of definitions from the Win32::Foundation module. If you\'re unsure, the docs for any given API provide a helpful comment indicating which features are required. For example, here are the docs for WaitForThreadpoolWorkCallbacks where you can see it depends on both of these features since it is defined in the Win32::System::Threading module and depends on BOOL which is defined in the Win32::Foundation module. Cargo will now handle the heavy lifting, tracking down the dependencies and making sure the import libs are present, so that we can simply call these APIs in Rust without any further configuration. We can employ a use declaration to make these APIs a little more accessible: use windows_sys::{Win32::Foundation::*, Win32::System::Threading::*}; In order to \\"prove\\" that the code works and yet keep it real simple let\'s just use the thread pool to increment a counter some number of times. Here we can use a reader-writer lock for safe and multi-threaded access to the counter variable: static COUNTER: std::sync::RwLock<i32> = std::sync::RwLock::new(0); For this example, I\'ll just use a simple main function with a big unsafe block since virtually everything here is going to be unsafe. Why is that? Well the windows crate lets you call foreign functions and these are generally assumed to be unsafe. fn main() { unsafe { }\\n} The thread pool API is modeled as a set of \\"objects\\" exposed via a traditional C-style API. The first thing we need to do is create a work object: let work = CreateThreadpoolWork(Some(callback), std::ptr::null_mut(), std::ptr::null()); The first parameter is a pointer to a callback function. The remaining parameters are optional and you can read more about them in my thread pool series on MSDN. Since this function allocates memory, it is possible that it might fail, and this is indicated by returning a null pointer rather than a valid work object handle. We\'ll check for this condition and call the GetLastError function to display any relevant error code: if work == 0 { println!(\\"{:?}\\", GetLastError()); return;\\n} The callback itself must be a valid C-style callback according to the signature expected by the thread pool API. Here\'s a simple callback that will increment the count: extern \\"system\\" fn callback(_: PTP_CALLBACK_INSTANCE, _: *mut std::ffi::c_void, _: PTP_WORK) { let mut counter = COUNTER.write().unwrap(); *counter += 1;\\n} The parameters can safely be ignored but do come in handy from time to time. At this point, we have a valid work object but nothing is happening yet. In order to kick off some \\"work\\", we need to submit the work object to the thread pool. You can do so as many times as you\'d like, so lets go ahead and do it ten times: for _ in 0..10 { SubmitThreadpoolWork(work);\\n} You can now expect the callbacks to run concurrently, hence the RwLock above. Of course, with all of that concurrency we need some way to tell when the work is done. That\'s the job of the WaitForThreadpoolWorkCallbacks function: WaitForThreadpoolWorkCallbacks(work, 0); The second parameter indicates whether we would like to cancel any pending callbacks that have not started to execute. Passing 0, meaning false, here thus indicates that we would like the wait function to block until all of the submitted work has completed. At that point, we can safely close the work object to free its memory: CloseThreadpoolWork(work); And just to prove that it works reliably, we can print out the counter\'s value: let counter = COUNTER.read().unwrap();\\nprintln!(\\"counter: {}\\", *counter); Running the sample should print something like this: counter: 10 Here\'s the full sample for reference .","breadcrumbs":"Calling your first API with the windows-sys crate » Calling your first API with the windows-sys crate","id":"8","title":"Calling your first API with the windows-sys crate"},"9":{"body":"COM APIs are unique in that they expose functionality through interfaces. An interface is just a collection of virtual function pointers grouped together in what is known as a vtable, or virtual function table. This is not something that Rust supports directly, like C++ does, but the windows crate provides the necessary code gen to make it possible and seamless. A COM API will still typically start life through a traditional C-style function call in order to get your hands on a COM interface. From there you might call other methods via the interface. Some COM-based APIs can get real complicated so let\'s start with a very simple example. The CreateUri function is officially documented on MSDN as returning the IUri interface representing the results of parsing the given URI. The Rust docs for the windows crate indicate that it resides in the Win32::System::Com module so we can configure our windows crate dependency accordingly: [dependencies.windows]\\nversion = \\"0.52\\"\\nfeatures = [ \\"Win32_System_Com\\",\\n] And we can employ a use declaration to make this API a little more accessible. The windows crate\'s core module also provides a few helpers to make it easier to work with COM interfaces, so we\'ll include that as well: use windows::{core::*, Win32::System::Com::*}; For this example, I\'ll just use a simple main function with a big unsafe block since virtually everything here is going to be unsafe. Why is that? Well the windows crate lets you call foreign functions and these are generally assumed to be unsafe. fn main() -> Result<()> { unsafe { Ok(()) }\\n} The only \\"interesting\\" point here is the use of the Result type from the windows::core module that provides Windows error handling to simplify the following API calls. And with that, we can call the CreateUri function as follows: let uri = CreateUri(w!(\\"http://kennykerr.ca\\"), Uri_CREATE_CANONICALIZE, 0)?; There\'s quite a lot going on here. The first parameter is actually a PCWSTR, representing a null-terminated wide string used by many Windows APIs. The windows crate provides the handy w! macro for creating a valid null-terminated wide string as a compile-time constant. The second parameter is just the default flag specified by the official documentation. The third parameter is reserved and should thus be zero. The resulting IUri object has various methods that we can now use to inspect the URI. The official documentation describes the various interface methods and the Rust docs give you a quick glimpse at their various signatures so that you can quickly figure out how to call them in Rust. For this example, let\'s just call two of them to print out the URI\'s domain and the HTTP port number: let domain = uri.GetDomain()?;\\nlet port = uri.GetPort()?; println!(\\"{domain} ({port})\\"); Under the hood, those methods will invoke the virtual functions through the COM interface and into the implementation provided by the API. They also provide a bunch of error and signature transformation to make it very natural to use from Rust. And that\'s it, running the sample should print something like this: kennykerr.ca (80) Here\'s the full sample for reference .","breadcrumbs":"Calling your first COM API » Calling your first COM API","id":"9","title":"Calling your first COM API"}},"length":22,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{".":{"1":{"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"1":{"7":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"5":{"2":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"16":{"tf":2.0},"17":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"1":{"6":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"5":{"6":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"2":{"3":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"4":{"0":{"0":{"1":{"7":{"2":{"5":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"1":{"2":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.449489742783178},"21":{"tf":2.449489742783178}}},"df":5,"docs":{"16":{"tf":2.0},"21":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"2":{"0":{"2":{"1":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}},"3":{"df":1,"docs":{"13":{"tf":1.0}}},"8":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"d":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"8":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":16,"docs":{"10":{"tf":3.1622776601683795},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":2.0},"17":{"tf":3.1622776601683795},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"2":{"tf":2.6457513110645907},"20":{"tf":2.0},"21":{"tf":2.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"5":{"tf":3.1622776601683795},"7":{"tf":3.3166247903554},"8":{"tf":3.3166247903554},"9":{"tf":2.8284271247461903}}},"p":{"df":1,"docs":{"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"m":{"6":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}},"y":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"18":{"tf":1.4142135623730951}}}}},"d":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":2.8284271247461903},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":2.0},"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":2.449489742783178}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"k":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":4.242640687119285}}}}}},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}}},"c":{"+":{"+":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"_":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"0":{"tf":1.0},"10":{"tf":3.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":2.8284271247461903},"21":{"tf":2.6457513110645907},"5":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.23606797749979},"9":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":2.449489742783178}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"20":{"tf":2.449489742783178}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}}}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0}}},"t":{"df":1,"docs":{"11":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"g":{"!":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"0":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.0},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0}}}}},"df":1,"docs":{"16":{"tf":1.0}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"13":{"tf":3.872983346207417},"17":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":8,"docs":{"10":{"tf":2.8284271247461903},"11":{"tf":1.7320508075688772},"12":{"tf":2.6457513110645907},"13":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":2.6457513110645907}},"e":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"17":{"tf":2.8284271247461903},"2":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"20":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":3.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"18":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":1.0}}},"t":{"df":2,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772}}},"t":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\'":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":19,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":3.3166247903554},"15":{"tf":2.6457513110645907},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"18":{"tf":1.4142135623730951},"2":{"tf":3.1622776601683795},"20":{"tf":2.0},"21":{"tf":1.7320508075688772},"3":{"tf":2.449489742783178},"4":{"tf":1.4142135623730951},"5":{"tf":2.6457513110645907},"6":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":2.23606797749979},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"w":{"!":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":2.0},"17":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"v":{"df":1,"docs":{"15":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":6,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.7320508075688772}}}}}},"i":{"c":{"df":1,"docs":{"11":{"tf":2.6457513110645907}},"e":{"\'":{"df":1,"docs":{"11":{"tf":1.0}}},".":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"3":{"d":{"df":1,"docs":{"11":{"tf":2.0}}},"df":0,"docs":{}},"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":2.449489742783178}}}}},"x":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951}}}},"o":{"c":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"h":{"!":{"(":{"\\"":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{">":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":5,"docs":{"10":{"tf":1.7320508075688772},"4":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":2.0},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"\'":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"14":{"tf":2.0}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}},"df":1,"docs":{"21":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"2":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}}}}},"r":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":3.0},"21":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"5":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979}}}},"s":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"a":{"df":2,"docs":{"2":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"8":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"r":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":1.0},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"3":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"d":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"21":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.4142135623730951}}}}},"x":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"14":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.6457513110645907},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\\"":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":4,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"\'":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}},"df":16,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"17":{"tf":4.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":3.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.6457513110645907},"9":{"tf":3.0}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"10":{"tf":1.0},"15":{"tf":2.449489742783178},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":2.0},"3":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"_":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":1,"docs":{"21":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}}}}}},"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":5,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":4,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"a":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"2":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"h":{"!":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":8,"docs":{"11":{"tf":1.0},"17":{"tf":4.898979485566356},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"21":{"tf":1.0}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}},"d":{"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":1,"docs":{"16":{"tf":2.23606797749979}},"l":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"p":{"d":{"b":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"16":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"10":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"16":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}}},"p":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"c":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"\'":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"21":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.7320508075688772}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.8284271247461903}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":2.0},"21":{"tf":2.0}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"i":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"3":{"2":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}},"6":{"8":{"6":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"3":{"d":{"1":{"1":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"20":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":5.196152422706632},"13":{"tf":3.1622776601683795},"17":{"tf":2.8284271247461903},"9":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":3.4641016151377544},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":14,"docs":{"10":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":2.6457513110645907},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"c":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"f":{"a":{"c":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.8284271247461903},"12":{"tf":3.0},"13":{"tf":3.0},"9":{"tf":2.8284271247461903}},"e":{"\'":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"10":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":2.0}}}}}}}}},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}},"t":{"\'":{"df":4,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":4.47213595499958}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":2.23606797749979}}},"y":{"\'":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"y":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}},"n":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"14":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":2.8284271247461903}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":2.8284271247461903}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"\'":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"df":4,"docs":{"15":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":6,"docs":{"14":{"tf":3.3166247903554},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":3,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":2.449489742783178}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0}},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":2.23606797749979},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":2.6457513110645907},"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":2.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"df":4,"docs":{"13":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"13":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":2.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"n":{"df":2,"docs":{"17":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"17":{"tf":2.0},"20":{"tf":3.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"a":{"df":1,"docs":{"19":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}},"w":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"16":{"tf":1.0},"3":{"tf":2.6457513110645907},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":6,"docs":{"10":{"tf":2.0},"11":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":2.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"5":{"tf":1.0}}},"df":2,"docs":{"0":{"tf":1.4142135623730951},"15":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"s":{"d":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"c":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":5,"docs":{"11":{"tf":1.0},"17":{"tf":3.3166247903554},"21":{"tf":3.7416573867739413},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},">":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"21":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":2.6457513110645907},"2":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"h":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"w":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"20":{"tf":2.449489742783178},"21":{"tf":3.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"17":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.449489742783178},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}}}}}}},"t":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"2":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":2.449489742783178},"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{")":{"?":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"s":{"df":2,"docs":{"17":{"tf":2.23606797749979},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"18":{"tf":1.0},"20":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}},"p":{"df":1,"docs":{"20":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"f":{"(":{"\\"":{"%":{"d":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":3,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":2.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"i":{"d":{"df":13,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":2.8284271247461903},"2":{"tf":2.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"p":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"w":{"df":3,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"z":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"18":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"12":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":3.0},"20":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"17":{"tf":4.47213595499958},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}}}},"df":1,"docs":{"10":{"tf":1.0}}}}},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"19":{"tf":1.0}}},"df":16,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.449489742783178},"10":{"tf":2.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.6457513110645907},"17":{"tf":2.6457513110645907},"18":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":2.8284271247461903},"21":{"tf":1.7320508075688772},"5":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}}}},"v":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":2.23606797749979}},"e":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"17":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"w":{"df":1,"docs":{"10":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"(":{"&":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":2.449489742783178}}}}}},"df":1,"docs":{"17":{"tf":3.872983346207417}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"17":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"m":{"df":1,"docs":{"17":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"20":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":2,"docs":{"21":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"14":{"tf":1.0},"21":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"11":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"c":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":2.0}}}}},"r":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"14":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"(":{"&":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"[":{".":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":3.0},"18":{"tf":3.3166247903554},"19":{"tf":1.7320508075688772},"20":{"tf":3.872983346207417},"21":{"tf":3.872983346207417},"9":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":2.23606797749979},"2":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"u":{"b":{"df":1,"docs":{"16":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":2.0},"5":{"tf":1.0},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":8,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":2.0},"2":{"tf":2.23606797749979},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"2":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"\\\\":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"14":{"tf":3.1622776601683795},"15":{"tf":1.7320508075688772},"16":{"tf":1.0}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":2.23606797749979},"20":{"tf":2.449489742783178},"21":{"tf":3.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"15":{"tf":2.0}}}},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"\'":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"\'":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}},"df":2,"docs":{"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"u":{"df":5,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":2.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0}}}},"p":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":2.0},"2":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"1":{"6":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"17":{"tf":2.8284271247461903},"18":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"0":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":2.6457513110645907},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":2.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"df":5,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"\'":{"df":1,"docs":{"9":{"tf":1.0}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"s":{"df":19,"docs":{"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"14":{"tf":2.449489742783178},"15":{"tf":2.23606797749979},"16":{"tf":2.23606797749979},"17":{"tf":3.4641016151377544},"18":{"tf":2.449489742783178},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":3.0},"21":{"tf":2.8284271247461903},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"17":{"tf":3.872983346207417},"21":{"tf":2.449489742783178}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"[":{".":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.6457513110645907},"21":{"tf":2.6457513110645907}}}}},"v":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}}}}},"df":5,"docs":{"17":{"tf":4.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"17":{"tf":4.123105625617661},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"(":{"&":{"\'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"c":{":":{":":{"<":{"df":0,"docs":{},"u":{"1":{"6":{">":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":14,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"i":{"a":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"4":{"1":{"0":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}},"y":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}},"e":{"\'":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"n":{"3":{"2":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":2.23606797749979},"19":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.6457513110645907},"10":{"tf":3.0},"11":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.7320508075688772},"14":{"tf":3.872983346207417},"15":{"tf":3.4641016151377544},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":3.7416573867739413},"20":{"tf":2.6457513110645907},"21":{"tf":2.0},"3":{"tf":3.0},"4":{"tf":1.4142135623730951},"5":{"tf":3.3166247903554},"6":{"tf":2.449489742783178},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":2.8284271247461903}},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"3":{"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"3":{"2":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"!":{"(":{"\\"":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"3":{"2":{".":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.7320508075688772},"13":{"tf":3.0},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":2.0},"21":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"14":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"df":0,"docs":{},"k":{"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"7":{"tf":3.1622776601683795},"8":{"tf":3.4641016151377544},"9":{"tf":1.0}}},"l":{"d":{"<":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.7320508075688772}},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"21":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"\'":{"d":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{".":{"1":{"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"1":{"7":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"5":{"2":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"0":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"16":{"tf":2.0},"17":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"1":{"6":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"17":{"tf":1.0}}},"5":{"6":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"2":{"3":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"4":{"0":{"0":{"1":{"7":{"2":{"5":{"8":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"1":{"2":{"0":{"0":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":2.449489742783178},"21":{"tf":2.449489742783178}}},"df":5,"docs":{"16":{"tf":2.0},"21":{"tf":1.7320508075688772},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"2":{"0":{"2":{"1":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.0}}},"3":{"df":1,"docs":{"13":{"tf":1.0}}},"8":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}},"_":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":3,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"a":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"\'":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"d":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"8":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"i":{"df":16,"docs":{"10":{"tf":3.4641016151377544},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":2.0},"17":{"tf":3.4641016151377544},"18":{"tf":1.0},"19":{"tf":2.0},"2":{"tf":2.6457513110645907},"20":{"tf":2.23606797749979},"21":{"tf":2.23606797749979},"3":{"tf":1.7320508075688772},"4":{"tf":2.0},"5":{"tf":3.4641016151377544},"7":{"tf":3.605551275463989},"8":{"tf":3.605551275463989},"9":{"tf":3.1622776601683795}}},"p":{"df":1,"docs":{"5":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"m":{"6":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0}}}},"df":1,"docs":{"15":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}},"y":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"16":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"13":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":4,"docs":{"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"18":{"tf":1.4142135623730951}}}}},"d":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":2.8284271247461903},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":2.0},"3":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":5,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"x":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":2.449489742783178}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"k":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":4.242640687119285}}}}}},"g":{"df":1,"docs":{"15":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"1":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.0},"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.7320508075688772}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}}},"c":{"+":{"+":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"1":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":2,"docs":{"0":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"(":{"_":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"0":{"tf":1.0},"10":{"tf":3.3166247903554},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"2":{"tf":1.0},"20":{"tf":3.0},"21":{"tf":2.8284271247461903},"5":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":2.6457513110645907},"9":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":2.449489742783178}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"20":{"tf":2.449489742783178}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}}}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0}}},"t":{"df":1,"docs":{"11":{"tf":2.23606797749979}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"g":{"!":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"(":{"0":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"2":{"tf":1.7320508075688772},"5":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0}}}}},"df":1,"docs":{"16":{"tf":1.0}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":11,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"u":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"13":{"tf":4.358898943540674},"17":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"m":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"df":8,"docs":{"10":{"tf":2.8284271247461903},"11":{"tf":2.23606797749979},"12":{"tf":3.0},"13":{"tf":1.0},"2":{"tf":2.0},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":3.0}},"e":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":7,"docs":{"13":{"tf":1.0},"14":{"tf":2.23606797749979},"16":{"tf":1.7320508075688772},"17":{"tf":2.8284271247461903},"2":{"tf":2.6457513110645907},"21":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"c":{"df":2,"docs":{"20":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.7320508075688772}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"9":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":3.0}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"18":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":1.0}}},"t":{"df":2,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.7320508075688772}}},"t":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":1.4142135623730951}}}}}}},"p":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"\'":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":2,"docs":{"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903}}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":4,"docs":{"0":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":20,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":3.605551275463989},"15":{"tf":2.6457513110645907},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"18":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":3.4641016151377544},"20":{"tf":2.23606797749979},"21":{"tf":2.0},"3":{"tf":2.8284271247461903},"4":{"tf":1.4142135623730951},"5":{"tf":2.6457513110645907},"6":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":2.6457513110645907},"14":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"(":{"df":0,"docs":{},"w":{"!":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{":":{"/":{"/":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"11":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{":":{":":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{":":{":":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"e":{".":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":2.0},"17":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"3":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}},"v":{"df":1,"docs":{"15":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":6,"docs":{"1":{"tf":2.23606797749979},"10":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"2":{"tf":1.0},"5":{"tf":1.7320508075688772}}}}}},"i":{"c":{"df":1,"docs":{"11":{"tf":2.6457513110645907}},"e":{"\'":{"df":1,"docs":{"11":{"tf":1.0}}},".":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.4142135623730951}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"16":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"3":{"d":{"df":1,"docs":{"11":{"tf":2.0}}},"df":0,"docs":{}},"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":2.449489742783178}}}}},"x":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":2.8284271247461903},"17":{"tf":1.4142135623730951}}}},"o":{"c":{".":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"h":{"!":{"(":{"\\"":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{">":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":5,"docs":{"10":{"tf":1.7320508075688772},"4":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":2.0},"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"n":{"\'":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.7320508075688772}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"14":{"tf":2.0}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"9":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}},"df":1,"docs":{"21":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"2":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}}}}},"r":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":3.0},"21":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"5":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":2.23606797749979},"13":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979}}}},"s":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"r":{"a":{"df":2,"docs":{"2":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"14":{"tf":1.0},"17":{"tf":1.0},"8":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"s":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"r":{"df":2,"docs":{"10":{"tf":1.0},"5":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":4,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"w":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"21":{"tf":1.0},"5":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":1.0},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"3":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"d":{"df":6,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"6":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":2.0},"21":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.0}}}}},"x":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"14":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.6457513110645907},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\\"":{"df":0,"docs":{},"{":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"}":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":4,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"\'":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}},"df":16,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"16":{"tf":2.23606797749979},"17":{"tf":4.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.7320508075688772},"2":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":3.0},"6":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.6457513110645907},"9":{"tf":3.0}}}}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":14,"docs":{"10":{"tf":1.0},"15":{"tf":2.8284271247461903},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":2.23606797749979},"21":{"tf":2.23606797749979},"3":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"t":{"_":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":1,"docs":{"21":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}}}}}}},"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.7320508075688772},"20":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":5,"docs":{"11":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":4,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"a":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"2":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"h":{"!":{"(":{"\\"":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":8,"docs":{"11":{"tf":1.0},"17":{"tf":4.898979485566356},"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"21":{"tf":1.0}}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":2.0}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\"":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{".":{"c":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}},"d":{"df":1,"docs":{"16":{"tf":1.0}},"l":{"df":1,"docs":{"16":{"tf":2.23606797749979}},"l":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"p":{"d":{"b":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"16":{"tf":2.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"10":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"16":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}}}},"p":{"df":5,"docs":{"1":{"tf":1.0},"15":{"tf":1.0},"18":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}}}}},"n":{"c":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"\'":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"21":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.7320508075688772}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"df":0,"docs":{},"o":{"d":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"1":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.8284271247461903}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":5,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"18":{"tf":1.7320508075688772},"20":{"tf":2.0},"21":{"tf":2.0}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}},"i":{"\'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"3":{"2":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}},"6":{"8":{"6":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"3":{"d":{"1":{"1":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{":":{":":{"<":{"df":0,"docs":{},"i":{"3":{"2":{">":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"c":{"!":{"[":{"1":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"<":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"20":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":5.385164807134504},"13":{"tf":3.1622776601683795},"17":{"tf":3.1622776601683795},"9":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":3.4641016151377544},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":14,"docs":{"10":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":2.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"21":{"tf":2.6457513110645907},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"c":{"df":7,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"14":{"tf":1.0},"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}},"f":{"a":{"c":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":3.1622776601683795},"12":{"tf":3.3166247903554},"13":{"tf":3.3166247903554},"9":{"tf":2.8284271247461903}},"e":{"\'":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"10":{"tf":1.0}},"t":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":2.0}}}}}}}}},"s":{"df":0,"docs":{},"n":{"\'":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}}},"t":{"\'":{"df":4,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"<":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"b":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":4.47213595499958}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"(":{"&":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":2.23606797749979}}},"y":{"\'":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{".":{"c":{"a":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"y":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}},"n":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"10":{"tf":1.0},"16":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"14":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":2.8284271247461903}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":2.8284271247461903}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.0}}}},"t":{"\'":{"df":11,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"df":4,"docs":{"15":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":6,"docs":{"14":{"tf":3.3166247903554},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"0":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.0}}},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":3,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.0}},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":2.449489742783178}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"o":{"a":{"d":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0}},"x":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":2.23606797749979},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":2.6457513110645907},"14":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":2.449489742783178},"9":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":9,"docs":{"10":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"k":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"i":{"df":4,"docs":{"13":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"13":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"18":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"x":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":2.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}},"n":{"df":2,"docs":{"17":{"tf":1.0},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"17":{"tf":2.0},"20":{"tf":3.0}},"e":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"a":{"df":1,"docs":{"19":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}},"w":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":4,"docs":{"16":{"tf":1.0},"3":{"tf":2.6457513110645907},"5":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":6,"docs":{"10":{"tf":2.0},"11":{"tf":2.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":2.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"5":{"tf":1.0}}},"df":2,"docs":{"0":{"tf":1.4142135623730951},"15":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"16":{"tf":1.0},"2":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"o":{"d":{"df":1,"docs":{"15":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":7,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}},"s":{"d":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"v":{"c":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.4142135623730951},"21":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":5,"docs":{"11":{"tf":1.0},"17":{"tf":3.3166247903554},"21":{"tf":3.7416573867739413},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},">":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":2.6457513110645907},"17":{"tf":1.0},"21":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"9":{"tf":1.0}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"17":{"tf":2.6457513110645907},"2":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"w":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"d":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"18":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"h":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"w":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":2.23606797749979},"20":{"tf":2.449489742783178},"21":{"tf":3.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"17":{"tf":2.0},"7":{"tf":2.23606797749979},"8":{"tf":2.449489742783178},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"k":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"0":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"0":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"5":{"tf":1.0}}}}},"n":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"<":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"4":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"3":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}}}}}}},"t":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"2":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"16":{"tf":2.449489742783178},"17":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{")":{"?":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}},"s":{"df":2,"docs":{"17":{"tf":2.23606797749979},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":2.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":3,"docs":{"18":{"tf":1.0},"20":{"tf":1.7320508075688772},"9":{"tf":1.0}}}}}}},"df":1,"docs":{"16":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"20":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":2.6457513110645907},"8":{"tf":2.6457513110645907}}}},"p":{"df":1,"docs":{"20":{"tf":1.0}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"2":{"tf":1.0},"21":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"21":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"f":{"(":{"\\"":{"%":{"d":{"\\\\":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\\"":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"{":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":3,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"17":{"tf":1.0}}},"df":3,"docs":{"1":{"tf":1.4142135623730951},"16":{"tf":2.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"i":{"d":{"df":13,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"12":{"tf":2.23606797749979},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":2.8284271247461903},"2":{"tf":2.0},"3":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.449489742783178}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"p":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"p":{"c":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"11":{"tf":2.0}}},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}},"w":{"df":3,"docs":{"14":{"tf":2.0},"15":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":5,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"z":{"df":1,"docs":{"2":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"18":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":4,"docs":{"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"21":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":8,"docs":{"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}}},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"12":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"x":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"2":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":3.0},"20":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":2.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"11":{"tf":1.0},"21":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":7,"docs":{"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"17":{"tf":4.47213595499958},"20":{"tf":1.0},"21":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}}}},"df":1,"docs":{"10":{"tf":1.0}}}}},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"n":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"21":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"19":{"tf":1.0}}},"df":16,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":2.8284271247461903},"10":{"tf":2.0},"11":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"16":{"tf":3.0},"17":{"tf":2.6457513110645907},"18":{"tf":1.0},"2":{"tf":2.449489742783178},"20":{"tf":2.8284271247461903},"21":{"tf":1.7320508075688772},"5":{"tf":2.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.23606797749979}}}}},"v":{"a":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":2.23606797749979}},"e":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"17":{"tf":2.23606797749979}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"w":{"df":1,"docs":{"10":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"(":{"&":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":2.449489742783178}}}}}},"df":1,"docs":{"17":{"tf":3.872983346207417}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"k":{"df":2,"docs":{"5":{"tf":1.0},"6":{"tf":1.7320508075688772}}}},"df":1,"docs":{"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"17":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":2.0}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"m":{"df":1,"docs":{"17":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":2.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":3,"docs":{"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"4":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"20":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":8,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":2,"docs":{"21":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"14":{"tf":1.0},"21":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"(":{"\\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"\\"":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":3,"docs":{"11":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"2":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"c":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":2.449489742783178}}}}},"r":{"d":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"0":{"tf":1.0},"1":{"tf":2.23606797749979},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"14":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":1,"docs":{"8":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"(":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"n":{"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"0":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"i":{"3":{"2":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"(":{"&":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"[":{".":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":9,"docs":{"10":{"tf":1.0},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":3.0},"18":{"tf":3.605551275463989},"19":{"tf":2.0},"20":{"tf":4.123105625617661},"21":{"tf":4.123105625617661},"9":{"tf":1.4142135623730951}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"20":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":2.6457513110645907},"2":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"u":{"b":{"df":1,"docs":{"16":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":2.0},"5":{"tf":1.0},"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":8,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":2.0},"2":{"tf":2.6457513110645907},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":2.23606797749979},"6":{"tf":1.4142135623730951},"8":{"tf":2.23606797749979}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"16":{"tf":2.449489742783178},"17":{"tf":2.23606797749979},"2":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"\\\\":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"\\\\":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"14":{"tf":3.4641016151377544},"15":{"tf":1.7320508075688772},"16":{"tf":1.0}}}}}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"2":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"18":{"tf":2.23606797749979},"20":{"tf":2.449489742783178},"21":{"tf":3.0},"9":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"15":{"tf":2.0}}}},"x":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":2.449489742783178}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"t":{"\'":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\'":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"\'":{"df":2,"docs":{"18":{"tf":1.0},"19":{"tf":1.0}}},"df":2,"docs":{"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"u":{"df":5,"docs":{"15":{"tf":1.0},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"1":{"tf":1.4142135623730951},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"2":{"tf":2.0},"21":{"tf":1.7320508075688772},"7":{"tf":2.23606797749979},"8":{"tf":2.23606797749979},"9":{"tf":1.0}}}},"p":{"df":1,"docs":{"5":{"tf":1.0}}}},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":2.0},"2":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":3,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0}}}},"p":{"df":1,"docs":{"2":{"tf":1.0}},"i":{"c":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"17":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"12":{"tf":1.0},"17":{"tf":2.0},"2":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":5,"docs":{"16":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":9,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"6":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"1":{"6":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"3":{"2":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"21":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"8":{"df":3,"docs":{"17":{"tf":2.8284271247461903},"18":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{},"i":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"0":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"11":{"tf":1.0},"2":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"1":{"tf":1.0},"14":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":2.6457513110645907},"20":{"tf":1.7320508075688772},"21":{"tf":2.23606797749979},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":2.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"df":5,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0}}},"r":{"df":0,"docs":{},"i":{"\'":{"df":1,"docs":{"9":{"tf":1.0}}},".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}},"_":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"s":{"df":19,"docs":{"1":{"tf":1.0},"10":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"14":{"tf":2.449489742783178},"15":{"tf":2.23606797749979},"16":{"tf":2.23606797749979},"17":{"tf":3.4641016151377544},"18":{"tf":2.449489742783178},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":3.0},"21":{"tf":2.8284271247461903},"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"17":{"tf":3.872983346207417},"21":{"tf":2.449489742783178}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"1":{"6":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"[":{".":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"19":{"tf":1.7320508075688772},"20":{"tf":2.6457513110645907},"21":{"tf":2.6457513110645907}}}}},"v":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}}}}},"df":5,"docs":{"17":{"tf":4.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"17":{"tf":4.123105625617661},"7":{"tf":1.0},"8":{"tf":1.0}},"e":{"(":{"&":{"\'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":2.6457513110645907}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.0}},"e":{"c":{":":{":":{"<":{"df":0,"docs":{},"u":{"1":{"6":{">":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":14,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"i":{"a":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"2":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":2.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"4":{"1":{"0":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"s":{"(":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"20":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}},"y":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}},"e":{"\'":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":10,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.0},"20":{"tf":1.0},"21":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"r":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}},"h":{"a":{"df":0,"docs":{},"t":{"\'":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"6":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":5,"docs":{"15":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"20":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"n":{"3":{"2":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"i":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":2.6457513110645907},"19":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":22,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":2.6457513110645907},"10":{"tf":3.0},"11":{"tf":1.0},"12":{"tf":2.0},"13":{"tf":1.7320508075688772},"14":{"tf":4.123105625617661},"15":{"tf":3.4641016151377544},"16":{"tf":1.4142135623730951},"17":{"tf":2.0},"18":{"tf":2.449489742783178},"19":{"tf":1.4142135623730951},"2":{"tf":4.242640687119285},"20":{"tf":2.8284271247461903},"21":{"tf":2.23606797749979},"3":{"tf":3.0},"4":{"tf":1.4142135623730951},"5":{"tf":3.3166247903554},"6":{"tf":2.8284271247461903},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.8284271247461903}},"s":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"3":{"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"{":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}},"e":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"_":{"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"3":{"2":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"!":{"(":{"\\"":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"3":{"2":{".":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":1.7320508075688772},"13":{"tf":3.3166247903554},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"3":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":2.0},"21":{"tf":1.4142135623730951},"5":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"14":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"df":0,"docs":{},"k":{"df":13,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"2":{"tf":1.0},"20":{"tf":1.7320508075688772},"21":{"tf":2.0},"7":{"tf":3.1622776601683795},"8":{"tf":3.4641016151377544},"9":{"tf":1.0}}},"l":{"d":{"<":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":4,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.7320508075688772}},"r":{"df":2,"docs":{"7":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"0":{"tf":1.0},"21":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"21":{"tf":1.7320508075688772}}}}}}}}},"x":{"8":{"6":{"_":{"6":{"4":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":2.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"\'":{"d":{"df":2,"docs":{"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}},"r":{"df":3,"docs":{"14":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}},"title":{"root":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":10,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":6,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"m":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"9":{"tf":1.0}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.0},"3":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"16":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"f":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"15":{"tf":1.0},"21":{"tf":1.0}}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"17":{"tf":1.0}}}}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"16":{"tf":1.0}}}}}},"s":{"d":{"df":0,"docs":{},"k":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"18":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"y":{"df":2,"docs":{"2":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"\'":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"n":{"3":{"2":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"2":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}}');