;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-opt %s -all --closed-world --signature-pruning --fuzz-exec -S -o - | filecheck %s

(module
  ;; CHECK:      (type $public (func))

  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $private (func))

  ;; CHECK:       (type $2 (struct))

  ;; CHECK:      (type $test (func (result i32)))
  (type $test (func (result i32)))

  (type $public (func))

  ;; After signature pruning this will be (func), which is the same as $public.
  ;; We must make sure we keep $private a distinct type.
  (type $private (func (param i32)))

  ;; CHECK:      (import "" "" (func $public (type $public)))
  (import "" "" (func $public (type $public)))

  ;; CHECK:      (elem declare func $public)

  ;; CHECK:      (export "test" (func $test))

  ;; CHECK:      (func $private (type $private)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $private (type $private) (param $unused i32)
    (nop)
  )

  ;; CHECK:      (func $test (type $test) (result i32)
  ;; CHECK-NEXT:  (local $0 funcref)
  ;; CHECK-NEXT:  (ref.test (ref $private)
  ;; CHECK-NEXT:   (select (result funcref)
  ;; CHECK-NEXT:    (ref.func $public)
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $test (export "test") (type $test) (result i32)
    (local funcref)
    ;; Test that $private and $public are separate types. This should return 0.
    (ref.test (ref $private)
      ;; Use select to prevent the ref.test from being optimized in
      ;; finalization.
      (select (result funcref)
        (ref.func $public)
        (local.get 0)
        (i32.const 1)
      )
    )
  )
)
