;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --duplicate-function-elimination --optimize-level=1 -S -o - | filecheck %s

(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (nop)
  )
  (func $other (type $0)
    (nop)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (nop)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (i32.const 0)
    )
  )
  (func $other (type $0)
    (drop
      (i32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.const 1)
    )
  )
)
(module
  (memory 0)
  (start $other)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (table $0 3 3 funcref)

  ;; CHECK:      (elem $0 (i32.const 0) $keep2 $keep2 $caller)

  ;; CHECK:      (export "keep2" (func $keep2))
  (export "keep2" (func $keep2))
  (export "other" (func $other))
  (table 3 3 funcref)
  (elem (i32.const 0) $keep2 $other $caller)
  ;; CHECK:      (export "other" (func $keep2))

  ;; CHECK:      (start $keep2)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (nop)
  )
  (func $other (type $0)
    (nop)
  )
  ;; CHECK:      (func $caller
  ;; CHECK-NEXT:  (call $keep2)
  ;; CHECK-NEXT:  (call $keep2)
  ;; CHECK-NEXT: )
  (func $caller (type $0)
    (call $keep2)
    (call $other)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2-after-two-passes
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $keep2-after-two-passes (type $0)
    (nop)
  )
  (func $other (type $0)
    (nop)
  )
  ;; CHECK:      (func $keep-caller
  ;; CHECK-NEXT:  (call $keep2-after-two-passes)
  ;; CHECK-NEXT: )
  (func $keep-caller (type $0)
    (call $keep2-after-two-passes)
  )
  ;; CHECK:      (func $other-caller
  ;; CHECK-NEXT:  (call $keep2-after-two-passes)
  ;; CHECK-NEXT: )
  (func $other-caller (type $0)
    (call $other)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep-4
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $keep-4 (type $0)
    (nop)
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (unreachable)
  )
  ;; CHECK:      (func $keep-caller
  ;; CHECK-NEXT:  (call $keep-4)
  ;; CHECK-NEXT: )
  (func $keep-caller (type $0)
    (call $keep-4)
  )
  ;; CHECK:      (func $other-caller
  ;; CHECK-NEXT:  (call $other)
  ;; CHECK-NEXT: )
  (func $other-caller (type $0)
    (call $other)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (type $3 (func (param i32)))

  ;; CHECK:      (type $T (func (result i32)))
  (type $T (func (result i32)))
  (type $S (func (result i32)))
  (type $2 (func))
  (type $3 (func (param i32)))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep4-similar-but-func-sig-differs
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep4-similar-but-func-sig-differs (type $2)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other1 (param $i i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other1 (type $3) (param $i i32)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other2 (result i32)
  ;; CHECK-NEXT:  (i32.const 0)
  ;; CHECK-NEXT: )
  (func $other2 (type $T) (result i32)
    (i32.const 0)
  )
  (func $other3 (type $S) (result i32)
    (i32.const 0)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $1 (func (param i32)))

  ;; CHECK:      (type $S (func (result i32)))
  (type $S (func (result i32)))
  (type $1 (func (param i32)))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2-similar-but-func-sig-differs (param $i i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2-similar-but-func-sig-differs (type $1) (param $i i32)
    (drop
      (i32.const 0)
    )
  )
  (func $other1 (type $1) (param $i i32)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other2 (result i32)
  ;; CHECK-NEXT:  (i32.const 0)
  ;; CHECK-NEXT: )
  (func $other2 (type $S) (result i32)
    (i32.const 0)
  )
  (func $other3 (type $S) (result i32)
    (i32.const 0)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (nop)
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (nop)
    (nop)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (block $block0
    )
  )
  (func $other (type $0)
    (block $block0
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $block0
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $block0
      (nop)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (block $block0
      (nop)
    )
  )
  (func $other (type $0)
    (block $block0
      (nop)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $block0
      (nop)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $block0
      (nop)
      (unreachable)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $block0
      (nop)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $block0
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $block0
      (unreachable)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase-since-block-names-do-not-matter
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase-since-block-names-do-not-matter (type $0)
    (block $foo
    )
  )
  (func $other (type $0)
    (block $bar
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase-since-block-names-do-not-matter
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (br $foo)
  ;; CHECK-NEXT:   (br_table $foo $foo
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase-since-block-names-do-not-matter (type $0)
    (block $foo
      (br $foo)
      (br_table $foo $foo
        (i32.const 0)
      )
    )
  )
  (func $other (type $0)
    (block $bar
      (br $bar)
      (br_table $bar $bar
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $foo)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $foo
      (block
        (drop
          (i32.const 0)
        )
        (br $foo)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $bar
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $bar)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $bar
      (block
        (drop
          (i32.const 1)
        )
        (br $bar)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (br_if $foo
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $foo
      (br_if $foo
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $bar
  ;; CHECK-NEXT:   (br_if $bar
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $bar
      (br_if $bar
        (i32.const 1)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (br_if $foo
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (block $foo
      (br_if $foo
        (i32.const 0)
      )
    )
  )
  (func $other (type $0)
    (block $bar
      (br_if $bar
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (br_table $foo $foo
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $foo
      (br_table $foo $foo
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $bar
  ;; CHECK-NEXT:   (br_table $bar $bar
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $bar
      (br_table $bar $bar
        (i32.const 1)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (loop $bar
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (loop $bar
      (nop)
    )
  )
  (func $other (type $0)
    (loop $sjc
      (nop)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block $foo (result i32)
  ;; CHECK-NEXT:    (br_table $foo $foo
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (block $foo (result i32)
        (br_table $foo $foo
          (i32.const 0)
          (i32.const 0)
        )
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block $bar (result i32)
  ;; CHECK-NEXT:    (br_table $bar $bar
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (block $bar (result i32)
        (br_table $bar $bar
          (i32.const 0)
          (i32.const 1)
        )
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (block $bar
  ;; CHECK-NEXT:    (br_table $foo $bar
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (block $foo
      (block $bar
        (br_table $foo $bar
          (i32.const 0)
        )
      )
    )
  )
  (func $other (type $0)
    (block $bar
      (block $foo
        (br_table $bar $foo
          (i32.const 0)
        )
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (block $foo
  ;; CHECK-NEXT:   (block $bar
  ;; CHECK-NEXT:    (br_table $foo $bar
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (block $foo
      (block $bar
        (br_table $foo $bar
          (i32.const 0)
        )
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (block $bar
  ;; CHECK-NEXT:   (block $foo
  ;; CHECK-NEXT:    (br_table $foo $bar
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (block $bar
      (block $foo
        (br_table $foo $bar
          (i32.const 0)
        )
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (call $erase)
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (call $erase)
  )
  (func $other (type $0)
    (call $erase)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2-but-in-theory-we-could-erase
  ;; CHECK-NEXT:  (call $keep2-but-in-theory-we-could-erase)
  ;; CHECK-NEXT: )
  (func $keep2-but-in-theory-we-could-erase (type $0)
    (call $keep2-but-in-theory-we-could-erase)
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (call $other)
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (call $other)
  )
)
(module
  ;; CHECK:      (type $FUNCSIG$v (func))

  ;; CHECK:      (import "env" "i" (func $i))
  (import "env" "i" (func $i))
  ;; CHECK:      (import "env" "j" (func $j))
  (import "env" "j" (func $j))
  (memory 0)
  (type $FUNCSIG$v (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (call $i)
  ;; CHECK-NEXT: )
  (func $erase (type $FUNCSIG$v)
    (call $i)
  )
  (func $other (type $FUNCSIG$v)
    (call $i)
  )
)
(module
  ;; CHECK:      (type $FUNCSIG$v (func))

  ;; CHECK:      (import "env" "i" (func $i))
  (import "env" "i" (func $i))
  ;; CHECK:      (import "env" "j" (func $j))
  (import "env" "j" (func $j))
  (memory 0)
  (type $FUNCSIG$v (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (call $i)
  ;; CHECK-NEXT: )
  (func $keep2 (type $FUNCSIG$v)
    (call $i)
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (call $j)
  ;; CHECK-NEXT: )
  (func $other (type $FUNCSIG$v)
    (call $j)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $T (func))
  (type $T (func))
  (table 2 2 funcref)
  (elem (i32.const 0)  $erase $other)
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (table $0 2 2 funcref)

  ;; CHECK:      (elem $0 (i32.const 0) $erase $erase)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (call_indirect (type $T)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $T)
    (call_indirect (type $T)
      (i32.const 0)
    )
  )
  (func $other (type $T)
    (call_indirect (type $T)
      (i32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $T (func))
  (type $T (func))
  (table 2 2 funcref)
  (elem (i32.const 0)  $keep2 $other)
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (table $0 2 2 funcref)

  ;; CHECK:      (elem $0 (i32.const 0) $keep2 $other)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (call_indirect (type $T)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $T)
    (call_indirect (type $T)
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (call_indirect (type $T)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $T)
    (call_indirect (type $T)
      (i32.const 1)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $T (func))
  (type $T (func))
  (type $S (func))
  (table 2 2 funcref)
  (elem (i32.const 0)  $keep2 $other)
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (table $0 2 2 funcref)

  ;; CHECK:      (elem $0 (i32.const 0) $keep2 $keep2)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (call_indirect (type $T)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $T)
    (call_indirect (type $T)
      (i32.const 0)
    )
  )
  (func $other (type $T)
    (call_indirect (type $S)
      (i32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase-even-locals-with-different-names
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $i)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase-even-locals-with-different-names (type $0)
    (local $i i32)
    (drop
      (local.get $i)
    )
  )
  (func $other (type $0)
    (local $j i32)
    (drop
      (local.get $j)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $i)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (local $i i32)
    (drop
      (local.get $i)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (local $j i64)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (local.get $j)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (local $j i64)
    (drop
      (local.get $j)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase-even-locals-with-different-names
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local.set $i
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase-even-locals-with-different-names (type $0)
    (local $i i32)
    (local.set $i
      (i32.const 0)
    )
  )
  (func $other (type $0)
    (local $j i32)
    (local.set $j
      (i32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local.set $i
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (local $i i32)
    (local.set $i
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (local $j i64)
  ;; CHECK-NEXT:  (local.set $j
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (local $j i64)
    (local.set $j
      (i64.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local.set $i
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (local $i i32)
    (local.set $i
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (local $j i32)
  ;; CHECK-NEXT:  (local.set $j
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (local $j i32)
    (local.set $j
      (i32.const 1)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (i32.load
        (i32.const 0)
      )
    )
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
  (func $other (type $0)
    (drop
      (i32.load
        (i32.const 0)
      )
    )
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.load offset=3
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.load16_s offset=3
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3 align=1
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.load16_s offset=3 align=1
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.load16_s align=2
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 1)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_u offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.load16_u offset=3 align=2
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.load16_s offset=3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i32.load16_s offset=3 align=2
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (i32.store
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (i32.store
      (i32.const 0)
      (i32.const 100)
    )
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
  (func $other (type $0)
    (i32.store
      (i32.const 0)
      (i32.const 100)
    )
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (i32.store offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (i32.store offset=3
      (i32.const 0)
      (i32.const 100)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (i32.store16 offset=3
      (i32.const 0)
      (i32.const 100)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (i32.store16 offset=3 align=1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (i32.store16 offset=3 align=1
      (i32.const 0)
      (i32.const 100)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (i32.store16
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (i32.store16 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 1)
      (i32.const 100)
    )
  )
)
(module
  (memory 10)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 10)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 100)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 100)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (i32.store16 offset=3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 101)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (i32.store16 offset=3 align=2
      (i32.const 0)
      (i32.const 101)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i64.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f64.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (i64.const 0)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (i64.const 1)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.const 0.10000000149011612)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.const 0.10000000149011612)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.const -0.10000000149011612)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.const -0.10000000149011612)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f64.const 0.1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f64.const 0.1)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f64.const 0.2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f64.const 0.2)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.abs
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (f32.abs
        (f32.const 0)
      )
    )
  )
  (func $other (type $0)
    (drop
      (f32.abs
        (f32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.abs
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.abs
        (f32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.abs
  ;; CHECK-NEXT:    (f32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.abs
        (f32.const 1)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.abs
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.abs
        (f32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.neg
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.neg
        (f32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
  (func $other (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 1)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 1)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.add
        (f32.const 1)
        (f32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep2
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.add
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep2 (type $0)
    (drop
      (f32.add
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (f32.sub
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (f32.sub
        (f32.const 0)
        (f32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
  (func $other (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (select
        (i32.const 1)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 2)
        (i32.const 0)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 0)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (select
        (i32.const 0)
        (i32.const 0)
        (i32.const 3)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (return)
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (return)
  )
  (func $other (type $0)
    (return)
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func (result i32)))
  (type $0 (func (result i32)))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase (result i32)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0) (result i32)
    (return
      (i32.const 0)
    )
  )
  (func $other (type $0) (result i32)
    (return
      (i32.const 0)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func (result i32)))
  (type $0 (func (result i32)))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep (result i32)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0) (result i32)
    (return
      (i32.const 0)
    )
  )
  ;; CHECK:      (func $other (result i32)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0) (result i32)
    (return
      (i32.const 1)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.size)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (memory.size)
    )
  )
  (func $other (type $0)
    (drop
      (memory.size)
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $erase
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.grow
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $erase (type $0)
    (drop
      (memory.grow
        (i32.const 10)
      )
    )
  )
  (func $other (type $0)
    (drop
      (memory.grow
        (i32.const 10)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.grow
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0)
    (drop
      (memory.grow
        (i32.const 10)
      )
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.grow
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (memory.grow
        (i32.const 11)
      )
    )
  )
)
(module
  (memory 0)
  ;; CHECK:      (type $0 (func))
  (type $0 (func))
  ;; CHECK:      (memory $0 0)

  ;; CHECK:      (func $keep
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.size)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $keep (type $0)
    (drop
      (memory.size)
    )
  )
  ;; CHECK:      (func $other
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (memory.grow
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $other (type $0)
    (drop
      (memory.grow
        (i32.const 10)
      )
    )
  )
)
