set(SPM_VERSION 1.2.4)

# relocatable package

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SPMConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(SPM_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin/")
set_and_check(SPM_INC_DIR "${PACKAGE_PREFIX_DIR}/include/")
set_and_check(SPM_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib/")

check_required_components(SPM)

# dependencies of SPM

# private dependencies must be given only if spm built static
if (NOT ON)
  include("${CMAKE_CURRENT_LIST_DIR}/mTargets.cmake")
  include("${CMAKE_CURRENT_LIST_DIR}/cblasTargets.cmake")
  include("${CMAKE_CURRENT_LIST_DIR}/lapackeTargets.cmake")
  if (ON)
    include("${CMAKE_CURRENT_LIST_DIR}/scotchTargets.cmake")
  endif()
endif()

# mpi must be given because it is a "public" dependency (mpi.h required in the spm API)
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/mpicTargets.cmake")
  if (OFF)
    include("${CMAKE_CURRENT_LIST_DIR}/mpifTargets.cmake")
  endif()
endif()

# add the targets file
include("${CMAKE_CURRENT_LIST_DIR}/spmTargets.cmake")
if (OFF)
  include("${CMAKE_CURRENT_LIST_DIR}/spmfTargets.cmake")
endif()
